/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   SelectDsRateOption.c
*
*-------------------------------------------------------------------------
*/
// *************************************************************************
// SelectDsRateOption.c
//
// History
//
// 08/07/10 Nihar: Fix for link holes on TR-67B FB noise interleave path
//             against TI-AC5 in DMT mode
//             Grep for IOP_DS_DMT_TI_LinkHoleIntlvFBNoise
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
// *************************************************************************

#include "common.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showinit.h"
#include "synsymbl.h"
#include "ib.h"
#include "mp.h"
#include "cmv.h"
#include "exchdata.h"

#include "bitload.h"
#include "bitload_dmt.h"
#include "ghs.h"
#include "tone_ord.h"
#include "DSLEngin.h"
#include "dec_adap.h"
#include "VerifyRateWithTwoCG.h"
#include "decimalgain.h"

#include "rinfotbl.h"

//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
#ifndef ISDN   // Only for Anx-A
extern FlagT gft_workaround_lowrate_Adtran_GMX;
#endif
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)

/*^^^
*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*       void SelectDsRateOption(Option_t *pta_options, int16 *ps_OutRateOption)
*
*   Abstract:
*       This function selects the downstream rate option from the given four rate options
*  and the result of bitloading.
*
*   Input Parameters:
*     pta_options  -- pointer to the four rate options
*
*  Output Parameter:
*     ps_OutRateOption -- pointer to the selected rate option
*
*  Global Variables:
*     gft_FineGainOn    -- (I) Fine Gain Enable flag
*     gs_TotalBitsSupported -- (I/O) total number of bits supported for given channel
*                       and coding gain
*
*--------------------------------------------------------------------------------------------------
^^^*/
void SelectDsRateOption(Option_t *pta_options, int16 *ps_OutRateOption)
{
   Option_t *pt_option;
   int16 i, j, s_path = 0, s_option, s_CG;
   int16 sa_K[NUM_DATA_PATHS], sa_L[NUM_DATA_PATHS], sa_A[NUM_DATA_PATHS];
   int16 sa_R[NUM_DATA_PATHS], sa_BytesPerPath[NUM_DATA_PATHS], sa_CodingGain[NUM_DATA_PATHS];
   int16 sa_OptionPayload[NUM_DS_RATE_OPTIONS] ;
   FlagT ft_flag;
   int16 s_UserMaxK;
   int16 s_OptionOrder_temp[NUM_DS_RATE_OPTIONS] ;
    int s_Pyld_RateOption, s_MaxBytes_NoTcmOvhd;
#ifdef ISDN
   // IOP_DS_DMT_TI_LinkHoleIntlvFBNoise (Start_End)
   int16 s_CGDelta = 2; //extra coding gain if TI-ac6 picks R=0 for interleave path
#endif

   /* Perform tone ordering if we're running G992_1 */
   if (((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) == 0) && ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C) == 0) )
   {
      ToneOrdering(guca_RxBat, gs_RxNumTones, (int16)guc_MaxAllocBitsPerTone, gsa_RxToneOrder);
      gs_FirstNonzeroRxTone = gs_FirstNonzeroTone;    /* gs_FirstNonzeroTone is set by ToneOrdering() */
   }
   else
   {
      for(i=0; i<gs_RxNumTones; i++)
         gsa_RxToneOrder[i] = i;
   }

   /* ===================================================================================== */
   /* Select Rate Option:                       */
   /* We examine the options in order of decreasing payload.  This increases the PM a bit,  */
   /* but it saves _a lot_ of BG Task time. If we examined all 4 options, plus we reeval'ed */
   /* the chosen one) we might fail in low rate fixed rate link attempts               */
   /* ===================================================================================== */
   *ps_OutRateOption = ALL_OPTIONS_FAIL;

   /* =================================================================================== */
   /* First, calculate the total DS payload of each option and order the options  */
   /* =================================================================================== */
   pt_option = pta_options;

#ifdef ISDN
   // An Anaconda bug was found when testing against a Fast Fixed Rate Profile in AnxB. The first two rate options were
   // set to the fixed rate, while the last two options were larger. To avoid selecting rate options which are not set
   // to the fixed rate, don't sort rate options into descending order when linking with Anaconda in AnxB Fast Path.
   if ((gs_CurrentCoChipset == ANCDA_CO_CHIPSET) && (guca_R_C_Rates1[0]!=0))
         ;
   else
   {
#endif
   for(s_option=0; s_option<NUM_DS_RATE_OPTIONS; s_option++) {

      sa_OptionPayload[s_option] = 0 ;

      for(s_path = 0; s_path <NUM_DATA_PATHS; s_path++) {
         /* Compute payload from ASx channels */
         j = s_path*NUM_DS_BEARER_CHANNELS + DS_AS0_BEARER_CHANNEL;
         for(i=DS_AS0_BEARER_CHANNEL; i<=DS_AS3_BEARER_CHANNEL; i++, j++) {
            sa_OptionPayload[s_option] += pt_option->pus_ReqBytes[j];
         }
         /* Compute payload from LSx channels */
         for(i=DS_LS0_BEARER_CHANNEL; i<=DS_LS2_BEARER_CHANNEL; i++, j++) {
            if(pt_option->pus_ReqBytes[j] != 255)
               sa_OptionPayload[s_option] += pt_option->pus_ReqBytes[j];
         }
      }

      /* Find the current order of this option (resulting offset = i) */
      for (i=0 ; i<s_option ; i++) {
         if (sa_OptionPayload[s_option] > sa_OptionPayload[gusa_DS_OptionOrder[i]])
            break ;
      }
      /* Put option in current proper offset (after shifting right-by-1 the already examined ones) */
      for (j=s_option; j>i ; j--) {
         gusa_DS_OptionOrder[j] = gusa_DS_OptionOrder[j-1] ;
      }
      gusa_DS_OptionOrder[i] = s_option ;

      /* Next option: */
      pt_option++ ;
   }
#ifdef ISDN
   }
#endif
   s_UserMaxK = gt_ADSL1_Control.DsRateCap >>3 ; // in bytes
   if (sa_OptionPayload[gusa_DS_OptionOrder[NUM_DS_RATE_OPTIONS-1]]>s_UserMaxK) {
      // Last option is higher than user desired threshold - put all options in reverse order (lower to higher)
      for (i=0 ; i<NUM_DS_RATE_OPTIONS ; i++)
         s_OptionOrder_temp[i] = gusa_DS_OptionOrder[i] ;
      for (i=0 ; i<NUM_DS_RATE_OPTIONS ; i++)
         gusa_DS_OptionOrder[i] = s_OptionOrder_temp[NUM_DS_RATE_OPTIONS-1-i];
   }
   else {
      // Put ahead options that satisfy the user desired threshold
      for(s_option=0; s_option<NUM_DS_RATE_OPTIONS; s_option++) {
         // If currently last placed option lower than threshold, then put it at beginning.
         if (sa_OptionPayload[gusa_DS_OptionOrder[NUM_DS_RATE_OPTIONS-1]]<=s_UserMaxK)  {
            j = gusa_DS_OptionOrder[NUM_DS_RATE_OPTIONS-1] ;
            for (i=NUM_DS_RATE_OPTIONS-1 ; i>0; i--) {
               gusa_DS_OptionOrder[i] = gusa_DS_OptionOrder[i-1] ;
            }
            gusa_DS_OptionOrder[0] = j ;
         }
      }
   }

   /* =================================================================================== */
   /* Then examine the options in order of decreasing paylod (found above)          */
   /* =================================================================================== */
   for(s_option=0; s_option<NUM_DS_RATE_OPTIONS; s_option++) {

      pt_option = &pta_options[gusa_DS_OptionOrder[s_option]] ;

      /* Process each path */
      for(s_path = 0; s_path <NUM_DATA_PATHS; s_path++) {

         sa_K[s_path] = 0;
         sa_L[s_path] = 0;
         sa_A[s_path] = 0;

         /* Compute payload from ASx channels */
         j = s_path*NUM_DS_BEARER_CHANNELS + DS_AS0_BEARER_CHANNEL;
         for(i=DS_AS0_BEARER_CHANNEL; i<=DS_AS3_BEARER_CHANNEL; i++, j++) {
            sa_K[s_path] += pt_option->pus_ReqBytes[j];
         }

         /* Set AEX byte */
         if(sa_K[s_path] > 0)
            sa_A[s_path] = 1;

         /* Compute payload from LSx channels */
         for(i=DS_LS0_BEARER_CHANNEL; i<=DS_LS2_BEARER_CHANNEL; i++, j++) {
            if(pt_option->pus_ReqBytes[j] != 255)
               sa_K[s_path] += pt_option->pus_ReqBytes[j];
            else
               sa_L[s_path] = 1;
         }

         /* Set LEX byte */
         if(sa_K[s_path] > 0)
            sa_L[s_path] = 1;

         /* Reset AEX LEX to zero for REDUCED framing mode */
         if((gft_FrameMode == REDUCED_SEPARATE) || (gft_FrameMode == REDUCED_MERGED)) {
            sa_L[s_path] = 0;
            sa_A[s_path] = 0;
         }

      } /* for(s_path = 0; s_path <NUM_DATA_PATHS; s_path++) { */


      /* Compute the total bytes per symbol and per path */
      for(s_path = 0; s_path < NUM_DATA_PATHS; s_path++) {
         sa_BytesPerPath[s_path] = (sa_K[s_path] + sa_A[s_path] + sa_L[s_path]
                                    + pt_option->puc_CheckBytes[s_path]);
      }

      /* Add fast byte / synch byte */
      if(gft_FrameMode == REDUCED_MERGED) {
         if(sa_BytesPerPath[FAST_DATA_PATH] > 0) {
            sa_BytesPerPath[FAST_DATA_PATH]++;
            s_path = FAST_DATA_PATH;
         }
         else {
            sa_BytesPerPath[INTERLEAVE_DATA_PATH]++;
            s_path = INTERLEAVE_DATA_PATH;
         }
      }
      else {
         sa_BytesPerPath[FAST_DATA_PATH]++;
         sa_BytesPerPath[INTERLEAVE_DATA_PATH]++;
         s_path = FAST_DATA_PATH;
      }
      /* Compute the number of check bytes per codeword used for each path */
      sa_R[FAST_DATA_PATH] = pt_option->puc_CheckBytes[FAST_DATA_PATH];
      if (pt_option->uc_S) {     // S>=1
         sa_R[INTERLEAVE_DATA_PATH] = pt_option->puc_CheckBytes[INTERLEAVE_DATA_PATH]*pt_option->uc_S;
      }
      else {                  // S=0 corresponds to S=1/2
         sa_R[INTERLEAVE_DATA_PATH] = pt_option->puc_CheckBytes[INTERLEAVE_DATA_PATH] >>1 ;
      }

      //Compute the coding gain for each path
      sa_CodingGain[FAST_DATA_PATH] = GetCodingGain(sa_R[FAST_DATA_PATH]);
      sa_CodingGain[INTERLEAVE_DATA_PATH] = GetCodingGain(sa_R[INTERLEAVE_DATA_PATH]);

      /* Check if this option is valid or not */

      if((gft_FrameMode == REDUCED_MERGED) || (sa_CodingGain[FAST_DATA_PATH] == sa_CodingGain[INTERLEAVE_DATA_PATH])) {
         // Note: VerifyRateWithOneCG now expects a 8.8 CG argument (instead of the previous 15.1)
         s_CG = sa_CodingGain[s_path]<<7 ;

         /* Following CG adjustment put in, but off by default until we are more comfortable:

         // If strong RS in interleave path, increase max concatenated CG by 0.25 dB
         if ((s_path==INTERLEAVE_DATA_PATH) && (gft_TcmFlag==TRUE)) {
            if ((sa_R[INTERLEAVE_DATA_PATH]>=12) && (pt_option->us_D>=32))
            {
               s_CG += 0x0040 ;        // 0.25 dB in 8.8
            }
         }
         */

      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
      //Add 0.5 dB coding gain to choose the best option of C-RatesRA.
      #ifndef ISDN
      if (gft_workaround_lowrate_Adtran_GMX == TRUE)
               s_CG += 0x0080;
      #endif
      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)

         ft_flag = VerifyRateWithOneCG((int16)(sa_BytesPerPath[FAST_DATA_PATH]+sa_BytesPerPath[INTERLEAVE_DATA_PATH]), s_CG, s_path);

      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
      //Substract 0.5 dB coding gain which is added before choosing options of C-RatesRA.
      #ifndef ISDN
      if (gft_workaround_lowrate_Adtran_GMX == TRUE)
               gsa_TotalCodingGain[INTERLEAVE_DATA_PATH] -= 0x0080;
      #endif
      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)

#ifdef ISDN
         // IOP_DS_DMT_TI_LinkHoleIntlvFBNoise (Start)
         // Fix for link holes on TR-67B FB noise interleave path against TI-AC5 in DMT mode

         //Workaround for link hole between 4000m-4500m against Siemens-TI AC6, ilv path, trellis on;
         //When linking with Siemens-TI AC6 on intl path above 4000 meter, the rate options CRATERA provided by CO
         //give R=0, which is equivalent to fast path. In order to prevent link failure due to R=0 and no RS coding gain,
         //we increase coding gain by 1db if the # of bits supported cannot meet the requirement of the lowest option,
         //Since the margin is rounded to .5db in DMT, hopefully there is no margin violation.
         if ((gs_CurrentCoChipset == TI_CO_CHIPSET) &&
            (guca_R_C_Rates1[0]==0) &&
            (gft_TcmFlag == TRUE) )
         {
            if ( (!ft_flag) && (s_option==3) )
            {
               sa_CodingGain[INTERLEAVE_DATA_PATH] += s_CGDelta;
               s_CG = sa_CodingGain[s_path]<<7 ;
               ft_flag = VerifyRateWithOneCG((int16)(sa_BytesPerPath[FAST_DATA_PATH]+sa_BytesPerPath[INTERLEAVE_DATA_PATH]), s_CG, s_path);
            }
         }
         // IOP_DS_DMT_TI_LinkHoleIntlvFBNoise (End)
#endif
      }
      else {
         // We may need to adjust the SNRs for Trellis on cases for this case too.
         ft_flag = VerifyRateWithTwoCG(sa_BytesPerPath, sa_CodingGain);
      }


      /* If option just examined can be supported, don't examine the rest */
      if(ft_flag == TRUE) {
         *ps_OutRateOption = gusa_DS_OptionOrder[s_option];
         break;
      }
   }  /* for(s_option=0; s_option<NUM_DS_RATE_OPTIONS; s_option++) */

   /* Calculate Max Attainable Bits minus Trellis Overhead, convert to bytes */
   if(gft_TcmFlag == TRUE)
    { /*    Use RMsgs RA ncloaded for Trellis overhead calculation.  Otherwise, if there is a
            fixed rate link the value of ncloaded will be much lower than achievable.
            Max Bytes (no TCM Ovhd) = Total Bits - TCM Ovhd.
            NOTE: TCM Ovhd = ((gus_ncloaded+9)>>1)    */
      s_MaxBytes_NoTcmOvhd = ((gs_TotalBitsSupported - (((int16)gt_RMsgRA.us_ncloaded+9)>>1))>>3);
   }
    else
    {
        s_MaxBytes_NoTcmOvhd = gs_TotalBitsSupported>>3;
    }

    /* Assume RS Checkbytes in all cases except FAST PATH w/ Trellis ON
      Remove RS Checkbytes which are approx. 1/16 of total CW size.
       Multiply by 15/16 and add 8 to round up */
    if ((s_path == INTERLEAVE_DATA_PATH) || (gft_TcmFlag == FALSE))
    {
      s_MaxBytes_NoTcmOvhd = (15*s_MaxBytes_NoTcmOvhd + 8)>>4;
   }

   /* Calculate Payload of selected Rate Option so that it can be compared to AttnDR calc */
   if (pt_option->uc_S)      // S>=1
    {
      s_Pyld_RateOption = sa_BytesPerPath[FAST_DATA_PATH]+sa_BytesPerPath[INTERLEAVE_DATA_PATH] - (sa_R[s_path]/pt_option->uc_S);
   }
   else                            // S=0 corresponds to S=1/2
    {
      s_Pyld_RateOption = sa_BytesPerPath[FAST_DATA_PATH]+sa_BytesPerPath[INTERLEAVE_DATA_PATH] - (sa_R[s_path]<<1);
   }

    /* Make sure MaxAttnDr is NOT < selected rate option. */
    if (s_MaxBytes_NoTcmOvhd < s_Pyld_RateOption)
    {
        s_MaxBytes_NoTcmOvhd = s_Pyld_RateOption;
    }

    if (((s_path == FAST_DATA_PATH) || (!gt_RMsgs1.us_Higher_BitRates)) && (s_MaxBytes_NoTcmOvhd > 255))

    {
        // Cap AttnDR to 8128Kbps in Fast Path or if Intl w/ S=1/2 disabled
        s_MaxBytes_NoTcmOvhd = 255;
    }


    /*   Report Max Attainable Data Rate in Kbps (Subtract out DMT Overhead)
      NOTE: S=1/2 has 2 ovhd bytes, however this is only an estimate of
            Max Attn Data Rate.  It is not worth adding the additional logic
                since 1 byte is a small % of a minimum of 255 bytes. */
    gt_NearEndParam.ul_AttainableDataRate = ((int32)((s_MaxBytes_NoTcmOvhd - 1) * 32000));

   /* After the bitloading is done, calculate variables for excess margin reduction. */
   if ((!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable )) && (gft_FineGainOn == TRUE))
   {
      /* Calculate excess margin reduction in dB (EMR = min{(Average - Requested), (Minimum - Desired)}. */
      gt_FineGainInfo.s_ExcessMarRedDB = gs_RxAvMargin - gs_RequestedRxMaxMargin;
      if (gt_FineGainInfo.s_ExcessMarRedDB > gs_RxMinMargin - gs_RxDesiredMargin)
         gt_FineGainInfo.s_ExcessMarRedDB = gs_RxMinMargin - gs_RxDesiredMargin;
      /* Limit the margin reduction to 14.5dB + min_fine_gain (= 12dB, currently) from above. */
      if (gt_FineGainInfo.s_ExcessMarRedDB > 0x0E80 + gs_min_fine_gain)
         gt_FineGainInfo.s_ExcessMarRedDB = 0x0E80 + gs_min_fine_gain;
      /* Limit the margin reduction to 0dB from below. */
      if (gt_FineGainInfo.s_ExcessMarRedDB < 0)
         gt_FineGainInfo.s_ExcessMarRedDB = 0;

      /* If CO sends non-compliant synch symbol, limit the margin reduction to 9dB. */
      if( (gs_CurrentCoChipset != ALA_CO_CHIPSET) &&
         (gs_CurrentCoChipset != IFTN_CO_CHIPSET) &&
         (gs_CurrentCoChipset != BDCM_CO_CHIPSET) )
      {
         if (gt_FineGainInfo.s_ExcessMarRedDB > 0x0900)
            gt_FineGainInfo.s_ExcessMarRedDB = 0x0900;
      }

      /* Calculate fine gain reduction and FDQ boost. */
      gt_FineGainInfo.s_ExcessMarFGReduction = DecimalGain((int16)(-gt_FineGainInfo.s_ExcessMarRedDB));
      gs_ExcessMarFDQBoost = (int16)(0x4000000L/gt_FineGainInfo.s_ExcessMarFGReduction);

      /* Update margins based on the excess margin reduction. */
      gs_RxAvMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
      gs_RxMinMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
   }
}



