/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   bitload.c
*
*   Source code of the subset of bitloading functions needed for FR.
*
*-------------------------------------------------------------------------
*/
// *****************************************************************************
// bitload2.c
//
// History
// 26/07/10  Bhadra/Palaksha Murthy  Added fix against CNXT Cos.Link drops are
//           observed with some old CNXT DSLAMS in ADSL2/+ mode,if all tones are
//           loaded with 1bit(at some long loop fixed rate cases.
//          Solution is to force atleast to have one 2 bit tone.
//          Grep for "IOP_ALL_BISPLus_CNXT_1bitConstellation" to check the changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
// *****************************************************************************

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata_bis.h"
#include "bitload2.h"
#include "cmv.h"
#include "changebat.h"
#include "bitload_support.h"
#include "bitload_const.h"
#include "decimalgain.h"
#include "hndshk_Data.h"
#include "states.h"
#include "pll.h"

#include <string.h>
#include "memsetbf.h"


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 FindChWithLargestFGain();
*
*   Description:
*       Scans through those channels, which have increased BAT through the
*       use of fine gains, and finds the one that required the largest fine gain
*       to obtain its BAT increase
*
*   Input Parameters:
*
*   Returns:
*     Channel with the smallest SNR
*     or
*     -1: no channel is found
*
*  Global Variables:
*       gsa_RxFineGainPlusBitChannel - (I)  (approx) fine gains/extra bits for each tone; see definition, above, for format
*       gsa_RxFineGains              - (I)  exact fine gains for each tone (in dB, when this function is called)
*-----------------------------------------------------------------------------
^^^*/


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       FlagT InitBitloading(void);
*
*   Description:
*       Initializes bit allocaiton table to zeros.
*
*   Input Arguments:
*     none
*
*  Output Arguments:
*     none
*
*   Returns:
*     FAIL
*
*  Global Variables:
*     gsa_RxBat[]  -- (O) bit allocation array (set to 0)
*     RxFineGain[] -- (O) fine gain array (set to 0)
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE FlagT InitBitloading(int16 s_path)
{

   int16 s_channel;

    /*  Clear the bit allocation tables */
   for(s_channel=0; s_channel < gs_RxNumTones; s_channel++) {

   /* only if we have dual latency support and we are working for LP0 path,
      assume that LP1 is already set and skip over the LP1 tones */
      // if (  ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_5_ALL) != 0)&&(gt_rx_config.s_Nlp==2)&&(s_path == LP0_DATA_PATH) && (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_channel)))

         if (((STATArray[STAT_Mode] & STAT_ConfigMode_ADSL2_ALL) != 0) && (s_path == LP0_DATA_PATH))
         {
            if(gt_rx_config.s_Nlp==2)
            {
               if (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_channel))
                  continue;

            }
         }

      guca_RxBat[s_channel] = 0;
      gsa_RxFineGains[s_channel] = 0;
   }



    return(FAIL);

}

/*^^^
*-----------------------------------------------------------------------------
*   Prototype:
*       void OffsetSNRRequired(int16 s_Margin, int16* psa_SNRRequired);
*
*   Description:
*       Adds a margin offset to gsa_ConstellationSNR[] and put it in
*       gsa_SNRRequired[].
*
*   Input Parameters:
*     s_Margin -- margin added to required SNR
*
*  Output Parameters:
*     psa_SNRRequired -- pointer to array of required SNR per tone
*
*   Returns:
*     none
*
*  Global variables:
*     guc_MaxAllocBitsPerTone -- (I) the maximum number of bits per tone supported
*     gsa_ConstellationSNR[]  -- (I) Constellation SNR buffer
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE void OffsetSNRRequired(int16 Margin, int16* psa_SNRRequired)
{

    int16 i;

    for(i = 0; i <= guc_MaxAllocBitsPerTone; i++)
        psa_SNRRequired[i] = gsa_ConstellationSNR[i] + Margin;
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 CalcMaxBits(int16 s_GainsEnabled);
*
*   Description:
*       Calculates the maximum number of bits the channel can support
*     for given channel SNRs and required SNRs.
*       Will use fine gains if GainsEnabled != 0
*
*   Input Arguments:
*     s_GainsEnable -- indicator if fine gain is in use (1) or not (0)
*
*   Returns:
*       The maximum number of bits supported by channel.
*
*  Global Variables:
*     gs_RxBitLoadFirstChannel-- (I) RX first channel
*     gs_RxBitLoadLastChannel -- (I) RX last channel
*     gsa_SNRRequired[]    -- (I) require SNR per tone
*     gpsa_MeasuredSnrBuf     -- (I) pointer to measured SNR buffer
*     guc_MaxAllocBitsPerTone -- (I) the max. US bits per tone supported
*
*     gsa_RxBat[]          -- (O) bit allocation table
*     gus_ncloaded         -- (O) number of tones with bits allocated
*     gs_RxExtraBits       -- (O) no. of extra bits due to use of fine gains
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE int16 CalcMaxBits(int16 s_GainsEnabled, uint8 *psa_RxBat, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, uint16 *pus_ncloaded, int16 *ps_RxAvFineGain, int16 s_TargetLp, int16 s_path)
{
   int16 s_ch;          /*  channel index */
   uint8 s_qc;          /*  QAM constellation size */
   int16 s_SNR;
   int16 s_MaxBits = 0, s_min_fine_gain;
   int16 s_MinBitsPerTone = (int16) RX_MIN_BITS_PER_TONE;
   int32 l_SumFineGaindB = 0; // Excess SNR
   int16 s_InitialSumBi;
   FlagT ft_BitloadOK=0, ft_TcmFlag;
   int16 s_delta_for_fixedrate = 3;
   int32  l_SumFGainLinSq = 0;
   int16 s_delta_Lp;
   int16 s_temp;
   int16 s_SNR_Thresh = (int16) SNR_THRESH_LOAD_MIN_BITS;
   int16 s_MaxNOMATP_DS, s_DsPcb;
   // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (Start)
   int16 s_SNR_1, s_AdditionalSNRNeeded, s_ToneToAddTo, s_MinSnrBoost;
   int16 s_FineGainToConsider, s_IndexForMinBoost;
   // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (End)


   if (gft_ModemType == G_DMT_BIS)
      s_MinBitsPerTone = (int16) gs_RxMinBitsPerTone_BIS_TCM;

   if (s_GainsEnabled)
      s_min_fine_gain = gs_min_fine_gain;
   else
      s_min_fine_gain = 0;


   if (( gl_SelectedMode & (MODE_ADSL2)  ))
      ft_TcmFlag =  gft_TcmFlag_bis_DS;
   else ft_TcmFlag = gft_TcmFlag;


   *pus_ncloaded = 0;

    /* Allocate max # bits to each channel */
   for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
   {
   /* only if we have dual latency support and we are working for LP0 path,
      assume that LP1 is already set and skip over the LP1 tones */
      if (((STATArray[STAT_Mode] & STAT_ConfigMode_ADSL2_ALL) != 0)&&
          (gt_rx_config.s_Nlp==2) && (s_path == LP0_DATA_PATH) &&
          (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_ch)))
         continue;

      /* clear bit allocation entry */
      psa_RxBat[s_ch] = 0;
      if (s_GainsEnabled) psa_RxFineGains[s_ch] = 0;

      // Set fine gain to minimum while loading tones.
      s_SNR = gpsa_MeasuredSnrBuf[s_ch] + s_min_fine_gain;

      //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
      if(gft_Bitswap_UreTX == 1)
      {
         s_SNR += gsa_TotalCodingGain[LP1_DATA_PATH];
         //FEATURE_DS_BisPlus_ALL_BitSwapReTx_PAR Start
         // If PARR Tone is set clear SNR on that TONE
         if (IS_TONEFLAGSET(p_PARRTONEset,s_ch) )
            s_SNR = 0;
         // FEATURE_DS_BisPlus_ALL_BitSwapReTx_PAR End
      }
      //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)

      // decrease fine gain to -infinity for the tones if there SNR is below a threshold
      // from being bitloadable (useful for nomATP )

      if((s_GainsEnabled) &&
         (s_SNR <
         gsa_SNRRequired[s_MinBitsPerTone] - s_SNR_Thresh + s_min_fine_gain))
      {  //SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start_End)  //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
         psa_RxFineGains[s_ch] = NEG_INFINITY_DB;
         //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
         //SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
         // Indicate PARR tone set during Training only.
         if((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (gft_Bitswap_UreTX == 0))
         {
            SETTONEFLAG(p_PARRTONEset, s_ch);
         }
      }  //SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
      /* In All Modes, set Gain for pilot tone to 0 unless we have Aux/DD Pilot On */
      /* In DMT Mode, always set Gain for pilot tone 64 to 0 */
      if (s_GainsEnabled &&
         (gft_AuxPilot == AUX_PILOT_DISABLE || !(( gl_SelectedMode & (MODE_ADSL2)  ))))
      {
         psa_RxFineGains[gs_CPilotTone] = 0;
      }

      if (s_SNR >= gsa_SNRRequired[s_MinBitsPerTone])
      {
         for(s_qc = guc_MaxAllocBitsPerTone; s_qc >= s_MinBitsPerTone; s_qc--)
         {

            if(s_SNR >= gsa_SNRRequired[s_qc])
            {
               psa_RxBat[s_ch] = s_qc;
               (*pus_ncloaded)++;

               s_MaxBits += (int16) s_qc;

               if (s_GainsEnabled)
               {
                  psa_RxFineGains[s_ch] = s_min_fine_gain;     // We use dB format for now.
                  l_SumFineGaindB += s_min_fine_gain;
               }

               break;
            }
         }
      }
    }

   if(gft_AuxPilot == AUX_PILOT_ACTIVE)
   {
      int16 s_AuxPilotToneBits = 2;
      s_MaxBits = s_MaxBits-(int16) psa_RxBat[gs_AuxPilotToneIdx]+s_AuxPilotToneBits;
      psa_RxBat[gs_AuxPilotToneIdx] = (uint8) s_AuxPilotToneBits;
      if (s_GainsEnabled)
      {
         l_SumFineGaindB -= psa_RxFineGains[gs_AuxPilotToneIdx];
         psa_RxFineGains[gs_AuxPilotToneIdx] = 0;
      }
   }

   if ((s_GainsEnabled) &&(( gl_SelectedMode & (MODE_ADSL2)  )))
   {
      // ---------------------------------------------------------------------
      // Output of (ComputeSumFGainLinSq) "gl_SumGiSqTssiSq " format Q15.17
      // ---------------------------------------------------------------------
      // Gain(gi) => Q8.8 in dB format
      // Gi,Decimal        => DecimalGain(gsa_RxFineGains[i])
      //  convert to Q3.9 format    =>Q3.13/2^4 Q3.9 ( linear,as per gi representation in R-PARAMS)
      //
      // Tssi Q6.10 format (after linear conversion)
      // Gi*Tssi = Q9.19, truncate to 16bits and convert to Q3.13 format
      // => Q9.19/2^6 => Q9.13
      // Truncate to 16 bits =>     Q3.13 =>(Gi*TSSi)
      // (Gi*TSSi)^2 = Q3.13 *Q3.13 => Q6.26
      // for accumulating 512 tones we need 9bits (so shift value by 9)
      // (Gi*TSSi)^2/2^9 => Q6.26/2^9 =>Q15.17 format
      // ---------------------------------------------------------------------
      ComputeSumFGainLinSq(pus_ncloaded, &gl_SumFGainLinSq, &gl_SumGiSqTssiSq);

      s_MaxNOMATP_DS = gt_TxPMDControl.s_MAXNOMATP_DS;

      s_temp = ((s_MaxNOMATP_DS - gt_TxPMDControl.s_NOMPSD_DS) << 8) /5; // divide by 5 instead of 10, as decimal Gain function divides by 20, we need to
                                                      // calulate 10 ^(maxNomATP /10)

      gl_MaxSumGiSqTssiSqLin = DecimalGain(s_temp) ; //3.13

      // This would need to change if for any newer mode NomATP/ PSD constraints change
      // NomATP is computed as: 36.35 +nomPSD + 10 log(sum(gi^2 tssi^2))
      // based on ATP values calculate maximum allowed sum(gi^2 tssi^2)
      #ifdef ISDN
      //See B.1.2.2. In addition, for non-overlapped spectrum operation, the aggregate transmit power
      //across the whole passband shall not exceed 19.8 dBm.
      //For spectrum management purposes, the PSD template nominal passband aggregate transmit power
      //is 19.3 dBm
      //  round(10^((198*256/10 + 40*256 - 36.35*256  ) / (256 *10)) *16)
      gl_MaxSumGiSqTssiSqLin = gl_MaxSumGiSqTssiSqLin * 3541; //10^((199*256/10 + 40*256 - 9305 + (2(19-6) -9) * 10 * log(2)*256 ) / (256* 10)) /8192  = 3645
      #else
            // -----------------------------------------------
      // Computation of gl_MaxSumGiSqTssiSqLin in Q15.17
      // -----------------------------------------------
      // MAXNOMATP[dBm] +MAXNOMATP_GHS = 36.35+(MAXNOMPSD+NOMPSD_GHS)+10log(sum((gi*tssi)^2))
      //                                  here sum is over the tones from Medlet Set
      // 10log(sum((gi*tssi)^2)) = [MAXNOMATP[dBm] -36.35- MAXNOMPSD ] + [MAXNOMATP_GHS-NOMPSD_GHS]
      // Convert to linear values (gl_SumGiSqTssiSq is in linear format)
      // sum((gi*tssi)^2 = 10 ^({[MAXNOMATP[dBm] -36.35- MAXNOMPSD ] + [MAXNOMATP_GHS-NOMPSD_GHS]}/10)
      //                = 10 ^([MAXNOMATP[dBm] -36.35- MAXNOMPSD ]/10) * 10 ^( [MAXNOMATP_GHS-NOMPSD_GHS]/10)
      //
      // The requirement sum((gi*tssi)^2 is in Q15.17 format
      //
      // 10 ^( [MAXNOMATP_GHS-NOMPSD_GHS]/10)   => from FW is Q.13 format
      // As per std MAXNOMATPds = 20.4 dBm, MAXNOMPSDds  -40 dBm/Hz. So
      // 10 ^([MAXNOMPSD[dBm] -36.35- MAXNOMPSD ]/10) = 10^((204*256/10 + 40*256 - 36.35*256  ) / (256 *10))
      //                   = 254 (format Q32)
      // 10 ^([MAXNOMATP[dBm] -36.35- MAXNOMPSD ]/10) * 10 ^( [MAXNOMATP_GHS-NOMPSD_GHS]/10)
      //                      => Q32*Q3.13
      //                      => Q35.13
      //                      => Q19.13 (Truncate to 32 bits)
      // Requirement is Q15.17, So multiply by 2^4
      //                      => Q19.13 * 2^4
      //                      => Q15.17 (Truncate to 32 bits)
      // So the constant value used here is 254*16 = 4064(Q12.4) for computation "gl_MaxSumGiSqTssiSqLin"
      // This is the Max Value we can have over the 512 tones.
      // Can we use   gl_MaxSumGiSqTssiSqLin*2 ( for Bis Mode)     ?
      //              gl_MaxSumGiSqTssiSqLin*4 ( for AnnexL Mode)  ?
      // ---------------------------------------------------------------------
      //10^((204*256/10 + 40*256 - 9305 + (2(19-6) -9) * 10 * log(2)*256 ) / (256 *10)) /8192  = 4090
      gl_MaxSumGiSqTssiSqLin = gl_MaxSumGiSqTssiSqLin * 4067;
      #endif

      // DS power cutback (dB)
      s_DsPcb = (gt_RCMsgPcb_bis.us_C_MIN_PCB_DS > gt_RMsgPcb_bis.us_R_MIN_PCB_DS) ?
               gt_RCMsgPcb_bis.us_C_MIN_PCB_DS: gt_RMsgPcb_bis.us_R_MIN_PCB_DS;
      while(s_DsPcb!=0)
      {
         gl_MaxSumGiSqTssiSqLin >>= 13;   //DecimalGain() returns in Q3.13
         if (s_DsPcb > 3 && gl_MaxSumGiSqTssiSqLin < 0x3fffffff)
         {
            gl_MaxSumGiSqTssiSqLin *= DecimalGain(3<<9); // 10 ^ (2*x/20), x in Q8.8 format
            s_DsPcb -= 3;
         }
         else
         {
            gl_MaxSumGiSqTssiSqLin *= DecimalGain((int16)(s_DsPcb<<9)); // 10 ^ (2*x/20), x in Q8.8 format
            s_DsPcb = 0;
         }
      }
   }

   /* Check if we are in adaptive rate or fixed rate scenario. Adaptive rate we calculate the maximum
      number of bits which can be supported; while in fixed rate scenario, we compute the BAT as much as
      required , this is based on s_TargetLp. s_targetLp = 7FFF, implies rate adaptive mode */

   if ((s_TargetLp < 0x7FFF) && (( gl_SelectedMode & (MODE_ADSL2)  )))
   {
   /* Compute no. of channels having bits, and channels having one bit if tcm is enabled. */

   GetBatStats(psa_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, (int16 *)(void *)&gus_Rx_Tcm_Num1bits, &gs_Tcm_Oh, &s_InitialSumBi, s_path);

   s_delta_Lp =  ( s_TargetLp + gs_Tcm_Oh) - s_InitialSumBi ;
   ft_BitloadOK = (FlagT)AllocateBiGi_desiredLp_Bis(s_GainsEnabled, psa_RxBat,  s_MaxBits, l_SumFineGaindB, &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, psa_RxFineGains,  ps_RxExtraBits,  pus_ncloaded,   s_delta_Lp , s_path) ;

   }
   else
   {
      // not target LP case (Adative Rate case)
      // common to DMT / BIS
      if (s_GainsEnabled == TRUE)
      {
         if ( gl_SelectedMode & (MODE_ADSL2)  )
            *ps_RxExtraBits = ChooseFineGains_BIS(psa_RxBat, psa_RxFineGains,  &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 0x7FFF, 0, s_path);

         else
            *ps_RxExtraBits = ChooseFineGains_DMT(psa_RxBat, psa_RxFineGains, &l_SumFineGaindB, *pus_ncloaded);


      }
      else
      {
         // fine gains not enabled
         *ps_RxExtraBits = 0;
      }

   }
   // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (Start)
   if ((gl_SelectedMode & MODE_ADSL2) &&
       (gs_CurrentCoChipset == GSI_CO_CHIPSET))
   {

      /* Compute no. of channels having bits, and channels having one bit if tcm is enabled. */
      GetBatStats(psa_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded,
                  (int16 *)(void *)&gus_Rx_Tcm_Num1bits, &gs_Tcm_Oh, &s_InitialSumBi, s_path);

      // if( (!gs_ChIdx_1bitTo2bit) && (gl_SelectedMode & MODE_ADSL2) && (gs_CurrentCoChipset ==
      // GSI_CO_CHIPSET))
      if (gus_Rx_Tcm_Num1bits == gus_ncloaded)
      {

         // Removing 1 bit from tone starting from last freq index
         for (s_ch = gs_RxBitLoadLastChannel; s_ch >= gs_RxBitLoadFirstChannel;
              s_ch--)
         {
            if (psa_RxBat[s_ch] == 1)
               break;
         }

         UpdateFineGainLinSumSq(psa_RxFineGains[s_ch], 0,
                                gusa_DS_Tssi_Value[s_ch], &gl_SumFGainLinSq,
                                &gl_SumGiSqTssiSq, 1);

         psa_RxBat[s_ch] = 0;

         if (s_GainsEnabled == TRUE)
            psa_RxFineGains[s_ch] = 0;

         // Adding 1 more bit on tone loaded with 1 bit starting from first bitload tones
         s_MinSnrBoost = 0x7FFF;
         s_IndexForMinBoost = 0;
         for (s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel;
              s_ch++)
         {
            if (psa_RxBat[s_ch] == 1)
            {
               s_SNR_1 = gpsa_MeasuredSnrBuf[s_ch] + psa_RxFineGains[s_ch];
               s_AdditionalSNRNeeded = gsa_SNRRequired[2] - s_SNR_1;

               if (s_AdditionalSNRNeeded < s_MinSnrBoost)
               {
                  s_MinSnrBoost = s_AdditionalSNRNeeded;
                  s_IndexForMinBoost = s_ch;
               }
            }
         }

         // s_SNR adjusted with fine gain
         // s_SNR = gpsa_MeasuredSnrBuf[s_ch] + psa_RxFineGains[s_ch];
         // s_AdditionalSNRNeeded = gsa_SNRRequired[2] - s_SNR;
         s_ToneToAddTo = s_IndexForMinBoost;
         s_FineGainToConsider = psa_RxFineGains[s_ToneToAddTo];

         // Need to check whether "s_MinSnrBoost" is available in the basket

         // side effects may be ther with out the above check
         UpdateFineGainLinSumSq(s_FineGainToConsider,
                                (int16) (s_FineGainToConsider + s_MinSnrBoost),
                                gusa_DS_Tssi_Value[s_ToneToAddTo],
                                &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 0);

         psa_RxBat[s_ToneToAddTo] += 1;

         psa_RxFineGains[s_ToneToAddTo] = s_FineGainToConsider + s_MinSnrBoost;

         gs_ChIdx_1bitTo2bit = s_ToneToAddTo;   // to use it later for bitswap chk

      }  // if(gus_Rx_Tcm_Num1bits == gus_ncloaded)
   }  // if( (gl_SelectedMode & MODE_ADSL2) && (gs_CurrentCoChipset == GSI_CO_CHIPSET))
   // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (End)



   /* Compute no. of channels having bits, and channels having one bit if tcm is enabled. */
   GetBatStats(psa_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, (int16 *)(void *)&gus_Rx_Tcm_Num1bits, &gs_Tcm_Oh, &s_InitialSumBi, s_path);


   /*  If the number of tones having one bit loaded is not even, then choose an arbitrary
   tone with one bit, and set it to zero.  Then adjust the other parameters accordingly.
   We choose the tone to kill from the end (as it is more easy to find a tone with one
   bit in the higher tones than in the lower tones for good MedleySNRs.  */

   if ((gus_Rx_Tcm_Num1bits & 0x1) && (ft_TcmFlag == TRUE))
   {
      for (s_ch = gs_RxBitLoadLastChannel; s_ch >= gs_RxBitLoadFirstChannel; s_ch--)
      {
         if (psa_RxBat[s_ch] == 1)
            break;
      }

      // One bit correction to the value of s_MaxBits.
      s_MaxBits--;

      UpdateFineGainLinSumSq(psa_RxFineGains[s_ch], 0, gusa_DS_Tssi_Value[s_ch], &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 1);

      psa_RxBat[s_ch] = 0;

      if (s_GainsEnabled == TRUE) psa_RxFineGains[s_ch]= 0;
      gus_Rx_Tcm_Num1bits--;
      (*pus_ncloaded)--;   // Since we have killed one tone, reduce the number of tones loaded by one.
   } // if (gus_Rx_Tcm_Num1bits & 0x1)


   if (s_GainsEnabled == TRUE)
   {
      //loaded tones and/or fine gains could be changed by ChangeLpKeepMaxMargin, so recalculate AvFineGain here.
         l_SumFineGaindB = 0;
         for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
         {
            if (guca_RxBat[s_ch] > 0)
               l_SumFineGaindB += gsa_RxFineGains[s_ch];
         }

      *ps_RxAvFineGain = QuickAverage(l_SumFineGaindB, *pus_ncloaded);
   }
   else
   {
      *ps_RxAvFineGain = 0;
   }

   if (s_TargetLp < 0x7FFF)
   {
      // it returns if the Bitloading is able to alloacte exact bits as required
      return(ft_BitloadOK);
   }

   else
   {
      // return actual supported bits
      return (s_MaxBits+*ps_RxExtraBits);
   }
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*        void AdjustTcmCodingGains();
*
*  Description:
*        Adjust the Constellation SNR for odd constellations b=5, b=7
*
*  Global Variables:
*        gsa_ConstellationSNR array
*
*-----------------------------------------------------------------------------
*/

C_SCOPE void AdjustTcmCodingGains(int16 s_R)
{
   if (guc_Iridia_Revision_Number == IRIDIA_30)
   {
      // adjust the constellation SNR to take care of coding gain for b=5 and b=7 constellations
      // Add 1.5 dB for b=5; and 1 dB for b=7 and .5dB  for b=9
      if (s_R == 0)
      {
         gsa_ConstellationSNR[5] = 0x1875 + 0x180;
         gsa_ConstellationSNR[7] = 0x1E97 + 0x100;
         gsa_ConstellationSNR[9] = 0x24A1 + 0x80;
      }
      else
      {
         // No adjustment for other values of R
         gsa_ConstellationSNR[5] = 0x1875;
         gsa_ConstellationSNR[7] = 0x1E97;
         gsa_ConstellationSNR[9] = 0x24A1;
      }
   }
}

