/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   bitload_dmt.c
*
*   ADSL1 bitloading algorithms.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// bitload_dmt.c
//
// History
//
// 06/03/2008 Kannan: Changes are incorporated if "The received DS rate options are too high
//                    to be accepted from CPE". Retrain and send lower max
//                    rate to reduce CO DS rate options". Grep for
//                    R3_P1: AR8_TF: PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions
//
// 10/08/2010 Nihar: Three bug fixes for KTL and BT qual tests:
//            (1) Avoid bitswap on aux pilot in G.dmt/T1.413 mode.
//            (2) No (i.e. 0dB) finegain on aux pilot in G.dmt/T1.413 mode.
//            (3) Skip pilot FDQ magnitude adaptation during sync symbol since CO Tx pilot with average finegain power.
//             Grep for PERF_DS_AB_ALL_ALL_PilotBugfixes
//
// 22/08/2011 Vinjam: Report DS margin as 6 when it is 5.8 or 5.9
//              Grep for XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
// *****************************************************************************
#include "common.h"
#include "gdata.h"
#include "gdata_dmt.h"
#include "bitload.h"
#include "bitload_dmt.h"
#include "bitload2.h"
#include "cmv.h"
#include "exchdata.h"
#include "SelectDsRateOption.h"
#include "exchmsgs.h"
#include "changebat.h"
#include "bitload_const.h"
#include "rinfotbl.h"
#include "minmaxmargin.h"
#include "pll.h"

#ifndef ISDN   // Only for Anx-A
// Increase the delta Margin of "MARGIN_DELTA_TO_GET_LESS_CRATESRA" to reduce DS Rate options
// PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (start_end)
#define  MARGIN_DELTA_TO_GET_LESS_CRATESRA   (0x0180) // Q 8.8 format 1.5dB
#endif // ifndef ISDN

//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
#ifndef ISDN   // Only for Anx-A
FlagT gft_workaround_lowrate_Adtran_GMX = FALSE;
#endif
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)

//XDSLRTFW-3354 (START)
//XDSLRTFW-3674 Options_For_debug(start) added @ RCPilot1RxF.c
//#ifndef ISDN   // Only for Anx-A
//int16 gs_DSMarginDelta = 0;
//#endif
//XDSLRTFW-3354 (END)

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void SelectRateOptionForRMsgRA(void);
*
*   Description:
*  This function is called following the MEDLEY based SNR
*   calculation.  It will NOT select the DS rate option from C_RATES1 at this time
*   but computes its desired rate option based on its channel analysis result.
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Returns:
*
*  Global Variables:
*     gft_FineGainOn    -- (I) indicator if fine gain is used (1) or not (0)
*     gsa_MedleySnrBuf  -- (I) SNR buffer computed during Medley
*     gs_RxDesiredMargin   -- (I) desired SNR margin
*     gft_RS_Support    -- (I) maximum no. of RS check bytes agreed by two modem
*
*     gpsa_MeasuredSnrBuf -- (O) pointer to measured SNR buffer
*     gs_BitLoadingOK      -- (O) set to SUCCEED if bit loading succeeds, else set to FAIL
*     gsa_SNRRequired[] -- (O) required SNR per constellation for given SNR margin
*
*     gs_RxAvMargin --  (O) average SNR margin in Q8.8
*     gus_ncloaded  --  (O) number of tones being bit-allocated
*     gs_DS_RateOption -- (O) selected rate option
*     R_MSG_RA       (O) R_MGS_RA message
*-----------------------------------------------------------------------------
^^^*/
void SelectRateOptionForRMsgRA(void)
{

    int16 s_RSCodingGain, s_R = 0, s_RSCodingGain_Show = 0;
    int16 s_RRatesRA_deltaK = 0 ;
    int16 s_UserMaxK, s_UserReportedK;
    int16 s_Tcm_Oh = 0;
    int16 s_RxInitialMargin ;
    //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
#ifndef  ISDN  // Only for Annex - A
    int16 s_max_payload = 0, s_maxR = 0, s_temp;
#endif
    //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)


    int16 s_path=COMBINED_LP;

    /* Init Bit Loading */
    gft_BitloadOK = InitBitloading(s_path);

    //Use the maximum coding gain (in Q15.1 format) in computing channel capacity
    //Get the total maximum coding gain (RS+TCM) (in Q8.8 format)
    s_RSCodingGain = GetCodingGain(0);
    s_RSCodingGain_Show = s_RSCodingGain;



    // Interop Rate Negotiation changes for specific vendors in the INTL Path with Trellis Enabled
    // NOTE: This check for Fast or Intl does not work for BRCM
    if ((guca_R_C_Rates1[0]==0) && (gft_TcmFlag == TRUE))
    {
        // Investigation of what to send in RMSGSRA in INTL Path found the following are ideal:
        // Chipset          RS      CG act      CG rep      Margin Req
        // Default          0       5           -           CRates1 = 6
        // ADI              Any     6.5         6           CRates1 = 0
        // ALA              >0      8           -           CRates1 = 6
        // CTLM (>8128)     0       5.5         -           CRates1 = 6 NOTE: Per testing by Apostolos @ Lucent & UNH
        // CTLM (<=8128)    0       7.5         6           CRates1 = 6
        // GSPN             0       8           6           CRates1 = 3 AnxB
        // GSPN             0       8           7           CRates1 = 6 AnxB
        // IFX              16      8           5.5         CRates1 = 6 AnxB
        // TI               16      8           -           CRates1 = 6
        // BRCM             Any     7.5         -           CRates1 = 6 NOTE: NOT CHECKED IN, cannot detect Fast or Intl in CRates1 Msg

        if (gs_CurrentCoChipset == ALA_CO_CHIPSET)
        {
            s_R = 16;
            s_RSCodingGain = 16;        /* 8db */
            s_RSCodingGain_Show = 16;   /* 8db */
            s_RRatesRA_deltaK = 1;     // else we pick the 2nd option (1 byte lower), which is ok but leaves little margin for error (3rd/4th is much lower)
        }
        else if (gs_CurrentCoChipset == TI_CO_CHIPSET)
        {
            s_R = 16;
            s_RSCodingGain = 16;        /* 8db */
            s_RSCodingGain_Show = 16;   /* 8db */
        }
        else if ((gs_CurrentCoChipset == ADI_CO_CHIPSET) || (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET))
        {
            s_RSCodingGain = 13;         /* Use 6.5db Coding Gain */
            s_RSCodingGain_Show = 12;    /* Show 6db Coding Gain to ADI CO */
        }

#ifndef ISDN
        /*  We have never encountered a Centillium Based Annex B CO, so remove this code to free up memory */
        else if ( (gs_CurrentCoChipset == CTLM_CO_CHIPSET) ||
                (!(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) && (gs_CurrentCoChipset == GENERIC_CO_CHIPSET)) )
        {
            if (gs_Capacity <= 1950) {
                // Original workaround (s_RSCodingGain = 15, s_RSCodingGain_Show = 12) was checked in:
                // 5/21/04 - by Vladin for an issue investigated by Apostolos at Lucent.
                // Legacy CTLM FW could not be obtained to determine the impact this change may cause.
                s_RSCodingGain = 11;        /* 5.5db */
                s_RSCodingGain_Show = 11;   /* 5.5db */
            }
            else {   // Probable >8128 link where CLTM will not offer RS - go with conservative CG assumption
                gs_tcm_coding_gain = TCM_CODING_GAIN;
                s_RSCodingGain = 11 ;
                s_RSCodingGain_Show = 11 ;
            }
        }
#else
        else if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
        {
            s_RSCodingGain = 16;       /* Use 8db Coding Gain */
            if (gs_RxDesiredMargin == 0x0300)
            {
                s_RSCodingGain_Show = 12; /* Show 6db Coding Gain to GSI CO */
            }
            else
            {
                s_RSCodingGain_Show = 14; /* Show 7db Coding Gain to GSI CO */
            }
        }
        else if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
        {
            s_R = 16;                  /* Show 16 overhead bytes (any R > 0 will do). */
            s_RSCodingGain = 16;       /* Use 8db Coding Gain */
            s_RSCodingGain_Show = 11;     /* Show 5.5db Coding Gain to IFX CO */
        }
#endif  // End of #ifndef/#else ISDN
        else
        {
            s_RSCodingGain_Show = s_RSCodingGain;
        }
    }
    if ((guca_R_C_Rates1[0]!=0) && (gft_TcmFlag == TRUE) && (gs_RxDesiredMargin == 0))
    {
        // If Fast Path & CMsg1 Rqst'd Mrg=0, it is ADI RA1 Interface.
        // Calculate Bmax with 0db of Coding Gain.  You are already
        // using 6db of Gain do to Mrg=0db, adding 5.5db of Coding Gain
        // is like calculating Bmax with 11.5db of Coding Gain.

        s_RSCodingGain = 0;         /* 0db */
        s_RSCodingGain_Show = s_RSCodingGain;

#ifdef ISDN
        if (gs_CurrentCoChipset == ADI_CO_CHIPSET)
        {
            // 1. check for ADI-DSLAM
            // 2. check for guca_R_C_Rates1[0]!=0     (=> fast path)
            // 3. check for AS0[RateOption0] == AS0[RateOption3]  (=> rate adapative - all rate options are identical)
            if (guca_R_C_Rates1[0] == guca_R_C_Rates1[90])
            {
                // At DTAG we see ADI930 in Fast Path fails fixed rate 1400m loop with 6dB margin.
                // Link is dropped by CO after R-MSG-RA because DS-Bmax is too low to fulfill the rate requirment
                // Solution is to use 2db of coding gain when calculating Bmax, but only report 0db.
                s_RSCodingGain = 0x4;         /* Use 2db CG */
                s_RSCodingGain_Show = 0;      /* Report 0db CG */
            }
        }
        else if (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET)
        {
            // At CETECOM we see Anaconda in Fast Path with RS ON (ECI Dslam).  Detected by
            // Mrgn=0 in CMsg1 Fast Path.  Solution is to use 2db of coding gain when calculating
            // Bmax, but only report 0db.  Otherwise end up with excess margin.

            s_RSCodingGain = 0x4;         /* 2db */
            // In order to pass tests @ DTAG, changed RS Coding Gain Show = RS Coding Gain Actual.
            // Some excess Margin is seen, however avoids link gaps on long loop reach tests.
            s_RSCodingGain_Show = s_RSCodingGain;
        }
#endif // ISDN ONLY
    }




    if ((gft_TcmFlag == TRUE) && (guca_R_C_Rates1[0]==0) &&
            (gs_CurrentCoChipset==GENERIC_CO_CHIPSET) )
    {
        // These steps sacrifice margin for data rate in order to
        // meet certain FT fixed rate test rate requirements against CTLM.
        // Values were determined experimentally at LEA.

        // Always at least 0.5 dB margin delta against CTLM intlv path:
        OPTNArray[OPTN_MarginDelta] += 0x080;


        // For specific fixed rate cases, increase margin delta:
        if (guca_R_C_Rates1[10]==guca_R_C_Rates1[40])
        {
            if (gus_ncloaded<=175){
                if ((guca_R_C_Rates1[10]==19) || (guca_R_C_Rates1[10]==47) || (guca_R_C_Rates1[10]==76))    // 608 or 1504 or 2432 kbps
                OPTNArray[OPTN_MarginDelta] += 0x0100;      // total 0x180

                if (guca_R_C_Rates1[10]==38) // 1216 kbps
                OPTNArray[OPTN_MarginDelta] += 0x0140;      // total 0x1c0
            }

            if((gus_ncloaded<=125) && (guca_R_C_Rates1[10]==48))     // 1536kbps
            OPTNArray[OPTN_MarginDelta] += 0x0280;       // total 0x300
        }// end specific fixed rates
    }


    // Disable MarginD in fast path or for non-select CO's, if so indicated
    if ( (OPTNArray[OPTN_AlgControl2]&OPTN_MarginD_IntlvDMTonly) && ((gft_TcmFlag==FALSE)||(guca_R_C_Rates1[0]!=0)) )
    {
        // Fast path (for BDCM, this is never going to apply, since they always send CRAtes1 values in the intlv fields)
        OPTNArray[OPTN_MarginDelta] = 0 ;
    }
    if ( (OPTNArray[OPTN_AlgControl2]&OPTN_MarginD_SelectDMTonly)
            && (gs_CurrentCoChipset!=ALA_CO_CHIPSET)
            && (gs_CurrentCoChipset!=BDCM_CO_CHIPSET)
            && (gs_CurrentCoChipset!=GENERIC_CO_CHIPSET) )
    {
        // We are against a non-selected for MarginD CO
        OPTNArray[OPTN_MarginDelta] = 0 ;
    }

//XDSLRTFW-3354 (START)
#ifndef ISDN
   //XDSLRTFW-3674 Options_For_debug
    if (OPTNArray[OPTN_MarginDelta] == 0)//controlled in "RCPILOT1RXF.c"
     {
   //    gs_DSMarginDelta = 0x0080;
       OPTNArray[OPTN_MarginDelta] += gt_HercADSL_OPTNMap_MarginControl.s_OPTN_margin;//gs_DSMarginDelta;
    }
    else gt_HercADSL_OPTNMap_MarginControl.s_OPTN_margin = 0;
#endif
//XDSLRTFW-3354 (END)

    s_RxInitialMargin = gs_RxDesiredMargin ;

    // Adjust Constellation SNR if Trellis is on and Fast path is going to be used
    if ( (gft_TcmFlag == TRUE) && (guca_R_C_Rates1[0]>0) ){    // guca_R_C_Rates1[0] (=AS0[FAST]) >0 -> CO uses fast path
        AdjustTcmCodingGains(0);
    }

#ifndef ISDN   // Only for Anx-A
    // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (Start)
    // Link hole was observed at 6 to 7kft in G.dmt/T1413 Intl Mode against old Geminax FW versions
    // 07_0F_03 & 07_0F_05. Observed that the received DS rate options are too high to be accepted
    // from CPE.
    // Hence reduce the Bmax by using the Delta Margin of MARGIN_DELTA_TO_GET_LESS_CRATESRA, (Q8.8
    // format)
    // to get less C-RATESRA option in the DS. With this we may loose 300kbps instead of Link hole.
    // Though this problem was observed with Geminax, it is extended to other CO's too, if we have
    // any
    // similar problem.
    if (gus_Persistent_UserDefBits & REDUCE_BMAX_IN_RMSGRA_FOR_ADSL1)
    {
        /* Compute Required SNR (= constellation SNR + margin) for each constellation */
        OffsetSNRRequired((gs_RxDesiredMargin +
        MARGIN_DELTA_TO_GET_LESS_CRATESRA) -
        OPTNArray[OPTN_MarginDelta], gsa_SNRRequired);
    }
    else
    // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (End)
#endif // ifndef ISDN
    /* Compute Required SNR (= constellation SNR + margin) for each constellation */
    OffsetSNRRequired(gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta], gsa_SNRRequired);

    /* Compute SNR plus coding gain */
    gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

    /* Add coding gain to SNRs */
    AddCodingGainToSnr(gsa_MedleySnrBuf, (int16)(s_RSCodingGain<<7), gpsa_MeasuredSnrBuf, s_path);

    /* Calculate the max bits per symbol that the channel can support */
    /* and perform initial bit allocation and fine gain marking */
    gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);



#ifdef ISDN
    /*  Hack to link on long loops against Anaconda CO in the Intl Path in Annex B.
        This forces CO to use RS Coding on it's rate options, which allows CPE to link
        for an additional 200m of loop reach with EB noise on the UR2 3dB Profile.  */
    if ((gs_TotalBitsSupported < 64) && (guca_R_C_Rates1[0]==0) && (gft_TcmFlag == TRUE) && (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET))
    {
        s_RxInitialMargin = 0;          // 0dB Margin
        s_R = 0;                        // 0 RS Checkbytes
        gs_TotalBitsSupported = 0xAE;   // Bmax = 174 bits
        gus_ncloaded = 0x54;            // NC = 84
        s_RSCodingGain_Show = 0xD;      // Coding Gain Reported = 6.5dB
    }
#endif // ISDN ONLY

    /* Compute the TCM overhead if it is used */
    if(gft_TcmFlag == TRUE){
        s_Tcm_Oh = (((int16)gus_ncloaded+9)>>1);
    }

    /* Don't select rate option at this time */
    gs_DS_RateOption = NO_RATE_OPTION_SELECTED;

    /* Set up R_MSGS structure */
    gt_RMsgRA.us_SnrMargin = (uint16)((s_RxInitialMargin+(1<<7))>>8);
    gt_RMsgRA.us_R = s_R;

    gt_RMsgRA.us_K = (gs_TotalBitsSupported - s_Tcm_Oh) >> 3;

    /* Limit reported K, per user configuration */
    s_UserMaxK = gt_ADSL1_Control.DsRateCap >>3 ; // in bytes
    if ((guca_R_C_Rates1[0]==0) && (gft_TcmFlag == TRUE)) {    // Intlv Path
        // Below: /3 for bits/tone; >>3 for bytes; >>1 for CG in dB
        s_UserReportedK = s_UserMaxK - (gs_max_coding_gain-s_RSCodingGain)*(gus_ncloaded>>4)/3;
        s_UserReportedK += 6 ;         // So as not to be overly conservative in the capped options
    }
    else {
        s_UserReportedK = s_UserMaxK ;
    }
    if (gt_RMsgRA.us_K > s_UserReportedK) {
        gt_RMsgRA.us_K = s_UserReportedK;

        // If ADI CO, INTL Path &  DS Rate Capped by User
        // Report to CO assumptions were CG =0, SNR=6
        if (((gs_CurrentCoChipset == ADI_CO_CHIPSET) || (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET)) && (guca_R_C_Rates1[0]==0))
        {
            s_RSCodingGain_Show = 0;
            gt_RMsgRA.us_SnrMargin = 6;
        }
    }

    if ((int16)gt_RMsgRA.us_K < 0)
    {
        gt_RMsgRA.us_K = 0;
    }

    if (gt_RMsgRA.us_K >= 6) {
        gt_RMsgRA.us_K -= s_RRatesRA_deltaK;    //Reduce (by 1, against ALA-INTLV so far) to target 1st option
    }

    gt_RMsgRA.us_ncloaded = gus_ncloaded;
    gt_RMsgRA.us_CodingGain = s_RSCodingGain_Show;
    gt_RMsgRA.us_TotalBitsPerSymbol = (gt_RMsgRA.us_K<<3) + s_Tcm_Oh;
    //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
    //To improve the DS rate when against NVLT-C in T1413 mode, the solution is below.

    //1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
    //   then set the parameters in R-MsgsRA accordingly.
    //   After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
    //   which are provided by CPE in R-MsgsRA.
    //   Then CPE will select the first option from the C-RatesRA.
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
#ifndef  ISDN  // Only for Annex - A
   //if ((gs_fe_T1413_VendorID == 0x53) && (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected))
   if ( ((gs_fe_T1413_VendorID == 0x53) && (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)) ||
         ((gft_Adtran_GMX_DMT == TRUE) && (guca_R_C_Rates1[0] == 0)) )
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)
   {
      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
      FlagT ft_NVLTC_fix = FALSE;
      FlagT ft_AdtranGmx_fix = FALSE;

      if ( (gs_fe_T1413_VendorID == 0x53) && (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) )
         ft_NVLTC_fix = TRUE;

      if ( (gft_Adtran_GMX_DMT == TRUE) && (guca_R_C_Rates1[0] == 0) )
      {
         ft_AdtranGmx_fix = TRUE;
         gft_workaround_lowrate_Adtran_GMX = TRUE;
         gs_fgain_adjust = 0x0200;
      }
      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)

   //The searching starting from R = 4 is to garantee some RS protection due to the impulse-like noise
   //found in NVLT-C CO, no noise case. The impluse-like noise can not be observed with averaged minimum margin.
      //for (s_R=0; s_R<=16; s_R+=2)
      for (s_R=4; s_R<=16; s_R+=2)
      {

         gft_BitloadOK = InitBitloading(s_path);

         // Get the total maximum coding gain (RS+TCM) (in Q8.8 format)
         s_RSCodingGain = GetCodingGain(s_R);

         // Adjust Constellation SNR if Trellis is on
         if (gft_TcmFlag == TRUE)
            AdjustTcmCodingGains(gft_RS_Support);

         // Compute Required SNR (= constellation SNR + margin) for each constellation
         OffsetSNRRequired(gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta],
                           gsa_SNRRequired);

         /* Compute SNR plus coding gain */
         gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

         /* Add coding gain to SNRs */
         AddCodingGainToSnr(gsa_MedleySnrBuf, (int16) (s_RSCodingGain << 7),
                           gpsa_MeasuredSnrBuf, s_path);

         /* Calculate the max bits per symbol that the channel can support */
         /* and perform initial bit allocation and fine gain marking */
         gs_TotalBitsSupported =
            CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits,
                        &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);

         if (gft_TcmFlag == TRUE)
         {
            s_Tcm_Oh = (((int16) gus_ncloaded + 9) >> 1);
         }

         s_temp = ((gs_TotalBitsSupported - s_Tcm_Oh) >> 3) - s_R;
         //ChihWen: Fix of no sync issue on 2500m ~ 3500m loops (START)
         //When K+R > 255 and S=1/2, the coding gain should be calculated by R/2 in C-RatesRA.
         //The reported K should be adjusted by K-R, and the reported R should be adjusted by 2R, to make
         //(K-R)+2R = K+R.
      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
         if ( (ft_NVLTC_fix == TRUE) &&
               ((gt_RMsgs1.us_Higher_BitRates == S_HALF_OPTION) && ((s_temp+s_R) > 255)) )
         //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)
         {
            //Reduce 8 more bytes to make CO to provide more appropriate options
            s_temp -= (s_R+8);
            if (s_temp < 0)
               s_temp = 1;

            s_R += s_R;
         }
         //ChihWen: Fix of no sync issue on 2500m ~ 3500m loops (START)


         if (s_temp > s_max_payload)
         {
            s_max_payload = s_temp;
            s_maxR = s_R;
            s_RSCodingGain_Show = s_RSCodingGain;

            //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
            if (ft_NVLTC_fix == TRUE)
            {
               gt_RMsgRA.us_K = s_max_payload;
               gt_RMsgRA.us_R = s_maxR;
               gt_RMsgRA.us_ncloaded = gus_ncloaded;
               gt_RMsgRA.us_CodingGain = s_RSCodingGain_Show;
               gt_RMsgRA.us_TotalBitsPerSymbol = ((gt_RMsgRA.us_K+gt_RMsgRA.us_R) << 3) + s_Tcm_Oh;
            }
            if (ft_AdtranGmx_fix == TRUE)
            {
               if (s_max_payload >= 64)
               {
                  gt_RMsgRA.us_K = s_max_payload;
                  gt_RMsgRA.us_R = 0;

                  //The one-order equation is from the (codeword size, loaded tone number) = (245,152)   and (104,64)
                  gt_RMsgRA.us_ncloaded = ((int32)(gt_RMsgRA.us_K+gt_RMsgRA.us_R)*(int32)(159)-(int32)(232)) >> 8;
                  if (gt_RMsgRA.us_ncloaded < 64)
                     gt_RMsgRA.us_ncloaded = 64;
                  s_Tcm_Oh = (gt_RMsgRA.us_ncloaded + 9) >> 1;

                  gt_RMsgRA.us_CodingGain = 11;
                  gt_RMsgRA.us_TotalBitsPerSymbol = ((gt_RMsgRA.us_K+gt_RMsgRA.us_R) << 3) + s_Tcm_Oh;
               }
            }
         }//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)
      }
   }
#endif
   //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)

    gft_BitloadOK = SUCCEED;
}



/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void SelectRateOptionForRMsg2(void);
*
*   Description:
*  This function is called in R_C_REVERB_RA state. This function select
*  the final rate option from C_RATE_RA according to new target SNR margin
*   from C_MSG_RA
*
*   Returns:
*     none
*
*  Global Variables:
*     gft_FineGainOn -- (I) indicator if fine gain is used (1) or not (0)
*
*     gpsa_MeasuredSnrBuf -- (O) pointer to measured SNR buffer
*     gs_BitLoadingOK      -- (O) set to SUCCEED if bit loading succeeds, else set to FAIL
*     gsa_SNRRequired[] -- (O) required SNR per constellation for given SNR margin
*
*     gsa_RxBat[] --    (O) final bit allocation table
*     gsa_RxFineGains[] --(O) final fine gain tables
*     gs_RxAvMargin --  (O) average SNR margin in Q8.8
*     gs_RxMinMargin -- (O) minimum SNR margin in Q8.8
*     gs_RxAvFineGain --   (O) average fine gain in Q8.8
*     gs_US_RateOption -- (O) highest rate option supported
*     gft_RCExchRARcvFlag - (O)
*-----------------------------------------------------------------------------
^^^*/
void SelectRateOptionForRMsg2(void)
{

#ifdef  T1413_SUPPORT_EES_OFF
    int16 s_RSCodingGain;

    if((STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) && (!gft_T1413_EesFlag) )  {
        // do bit loading if EES is not used

        //Init Bit Loading
        gft_BitloadOK = InitBitloading(s_path);

        //Get the total maximum coding gain (RS+TCM) (in Q8.8 format)
        s_RSCodingGain = GetCodingGain(gft_RS_Support);

        // Adjust Constellation SNR if Trellis is on
        if (gft_TcmFlag == TRUE)
        AdjustTcmCodingGains(gft_RS_Support);

        //Compute Required SNR (= constellation SNR + margin) for each constellation
        OffsetSNRRequired(gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta], gsa_SNRRequired);

        //Compute SNR plus coding gain
        gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

        //Add coding gain to SNRs
        AddCodingGainToSnr(gsa_MedleySnrBuf, (int16)(s_RSCodingGain<<7), gpsa_MeasuredSnrBuf, s_path);

        //Calculate the max bits per symbol that the channel can support
        //and perform initial bit allocation and fine gain marking
        gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF,s_path);

        //Minimum data rate has to be >= 2*32 kbps
        //(i.e. one byte for synch and at least one byte per symbol for payload)
        if(gs_TotalBitsSupported < 16) {
            gs_DS_RateOption = ALL_OPTIONS_FAIL;
            gft_BitloadOK = FAIL;
            return;
        }
        //Form R_MSG2 message
        gt_RMsg2.s_TotalBitsSupported = gs_TotalBitsSupported /*+ gs_TcmOh*/;
    }
#endif

    //Compute Required SNR (= constellation SNR + margin) for each constellation
    OffsetSNRRequired(gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta], gsa_SNRRequired);

    //XDSLRTFW-3354 (START)
   //XDSLRTFW-3674 Options_For_debug ; handled in RCPilot1RxF.c
   if (gt_HercADSL_OPTNMap_MarginControl.s_OPTN_margin != 0)
   {
      OPTNArray[OPTN_MarginDelta] -= gt_HercADSL_OPTNMap_MarginControl.s_OPTN_margin;
   }
   //XDSLRTFW-3354 (END)

   //Select DS rate option
   SelectDsRateOption(gta_DS_options, &gs_DS_RateOption);

#ifndef ISDN   // Only for Anx-A
    // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (Start)
    // Bit Load failed since the received DS rate options are too high to be accepted from CPE.
    // => retrain and send lower max rate to reduce CO DS rate options
    if ((gs_DS_RateOption == ALL_OPTIONS_FAIL) && (gft_BitloadOK == FAIL))
    {
        gus_Persistent_UserDefBits |= REDUCE_BMAX_IN_RMSGRA_FOR_ADSL1;
    }
    // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (End)
#endif // ifndef ISDN


    if (gs_DS_RateOption == ALL_OPTIONS_FAIL) {
        gt_RMsg2.us_PerformMargin = 0;
    }
    else {

        /* Form R_MSG2 message (perform rounding) */
        gt_RMsg2.us_PerformMargin = (uint16)((gs_RxAvMargin+(1<<7))>>8);

    }

    /* Form R_MSG2 message */
    gt_RMsg2.s_TotalBitsSupported = gs_TotalBitsSupported;

    /* Form R_MSGS2, R_RATES2, and R_B&G */
    FormRInfo2();

    /* Set the flag to indicate bitloading is done */
    gft_BitloadState = TRAINING_DONE;

    /* Note: if bitloading fails, the state machine will go to */
    /* fail state until after sending out R_RATES2 (so CO will know why CPE fails) */
}

/*^^^
*-------------------------------------------------------------------
*
*  FlagT VerifyRateWithOneCG(int16 s_TotalBytes, int16 s_CodingGain, int16 s_path)
*
*  Description:
*      This function performs bitloading based on given coding
*  gain and decide if the total bits allocated can support or
*   cannot support given rate.  "OneCG" means "one coding gain"
*  value, i.e. single latency data path.
*
*  Input Arguments:
*     s_TotalBytes -- number of bytes required per symbol
*                 (excluding bits for TCM overhead bits)
*     int16 s_CodingGain - Coding gain used
*
*  Return:
*     FAIL or SUCCEED
*
*  Global Variables:
*     guca_RSCodingGain[] -- (I) Reed Solomon coding gain table
*     gft_TcmFlag       -- (I) TCM enable flag
*     gsa_MedleySnrBuf[]   -- Medley SNR buffer
*
*     gsa_RxShowtimeSnrBuf[] -- (O) SNR plus coding gain buffer
*     gpsa_MeasuredSnrBuf     -- (O) pointer to SNR buffer above
*     gs_TotalBitsSupported  -- (O) total number of bits supported
*     gus_ncloaded         -- (O) total number of tone allocated
*     gs_RxBat[]           -- (O) new bit allocation table
*     gs_RxExtraBits       -- (O) no. of extra bits due to use of fine gains
*-------------------------------------------------------------------
*^^^
*/

FlagT VerifyRateWithOneCG(int16 s_TotalBytes, int16 s_CodingGain, int16 s_path)
{
    // Note: VerifyRateWithOneCG now expects a 8.8 CG argument (instead of the previous 15.1)

    int16 s_OhTcm;
    int16 s_BitsPerSymbol;
    int16 i,s_delta_Lp, s_ActualDeltaSumLp;
    int32 l_SumFineGaindB;
    int16 s_AvRemainingFineGaindB, s_RemainingFineGainPerTone;
    int16 s_ch;

    /*Store coding gain in Q8.8 format*/
    gsa_TotalCodingGain[s_path] = s_CodingGain;

    /* Compute SNR plus coding gain */
    gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];


    AddCodingGainToSnr(gsa_MedleySnrBuf, gsa_TotalCodingGain[s_path], gpsa_MeasuredSnrBuf, s_path);

    gft_BitloadOK = InitBitloading(s_path);


    gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF,s_path);


    /* Compute TCM overhead based adjusted number loaded tones */
    if(gft_TcmFlag == TRUE)
    s_OhTcm = (int16)(((gus_ncloaded+1)>>1) + 4);
    else
    s_OhTcm = 0;

    s_BitsPerSymbol = s_TotalBytes*8 + s_OhTcm;

    //Check if the total available bits is greater than the total required bits
    if(gs_TotalBitsSupported >= s_BitsPerSymbol) {

        // set tone flag, currently all tones are set to 1, this is important mainly in BIS
        for (i=0 ; i<gs_RxNumTones ; i++)
        {
            SETTONEFLAG(p_MEDLEYset_DS, i);
        }

        /* Skip for the DD pilot tone */
        CLEARTONEFLAG(p_MEDLEYset_DS, gs_AuxPilotToneIdx);
        CLEARTONEFLAG(p_MEDLEYset_DS, gs_CPilotTone);

        s_delta_Lp =  s_BitsPerSymbol - gs_TotalBitsSupported;
        gft_BitloadOK = !ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_delta_Lp , gpsa_MeasuredSnrBuf, gs_RxDesiredMargin, p_MEDLEYset_DS, guca_RxBitswapTones, &s_ActualDeltaSumLp, FALSE, 0,0);

        if(gft_BitloadOK == SUCCEED)
        {
            if(s_path == FAST_DATA_PATH)
            gs_MaxToneForFast = gs_RxNumTones-1;
            else
            gs_MaxToneForFast = -1;

            gs_RxMinMargin = 0x7FFF;

            //loaded tones and/or fine gains could be changed by ChangeLpKeepMaxMargin, so recalculate AvFineGain here.
            l_SumFineGaindB = 0;
            for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
            {
                if (guca_RxBat[s_ch] > 0)
                l_SumFineGaindB += gsa_RxFineGains[s_ch];
            }

            gs_RxAvFineGain = QuickAverage(l_SumFineGaindB, gus_ncloaded);

            // Consider whether we should add the unused fine gain on the loaded tones to improve margin
            // for now we only consider long loops
            l_SumFineGaindB = 0;
            if ((gft_FineGainOn == TRUE) && (gus_ncloaded <= OPTNArray[OPTN_FgainAjust_Threshold]))
            {
                s_AvRemainingFineGaindB = gs_fgain_adjust - gs_RxAvFineGain;
                if (s_AvRemainingFineGaindB > 0)
                {
                    for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
                    {
                        // PERF_DS_AB_ALL_ALL_PilotBugfixes (START)
                        //Skip Aux Pilot Tone to ensure it has 0dB finegain
                        if (s_ch == gs_AuxPilotToneIdx)
                        continue;
                        // PERF_DS_AB_ALL_ALL_PilotBugfixes (END)
                        if (guca_RxBat[s_ch] > 0)
                        {
                            s_RemainingFineGainPerTone = gs_max_fine_gain - gsa_RxFineGains[s_ch];

                            gsa_RxFineGains[s_ch] += MIN (s_AvRemainingFineGaindB, s_RemainingFineGainPerTone);

                            l_SumFineGaindB += gsa_RxFineGains[s_ch];
                        }
                    }

                    gs_RxAvFineGain = QuickAverage(l_SumFineGaindB, gus_ncloaded);
                }
            }
            //Calulate actual fine gain and margin
            //Inside the following function, only the fine gains for unloaded tones are modified. So the average fine gain is
            //not affected.
            CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);

            // Report DS margin as 6 when it is 5.8 or 5.9
            // SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (Start)
            // 0x05CC is 5.79dB in 6.6 format
            if ((gs_RxAvMargin > 0x05CC) && (gs_RxAvMargin < 0x0600))
               gs_RxAvMargin = 0x0600; // 0x0600 is 6dB in 8.8. format
            // SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (End)

            // save the average and min margin at the end of initializations
            gs_init_AvMargin = gs_RxAvMargin;
            gs_init_MinMargin = gs_RxMinMargin;

            return(SUCCEED);
        }
    }
    return(FAIL);

}


/*^^^
*------------------------------------------------------------------------
*
*  Prototype: void BGMedleyBitload(void)
*
*  Description: Background Medley bitloading.
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*
*------------------------------------------------------------------------
*^^^
*/
void BgMedleyBitload(void)
{
    gl_Rx_Total_Power = 0;


#ifdef  T1413_SUPPORT_EES_OFF
    if ( (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) && (!gft_T1413_EesFlag) )
    SelectRateOptionForRMsg2();
    else
#endif
    SelectRateOptionForRMsgRA();

    gft_BitloadState = TRAINING_DONE;
}



/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 ChooseFineGains_DMT(void);
*
*   Description:
*     Computes the exact amount of fine gain required for each tone and allocates
*     that. pl_SumFineGainsdB is the total sum of fine gain which can be applied
*     and l_MaxSumFineGain, is the maximum sum fine gain which can be applied
*
*
*   Returns:
*       number of extra bits allocate by applying the fine gain
*
*  Global variables:
*     gs_RxBitLoadFirstChannel-- (I) RX first channel
*     gs_RxBitLoadLastChannel -- (I) RX last channel
*     gpsa_MeasuredSnrBuf     -- (I) pointer to computed channel SNR per tone
*     gsa_SNRRequired[]    -- (I) required SNR per constellation
*     guc_MaxAllocBitsPerTone -- (I) maximum number of bits per tone
*
*     gsa_RxBat[]          -- (I/O) Bit Allocation Table after adding bits due to fine gain
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE int16 ChooseFineGains_DMT(uint8 *psa_RxBat, int16 *psa_RxFineGains, int32 *pl_SumFineGainsdB, int16 us_ncloaded)
{

    int16 s_ch;             /*  channel index */
    uint8 s_qc;             /*  QAM constellation size */
    int16 s_FineGainIncrease;
    int16 s_ExtraBits = 0;
    int  s_step, s_threshold;
    int16 s_fgain_adjust;
    int32 l_MaxSumFineGain;

    /* By default, use fine gain adjustment set in RCMedleyRxF_Bitload.c. */
    s_fgain_adjust = gs_fgain_adjust;

#ifdef ISDN
    /* To extend the reach in Annex B, allow for maximum fine gain adjustment if desired */
    /* adjustment is non-zero and the number of loaded tones is less than a threshold. */
    /* Note that at this point all tones have minimum fine gain (-2.5dB) added to SNRs */
    /* in the initial bitloading at the beginning CalcMaxBits() function. Local fine gain */
    /* adjustment change is desired so that this extra fine gain boost is not considered */
    /* when remaining fine gains are distributed on all tones to improve margin in */
    /* VerifyRateWithOneCG() function. */
    if ((gs_fgain_adjust != 0) && (us_ncloaded < gs_fgain_adjust_ncload3))
    {
        s_fgain_adjust = gs_max_fine_gain;
    }
#endif

    l_MaxSumFineGain = us_ncloaded * s_fgain_adjust;

    /* First go through the unloaded tones since we gain more bits using positive fine gains on these */
    /* tones than on the others. */
    for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
    {
        if (psa_RxBat[s_ch] == 0)
        {
            /* Find fine gain needed. */
            s_FineGainIncrease = gsa_SNRRequired[RX_MIN_BITS_PER_TONE] - gpsa_MeasuredSnrBuf[s_ch];
            /* Skip channels with too large fine gains. */
            if (s_FineGainIncrease > gs_max_fine_gain)
            continue;

            /* Check if we can use this much fine gain. Note that adding the tone increases the */
            /* ncloaded, which is taken care of by the adjustment to l_MaxSumFineGain. */
            if (*pl_SumFineGainsdB + s_FineGainIncrease < l_MaxSumFineGain + s_fgain_adjust)
            {
                psa_RxBat[s_ch] = RX_MIN_BITS_PER_TONE;
                s_ExtraBits += RX_MIN_BITS_PER_TONE;
                psa_RxFineGains[s_ch] = s_FineGainIncrease;
                *pl_SumFineGainsdB += s_FineGainIncrease;
                l_MaxSumFineGain += s_fgain_adjust;
            }
        }
    }

    /* Now process the rest of the tones. Prioritize the fine gain assignment by using a threshold */
    /* that increases from min fine gain to max fine gain. */
    for (s_step = gs_min_fine_gain + 128; s_step <= 640; s_step += 128)
    {
        s_threshold = s_step;

        /* saturate fine gains larger than the gs_max_fine_gain to gs_max_fine_gain */
        if (s_threshold > gs_max_fine_gain)
        s_threshold=gs_max_fine_gain;

        for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
        {
            /* Skip for the DD pilot tone */
            if (s_ch == gs_AuxPilotToneIdx || s_ch == gs_CPilotTone)
            continue;

            if (IS_TONEFLAGSET(p_FINEGAINSKIPset,s_ch) )
            continue;
            s_qc = psa_RxBat[s_ch];
            if ((s_qc == 0) || (s_qc == guc_MaxAllocBitsPerTone))
            continue;

            /* Find fine gain needed. */
            s_FineGainIncrease = gsa_SNRRequired[s_qc+1] - gpsa_MeasuredSnrBuf[s_ch];


            if (s_FineGainIncrease > s_threshold)
            continue;

            /* Find fine gain increase. */
            s_FineGainIncrease -= psa_RxFineGains[s_ch];

            /* Check if we can use this much fine gain. */
            if (*pl_SumFineGainsdB + s_FineGainIncrease < l_MaxSumFineGain)
            {
                psa_RxBat[s_ch] += 1;
                s_ExtraBits += 1;
                psa_RxFineGains[s_ch] += s_FineGainIncrease;
                *pl_SumFineGainsdB += s_FineGainIncrease;
            }
        }
    }

    return(s_ExtraBits);
}


/********************************************************************************
*   Prototype:
*       int16 Reduce1bitDMT( int16 *s_DeltaSumbi, uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *pus_ncloaded,int16  *psa_SNRBuffer, int16 s_MinBitsPerToneToConsider,  RxToneFlags p_ActiveTones_ToConsider, RxToneFlags p_ModifiedTones)
*
*   Description:
*     Exactly reduce 1 bit in case of DMT. The code works by finding any tone which has more than
*         2 bits, and removes 1 bit from it. In case we have all  2 bit tones,
*     it looks at the tone with highest margin, adds a bit to it and looks at tone with smallest
*     margin and removes 2 bits from it. Changes ncloaded in the process.
*
*
*  Global variables:
*     p_MedleySet : Same as supported set
*       p_ModifiedTones : Modified tones Array
*     gsa_RxFineGains[] : Fine Gains Table
*     guc_MaxAllocBitsPerTone : maximum number of bits per tone
*     psa_SNRBuffer   : SNR per tone
*     guca_RxBat[]   : Bit Allocation Table
*     s_DeltaSumbi   : number of bits to decrease
*
********************************************************************************/

C_SCOPE int16 Reduce1bitDMT( int16 *s_DeltaSumbi, uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *pus_ncloaded,int16  *psa_SNRBuffer, int16 s_MinBitsPerToneToConsider,  RxToneFlags p_ActiveTones_ToConsider, RxToneFlags p_ModifiedTones)
{
    uint8 uc_RetCode = 0;     // Return value

    int16 s_ch, s_ch1, s_Margin;
    FlagT ft_Result1, ft_Result2;

    //check if bat has >2 bit tones, if yes find it
    for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
    {
        if ((puca_RxBat[s_ch] > 2) && (IS_TONEFLAGSET(p_ActiveTones_ToConsider, s_ch)))
        {
            puca_RxBat[s_ch]--;
            *s_DeltaSumbi = 0;
            SETTONEFLAG(p_ModifiedTones, s_ch);
            break;
        }
    }

    //Could not find any 3 bit tones
    if (*s_DeltaSumbi != 0)
    {
        // add 1 bit to  tone with largest margin and remove one of the two bit tone
        // this case would happen only if we have all 2 bit tones

        ft_Result1 = FindToneWithExtremeMargin(LARGEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer, p_ActiveTones_ToConsider, s_MinBitsPerToneToConsider, (int16)(guc_MaxAllocBitsPerTone-1), &s_ch1, &s_Margin);

        CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch1);

        ft_Result2 = FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer, p_ActiveTones_ToConsider, s_MinBitsPerToneToConsider, (int16)(guc_MaxAllocBitsPerTone-1), &s_ch, &s_Margin);

        if ((ft_Result1 == FAIL) || (ft_Result2 == FAIL))
        {
            uc_RetCode = CHGBAT_RETCODE_CANT_CHANGE_LP;
        }

        puca_RxBat[s_ch1]++;
        puca_RxBat[s_ch]-=2;
        psa_RxFineGains[s_ch] = 0;

        (*pus_ncloaded)--;
        *s_DeltaSumbi = 0;

        // not sure whether we need to set this here (?)
        SETTONEFLAG(p_ModifiedTones, s_ch1);
        SETTONEFLAG(p_ModifiedTones, s_ch);
        SETTONEFLAG(p_ActiveTones_ToConsider, s_ch1); // important as the code may be getting to this part more than once
        SETTONEFLAG(p_ActiveTones_ToConsider, s_ch);

    }
    return(uc_RetCode);

}
