/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   fdq_adj.c
;
;  Routine to perform frequency-domain equalization (FDQ) training
;   during Medley.
;
;****************************************************************************/

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fdq_adap.h"
#include "RCMedleyRxF.h"
#include "rcmedley_Data.h"
#include "find_sintbl.h"
#include "cmv.h"
#include "pll.h"
#include "fft_tab.h"

/*****************************************************************************
;  Prototype:
;     void FdqAdjust(int16 *psa_FDQ_coef_in, int8 *psa_FDQ_exp_in,
;                 int16 s_offset, int16 *psa_FDQ_coef_out,
;                 uint8 *psa_FDQ_exp_out)
;
;  This sunroutine computes new FDQ parameters based on given FDQ parameters
;  and an offset value. Assume that given FDQ parameters are computed
;  for received signal x[n], n = 0, 1, ..., N (where N is number of samples
;  per symbol), new FDQ parameter should be computed for signal x[(n+offset)%N],
;  where offset can be negative or positive. Algorithm used are described below:
;
;  Let X[k] = Xr[k] + jXi[k], for k=0, 1, ..., N, represent FFT of x[n], and
;  X1[k] = X1r[k] + jX1i[k], for k=0, 1, ..., N, represent FFT of x[(n+m)%N]
;  Then
;
;     X1[k] = X[k] * W^(-km), where W = e^(-j2*pi/N)
;
;     X1[k] = X[k] * e(j2*pi*km/N)
;
;  Thus, the relation between new FDQ coefficients, FDQ1[k], and old FDQ coefficients,
;  FDQ[k], can be expressed:
;
;  FDQ1[k] = FDQ[k]*e(-j2*pi*km/N), since FDQ[k] = Y[k]/X[k], where Y[k] is reference
;
;  FDQ1[k] = FDQ1r[k] + jFDQ1i[k]
;        = (FDQr[k] + jFDQi[k])*(cos(2*pi*km/N)-jsin(2*pi*km/N))
;        = (FDQr[k]*cos(2*pi*km/N) + FDQi[k]*sin(2*pi*km/N))
;        + j(FDQi[k]*cos(2*pi*km/N) - FDQr[k]*sin(2*pi*km/N))
;
;  FDQ1r[k] = (FDQr[k]*cos(2*pi*km/N) + FDQi[k]*sin(2*pi*km/N))
;  FDQ1i[k] = (FDQi[k]*cos(2*pi*km/N) - FDQr[k]*sin(2*pi*km/N))
;
;  where sin(2*pi*i/N) for i=0, 1, ... N, are precomputed
;  and cos(2*pi*i) = sin(2*pi*(i+N/4)/N)
;
;  Input Arguments:
;     gsa_FDQ_coef_in -- pointer to input FDQ coefficient buffer
;     gsa_FDQ_exp_in -- pointer to input FDQ exponent buffer
;     gus_SyncOffset -- frame synch offset (relative to the frame synch point with which
;              the input FDQ is computed)
;
;  Output Arguments:
;     gsa_FDQ_coef -- pointer to output FDQ coefficient buffer
;     gsa_FDQ_exp -- pointer to output FDQ exponent buffer
;
;
;  Global Variable:
;     none
;
;****************************************************************************/

#define SIN_TBL_RSH_CNT    15       /* right shift count for table gsa_SinTbl[i] */

C_SCOPE void FdqAdjustPerTone(int16 *psa_FDQ_coef_in, uint8 *puca_FDQ_exp_in,
                     int16 *psa_FDQ_coef_out, uint8 *puca_FDQ_exp_out,
                     int16 s_chan_index, int16 s_offset)
{

   int16 i, i2, i2p1, j;
   int16 sa_PhaseShift[2];

   i = s_chan_index;
   i2 = i*2;
   i2p1 = i2+1;

   /* Set s_sin = sin(2*PI*s_offset*i/(2*RX_NUM_TONES)); */
   j = s_offset * i;
   while(j < 0)
      j += gs_RxFftLength;
   j &= (gs_RxFftLength-1);

   // The sa_PhaseShift[] array will hold the unity-magnitude
   // complex number W = e^(-j2*pi/N).
   sa_PhaseShift[1] = -1*findSinTbl(j);   // Imag part = -sin(2*pi/N).

   /* Set s_cos = cos(2*PI*s_offset*i/(2*RX_NUM_TONES)); */
   /* Since cos[w] = sin[w+Pi/2], then the cosine value can be obtained from sin table */
   j += gs_RxFftLength>>2;
   j &= (gs_RxFftLength-1);

   sa_PhaseShift[0] = findSinTbl(j);   // Real part = cos(2*pi/N).

   // Use the FdqUpdate() function to do the complex multiply of
   // gsa_FDQ_coef_in by sa_PhaseShift.  The FdqUpdate() function
   // does the multiply in place, so first copy the input coeff value to
   // the output array.

   psa_FDQ_coef_out[0] = psa_FDQ_coef_in[0];
   psa_FDQ_coef_out[1] = psa_FDQ_coef_in[1];
   puca_FDQ_exp_out[0] = puca_FDQ_exp_in[0];

   // The FdqUpdate() function expects mantissas with FDQ_MANTISSA_FRAC_BITS
   // fractional bits, whereas the PhaseShift mantissa have SIN_TBL_RSH_CNT
   // fractional bits.  Account for this by specifying the exponent of
   // PhaseShift to be the difference between the two constants.

   FdqUpdate((int16 *) psa_FDQ_coef_out, (uint8 *) puca_FDQ_exp_out,
            (int16 *)sa_PhaseShift, FDQ_MANTISSA_FRAC_BITS - SIN_TBL_RSH_CNT);
}

C_SCOPE void FdqAdjust(void)
{

   int16 i, i2, i2p1;

   for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++)
   {
      /* No fdq adjustment on the DD pilot tone */
#ifdef DANUBE_TEMP
         if ( ((i ==gs_AuxPilotToneIdx) && (gs_PilotToneIdx==gs_AuxPilotToneIdx)) || i == gs_CPilotTone)
#else
      if (i == gs_AuxPilotToneIdx || i == gs_CPilotTone)
#endif
         continue;

      i2 = i*2;
      i2p1 = i2+1;
      FdqAdjustPerTone(&gsa_FDQ_coef_in[i2], &guca_FDQ_exp_in[i],
                  &gsa_FDQ_coef_out[i2], &guca_FDQ_exp_out[i],
                  i, gs_MedleySyncOffset);
   }

   guc_FdqTrainingState = TRAINING_DONE;
}

#undef SIN_TBL_RSH_CNT
