/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   find_SinTbl.c
;
;
;
;****************************************************************************/

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fdq_adap.h"
#include "RCMedleyRxF.h"
#include "rcmedley_Data.h"


#define FFT_LEN_1024 1024

#define SIN_TBL_RSH_CNT    15       /* right shift count for table gsa_SinTbl[i] */

/* #define CALC_SIN_TBL */
#undef CALC_SIN_TBL     /* ifdef compute table, if undef use precomputed table */

#ifdef CALC_SIN_TBL     /* Compute sine table */

   #include <stdio.h>
   #include <math.h>
   FILE *fp_sin = NULL;
   double d_omega = (2.0*3.141592654/(2*gs_RxNumTones));
   double d_alpha, d_sin;
   int16 gsa_SinTbl[2*RX_NUM_TONES];

#else /* Use precomputed table */

/* SinTbl[i] = sin(2*pi*i/(RX_NUM_TONES*2)) in Q1.15 format */
extern int16 *gsa_sk_tab256;

#endif   /* #else //Use precomputed table */

C_SCOPE int16  findSinTbl(int16 j){
#if CALC_SIN_TBL
   return(gsa_SinTbl(j));
#else

   int16 s_value;
#if (RX_NUM_TONES == 128)
   j = j<<1;   /*double index */
#endif
   /*Four regions: 1st half of sine wave needs -1 since table starts with negative
   entries*/
   /* to reduce code size, could implement as:  d=abs(128-j&&0xFF); index=128-d;
                                    s_value = gsa_sk_tab256[index]*/

   if (gs_RxFftLength == FFT_LEN_1024)
   {
      if (j<=256){
         s_value = -1 * gsa_sk_tab256[j];
      }
      else if (j<=511){
         s_value = -1 * gsa_sk_tab256[512-j];
      }
      else if (j<=768){
         s_value = gsa_sk_tab256[j-512];
      }
      else {
         s_value = gsa_sk_tab256[1024-j];
      }

   }
   else
   {
      if (j<=128){
         s_value = -1 * gsa_sk_tab256[2*j];
      }
      else if (j<=255){
         s_value = -1 * gsa_sk_tab256[2*(256-j)];
      }
      else if (j<=384){
         s_value = gsa_sk_tab256[2*(j-256)];
      }
      else {
         s_value = gsa_sk_tab256[2*(512-j)];
      }
   }

   return(s_value);
#endif   /*CALC_SIN_TBL*/
}

#undef FFT_LEN_1024

#undef SIN_TBL_RSH_CNT
