/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   medley.c
 *
 *   Description: functions for generating a MEDLEY signal.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rx_ops.h"
#include "tx_ops.h"
#include "noiseacc.h"
#include "gdata.h"
#include "snr.h"
#include "bitload2.h"
#include <string.h>
#include "tx_ops2.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : UnpackPN
 *
 *  Description:  unpacks a psuedo random sequence of bits into an array of
 *  corresponding QPSK constellation points.
 *
 *  Prototype:  void UnpackPN(int16 *psa_unpk_PN,
 *                             int16 s_numbits,
 *                             uint16 *pusa_PNTab,
 *                             int16 s_gain)
 *
 *  Input Arguments:
 *      s_numbits   - # of bits from the psuedo random sequence to unpack,
 *                    must be a multiple of 32
 *      pusa_PNTab  - pointer to the table of packed psuedo random data
 *      s_gain      - scale factor
 *
 *  Output Arguments:
 *      *psa_unpk_PN    - pointer to array of QPSK constellation points
 *
 *  Returns: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void UnpackPN(int16 *psa_unpk_PN, int16 s_numbits, uint16 *pusa_PNTab, int16 s_gain) {

    int16 s_d, s_numtones;

    /*  setup to use SyncSymbol() */
    s_numtones = s_numbits >> 1;

    SyncSymbol(psa_unpk_PN, s_numtones, pusa_PNTab, s_gain);

    /*  restore DC and Nyqiust that were removed by SyncSymbol */
    s_d = pusa_PNTab[0] & 0x0001;

    if (s_d == 0) psa_unpk_PN[0] =  s_gain;
    else          psa_unpk_PN[0] = -s_gain;

    s_d = pusa_PNTab[0] & 0x0002;

    if (s_d == 0) psa_unpk_PN[1] =  s_gain;
    else          psa_unpk_PN[1] = -s_gain;

} /*  UnpackPN */
