/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   medley_b.c
*
*   Functions for BG Tasks from medley.c
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// medley_b.c
//
// History
//
// 04/08/2010 Nihar :
//    ISI (InterSymbol Interference) disturbs some of the beginning and end tones of the symbol.
//    Due to this disturbance we have observed FEC and occasionally CRC on the ISI dominated loop (5-8 kft)
//    even with the no noise and -140 dBm/Hz white noise conditions. CRC as well as FEC scenarios are
//    getting worse when REIN noise is introduced on those ISI dominated loops.
//
//    In this modified code the ISI dominated tones are taken care of. Whenever the difference between
//    ReverbEcho and Medley signals are above a certain threshold (in this case it is 7 dB, an empirical value)
//    then FW declare these as ISI dominated tone and assign Fine Gain to -2.5 dB to those tones. In this way FW
//    reduces the expectation of bit loading and margin on those tones.
//
//    Normally Higher corner tones are also ISI dominated but based on the threshold,
//    FW could not detect them. That's why we decided that from tone 500 and above are ISI dominated.
//    This portion of the code may lead to few Kbits less DS DR on short loops.
//    Grep for  PERF_DS_ALL_ALL_ISI_FAINGAIN_SHOWTIME
//
// 26/07/10  Bhadra/Kannan: Force Unity TDQ for ADSL2 mode in short loops( < 1500m )
//                    to avoid DS CRC errors against Connexant D57 DSLAM.
//                    And also enable Noise margin seperation calculation while forcing
//                    unity TDQ to improve the DS Data Rate.
//                    To enable uinty TDQ for CNXT, cw INFO 103 0 0x2
//                    Grep for "PERF_DS_Bis_CNXT_ForceUnityTDQ" to check the changes.
//
// 25/08/2010 Nihar: Enhance DS Data rate in 5T1 Noise loops for Alcatel CO's in DMT mode
//                    using Noise Margin Separation Calculation. By default, its enabled.
//                    To disable it, set bit 10 of INFO 103 0
//                    grep for PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate.
//
// 27/08/2010 Nihar: Reduce Reverb-Noise-Margin by 0.3dB & add 1dB ISI-margin
//                    to pass margin verification test for Initial 8 Tones only against TI in DMT mode
//                   Grep for PERF_DS_DMT_TI_SmartMrgAllocation
//
// 24/06/2011 Kannan: Noise margin separation changes for BT loops, Added 2dB NMSA for BT >= 700ft.
//                    These changes are taken from Danube.
//                   Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
// 28/09/2011 Raghu : PLL bandwidth is changed based pilot tone reverb SNR.
//                    Grep for XDSLRTFW-316
//
// 14/10/2011 Raghu : temperory fix for changes RCCrc3Rx.c, so as to be backward compatible
//                    so that scaling of Kp is same as before,scalled twice.
//                    Grep for XDSLRTFW-316
//
//  18/10/2011 Kannan/Vinjam: Restricted PLL scaling changes conneected with "XDSLRTFW-316" to DMT & T1.413 modes only.
//                  Grep for XDSLRTFW-316
//
// 23/02/2012 Sriram Shastry : Disable PLL bandwidth to reduce DS CRC for 24DSL noise CPE margin verification test.It was observed that if
//      RxAvgmargin drops from 3.5 dB to 2.5 dB , we see Burst of DS CRC's  as a result Sync is Lost.
//      Grep for : Enhc_DS_ALL_ALL_ByPassPLLBWIncrease
//
// 07/06/2012 Vinjam: Enabled flag "gft_Enable_DsVnInMedley" to consider the down stream virtual noise in
//      Medley SNR computation.
//      Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 18/06/2012 Vinjam: Populated Downstream virtual noise status (Enabled) to "INFO 68 8".
//      Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 22-04-2013 Anantha:  Disbling Sriram's 23/02/2012 change
//          grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg
//
// 28/05/2013 Ram: Using 1dB noise margin correction/seperation value for BT loops > 15Kft with
//                 Connexant/Globespan chipset and ADSL2/ADSL2+ mode
//                Grep for XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops
// 6/6/2013 Mahesh Added additional 1dB noise margin for AnxL loops above 14 kft
//             Grep for XDSLRTFW-691: BugFix_DS_AnxL_Avnx_Etsi
//
// 29/09/2014 ChihWen: Workaround of ignoring MaxDsATP and decreasing 1 dB margin to pass the TR100A AWGN longer loops in Askey lab.
//            Grep for XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting
//
// 06/08/2014 ChihWen: Enable noise margin separation against Vinax2 in the case when minINP >= 1, FB noise, and BIS mode.
//             Grep for XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM
//
// 29/04/2015 Vinay: Fixed the issue of not able to read DS SNR in DELT mode from CPE side.
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// 13/1/2017 Shriram Shastry : The CPE could not link up in G.DMT mode with 4.17.18.7 UGW7.1.1 [PPA API driver info: 96.32.7.3.0.0.4]
//          When  FW makes transition from VDSL to ADSL and CO is configued in ADSL1 Mode,
//          FW is 'NOT' communicating the required TC-Mode and  autonomous message to DSL API. Moved the  function call common for  all hndshk mode and T1413
//          Grep for XDSLRTFW-1924 / XDSLRTFW-2835
// ******************************************************************
#include "const.h"
#include "common.h"
#include "rx_ops.h"
#include "tx_ops.h"
#include "noiseacc.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "snr.h"
#include "bitload2.h"
#include <string.h>
#include "cmv.h"
#include "find_sintbl.h"
#include "dsp_op.h"
#include "pll.h"
#include "rcmedley_Data.h"
#include "fifo.h"
#include "med2rev.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "RCMedleyRxF_Bitload_bis.h"
#include "states.h"
#include "RMedleyTxF_bis.h"
#include "RCMedleyRxF_Bitload.h"
#include "memsetbf.h"
#include "memcopy.h"
#include "BGChooseRevSegBin.h"
#include "fdq_adap.h"
#include "dsp_op2.h"
#include "platform.h"
#include "exchdata.h"
#include "decimalgain.h"
#include "train_reinimmunity.h"
#include "bitload_const.h"
#include "hndshk_Data.h"
#include "ppe_memmap.h"
#include "plam.h"
#include "aux_reg_danube.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
#ifdef TARGET_HW
#include "aux_regs.h"
//#ifdef DANUBE
#include "dataswap.h"
//#endif
#endif
#include "arctan.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#define  R_C_MEDLEY_RX_LOAD_TDQ           (1)
#define R_C_MEDLEY_ADJUST_FRMALIGN        (21)
#define R_C_MEDLEY_RESET_FRMALIGN         (22)
#define R_C_MEDLEY_RX_FDQ_INIT            (2)
#define  R_C_MEDLEY_RX_AVERAGE_FRAME         (3)
#define  R_C_MEDLEY_RX_FDQ_TRAIN          (4)
#define R_C_MEDLEY_RX_LOAD_FDQ            (5)
#define  R_C_MEDLEY_RX_ADJUST_SYNCH       (6)
#define R_C_MEDLEY_RX_PRE_TEST_SNR_INIT      (7)
#define R_C_MEDLEY_RX_TEST_SNR_INIT       (8)
#define  R_C_MEDLEY_RX_CALCULATE_TEST_SNR (9)
#define  R_C_MEDLEY_RX_KEEP_BEST          (10)
#define R_C_MEDLEY_RX_COMPUTE_CHOSEN_FDQ  (101)
#define  R_C_MEDLEY_RX_LOAD_BEST          (11)
#define R_C_MEDLEY_FINAL_FRMALIGN         (23)
#define R_C_MEDLEY_RX_FINAL_SNR_INIT      (12)
#define  R_C_MEDLEY_RX_CALCULATE_FINAL_SNR   (13)
#define R_C_MEDLEY_RX_PREP_IMPULSE_DET    (15)
#define R_C_MEDLEY_RX_SET_IMPULSE_DET_THRESHOLD (16)

/* Below States are implemented in function RCMedleyRxF_Bitload() */
#define  R_C_MEDLEY_RX_BITLOAD            (14)
/* Below States are implemented in function RCMedleyRxF_Bitload_BIS() */
#define  R_C_MEDLEY_RX_BIS_BITLOAD        (14)

#define  R_C_MEDLEY_RX_COMPUTE_NMS_INIT               (25)
#define  R_C_MEDLEY_RX_COMPUTE_ADC_NOISE              (26)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT    (27)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK  (28)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT    (29)
#define  R_C_MEDLEY_RX_NOISE_MARGIN_AVERAGE_FRAME     (30)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_FDQ_TRAIN   (31)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNRINIT     (32)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNR         (33)
#define  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_POST_SNR    (34)




#define SIN_TBL_RSH_CNT       (15)     /* right shift count for table gsa_SinTbl[i] */
#define  TDQ_MANTISSA_WORDLENGTH (16)     /*  wordlength (in bits) of signed TDQ mantissa */
#define TDQ_MANTISSA_FRAC_BITS   (15)     /*  number of fractional bits in TDQ mantissa   */

#ifndef ISDN    // Only for Anx-A
// PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start)
/* For Alcatel ADLT-J FG10 STM COs in DMT mode: */
/* Reduce Reverb-Noise-Margin by 0.3dB to meet the AR7 data rate requirement in 5T1 Noise Loops */
/* It helps to improve the DS performance on 5T1 Noise Loops */
/* Apply it only for the DMT Mode */
/* 0.3dB *256 = 76.8 (Approx 77 => 0x004D) 8.8 format */
/* This is applied for the loops < 8kft when 5T1 noise is detected */
#define REVERB_NOISE_MARGIN_REDUCTION_ALCATEL_5T1NOISE_BELOW_8KFT_LOOPS   (0x004D)

/* 1.0dB *256 = 256 (=> 0x0100) 8.8 format */
/* This is applied for the loops above 8kft when 5T1 noise is detected */
#define REVERB_NOISE_MARGIN_REDUCTION_ALCATEL_5T1NOISE_ABOVE_8KFT_LOOPS  (0x0100)
// PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (End)


// PERF_DS_DMT_TI_SmartMrgAllocation (Start)
/* For TI-COs: */
/* Reduce Reverb-Noise-Margin by 0.3dB (AR7 uses 0.3 more coding gain) */
/* This is done for Fast and Interleaved modes. It is applicable for TI CO's. */
/* It is done to meet the Data Rate Requirement for British Telecom to compare the */
/* TI's AR7/UR8 CPE's Data Rate. */

/* Add 1dB ISI-margin to pass margin verification test for Initial 8 Tones only */
/* This change is done for the British Telecom */
/* As a consequence this degrades the DS performance by 32kbps on straight loops 9kft and above */

/* 0.3dB *256 = 76.8 (Approx 77 => 0x004D) 8.8 format */
#define REVERB_NOISE_MARGIN_REDUCTION_TI_ALL_LOOPS   (0x004D)
#define ISI_MARGIN_REDUCTION_TI_ALL_LOOPS        (0x0100)
// PERF_DS_DMT_TI_SmartMrgAllocation (End)
#endif  // ifndef ISDN

#ifdef DEBUG_IMP_DETECT
#undef DEBUG_IMP_DETECT
#endif
int16 gs_pllShowLimit;
int16 gs_fg_skip_threshold = 7*256; // PERF_DS_ALL_ALL_ISI_FAINGAIN_SHOWTIME
extern int16 gs_stall_cnt;
extern void UpdateRxSnrBufWoVN(void);


/********************************************************************************************
;  Subroutine Name: BgNoiseAcc
;
;  Description:
;     Calls NoiseAcc() with passing the global input parameters.
;
;  Prototype:
;     void BgNoiseAcc(void)
;
;  Input Arguments:
;     gsa_recv_tones -- pointer to the received DMT tones
;     gsa_ref_tones  -- pointer to the reference DMT tones
;     gs_MedleyOffset      -- offset used to generate Medley signal
;     gs_RxFirstChannel   -- first channel
;     gs_RxLastChannel    -- last channel
;
;  Output Arguments:
;     gla_NoisePower -- pointer to accumulators for storing noise power.
;                    Note that this pointer should point to the address
;                    for the first noise value.  Noise values will get written to
;                 gla_NoisePower[0] through gla_NoisePower[gs_RxLastChannel-gs_RxFirstChannel],
;                 rather than gla_NoisePower[gs_RxFirstChannel] through gla_NoisePower[gs_RxLastChannel]
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/

C_SCOPE void BgNoiseAcc(void)
{

    NoiseAcc(gla_NoisePower, 0, gsa_recv_tones, gs_MedleyOffset,gs_MedleyModulo,
    (int16) (2*gs_RxNumTones), gsa_ref_tones, gs_RxFirstChannel, gs_RxLastChannel);

    /* ================================================== */
    /* Accumulation is done. */
    /* ================================================== */
    guc_AccumState = TRAINING_DONE;
    gft_CopyRxBuffer = TRUE;
}



/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 ComputeCapacity(void);
*
*   Description:
*     This function calculates the total bits supported for the current SNR
*
*  Input:
*     gpsa_MeasuredSnrBuf - pointer to the measured SNR buffer
*
*  Output:
*     s_totalbits - total bits supported with the given SNRs
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE int16 ComputeCapacity(int16 *psa_SnrBuf)
{
    int16 s_ch, s_qc, s_SNR ;
    int16 s_totalbits=0;
    int16 s_path = COMBINED_LP;

    gpsa_MeasuredSnrBuf = psa_SnrBuf;

    if (gft_ModemType == G_DMT_BIS) {
        /* Compute Required SNR (= constellation SNR + 0 snr margin) for each constellation */
        OffsetSNRRequired(0, gsa_SNRRequired);

        /* Calculate the max bits per symbol that the channel can support */
        s_totalbits = CalcMaxBits(0, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF,s_path);/* Calculate without taking into account the fine gains */
    }
    else {     // For DMT do a simpler calculation - PM issues
        gus_ncloaded=0 ;
        for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++) {
            s_SNR = gpsa_MeasuredSnrBuf[s_ch];
            for(s_qc = guc_MaxAllocBitsPerTone; s_qc >= RX_MIN_BITS_PER_TONE; s_qc--) {
                if(s_SNR >= gsa_ConstellationSNR[s_qc]) {
                    gus_ncloaded++ ;
                    s_totalbits += (int16) s_qc;
                    break;
                }
            }
        }
        // Diff wrt original function: Auxpilot tone is counted with full bit alloc above. Change ?
    }

    return (s_totalbits);
}

/*^^^
*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*       void FindNoiseSeparationSnrAdj(void)
*
*   Abstract:
*
*   Parameters:
*
*  Global Variables:
*     none
*
*--------------------------------------------------------------------------------------------------
^^^*/
C_SCOPE void FindNoiseSeparationSnrAdj(void)
{
   int16 s_ch;
   int16 s_mr, s_me, s_mi;
   int16 s_ReverbSnr, s_EchoSnr, s_MedleySnr;
   int16 s_NoiseRatioR, s_NoiseRatioRE;
   int32 l_LinSnrAdj;
    //XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (START)
#ifdef ISDN
    FlagT ft_KickInNM_Vinax2 = FALSE;
#endif
    //XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (END)

#ifndef ISDN    // Only for Anx-A
    // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start_End)
    FlagT ft_AlcatelExtraRevMgn = FALSE;
    // PERF_DS_DMT_TI_SmartMrgAllocation (Start_End)
    int16 s_miStrongISI, s_AddStrongISIMargin = 0;
    //XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT(START_END)
    FlagT ft_Tr100A1_MV_12kft750bt_tuning = FALSE;

    /* Perform AFE and CO specific NoiSMA settings. */
    /* Avoid reverb noise margin correction on short bridgetaps for Amazon-A. */
 if (OPTNArray[OPTN_AlgControl2] & OPTN_NoiSMA_VR9_oPOTS)
 {
    //XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT (START)
    if ((gs_LoadHybIndex >= 16) &&
       (gl_SelectedMode & (MODE_G992_3 | MODE_G992_5)) &&
       (gs_PGAforLoopLengthEstimation > PGA_THRESHOLD_10_KFT) &&
       (gs_PGAforLoopLengthEstimation < PGA_THRESHOLD_14_KFT))
    {
        if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
        {
            // for now, enable it only for CNXT
            ft_Tr100A1_MV_12kft750bt_tuning = TRUE;
        }
    }
    //XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT (END)

    //XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START - END)
    if (gs_LoadHybIndex <= 1)
    {
        gs_ReverbNoiseMarginReduction = 0x0000;
    }

   //XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT (START)
   if (ft_Tr100A1_MV_12kft750bt_tuning)
   {
       /* Use only 0.5dB reverb noise margin correction for 12kft-750BT loops to pass MV test */
       gs_ReverbNoiseMarginReduction = 0x0080;
   }
   else
   //XDSLRTFW-815 PERF_A_DS_BISPLUS_ALL_MV12K750FT (END)
   {
      /* Use 1.0 dB more reverb noise margin correction on >700ft bridgetap loops for */
      /* Amazon-A (we have a lot of extra margin on these loops). */
      if ((gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_PERF_BT_LOOPS) == 0)
      {

   //XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START - END)
         if ((gs_LoadHybIndex >= 16))

         {
            gs_ReverbNoiseMarginReduction += 0x100;
         }
      }
      else
      {

         /* Use 0.5dB more reverb noise margin correction on 1500ft bridgetap loops for */
         /* Amazon-A (we have a lot of extra margin on these loops). */
   //XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START - END)
         if ((gs_LoadHybIndex == 21) || (gs_LoadHybIndex == 22) ||
             (gs_LoadHybIndex == 23))

         {
            gs_ReverbNoiseMarginReduction += 0x0080;
         }
      }
   }
   //XDSLRTFW-2033 (start)
   if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
   {
          if (((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L))) != 0)
               &&(gs_LoadHybIndex > 10)
               &&(gs_hsk_tone_power_dB < 1100)
               && (gt_INFX_CMV.us_OperatorSpBits7 & CMV_ReverbNoiseMarginFix)
             )
         {
               gft_CNXT_ANNEXL_BTLoops = TRUE;//debug only
         }
         else
         {

            // XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops (Start)
            if ((gs_LoadHybIndex >= 16) &&
               (gl_SelectedMode & (MODE_G992_3 | MODE_G992_5)) &&
               (gs_CurrentCoChipset == GSI_CO_CHIPSET))
            {
               if (gs_EstimatedLoopLength > 14800)
               {
                  /* Use 1dB (1dB in 8.8 format = 0x0100) reverb noise margin correction on > 1500ft bridgetap loops */
                  gs_ReverbNoiseMarginReduction = 0x0100;
               }
            }
         }
   }
   // XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops (End)

   //XDSLRTFW-691: BugFix_DS_AnxL_Avnx_Etsi [Start]
   if ((gl_SelectedMode & (MODE_G992_3 | MODE_G992_5)) &&
       (gs_CurrentCoChipset == IFTN_CO_CHIPSET) &&
       ((guca_fe_G9941_VendorID[6] & 0xF0)== AVINAX_PLATFORM_8))
   {
      if (gs_EstimatedLoopLength > 14800)
         gs_ReverbNoiseMarginReduction = 0x0100;
   }
   //XDSLRTFW-691: BugFix_DS_AnxL_Avnx_Etsi [End]
   // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start)

    /* This change is required for Alcatel ADLT-J FG10 STM COs in DMT mode: */
    /* It helps to improve the DS performance on 5T1 Noise Loops */
    /* Apply it if ( ((T1413 Mode && T11413_vid == Alcatel) || (ADSL1Mode && GhsVid == Alcatel)) &&
    (5T1Noise) && (API Bit not disabled) ) */
    if ((((STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) &&
                    (gs_fe_T1413_VendorID == T1413_ALA_ID)) ||
                ((gl_SelectedMode & (MODE_ADSL1) &&
                        (gs_CurrentCoChipset == ALA_CO_CHIPSET)))) && (gft_5T1Noise != FALSE) &&
            ((gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_5T1NOISE_ALC_DMT) == 0))
    {

        /* Addtional Reverb Noise Margin Reduction Delta of 0.3dB below 8kft */
        /* Addtional Reverb Noise Margin Reduction Delta of 1.0dB above 8kft */
        /* Measured Loop Attn for 8Kft: 40.0dB */
        /* This done to meet the TR067-A-1 Data rate requirement in 5T1 Noise Loops */
        /* Done Margin verification test with 12Kft 5T1 Noise, BER is 2.0E-9 (With Reported Mgn-5dB) */

        /* At 0kft Loop with 5T1 noise, this change will not be applied  since the flag
        "gft_5T1Noise" is set to FALSE */

        /* This should be enabled for all the Alcatel DSLAMs in ADSL1 Mode, including T1413 Mode, */
        /* T1413 vendor ID for Alcatel needs to added here */
        ft_AlcatelExtraRevMgn = TRUE;
        if (gt_NearEndParam.us_LoopAttenuation > 400)
        {
            gs_ReverbNoiseMarginReduction +=
            REVERB_NOISE_MARGIN_REDUCTION_ALCATEL_5T1NOISE_ABOVE_8KFT_LOOPS;
        }
        else
        {
            gs_ReverbNoiseMarginReduction +=
            REVERB_NOISE_MARGIN_REDUCTION_ALCATEL_5T1NOISE_BELOW_8KFT_LOOPS;
        }
    }

    // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (End)

    // PERF_DS_DMT_TI_SmartMrgAllocation (Start)

    /* For TI-COs: */
    /* Reduce Reverb-Noise-Margin by 0.3dB (AR7 uses 0.3 more coding gain) */
    /* Add 1dB ISI-margin to pass margin verification test for Initial 8 Tones only */
    /* This change is done for the British Telecom */
    /* It helps to improve the DS performance on straight loops 9kft and above */
    /* Apply it only for the DMT Mode */
    if ((gs_CurrentCoChipset == TI_CO_CHIPSET) &&
            (gl_SelectedMode & (MODE_ADSL1)) && (gs_hsk_tone_power_dB <= MINIMUM_GHS_TONE_PWR_AT_9000F) &&
            (gft_M140WhiteNoise != FALSE))
    {
        gs_ReverbNoiseMarginReduction +=
        REVERB_NOISE_MARGIN_REDUCTION_TI_ALL_LOOPS;
        s_AddStrongISIMargin = ISI_MARGIN_REDUCTION_TI_ALL_LOOPS;
    }
    else
    s_AddStrongISIMargin = 0x0000;

    // PERF_DS_DMT_TI_SmartMrgAllocation (End)
   }

   //XDSLRTFW-3307 XDSLRTFW-3370 (START)
   if (gl_SelectedMode & MODE_ADSL1)
   {
      if (STATArray[STAT_Performance] & STAT_24DSLNoise)
      {
         //gs_EchoNoiseMargin += 0x0380;//0x0200;
         //XDSLRTFW-3388 (START)
         //gs_ReverbNoiseMarginReduction -= 0x00c0;//0x0080;
         //if ( (gs_CurrentCoChipset == IFTN_CO_CHIPSET) && ((guca_fe_G9941_VendorID[6] & 0xF0) == AVINAX_PLATFORM_8) )
             OPTNArray[OPTN_AlgControl2] |= OPTN_NoiSMADisable;
         //XDSLRTFW-3388 (END)
      }

      else if (gft_5T1Noise == TRUE)
      {
         gs_EchoNoiseMargin += 0x0380;
         //XDSLRTFW-3389 (START)
         //if ( (gs_CurrentCoChipset == IFTN_CO_CHIPSET) && ((guca_fe_G9941_VendorID[6] & 0xF0) == AVINAX_PLATFORM_8) )
            gs_ReverbNoiseMarginReduction -= 0x00c0;
         //XDSLRTFW-3389 (END)
      }

      //XDSLRTFW-3471 (START)
      else if (gs_hsk_tone_power_dB <= MINIMUM_GHS_TONE_PWR_AT_12000F)
         gs_EchoNoiseMargin += 0x0280;
      //XDSLRTFW-3471 (END)
   }
   //XDSLRTFW-3307 XDSLRTFW-3370 (END)

   //XDSLRTFW-3272 (START)
   if (gl_SelectedMode & MODE_ADSL2)
   {
      if (gs_hsk_tone_power_dB <= MINIMUM_GHS_TONE_PWR_AT_12000F)
         gs_EchoNoiseMargin += 0x0280;
   }
   //XDSLRTFW-3272 (END)
#endif  // ifndef ISDN


//XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (START)
#ifdef ISDN
      if ( (gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_NM_VINAX2) &&
            (gl_SelectedMode & MODE_G992_3) &&
            (gs_CurrentCoChipset == IFTN_CO_CHIPSET) &&
            (((gs_CurrentCoVendorID>>12)&0xf) == 0xb) &&
            (gft_FBnoise == TRUE) &&
            (gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] >= 2) )
      {
         ft_KickInNM_Vinax2 = TRUE;
            gs_ReverbNoiseMarginReduction = 0x0080;
         }
#endif
//XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (END)



    /* Initialize algorithm parameters. */
    /* Reverb noise coefficient (Q3.13): */
    /* mr = 10^(-gs_ReverbNoiseMarginReduction/10), if effective margin > 0. */
    if (gs_ReverbNoiseMarginReduction < gs_RxDesiredMargin)
    {
        s_mr = DecimalGain((int16)(2*(-gs_ReverbNoiseMarginReduction)));
    }
    else
    {
        s_mr = 0x2000;
    }
    /* Echo noise coefficient (Q3.13): */
    /* me = 10^((gs_EchoNoiseMargin - gs_RxDesiredMargin)/10), limited to 1. */
    s_me = DecimalGain((int16)(2*(gs_EchoNoiseMargin - gs_RxDesiredMargin)));
    if (s_me > 0x2000)
    s_me = 0x2000;
    /* ISI coefficient (Q3.13): */
    /* mi = 10^((gs_ISIMargin - gs_RxDesiredMargin)/10), limited to 1. */
    s_mi = DecimalGain((int16)(2*(gs_ISIMargin - gs_RxDesiredMargin)));
    if (s_mi > 0x2000)
    s_mi = 0x2000;

#ifndef ISDN    // Only for Anx-A
    s_miStrongISI = s_mi;

    if (OPTNArray[OPTN_AlgControl2] & OPTN_NoiSMA_VR9_oPOTS)
    {

      // PERF_DS_DMT_TI_SmartMrgAllocation (Start)
      /* Increase ISI Margin to pass the Margin Verification test, Reason: when we increase the
         external noise, */
      /* more bits were swaped to the initial tones which has more ISI effect, to avoid the CRC's keep
          margin for */
      /* the Initial tones */
      s_miStrongISI = DecimalGain((int16)(2 * ((gs_ISIMargin + s_AddStrongISIMargin) - gs_RxDesiredMargin)));
      if (s_miStrongISI > 0x2000)
         s_miStrongISI = 0x2000;
      // PERF_DS_DMT_TI_SmartMrgAllocation (End)

      /* In the case of 5T1 crosstalk add more margin to what appears as ISI but is */
      /* actually spectral lekeage of the post TDQ noise. */
      if (gft_5T1Noise != FALSE)
      {
        /* Do not Limit Reverb Noise Margin coefficient for Alcatel STM FG10 CO in 5T1 Noise Case */
        // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start_End)
        if (ft_AlcatelExtraRevMgn == FALSE)
        s_mr = 0x2000;
        s_me = 0x2000;
        s_mi = 0x3FD9;
      }
   }
#endif  // ifndef ISDN
    /* Initialize the noise separation SNR adjustment array. */
    memset(gpsa_NoiseSeparationSnrAdj, 0, sizeof(int16)*gs_RxNumTones);

    /* Check the difference between SNRs to determine noise margin adjustment and finegain set*/
    for (s_ch = gs_RxFirstChannel; s_ch < gs_RxNumTones; s_ch++)
    {
         s_ReverbSnr = gsa_ReverbSnrBuf[s_ch];
         s_EchoSnr = gsa_ReverbEchoSnrBuf[s_ch];
         s_MedleySnr = gsa_MedleySnrBuf[s_ch];

      /* Some SNRs are not measured for C-PILOT tone so skip it. */
        if (s_ch == gs_CPilotTone)
        continue;
         if (s_ReverbSnr < s_MedleySnr)
            s_ReverbSnr = s_MedleySnr;

         if (s_EchoSnr < s_MedleySnr)
            s_EchoSnr = s_MedleySnr;

         if (s_EchoSnr > s_ReverbSnr)
            s_EchoSnr = s_ReverbSnr;

        /* Find s_NoiseRatio = 10^(SnrDiff/10) in Q3.13 format. */
         s_NoiseRatioRE = DecimalGain((int16)(2*(s_MedleySnr - s_EchoSnr)));
        /* Limit s_NoiseRatio. */
        if (s_NoiseRatioRE > 0x2000)
        s_NoiseRatioRE = 0x2000;

        /* Find s_NoiseRatio = 10^(SnrDiff/10) in Q3.13 format. */
         s_NoiseRatioR = DecimalGain((int16)(2*(s_MedleySnr - s_ReverbSnr)));

       if (((guc_impulse_noise_present != 7) && (gsa_ReverbEchoSnrBuf[s_ch] - gsa_MedleySnrBuf[s_ch] > gs_fg_skip_threshold))
                ||((guc_impulse_noise_present == 7) && (gsa_ReverbSnrBuf[s_ch] - gsa_MedleySnrBuf[s_ch] > gs_fg_skip_threshold)))
        {
            SETTONEFLAG(p_FINEGAINSKIPset, s_ch - 1);
            SETTONEFLAG(p_FINEGAINSKIPset, s_ch);
            SETTONEFLAG(p_FINEGAINSKIPset, s_ch + 1);
        }
        // PERF_DS_ALL_ALL_ISI_FAINGAIN_SHOWTIME (start)
        if ( s_ch > 500)
            SETTONEFLAG(p_FINEGAINSKIPset, s_ch);
        // PERF_DS_ALL_ALL_ISI_FAINGAIN_SHOWTIME (end)
        //PERF_DS_Bis_CNXT_ForceUnityTDQ (Start_End)
        //XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (START)
        if ( ((gft_M140WhiteNoise != FALSE) || (gft_5T1Noise != FALSE) ||(gft_ForceUnityTDQ == TRUE)
#ifdef ISDN
              || (ft_KickInNM_Vinax2 == TRUE)
              || ((gt_INFX_CMV.us_OperatorSpBits7 & CMV_ENABLE_NoiseMa_ISDN_FBNoise) && (gft_FBnoise == TRUE)) //possible sol for XDSLRTFW-2248
#endif
            )    && ((OPTNArray[OPTN_AlgControl2] & OPTN_NoiSMADisable) == 0))
        //XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (END)
        {
            /* Find inverse of SNR adjustment in linear domain in Q6.26 format. */
            // PERF_DS_DMT_TI_SmartMrgAllocation (Start)
#ifndef  ISDN  // Only for Annex - A
            /* Increase ISI Margin to pass the Margin Verification test, Reason: when we increase the
            external noise, */
            /* more bits were swaped to the initial tones which has more ISI effect, to avoid the
            CRC's keep margin for */
            /* the Initial tones */
            if ((s_ch <= (gs_RxFirstChannel + 8))&& (OPTNArray[OPTN_AlgControl2] & OPTN_NoiSMA_VR9_oPOTS))
               l_LinSnrAdj = (int32) s_miStrongISI *0x2000 + (int32)(s_mr - s_me) * s_NoiseRatioR + (int32)(s_me - s_miStrongISI) * s_NoiseRatioRE;
            else
#endif // ifndef ISDN
            // PERF_DS_DMT_TI_SmartMrgAllocation (End)
               l_LinSnrAdj = (int32)s_mi * 0x2000 + (int32)(s_mr - s_me) * s_NoiseRatioR + (int32)(s_me - s_mi) * s_NoiseRatioRE;
            /* Find noise separation SNR adjustment in dB in Q8.8 format. */
               gpsa_NoiseSeparationSnrAdj[s_ch] = ConvertToDB(1 << 26) - ConvertToDB(l_LinSnrAdj);
        }
    }


   // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
    if (gl_SelectedMode & (ANNEX_M))
      memset(gpsa_NoiseSeparationSnrAdj, 0, sizeof(int16)*gs_RxNumTones);
   // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)

    if (gt_INFX_CMV.s_CTUNE_NMSForce_mask & 0x4000)
       memcpy(gpsa_NoiseSeparationSnrAdj, gsa_NMS_Force, sizeof(int16)*gs_RxNumTones);
    return;
}

/*^^^
*------------------------------------------------------------------------
*
*  Prototype: void BGMedleySnrCalc(void)
*
*  Description: Background Medley SNR calculation.
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gla_RxAccumBuf[]    - (I) Noise accumulation buffer for tones
*      gs_log2_num_snr_training_symbols - (I) speaks for itself
*
*------------------------------------------------------------------------
*^^^
*/
C_SCOPE void BGMedleySnrCalc(void)
{
    int32 *pla_NoisePower;
    int16 s_ch;
   uint16 us_NumOfDsVnBreakPoints; //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
#ifdef DEBUG_SNR
    FILE *snrf;
#endif

    /* convert 48 bits accumulated value to 32 bits; */
    pla_NoisePower = gla_RxAccumBuf; /* Overwrite input buffer with 32-bit output. */
    RoundNoiseAccum(gla_RxAccumBuf, pla_NoisePower, gs_RxFirstChannel, gs_RxLastChannel, (int16) (gs_log2_num_snr_training_symbols));

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (Start)
   //As per the current geminax firmware: GmxMax_2010-01-27_Sw08-27-08-0-2E_Bin933_AnA.bin,
   //CO sends virtual noise break points in LDM mode, if VN is enabld.
   //Also as per the new G.Bis standard T-REC-G.992.3-200904-P!!PDF-E.pdf,
   //VN PSD needs to be considered in SNRps & ATTNDR
   if(gl_SelectedMode & (MODE_ADSL2))
   {
      gft_Enable_DsVnInMedley = 1; //XDSLRTFW-2433
       us_NumOfDsVnBreakPoints = gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones;
       if(us_NumOfDsVnBreakPoints  > 0)
      {
         //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
         gt_NearEndParam.us_VN_TCM_Supported |= 0x0100; //Used Bitmask as per VR9 Message Specification 1.6.1
      }
   }
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (End)

    /* Compute SNR (in dB) for each tone */
    SnrCalc(pla_NoisePower+gs_RxFirstChannel,
    gt_StateMachCntrl.psa_RXSNRBuf+gs_RxFirstChannel, gs_RxFirstChannel, gs_RxLastChannel);

    /* In All Modes, set SNR for pilot tone to 0 so that we do not bitload unless we have Aux/DD Pilot On */
    /* In DMT Mode, always set SNR for pilot tone 64 to 0 so that we do not bitload*/
    if (gft_AuxPilot == AUX_PILOT_DISABLE ||
            !(( gl_SelectedMode & (MODE_ADSL2)  )))
    {
        gt_StateMachCntrl.psa_RXSNRBuf[gs_CPilotTone] = 0;
    }

    /* Compute the total bits supported */
    gs_Capacity = ComputeCapacity(gt_StateMachCntrl.psa_RXSNRBuf);

#ifdef DEBUG_SNR
    snrf = fopen("MedleySNR.txt","w");
    for (i=0;i<gs_RxNumTones;i++)
    fprintf(snrf,"%d\n",gt_StateMachCntrl.psa_RXSNRBuf[i]>>8);
    fclose(snrf);
#endif

    if (gs_RxSubState == R_C_MEDLEY_RX_CALCULATE_FINAL_SNR)
    {
        BGChooseRevSegBin(gt_StateMachCntrl.psa_RXSNRBuf);

        if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNR_Save)
        {
           memcpy(gpsa_Medley_Vector,gt_StateMachCntrl.psa_RXSNRBuf,1024);
        }

        /* Find noise separation margin adjustment from Reverb, ReverbEcho, and */
        /* final Medley SNRs. */
        //FindNoiseSeparationSnrAdj();
        //memcpy(gpsa_Medley_Vector,gt_StateMachCntrl.psa_RXSNRBuf,1024);
        //memcpy(gpsa_NMS_Vector,gpsa_NoiseSeparationSnrAdj,sizeof(int16)*RX_NUM_TONES);
       if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN)
       {
         // NMS will be added to Medley inside the function
         FindNoiseMarginSeparation();
         // The below old NMS call call is for comparison only
         /* Find noise separation margin adjustment from Reverb, ReverbEcho, and */
         /* final Medley SNRs. */
         if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_compute_OldNMS_vec)
            FindNoiseSeparationSnrAdj();

       }
       else
       {
           /* Find noise separation margin adjustment from Reverb, ReverbEcho, and */
           /* final Medley SNRs. */
           FindNoiseSeparationSnrAdj();
           /* Add noise separation margin adjustment to Medley SNR. */
           /* Also, activate the margin correction due to CO TX nonlinearity if enabled */
           /* and any tone SNR is above 40dB (this threshold was found empirically). Shape */
           /* and magnitude of CO TX nonlinearity depends on the CO hardware design, */
           /* nominal DS power and power cutback, fine gains, etc., and it is extremely */
           /* difficult to exactly model and know what would the CO TX nonlinearity and */
           /* its effect be in showtime. Thus, the safest and most general way to correct */
           /* for the margin drop due to CO TX nonlinearity is to measure the margin */
           /* difference once we get to showtime and use this difference as a correction */
           /* to subsequent margin measurements. Note that this does not degrade the actual */
           /* margin (as determined by the margin test), since the CO TX non-linearity will */
           /* not change when the noise starts increasing. Therefore this correction is */
           /* along the lines of SNR corrections performed using the NoiSMA. */
           for (s_ch = gs_RxFirstChannel; s_ch < gs_RxNumTones; s_ch++)
           {
               if ((gft_NonLinMgnCorrEnable != FALSE) && (gsa_MedleySnrBuf[s_ch] > 0x2800))
               {
                   gs_NonLinMgnCorr = (int16)0x8000;
               }
               gsa_MedleySnrBuf[s_ch] += gpsa_NoiseSeparationSnrAdj[s_ch];
           }
       }
       UpdateRxSnrBufGet(); //XDSLRTFW-2443 / XDSLRTFW-2462
    }

    guc_SnrCalcState = TRAINING_DONE;

}

C_SCOPE void ComputeNormConjTDQFreqResp(int16 *psa_tdq_h, int16 s_tdq_exp_h, int16 s_ToneIdx, int16 *psa_TdqFreqRespCoef, int16 *ps_TdqFreqRespExp)
{
    int32 l_Acc_r, l_Acc_i;
    int16 i, s_Idx, s_Prod, s_shift, s_rcp_mag_coef, s_rcp_mag_exp;

    ////////////////////////////////////////////////////////
    // H(k) = sum_i=0_i=tdqLen[ tdq[i] * e(-j*2*pi*k*i/N) ]
    //      where k - pilot tone index
    //            N - Rx FFT Length
    ////////////////////////////////////////////////////////

    // Compute real part of freq. response
    l_Acc_r = 0; // Initialize accumulators.
    for(i=0; i<gs_TDQLen; i++)
    {
        s_Idx  = (s_ToneIdx * i);
        //cos[w] = sin[w+Pi/2]
        s_Idx += gs_RxFftLength>>2;
        s_Idx &= (gs_RxFftLength-1);
        s_Prod = (int16)(((int32)findSinTbl(s_Idx)*psa_tdq_h[i])>>SIN_TBL_RSH_CNT);
        l_Acc_r += s_Prod;
    }

    // Compute imaginary part of freq. response
    l_Acc_i = 0; // Initialize accumulators.
    for(i=0; i<gs_TDQLen; i++)
    {
        s_Idx  = (s_ToneIdx * i);
        s_Idx &= (gs_RxFftLength-1);
        s_Prod = (int16)(((int32)findSinTbl(s_Idx)*psa_tdq_h[i])>>SIN_TBL_RSH_CNT);
        l_Acc_i -= s_Prod;
    }

    // Normalize freq. response
    // Find smallest right shift value, s_shift, that guarantees mantissas fit in 16 lsbs,
    // and rightshift l_Acc_r, l_Acc_i by that value. This shifting increases the exponent
    // by s_shift.
    RightNormalizeSignedPair(&l_Acc_r, &l_Acc_i, TDQ_MANTISSA_WORDLENGTH, &s_shift);

    /* Update TDQ freq response */
    psa_TdqFreqRespCoef[0] = (int16) l_Acc_r;
    psa_TdqFreqRespCoef[1] = (int16) l_Acc_i;
    /* Update TDQ exp */
    *ps_TdqFreqRespExp = s_tdq_exp_h + s_shift;

    /* Conjugate TDQ freq response */
    psa_TdqFreqRespCoef[1] = -psa_TdqFreqRespCoef[1];

    /* Compute Magnitude of TDQ freq response */
    l_Acc_r = (((int32)psa_TdqFreqRespCoef[0] * psa_TdqFreqRespCoef[0] + (int32)psa_TdqFreqRespCoef[1] * psa_TdqFreqRespCoef[1])>>TDQ_MANTISSA_FRAC_BITS);
    /* Normalize the product */
    /* Get the normalization left shift count for the product */
    s_shift = -norm_l(l_Acc_r);
    /* Round and normalize the product and represent it in 16 bit */
    s_Prod =(int16) (round((l_Acc_r << -s_shift), 16));
    s_shift += 16;
    s_shift += (-TDQ_MANTISSA_FRAC_BITS + (*ps_TdqFreqRespExp<<1));
    // Compute reciprocal of magnitude. Divide routine requires normalized Q1.15 format.
    Divide_16bit(0x4000, -14, s_Prod, s_shift, &s_rcp_mag_coef, &s_rcp_mag_exp);
    s_rcp_mag_exp += TDQ_MANTISSA_FRAC_BITS;

    /* Normalise TDQ freq response */
    l_Acc_r = psa_TdqFreqRespCoef[0] * s_rcp_mag_coef;
    l_Acc_r >>= TDQ_MANTISSA_FRAC_BITS ;
    l_Acc_i = psa_TdqFreqRespCoef[1] * s_rcp_mag_coef;
    l_Acc_i >>= TDQ_MANTISSA_FRAC_BITS ;
    RightNormalizeSignedPair(&l_Acc_r, &l_Acc_i, TDQ_MANTISSA_WORDLENGTH, &s_shift);
    psa_TdqFreqRespCoef[0] = (int16) l_Acc_r;
    psa_TdqFreqRespCoef[1] = (int16) l_Acc_i;
    *ps_TdqFreqRespExp += (s_rcp_mag_exp + s_shift);
}

C_SCOPE int16 computePostSyncDeviation(int16 *psa_PostSyncCapacity, int16 s_postSync)
{
    int16 s_PostSyncTdqCapDeviation1, s_PostSyncTdqCapDeviation2, s_PostSyncTdqCapDeviation;
    s_PostSyncTdqCapDeviation1 = s_PostSyncTdqCapDeviation2 = 0;
    if (s_postSync != 0)
    {
        s_PostSyncTdqCapDeviation1 = psa_PostSyncCapacity[s_postSync-1] - psa_PostSyncCapacity[s_postSync];
        if (s_PostSyncTdqCapDeviation1 < 0) s_PostSyncTdqCapDeviation1 = -s_PostSyncTdqCapDeviation1;
    }
    if (s_postSync != (gs_MaxPostSync<<1))
    {
        s_PostSyncTdqCapDeviation2 = psa_PostSyncCapacity[s_postSync+1] - psa_PostSyncCapacity[s_postSync];
        if (s_PostSyncTdqCapDeviation2 < 0) s_PostSyncTdqCapDeviation2 = -s_PostSyncTdqCapDeviation2;
    }
    s_PostSyncTdqCapDeviation = (s_PostSyncTdqCapDeviation1 > s_PostSyncTdqCapDeviation2)? s_PostSyncTdqCapDeviation1: s_PostSyncTdqCapDeviation2;
    return (s_PostSyncTdqCapDeviation);
}

C_SCOPE void CopyRxMedleyBuffer(void)
{
    int16 j;

    if ((( gl_SelectedMode & (MODE_ADSL2)  )) &&
            gft_G992_5_Medley14thOrderPRBS == TRUE)
    {
        for(j=0; j< NUM_R_C_MEDLEY_BYTES; j++)
        guca_RxMedleyBuffer_sav[j] = guca_RxMedleyBuffer[j];
    }
}

C_SCOPE void RCMedleyMultiTdq(void)
{
    int16 i, j;
    int16 s_SyncMethods_Delta;
    static int16 s_PreviousSyncOffset;
    int16 s_CurrMinusChosenTdqCap, s_BestMinusChosenTdqCap, s_CapDeviation;
    FlagT ft_StopSyncOffsetsInThisDirection;
    int16 sa_TdqFreqRespCoef[2], s_TdqFreqRespExp;
    uint32 ul_data, ul_addr;

#ifdef DANUBE_TEMP
    int16 s_pilot_real;
    int16 s_pilot_left_real ;
    int16 s_pilot_right_real ;
    int16 s_pilot_imag ;
    int16 s_pilot_left_imag ;
    int16 s_pilot_right_imag ;
    int16 s_pilot_phase ;
    int16 s_pilot_left_phase;
    int16 s_pilot_right_phase ;
    int32 l_pdiff_left ;
    int32 l_pdiff_right ;
#endif

    // Find the delta between the frame alignment values produced by the two algorithms used,
    // And reduce the value to be in the range [-SamplesPerFrame/2, SamplesPerFrame].
    s_SyncMethods_Delta = (int16)gus_SyncOffset_Corr_Method - (int16)gus_SyncOffset;

    if (s_SyncMethods_Delta > gs_RxSamplesPerFrame/2)
    s_SyncMethods_Delta -= gs_RxSamplesPerFrame;
    else if (s_SyncMethods_Delta < -gs_RxSamplesPerFrame/2)
    s_SyncMethods_Delta += gs_RxSamplesPerFrame;

    switch (gs_RxSubState) {

        /* ============================================================================== */
        /* Load TDQ or turn it off.  For each TDQ, go to the center point for FDQ         */
        /* training, then go through all the sync points in order.                        */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_LOAD_TDQ:

        if (gs_TxState == R_MEDLEY_TX || gs_TxState == R_MEDLEY_TX_BIS)
        {
            if (gs_RxSubStateCnt == 0)
            {

                /* Disable FDQ since it will be trained.*/
                /* Needs to be disabled in loops of loading multi-TDQs */
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);

                gft_CopyRxBuffer = TRUE;

                /* Skip TDQ download if multi TDQ is disabled. */
                if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0)
                {
                    gs_RxSubState = R_C_MEDLEY_RX_FDQ_INIT;
                    break;
                }

                /* Turn PLL off for TDQ adjustment */
                gft_EnablePLL = FALSE;

                /* load the desired TDQ */
                if (gs_TdqIdx != gs_TdqOffIdx) {
                    gps_TdqFilter = &(gsa_MultiTdqTaps[gs_TdqIdx*gs_TDQLen]);
                    memcpy(&(gsa_pre_tdq_h[0]), gps_TdqFilter, gs_TDQLen*sizeof(int16));
                    gs_pre_tdq_h_exp = gsa_MultiTdqExp[gs_TdqIdx];
                    gs_AlignmentOffset = -gs_CumulativeAlignmentOffset + s_SyncMethods_Delta + gsa_MultiTdqPreSyncs[gs_TdqIdx];
                }
                else {
                    /* Turn TDQ off */
                    gsa_pre_tdq_h[0]=0x4000;
                    for (i=1; i<gs_TDQLen; i++)
                    gsa_pre_tdq_h[i]=0;
                    gs_pre_tdq_h_exp = gs_UnityTDQExp;
                    gs_AlignmentOffset = -gs_CumulativeAlignmentOffset;
                }
#ifdef ADSL_62
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
#else
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQ);
#endif //ADSL_62
         }

            gs_RxSubStateCnt++;
                gs_RxSubState = R_C_MEDLEY_ADJUST_FRMALIGN;

            break;

      case R_C_MEDLEY_ADJUST_FRMALIGN:

         // ensure that we are not doing frame alignment adjustment  close to a frame on which QT is likely to get stalled
         if ((gs_stall_cnt >=1) && (gs_stall_cnt < 8))
         {
                gs_AlignForRotation = gs_AlignmentOffset + gs_CumulativeAlignmentOffset;
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,MedleyAdjustAlignment);
                // Large enough negative alignments are implemented as large positive alignments.  This
                // causes one Rx frame to be discarded.
                if (gs_AlignmentOffset < -gs_RxCPLength)
                gft_SkipOneFrame = 1;

            gs_RxSubStateCnt++;
                gs_RxSubState = R_C_MEDLEY_RESET_FRMALIGN;


            } /* gs_RxSubStateCnt == 1 */

         break;

      case R_C_MEDLEY_RESET_FRMALIGN:

            /* Reset buffer alignments */
            if (gs_RxSubStateCnt == 2)
            {
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);
            }
            else if (gs_RxSubStateCnt == 5)
            {
                gs_RxSubStateCnt = -1;

                /* Adjust FDQ to account for pre-sync */
                FdqAdjustPerTone(&gsa_FDQ_coef_pilot_UnityTdq[0], &guc_FDQ_exp_pilot_UnityTdq,
                &gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_PilotToneIdx],
                gs_PilotToneIdx, gs_AlignForRotation);

                // =====================================================================================
                /* Adjust FDQ to account for TDQ, FDQ_Adjust =  FDQ * Normalised_TDQ_Conj */
                /* Normalised_TDQ_Conj = TDQ_Conj / Abs(TDQ_i) */
                // =====================================================================================
                ComputeNormConjTDQFreqResp(gsa_pre_tdq_h, (int16)(1 + gs_UnityTDQExp - gs_pre_tdq_h_exp), gs_PilotToneIdx, sa_TdqFreqRespCoef, &s_TdqFreqRespExp);
                FdqUpdate(&gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_PilotToneIdx],
                sa_TdqFreqRespCoef, (FDQ_MANTISSA_FRAC_BITS - TDQ_MANTISSA_FRAC_BITS + s_TdqFreqRespExp));

                /* Load pilot FDQ coefs */
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQPilot);

                gs_RxSubState = R_C_MEDLEY_RX_FDQ_INIT;
            }
            gs_RxSubStateCnt++;
        }
        break;


        /* ==================================================================== */
        /*  FDQ Training: Initialization */
        /* ==================================================================== */
    case R_C_MEDLEY_RX_FDQ_INIT:

        if (gs_RxSubStateCnt == TDQ_STABLIZE_LEN)
        {
            /* Turn PLL back on */
            gft_EnablePLL = TRUE;

            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
            gs_TrainCnt = 0;
            guc_AccumState = TRAINING_DONE;

            gs_num_fdq_training_symbols   = NUM_FDQ_TRAINING_SYMBOLS_MEDLEY;
            gs_log2_num_fdq_training_symbols = LOG2_NUM_FDQ_TRAINING_SYMBOLS_MEDLEY;
        }
        // allow PLL to settle before accumulation for FDQ training
        else if (gs_RxSubStateCnt == TDQ_STABLIZE_LEN + 8)
        {
            gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_MEDLEY_RX_PREP_IMPULSE_DET ;
            if (gft_Choose )
            {   // just run once to pick the indicator tones
                chooseImpNoiseTones(gsa_ReverbSnrBuf);
                gft_Choose=0;
            }
            gs_TrainCnt = 0;
        }
        gs_RxSubStateCnt++;
        break;

    case R_C_MEDLEY_RX_PREP_IMPULSE_DET :

        gs_mode = (gs_RxSubStateCnt  > 0) ; // set to 0 only for first time to initialize function.
        // we call impulseCheckMedley1() with gs_mode=0 and 1 prior to  FDQ train
        // find the avearge received tone value. z_av = x_av + j*y_av
        impulseCheckMedley1(gsa_RxToneBuf, gsa_indTones, gs_NumIndTones, 3, gs_mode );
        gs_TrainCnt  ++;

        if(gs_RxSubStateCnt == NUM_FRAMES_FDQ_PREP_METRIC /*gs_IndTime15*/)
        {
#ifdef DEBUG_IMP_DETECT
            if (jg_pause&8)  Pause(15);
#endif
            gs_TrainCnt=0;
            gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_MEDLEY_RX_SET_IMPULSE_DET_THRESHOLD;
            iMetricSort( 0 , INITIALIZE_METRIC_SORT);
        }
        gs_RxSubStateCnt++;
        break;

    case R_C_MEDLEY_RX_SET_IMPULSE_DET_THRESHOLD:
        /* ============================================================================================= */
        /* Find threshold for dropping frames from accumulation.                                         */
        /*  1. Measure Metric for N frames (had used 16+X )                                              */
        /*  2. Saving largest two.                                                                       */
        /*  3. Remove largest X from sum (This removes the impulse if it spans less than X frames.)      */
        /*  4. Set threshold at 3* mean metric.                                                          */
        /*  5. In following accumulation drop any frames that are greater than threshold.                */
        /*                                                                                               */
        /*  Note this will work even if we don't get an impulse in the 18 frames.                        */
        /*  The probability of a gaussian exceeding 3 sigma is 2/1000. So we will sometimes drop         */
        /*  a large white noise sample from the average. The effect on the overall                       */
        /*  SNR if a 3 sigma sample is dropped and replaced by a 1sigma sample in an average of 512 is   */
        /*  log10(512/511+9)= -.07dB                                                                     */
        /* ============================================================================================= */
        if ( gs_RxSubStateCnt  < gs_IndTime16 + gs_numSymbolsIgnored)
        {
            int16 indMetric;
            indMetric = (int16)  impulseCheckMedley1(gsa_RxToneBuf,gsa_indTones, gs_NumIndTones ,0, 2 );
            iMetricSort( indMetric , RUN_METRIC_SORT);

#ifdef DEBUG_IMP_DETECT
            gsa_ReverbSnrBuf[gs_TrainCnt] =   indMetric; // save for debug
            gs_TrainCnt++;
#endif
        } //if
        if  (gs_RxSubStateCnt == gs_IndTime16  + gs_numSymbolsIgnored)
        {
            gl_ind_metric_acc = iMetricSort( gs_numSymbolsIgnored , DONE_METRIC_SORT );
            gl_indThresh = (gl_ind_metric_acc * gs_KT) >> guc_indScale1;  // 3*mean (indScale1 = log2(indTime-2)
            gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_MEDLEY_RX_AVERAGE_FRAME;
#ifdef DEBUG_IMP_DETECT
            gsa_ReverbSnrBuf[gs_TrainCnt] = 0xABCD;
            XDump(gsa_ReverbSnrBuf, gs_IndTime16 + gs_numSymbolsIgnored);
            if (jg_pause&4) Pause(16);
#endif
            gs_TrainCnt=0;
        }

        gs_RxSubStateCnt++;

        break;

        /* ==================================================================== */
        /*  FDQ Training: Gather representative frame */
        /* ==================================================================== */
    case R_C_MEDLEY_RX_AVERAGE_FRAME:

        /* Accumulate the received signal in the background */
        if ((guc_AccumState == TRAINING_DONE) && (gft_CopyRxBuffer == TRUE))
        {
            int indMetric=0;
            if (gft_indEnable & 4 )
            indMetric = impulseCheckMedley1(gsa_RxToneBuf,gsa_indTones,gs_NumIndTones ,0, 2 ) ;
            if ( ((gft_indEnable & 4) == 0 ) || (indMetric < gl_indThresh) )
            {
                /* Turn off transfer of the Rx Tone buffer and save the medley offset so
            that the accumulation can be moved to the BG */
                gft_CopyRxBuffer = FALSE;
                gs_MedleyOffset = gs_RxFirstPNbit;
                gsa_recv_tones = &gsa_RxToneBuf[0];

                CopyRxMedleyBuffer();

                guc_AccumState = TRAINING_IN_PROGRESS;
                AddFunctionToBkgdFifo((PtrToBkgdFunc) BgMedleyToReverbAccum);
                gs_TrainCnt++;
#ifdef DEBUG_IMP_DETECT
                gsa_ReverbSnrBuf[gs_TrainCnt] = (int16) indMetric;
#endif
            }
            else
            {
                gs_droppedMedleyFdq++  ;
#ifdef DEBUG_IMP_DETECT
                gsa_ReverbEchoSnrBuf[gs_droppedMedleyFdq] = (int16) indMetric;
#endif
            }

        }
        /* Compute average of the accumulated frames in background */
        if(gs_TrainCnt == gs_num_fdq_training_symbols)
        {
#ifdef DEBUG_IMP_DETECT
            if (jg_pause & 0x40) Pause(17);
#endif
            guc_FdqTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAvgFDQAccumulation);
            gs_RxSubState = R_C_MEDLEY_RX_FDQ_TRAIN;
        }

        break;

        // ==============================================================================
        // FDQ Training: Calculate FDQ coefficients using the representative frame
        // ==============================================================================
    case R_C_MEDLEY_RX_FDQ_TRAIN:

        if (guc_FdqTrainingState == TRAINING_DONE) {

            if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
            {
                if ((gt_RCMsgFmt_bis.uc_MedleyPRBSds == 1) && (gt_RMsgFmt_bis.uc_MedleyPRBSus == 1))
                {
                    /* If using 14th order PRBS medley sequence, change the reverb reference signal */
                    /* to be the first frame of medley sequence */
                    MemCopyWords(gsa_CReverbRefTones, (int16)(2*gs_RxFirstChannel), gsa_unpk_PN512, (int16)(2*gs_RxFirstChannel), (int16)(2*(gs_RxLastChannel-gs_RxFirstChannel)));
                }
            }

            /* Calculate FDQ coefficients in the background. */
            guc_FdqTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc) FDQTrain);
            gs_RxSubState = R_C_MEDLEY_RX_LOAD_FDQ;
        }

        break;

        // ==============================================================================
        // Save the FDQ for this TDQ so that we can restore it if
        // necessary based on chosen TDQ
        // ==============================================================================
    case R_C_MEDLEY_RX_LOAD_FDQ:

        if (guc_FdqTrainingState == TRAINING_DONE) {

            /* may need to test multiple sync points  */
            /* store the FDQ for use by FdqAdjust() */
            MemCopyWords(gsa_FDQ_coef_sav, 0, gsa_pre_FDQ_coef, 0, (int16)(2*gs_RxNumTones));
            memcpy(guca_FDQ_exp_sav,  guca_pre_FDQ_exp,  sizeof(int8)*(gs_RxNumTones));
            gs_MedleySyncOffset = 0;
            s_PreviousSyncOffset = 0;
            gs_RxSubState = R_C_MEDLEY_RX_ADJUST_SYNCH;
        }
        break;

        // ==============================================================================
        // Adjust the FDQ to the current synch point
        // ==============================================================================
    case R_C_MEDLEY_RX_ADJUST_SYNCH:

      // ensure that we are not doing frame alignment adjustment  close to a frame on which QT is likely to get stalled
      if ((gs_stall_cnt >=1) && (gs_stall_cnt < 8))
      {
        gs_AlignmentOffset = gs_MedleySyncOffset - s_PreviousSyncOffset;

        /* Adjust buffer alignments to the current synch point */
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,MedleyAdjustAlignment);
        // Large enough negative alignments are implemented as large positive alignments.  This
        // causes one Rx frame to be discarded.
        if (gs_AlignmentOffset < -gs_RxCPLength)
        gft_SkipOneFrame = 1;

        /* Adjust FDQ based on the new frame synch point in the background */
        guc_FdqTrainingState = TRAINING_IN_PROGRESS;
        AddFunctionToBkgdFifo((PtrToBkgdFunc)FdqAdjust);

        /* Turn PLL off */
        gft_EnablePLL = FALSE;
        /* Adjust FDQ to account for post-sync and wait for new FDQ coefs to be loaded to enable PLL */
        FdqAdjustPerTone(&gsa_FDQ_coef_sav[(gs_PilotToneIdx<<1)], &guca_FDQ_exp_sav[gs_PilotToneIdx],
        &gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_PilotToneIdx],
        gs_PilotToneIdx, gs_MedleySyncOffset);

        gs_RxSubStateCnt = 0;
        gs_RxSubState = R_C_MEDLEY_RX_PRE_TEST_SNR_INIT;
      }

        break;

        // ==============================================================================
        // Rotate the reference tone and turn on PLL again
        // ==============================================================================
    case R_C_MEDLEY_RX_PRE_TEST_SNR_INIT:

        gs_RxSubStateCnt++;

        if(gs_RxSubStateCnt == 1)
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);

        if (gs_RxSubStateCnt == 4) {
            gs_RxSubStateCnt =0;
            gs_RxSubState = R_C_MEDLEY_RX_TEST_SNR_INIT;
        }

        break;

        /* ============================================================================== */
        /* SNR Calculation: Initialize for SNR calculations */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_TEST_SNR_INIT:

        if (guc_FdqTrainingState == TRAINING_DONE)
        {
            if (gs_RxSubStateCnt == 0)
            {
                /* Load current FDQ coefficients */
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
            }
            else if (gs_RxSubStateCnt == TDQ_STABLIZE_LEN)
            {
                /* Turn PLL back on */
                gft_EnablePLL = TRUE;
                /* Skip directly to final SNR measurement if multi TDQ is disabled. */
                if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0)
                {
                    gs_RxSubState = R_C_MEDLEY_RX_FINAL_SNR_INIT;
                }
            }
            else if (gs_RxSubStateCnt == TDQ_STABLIZE_LEN+8)
            {
                /* Initialize for test SNR calculation */
                MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
                guc_AccumState = TRAINING_DONE;
                gs_TrainCnt = 0;
                gs_RxSubStateCnt = -1;
                gs_RxSubState = R_C_MEDLEY_RX_CALCULATE_TEST_SNR;
                iMetricSort( 0,INITIALIZE_METRIC_SORT) ;
            }
            gs_RxSubStateCnt++;
        }
        break;

        /* ============================================================================== */
        /* SNR Calculation: Average frame and compute the SNR for the current synch point */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_CALCULATE_TEST_SNR:

        if ((gs_RxSubStateCnt < gs_IndTimeTestSnr + gs_numSymbolsIgnored)  && ( gft_indEnable & 2 ) )
        {
            int16 indMetric;
            indMetric = (int16) impulseCheck(gsa_RxToneBuf, gsa_indTones, gs_NumIndTones);
            iMetricSort(indMetric , RUN_METRIC_SORT) ;
#ifdef DEBUG_IMP_DETECT
            gsa_ReverbSnrBuf[gs_TrainCnt] =   indMetric;
#endif
            gs_TrainCnt++;
        } //if
        else if   ( (gs_RxSubStateCnt == gs_IndTimeTestSnr + gs_numSymbolsIgnored)  && ( gft_indEnable & 2 ) )
        {
            gl_ind_metric_acc = iMetricSort( gs_numSymbolsIgnored , DONE_METRIC_SORT) ;
            gl_indThresh = (gl_ind_metric_acc * gs_KT) >> guc_indScaleTestSnr;
#ifdef DEBUG_IMP_DET
            if (jg_pause & 0x10)  Pause(17);
#endif
            gs_TrainCnt=0;
        }
        else
        {
            /* Compute noise power in the background */
            if ((guc_AccumState == TRAINING_DONE) && (gft_CopyRxBuffer == TRUE))
            {
                int32  l_indMetric;
                if (gft_indEnable & 2 )
                l_indMetric = impulseCheck(gsa_RxToneBuf,gsa_indTones, gs_NumIndTones);
                else
                l_indMetric = gl_indThresh -1  ;

                if (gl_indThresh > l_indMetric )
                {
                    CopyRxMedleyBuffer();
                    gs_MedleyOffset = gs_RxFirstPNbit;
                    gft_CopyRxBuffer = FALSE;
                    guc_AccumState = TRAINING_IN_PROGRESS;

                    AddFunctionToBkgdFifo((PtrToBkgdFunc) BgNoiseAcc);
                    gs_TrainCnt++;
                }
                else
                gs_droppedMedleyTest++;
            }

            /* Compute SNR value in the background */
            if(gs_TrainCnt == NUM_SNR_TRAINING_SYMBOLS_TEST) {

                guc_SnrCalcState = TRAINING_IN_PROGRESS;
                gs_log2_num_snr_training_symbols = LOG2_NUM_SNR_TRAINING_SYMBOLS_TEST;
                AddFunctionToBkgdFifo((PtrToBkgdFunc) BGMedleySnrCalc);
                /* BgMedleySnrCalc() also calculates capacity */

                gs_RxSubState = R_C_MEDLEY_RX_KEEP_BEST;

            }  /* if(gs_TrainCnt == gs_num_snr_training_symbols) */

        }; //else ind.
        gs_RxSubStateCnt++;
        break;

        /* ============================================================================== */
        /* Keep the parameters that provides best capacity */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_KEEP_BEST:

        if (guc_SnrCalcState == TRAINING_DONE) {

            gsa_MultiTdqCapacity[gs_TdqIdx][gs_MedleySyncOffset+gs_MaxPostSync] = gs_Capacity;

            if (gsa_Best[CAPACITY] < gs_Capacity)
            {
                gsa_Best[SYNCH] = gs_MedleySyncOffset;
                gsa_Best[CAPACITY] = gs_Capacity;
                gsa_Best[TDQIDX] = gs_TdqIdx;
                /* Choose TDQ based on Capacity only */
                /* If current TDQ has 2% or more capacity than Chosen TDQ then choose current TDQ */
                s_CurrMinusChosenTdqCap = gs_Capacity - gsa_Chosen[CAPACITY];
                if ((s_CurrMinusChosenTdqCap*100) > (gs_dbgChosen*gsa_Chosen[CAPACITY]))
                {
                    gsa_Chosen[SYNCH] = gs_MedleySyncOffset;
                    gsa_Chosen[CAPACITY] = gs_Capacity;
                    gsa_Chosen[TDQIDX] = gs_TdqIdx;
                }
            }
            /* Special case: Incase all Multitdqs give 0 capacity, choose Unity Tdq */
            else if ((gsa_Best[CAPACITY] == 0) && (gs_TdqIdx == gs_TdqOffIdx) && (gs_MedleySyncOffset == 0))
            {
                gsa_Best[SYNCH] = gsa_Chosen[SYNCH] = gs_MedleySyncOffset;
                gsa_Best[CAPACITY] = gsa_Chosen[CAPACITY] = gs_Capacity;
                gsa_Best[TDQIDX] = gsa_Chosen[TDQIDX] = gs_TdqIdx;
            }

            /* Save Unity TDQ Medley SNR for for zero medley synch offset for non-plus modes */
            if ((gs_RxNumTones==256) && (gs_TdqIdx == gs_TdqOffIdx) && (gs_MedleySyncOffset == 0))
            {
                memcpy(gpsa_MedleyUnityTDQSnr, gt_StateMachCntrl.psa_RXSNRBuf, sizeof(int16)*(gs_RxNumTones));
            }

            // If capacity is more than about 10% (100% * 3300/2^15) below best so far, don't
            // advance offsets in this direction any further.
            s_PreviousSyncOffset = gs_MedleySyncOffset;
            if ((gsa_Best[CAPACITY] - gs_Capacity) >= (((int32)gsa_Best[CAPACITY] * 3300) >> 15))
            ft_StopSyncOffsetsInThisDirection = 1;
            else
            ft_StopSyncOffsetsInThisDirection = 0;

            if ((gs_MedleySyncOffset == gs_MaxPostSync) ||
                    ((gs_MedleySyncOffset > 0) && ft_StopSyncOffsetsInThisDirection))
            {
                // Done with all sync offset trials.  Go to next TDQ
                /* Choose TDQ based on minimum deviation in capacity between post-syncs */
                /* Compute deviation of chosen TDQ */
                gsa_Chosen[DEVIATION] = computePostSyncDeviation(&gsa_MultiTdqCapacity[gsa_Chosen[TDQIDX]][0], (int16)(gsa_Chosen[SYNCH]+gs_MaxPostSync));
                for (j = 0; j <= (gs_MaxPostSync<<1); j++)
                {
                    s_BestMinusChosenTdqCap = gsa_Best[CAPACITY] - gsa_MultiTdqCapacity[gs_TdqIdx][j];
                    s_CapDeviation = computePostSyncDeviation(&gsa_MultiTdqCapacity[gs_TdqIdx][0], j);
                    /* If current TDQ is within 2% of "Best Capacity" and has lesser deviation than chosen TDQ, then choose current TDQ */
                    if (((s_BestMinusChosenTdqCap*100) <= (gs_dbgChosen*gsa_Best[CAPACITY]) && s_CapDeviation < gsa_Chosen[DEVIATION]) ||
                            /* OR if current TDQ has same deviation as chosen TDQ and has better than "Chosen Capacity", then choose current TDQ */
                            (s_CapDeviation == gsa_Chosen[DEVIATION] && gsa_MultiTdqCapacity[gs_TdqIdx][j] > gsa_Chosen[CAPACITY]))
                    {
                        gsa_Chosen[SYNCH] = (j-gs_MaxPostSync);
                        gsa_Chosen[CAPACITY] = gsa_MultiTdqCapacity[gs_TdqIdx][j];
                        gsa_Chosen[TDQIDX] = gs_TdqIdx;
                        gsa_Chosen[DEVIATION] = s_CapDeviation;
                    }
                }
                guc_FdqTrainingState = TRAINING_WAITING;
                if (gsa_Chosen[TDQIDX] == gs_TdqIdx)
                {
                    gs_MedleySyncOffset = gsa_Chosen[SYNCH];
                    /* Adjust FDQ based on the new frame synch point in the background */
                    guc_FdqTrainingState = TRAINING_IN_PROGRESS;
                    AddFunctionToBkgdFifo((PtrToBkgdFunc)FdqAdjust);

                    /* Adjust FDQ to account for post-sync and wait for new FDQ coefs to be loaded to enable PLL */
                    FdqAdjustPerTone(&gsa_FDQ_coef_sav[(gs_PilotToneIdx<<1)], &guca_FDQ_exp_sav[gs_PilotToneIdx],
                    &gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_PilotToneIdx],
                    gs_PilotToneIdx, gs_MedleySyncOffset);
                }

                gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_CHOSEN_FDQ;
            }
            else
            {
                if ((gs_MedleySyncOffset == -gs_MaxPostSync) ||
                        ((gs_MedleySyncOffset < 0) && ft_StopSyncOffsetsInThisDirection))
                {
                    // Start doing positive sync offsets
                    gs_MedleySyncOffset = 1;
                }
                else if (gs_MedleySyncOffset <= 0)
                {
                    // Do next negative offset
                    gs_MedleySyncOffset--;
                }
                else // (gs_MedleySyncOffset > 0)
                {
                    // Do next positive offset
                    gs_MedleySyncOffset++;
                }

                gs_RxSubState = R_C_MEDLEY_RX_ADJUST_SYNCH; /* go to next synch point */
            }

        } /* guc_SnrCalcState = TRAINING_DONE */
        break;

    case R_C_MEDLEY_RX_COMPUTE_CHOSEN_FDQ:
        if (guc_FdqTrainingState == TRAINING_DONE)
        {
            guc_FdqTrainingState = TRAINING_WAITING;
            MemCopyWords(gsa_FDQ_coef_best, 0, gsa_pre_FDQ_coef, 0, (int16)(2*gs_RxNumTones));
            memcpy(guca_FDQ_exp_best,  guca_pre_FDQ_exp, sizeof(int8)*(gs_RxNumTones));
        }
        if (guc_FdqTrainingState == TRAINING_WAITING)
        {
            if (gs_TdqIdx < gs_last_tdq_idx) {
                gs_TdqIdx++;
                gs_MedleySyncOffset = 0;
                s_PreviousSyncOffset = 0;
                gs_RxSubStateCnt = 0;
                gs_RxSubState = R_C_MEDLEY_RX_LOAD_TDQ; /* go to next TDQ */
            }
            else {
                // Done with all TDQs
                /* Compute deviation of best TDQ (for debug purposes only) */
                gsa_Best[DEVIATION] = computePostSyncDeviation(&gsa_MultiTdqCapacity[gsa_Best[TDQIDX]][0], (int16)(gsa_Best[SYNCH]+gs_MaxPostSync));
                gs_RxSubState = R_C_MEDLEY_RX_LOAD_BEST; /* done searching */
            }
        }
        break;

        /* ============================================================================== */
        /* Pick the (TDQ, SYNCH) pair that achieves best capacity and               */
        /* download corresponding FDQ coefficients                            */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_LOAD_BEST:

        if (gsa_Chosen[TDQIDX] != gs_TdqOffIdx) {
            /* load the best TDQ */
            gps_TdqFilter = &(gsa_MultiTdqTaps[gsa_Chosen[TDQIDX]*gs_TDQLen]);
            memcpy(&(gsa_pre_tdq_h[0]), gps_TdqFilter, gs_TDQLen*sizeof(int16));
            gs_pre_tdq_h_exp = gsa_MultiTdqExp[gsa_Chosen[TDQIDX]];
            gs_AlignmentOffset = -gs_CumulativeAlignmentOffset + s_SyncMethods_Delta + gsa_MultiTdqPreSyncs[gsa_Chosen[TDQIDX]] + gsa_Chosen[SYNCH];
        }
        else {
            /* Turn TDQ off */
            gsa_pre_tdq_h[0]=0x4000;
            for (i=1; i<gs_TDQLen; i++)
            gsa_pre_tdq_h[i]=0;
            gs_pre_tdq_h_exp = gs_UnityTDQExp;

            /* move back to initial synch point for TDQ off */
            gs_AlignmentOffset = -gs_CumulativeAlignmentOffset + gsa_Chosen[SYNCH];
        }
#ifdef ADSL_62
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
#else
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQ);
#endif

        /* Restore the corresponding FDQ */
        MemCopyWords(gsa_pre_FDQ_coef, 0, gsa_FDQ_coef_best, 0, (int16)(2*gs_RxNumTones));
        memcpy(guca_pre_FDQ_exp,  guca_FDQ_exp_best,  sizeof(int8)*(gs_RxNumTones));

        /* Turn PLL off */
        gft_EnablePLL = FALSE;


        gs_RxSubState = R_C_MEDLEY_FINAL_FRMALIGN;
      break;

   case R_C_MEDLEY_FINAL_FRMALIGN:

      // ensure that we are not doing frame alignment adjustment  close to a frame on which QT is likely to get stalled
      if ((gs_stall_cnt >=1) && (gs_stall_cnt < 8))
      {
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,MedleyAdjustAlignment);
        // Large enough negative alignments are implemented as large positive alignments.  This
        // causes one Rx frame to be discarded.
        if (gs_AlignmentOffset < -gs_RxCPLength)
        gft_SkipOneFrame = 1;

        gs_AlignForRotation = gs_AlignmentOffset + gs_CumulativeAlignmentOffset;

        if (gs_PilotToneIdx != gs_CPilotTone)
        {

        /* FDQ Adjust Pilot Tone */
      /* Adjust FDQ to account for pre-sync */
      FdqAdjustPerTone(&gsa_pre_FDQ_coef[(gs_CPilotTone<<1)], &guca_pre_FDQ_exp[gs_CPilotTone],
            &gsa_pre_FDQ_coef[(gs_CPilotTone<<1)], &guca_pre_FDQ_exp[gs_CPilotTone],
            gs_CPilotTone, gs_AlignForRotation);

      // =====================================================================================
      /* Adjust FDQ to account for TDQ, FDQ_Adjust =  FDQ * Normalised_TDQ_Conj */
      /* Normalised_TDQ_Conj = TDQ_Conj / Abs(TDQ_i) */
      // =====================================================================================
      ComputeNormConjTDQFreqResp(gsa_pre_tdq_h, (int16)(1 + gs_UnityTDQExp - gs_pre_tdq_h_exp), gs_CPilotTone, sa_TdqFreqRespCoef, &s_TdqFreqRespExp);
      FdqUpdate(&gsa_pre_FDQ_coef[(gs_CPilotTone<<1)], &guca_pre_FDQ_exp[gs_CPilotTone],
            sa_TdqFreqRespCoef, (FDQ_MANTISSA_FRAC_BITS - TDQ_MANTISSA_FRAC_BITS + s_TdqFreqRespExp));
      }
#ifdef DANUBE_TEMP
        //This part is to handle the +/-90 degree phase rotation on auxpilot tone.
        /*
The idea behind the workaround is
(1). to check the phase of fdq coefficients of the auxpilot tone and those of its two neighboring tones.
In general, their phase should be continuous and a discontinuity with the auxpilot tone implies an unexpected phase rotation.
Due to the periodicity of the arctan output, we first convert those phase differences, which are more than 180,  into [0, pi] range,
to simply the fdq coeffs change in (2).

(2). to make the use of the property of continuity in signs of the fdq coeffs. Suppose we have Tone 48 as the auxpilot tone;
Tone 47 and Tone 49 are the data tones, based on which we adjust the FDq of tone 48.
Notice that (a), the inphase or quadrate parts (or both) of Tone 47 and Tone 49 should be of the same sign.
(b) If there is a 90 degree shift of Tone 48, we would have (x_48'=-y_48, y_48'=x_48) or (x_48=y_48', y_48'=-x_48).
By comparing y_47, x_48 and y_49 or x_47, y_48 and y_49, we finish the auxpilot phase shift adjustment.
*/
        s_pilot_real = gsa_pre_FDQ_coef[gs_PilotToneIdx<<1];
        s_pilot_left_real = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)-2];
        s_pilot_right_real = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+2];
        s_pilot_imag = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1];
        s_pilot_left_imag = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)-1];
        s_pilot_right_imag = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+3];

        s_pilot_phase = FastAtan(s_pilot_imag, s_pilot_real);
        s_pilot_left_phase = FastAtan(s_pilot_left_imag, s_pilot_left_real);
        s_pilot_right_phase = FastAtan(s_pilot_right_imag, s_pilot_right_real);

        l_pdiff_left= s_pilot_left_phase - s_pilot_phase;
        l_pdiff_right=  s_pilot_right_phase-s_pilot_phase ;

        // (1) and (2) below handle the situation when the difference is greater than 180 degree due to the periodicity of arctan calculation.
        // (notice 1 radian=8192, pi/2=12828, pi=25736, 5*pi/4=32154)
        if  (l_pdiff_left>32154)  //(1): when the FDQ coeffs of neighboring data tones are in 2nd quadrant and those of pilot in the 3rd quadrant
        {
            l_pdiff_left=(25736-s_pilot_left_phase) + (25736 + s_pilot_phase);
        }
        else if  (l_pdiff_left < -32154)   //(2): when the neighboring tones are in 3rd quadrant (or 4th) and the pilot in the 2nd quadrant.
        {
            l_pdiff_left=(25736-s_pilot_phase) + (25736 + s_pilot_left_phase);
        }
        else if  (l_pdiff_left <0) //(3): take the absolute value if -pi/2 shift
        {
            l_pdiff_left=-l_pdiff_left;
        }


        // (1) and (2) below handle the situation when the difference is greater than 180 degree due to the periodicity of that arctan calculation.
        if  (l_pdiff_right>32154)  //(1): when the neighboring data tones are in 2nd quadrant and the pilot in the 3rd quadrant
        {
            l_pdiff_right=(25736-s_pilot_right_phase) + (25736 + s_pilot_phase);
        }
        else if  (l_pdiff_right < -32154)   //(2): when the neighboring tones are in 3rd quadrant and the pilot in the 2nd quadrant.
        {
            l_pdiff_right=(25736-s_pilot_phase) + (25736 + s_pilot_right_phase);
        }
        else if  (l_pdiff_right <0) //(3): take the absolute value if -pi/2 shift
        {
            l_pdiff_right=-l_pdiff_right;
        }

        if (( l_pdiff_left>9868  && l_pdiff_left < 15868 ) || ( l_pdiff_right >9868  && l_pdiff_right < 15868 ))
        // (notice 70 degree=8192, 110 degree = 15868)
        // check whether the difference is within [70-110] range, if so, perform phase adjustment (1 radian=8192)
        {
            int16 temp;

            if (((s_pilot_left_imag>0) && (s_pilot_right_imag>0) && (s_pilot_real>0)) || ((s_pilot_left_imag<0) && (s_pilot_right_imag<0) && (s_pilot_real<0)) )
            { //  -pi/2 shift,Q = (-I)
                //  (1): should stay in 1st quadrant, pilot in 4th quadrant; should stay in 2nd quadrant, pilot in 1st quadrant;
                //  (2): should stay in 3rd quadrant, pilot in 2nd quadrant; should stay in 4th quadrant, pilot in 3rd quadrant;
                //  (3): it also handles the situation when two neighboring tones of the pilot are of quadrant 1 and 2 respectively;
                //          or quadrants 3 and 4 respectively; and the pilot has a -90 degree shift.
                temp = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1) +1];
                gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1]= gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]; //new_imag=old_real, as they are of the same sign
                gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]= -temp; //new_real=-old_imag;

            }

            else if (((s_pilot_left_imag>0) && (s_pilot_right_imag>0) && (s_pilot_real<0)) || ((s_pilot_left_imag<0) && (s_pilot_right_imag<0) && (s_pilot_real>0)))
            { //+pi/2 shift,  I = (-Q)
                //  (1): should stay in 1st quadrant, pilot in 2nd quadrant; should stay in 2nd quadrant, pilot in 3rd quant;
                //  (2): should stay in 3rd quadrant, pilot in 4th quadrant; should stay in 4th quadrant, pilot in 1st quant;
                //  (3): it also handles the situation when two neighboring tones of the pilot are of quadrant 1 and 2 respectively;
                //          or quadrants 3 and 4 respectively; and the pilot has a +90 degree shift.
                temp = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1) +1];
                gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1]= -gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]; //new_imag=-old_real, as they are of the opposite sign
                gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]= temp; //new_real=old_imag;

            }

            else if (((s_pilot_left_real>0) && (s_pilot_right_real>0) && (s_pilot_imag>0)) || ((s_pilot_left_real<0) && (s_pilot_right_real<0) && (s_pilot_imag<0)) )
            {
                // This part is partially redundancy; it deals with the situation when two neighboring tones are located on the different quadrant.
                // it mainly handles the situation when two neighboring tones of the pilot are of quadrant 1 and 4 respectively;
                // or quadrants 2 and 3 respectively; and the pilot has a +90 degree shift.

                temp = gsa_pre_FDQ_coef[gs_PilotToneIdx<<1];
                gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]= gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1]; //new_real=old_imag;  as they are of the same sign
                gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1]= -temp; //new_imag=-old_real, as they are of the opposite sign

            }

            else if (((s_pilot_left_real>0) && (s_pilot_right_real>0) && (s_pilot_imag<0)) || ((s_pilot_left_real<0) && (s_pilot_right_real<0) && (s_pilot_imag>0)) )
            {
                // This part is partially redundant;  it deals with the situation when two neighboring tones are located in the different quadrant.
                // it mainly handles the situation when two neighboring tones of the pilot are of quadrant 1 and 4 respectively;
                // or quadrants 2 and 3 respectively; and the pilot has a -90 degree shift.
                temp = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1) +1];
                gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1]= gsa_pre_FDQ_coef[gs_PilotToneIdx<<1];
                gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]= -temp;

            }
        }
        // handle 180 degree phase shift, which rarely happens
        else
        {
            if (((s_pilot_left_real>0) && (s_pilot_right_real>0)  && (s_pilot_real<0)) || ((s_pilot_left_real<0) && (s_pilot_right_real<0) && (s_pilot_real>0)))
            {
                gsa_pre_FDQ_coef[gs_PilotToneIdx<<1]= -gsa_pre_FDQ_coef[gs_PilotToneIdx<<1];

            }
            if (((s_pilot_left_imag>0) && (s_pilot_right_imag>0)  && (s_pilot_imag<0)) || ((s_pilot_left_imag<0) && (s_pilot_right_imag<0)  && (s_pilot_imag>0)))
            {
                gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1]= -gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1];

            }

        }

#endif

        AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);

        gs_RxSubState = R_C_MEDLEY_RX_FINAL_SNR_INIT;
      }
        break;

        /* ============================================================================== */
        /* Initialize for final SNR calculation */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_FINAL_SNR_INIT:

        /* Reset buffer alignments */
        if (gs_AlignmentOffset != 0) {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);
        }
        /* Initialize parameters related to SNR Calculation */
        MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
        gs_TrainCnt = 0;
        guc_AccumState = TRAINING_DONE;



        // Set flags (matters for cocomo trails)
        guc_FdqTrainingState = TRAINING_DONE;
        guc_TdqTrainingState = TRAINING_DONE;

        gs_RxSubStateCnt = 0;
        gs_RxSubState = R_C_MEDLEY_RX_CALCULATE_FINAL_SNR;

        break;


        /* ============================================================================== */
        /* Calculate final SNR for the chosen pair */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_CALCULATE_FINAL_SNR:

        if (gs_RxSubStateCnt == 3)
        {
            /* Medley Tdq Enabled */
            if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) != 0)
            {
                ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
                ScalePLL(gs_PllScaling);
            }

            /* Turn PLL back on */
            gft_EnablePLL = TRUE;


        }


        /* 8 extra frames for stablizing showtime Ki and Kp */
        if(gs_RxSubStateCnt == PLL_REACQUISITION_LEN - 8)
        {

            // XDSLRTFW-2579 (Start)
         /* XDSLRTFW-2464 */
            /* In case crystal frequency drift of 0.4 ppm/sec or higher is detected,
               new kp, ki together with new pll phase error threshold is used. See UpdatePLLAdaption function*/
            gs_Kp = gs_Kp_Showtime_FallBack;
            gs_Ki = gs_Ki_Showtime_FallBack;
            ScalePLL(gs_PllScaling);
            gs_Kp_Showtime_FallBack = gs_Kp;
            gs_Ki_Showtime_FallBack = gs_Ki;
         /* XDSLRTFW-2464 */
            gs_pllShowLimit = 715; // 5 degree degree

            //Experiment with 0.2 ppm/sec (or higher) crystal frequency drift across different
            //loop lengths ( 100m to 4000 m) showed that scaled Kp, Ki values are not sufficient
            //to follow crystal frequency ramp. Experiment also showed that without scaled Kp and Ki,
            //Showtime PLL adaptation can follow 0.2 ppm/sec without any CRC or bad DTUs across
            //different loop lengths with different Pilot tone indexes.

            ResetPLL((int16)gs_Kp_Showtime, (int16)gs_Ki_Showtime, gs_pllShowLimit);
            //ScalePLL(gs_PllScaling);     removed!

            // for debugging only
            // for (int ii = 0 ; ii <16; ii++)
            // {
            //     gusa_EDMetricLog[ii] = 0;
            // }

            // Counter reset
            gus_MicroInterruptionDetectionCnt = 0;
            gus_SymbolWithLowEdMetricCnt = 0;
            gul_PpmDriftCnt = 0;
            // XDSLRTFW-2579 (End)


         gs_Kp_Showtime_default = gs_Kp;  /* XDSLRTFW-2464 */
         gs_Ki_Showtime_default = gs_Ki;  /* XDSLRTFW-2464 */
        }

        if(gs_RxSubStateCnt == PLL_REACQUISITION_LEN-4 )
        {
            iMetricSort( 0 , INITIALIZE_METRIC_SORT );
        }

        // states to wait before accumulation is for PLL aquisition, and optionally for impulse detection setup.
        gs_statesToWait = R_C_MEDLEY_WT_LEN + PLL_ACQUISITION_LEN0 + 2  ;

        if (gft_indEnable & 1 )
        {
            gs_statesToWait += (gs_IndTime16 + gs_numSymbolsIgnored) ;
            if ( (gs_RxSubStateCnt > R_C_MEDLEY_WT_LEN+PLL_ACQUISITION_LEN0+2)
                    &&  (gs_RxSubStateCnt <= gs_statesToWait)  )
            {
                int16 indMetric;
                indMetric =  (int16) impulseCheck(gsa_RxToneBuf,gsa_indTones, gs_NumIndTones);
                iMetricSort( indMetric , RUN_METRIC_SORT );
#ifdef DEBUG_IMP_DETECT
                gsa_ReverbSnrBuf[gs_TrainCnt] =   indMetric;
#endif
                gs_TrainCnt++;
            } //if
            if (gs_RxSubStateCnt == gs_statesToWait)
            {
                gl_ind_metric_acc = iMetricSort( gs_numSymbolsIgnored , DONE_METRIC_SORT);
                gl_indThresh = (gl_ind_metric_acc * gs_KT) >> guc_indScale1;
#ifdef DEBUG_IMP_DETECT
                if (jg_pause&2)  Pause(8);
#endif
                gs_TrainCnt=0;
            }
        } // if indEnable

        /* Accumulate noise after initial waiting period  */
        if (gs_RxSubStateCnt > gs_statesToWait ) //R_C_MEDLEY_WT_LEN+PLL_ACQUISITION_LEN0+2)
        {

            if(gs_TrainCnt < NUM_SNR_TRAINING_SYMBOLS_FULL_INIT)
            {
                /* Compute noise power in the background */
                if ((guc_AccumState == TRAINING_DONE) && (gft_CopyRxBuffer == TRUE))
                {
                    int indMetric = 0;
                    CopyRxMedleyBuffer();

                    if (gft_indEnable & 1 )
                    indMetric = impulseCheck(gsa_RxToneBuf,gsa_indTones,   gs_NumIndTones);
                    //  if (gl_indThresh > (indMetric = impulseCheck(gsa_RxToneBuf,gsa_indTones,   gs_NumIndTones)))
                    if (((gft_indEnable & 1) ==0) || (gl_indThresh >  indMetric) )
                    {
                        gs_MedleyOffset = gs_RxFirstPNbit;
                        gft_CopyRxBuffer = FALSE;
                        guc_AccumState = TRAINING_IN_PROGRESS;

                        AddFunctionToBkgdFifo((PtrToBkgdFunc) BgNoiseAcc);
                        gs_TrainCnt++;

                        if (gs_PhaseError < -gs_dbgMaxPhErrMed)
                        gs_dbgMaxPhErrMed = -gs_PhaseError;
                        else if (gs_PhaseError > gs_dbgMaxPhErrMed)
                        gs_dbgMaxPhErrMed = gs_PhaseError;
                    }
                    else
                    {
                        gs_droppedMedley++;
#ifdef DEBUG_IMP_DETECT
                        if (gs_droppedMedley < 512-32 )
                        gsa_ReverbSnrBuf[32+gs_droppedMedley] = indMetric;
#endif
                    };
#ifdef DEBUG_IMP_DETECT
                    if (gs_TrainCnt<512) gsa_ReverbEchoSnrBuf[gs_TrainCnt] = indMetric;
#endif
                }

                /* Compute SNR value in the background */
                if(gs_TrainCnt == NUM_SNR_TRAINING_SYMBOLS_FULL_INIT) {

                    /* Init SNR's to 0 prior to SNR calculation */
                  // to get proper Medley SNR buf in ADSL1/ADSL2 modes
                    //MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));
                    MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*RX_NUM_TONES));
                    guc_SnrCalcState = TRAINING_IN_PROGRESS;
                    gs_log2_num_snr_training_symbols = LOG2_NUM_SNR_TRAINING_SYMBOLS_FULL_INIT;
                    AddFunctionToBkgdFifo((PtrToBkgdFunc) BGMedleySnrCalc);
                } /* if(gs_RxSubStateCnt == gs_num_snr_training_symbols) */
            }
            else if (guc_SnrCalcState == TRAINING_DONE)
            {
#ifdef BIS_CODESWAP
                if (gs_CodeSwapStatus != CODESWAP_IDLE)
                break;
#endif //BIS_CODESWAP
#ifdef DEBUG_IMP_DETECT
                if (jg_pause&1)  Pause(8);
#endif
                gs_RxSubStateCnt = -1;
                if (( gl_SelectedMode & (MODE_ADSL2)  ))
                {
                    gs_RxSubState = R_C_MEDLEY_RX_BIS_BITLOAD;
                    gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_Bitload_BIS;
                    gpF_TxStateFunc = (PtrToFunc)RMedleyTxF_Bitload_BIS;
                }
                else
                {
                    gs_RxSubState = R_C_MEDLEY_RX_BITLOAD;
                    gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_Bitload;
                }

                //XDSLRTFW-3795 (Start)
                //Check for TC mode when selected mode != Loop Diagnostics Mode.
                //Required TC mode may not be communicated by CO in G.Hs during Loop diagnostics mode.
                if ((gl_SelectedMode & LINK_DIAG) == 0)
                {
                   //XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (START)
                   if (gt_ADSL_TcMode_Reprt.us_FW_TC_mode == 0)
                   {
                      EnterFailStates(E_CODE_TC_NOT_SUPPORTED);
                   }

                   // XDSLRTFW-1924 / XDSLRTFW-2835 (start)
                   ul_addr=DREG_MISCRAM4_ADDR;
                   ReadPpeReg(ul_addr, &ul_data);

                   if (ul_data == 0) // PPA prior to 3.2
                   {
                      if (gus_TcModeUsed_PPE == 0)
                      {
                         gus_TcModeUsed_PPE = 0x2; // By Default ATM
                      }

                      gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode = (uint32)gus_TcModeUsed_PPE;

                      if (gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode == ATM_TC)   // Changing the numerical value due to mismatch between the standard and PPE in PPA 3.2
                      {
                         gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode = DREG_MISCRAM4_ATM;
                      }
                      else if (gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode == EFM_TC)    // Changing the numerical value due to mismatch between the standard and PPE in PPA 3.2
                      {
                         gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode = DREG_MISCRAM4_EFM;
                      }
                   }
                   else
                   {
                      gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode=(uint16)(ul_data & 0x3);  // If PPA 3.2 is used, then use the value in the register for TC Mode
                   }

                   // 1. Check for TC Mode Mismatch and fail
                   //    /* DSL FW. Msg. Catalouge */
                   //    #define          ATM_TC 2
                   //    #define          EFM_TC 1
                   //    /* PPE FW. Msg. Catalouge */
                   //    #define DREG_MISCRAM4_ATM 1
                   //    #define DREG_MISCRAM4_EFM 2
                   //
                   //    |DSL MODE  | FW.TC.Mode|  PPE.TC.Mode    |Pass/FAIL  |
                   //    +------------+-----------+--------------------+----------+
                   //    |ADSL2P    | ATM_TC |  DREG_MISCRAM4_ATM |PASS    |
                   //    |ADSL2     | ATM_TC |  DREG_MISCRAM4_ATM |PASS    |
                   //    |ADSL1     | ATM_TC |  DREG_MISCRAM4_ATM |PASS    |
                   //    |ADSL2P    | EFM_TC |  DREG_MISCRAM4_ATM |FAIL    |
                   //    |ADSL2     | EFM_TC |  DREG_MISCRAM4_ATM |FAIL    |
                   //    |ADSL1     | ATM_TC |  DREG_MISCRAM4_ATM |PASS    |
                   //    +------------+-----------+--------------------+----------+
                   //    |ADSL2P    | ATM_TC |  DREG_MISCRAM4_EFM |FAIL    |
                   //    |ADSL2     | ATM_TC |  DREG_MISCRAM4_EFM |FAIL    |
                   //    |ADSL1     | ATM_TC |  DREG_MISCRAM4_EFM |FAIL    |
                   //    |ADSL2P    | EFM_TC |  DREG_MISCRAM4_EFM |PASS    |
                   //    |ADSL2     | EFM_TC |  DREG_MISCRAM4_EFM |PASS    |
                   //    |ADSL1     | ATM_TC |  DREG_MISCRAM4_EFM |FAIL    |
                   //    +------------+-----------+--------------------+----------+
                   //
                   // 2. In addition we have to check if Bit-0 of register "DREG_MISCRAM6_ADDR" is SET
                   //    indicating that "Framer Request can be turned ON".
                   //    For further description of the register "DREG_MISCRAM6_ADDR", refer the document
                   //    "PPE DSL Notifications.docx".
                   //    Incase of mismatch in TC driver mode loaded or if Bit-0 is NOT SET, DSL FW should
                   //    drop the link and CLEAR the Bit-0 in "DREG_MISCRAM6_ADDR". This is as per
                   //    recommendation from PPE team.
                   // Bit definition of 0X7DC6 (DREG_MISCRAM6_ADDR):
                   //  Bit 0      --> Framer Request Enable (Set by the PPE driver and cleared by DSL FW)
                   //  Bit 1      --> Dynamic Frequency supported (Set by the PPE driver and cleared by DSL FW)

                   ul_addr = DREG_MISCRAM6_ADDR;
                   ReadPpeReg(ul_addr, &ul_data);

                   if ( ((gt_ADSL_TcMode_Reprt.us_FW_TC_mode == ATM_TC) && (gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode != DREG_MISCRAM4_ATM))  ||    //!ATM
                        ((gt_ADSL_TcMode_Reprt.us_FW_TC_mode == EFM_TC) && (gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode != DREG_MISCRAM4_EFM))  ||    //!EFM
                        ((ul_data & 0x1) == 0) )
                   {
                      ul_data = ul_data & 0xFFFE;
                      WriteCoreReg(DREG_MISCRAM6_ADDR,ul_data);

                      EnterFailStates(E_CODE_PPE_MISS_MATCH);
                   }
                   // XDSLRTFW-3712 (Start)
                   else
                   {
                      // If the Bit 1 of 0x7DCE register is set (refer PPE_DSL_Notifications for the bit information), the
                      // PPE driver is new one and supports the PPE frequency scaling. If the driver is a old one, the
                      // PPE clock frequency is always at 576MHz.
                      // Please refer MCAT 3.1 for the values for the values of INFO 244.
                      // Bit defintion of DREG register 0x7DCE (DREG_MISCRAM14_ADDR):
                      //       Value (Bit1 - Bit0)                 PPE Frequency
                      //             0                                576 MHz
                      //             1                                494 MHz
                      //             2                                432 MHz
                      //             3                                288 MHz
                      if (ul_data & MASK_BIT1)
                      {
                         ul_addr = DREG_MISCRAM14_ADDR;
                         ReadPpeReg(ul_addr, &ul_data);

                         gus_PPEClock_Configured = (ul_data & PPE_CLOCK_FREQ_MASK) + 1;
                      }
                      else
                      {
                         gus_PPEClock_Configured = PPE_CLOCK_576MHz;
                      }
                   }
                   // XDSLRTFW-3712 (End)
                   // XDSLRTFW-1924 / XDSLRTFW-2835 (end)
                   //XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (END)
                }
                //XDSLRTFW-3795 (End)
            }
        } /* else if(gs_RxSubStateCnt >=  C_R_MEDLEY_WT_LEN) */


        gs_RxSubStateCnt++;
        break;

      case R_C_MEDLEY_RX_COMPUTE_NMS_INIT:
        if (gs_TxState == R_MEDLEY_TX || gs_TxState == R_MEDLEY_TX_BIS)
        {
           gul_MedleySymbCount = gl_RxSymbolCount;

         //gs_log2_num_snr_training_symbols = LOG2_NUM_SNR_TRAINING_SYMBOLS_ADCNOISE;
         //guc_SnrCalcState = TRAINING_IN_PROGRESS;
         gt_StateMachCntrl.psa_RXSNRBuf = (int16 *)(void *)gpsa_deltaPGA_Snr;
         //gt_StateMachCntrl.psa_RXSNRBuf       = gsa_MedleySnrBuf;
         //MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));
         //AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
         gft_EnablePLL = FALSE;  //Freeze PLL tracking
         /* Disable FDQ since it will be trained.*/
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ); //disbale FDQ
         // Save values for default SNR measurement after NMS run with AGC1 gain to "actual+3dB"
         gsa_NMS_ResetPllRefToneInput_Save[0] = (gsa_PllRefTone[0]);// / gs_PilotToneScale);   // gsa_PllRefTone_unscale
         gsa_NMS_ResetPllRefToneInput_Save[1] = (gsa_PllRefTone[1]);// / gs_PilotToneScale);
         gs_NMS_AGC1_Gain_Save = (gs_AGC1_Gain_Set << 8);
         gs_PGA_required_Save = gs_PGA_required;
         guc_NMS_AlgHandler = CALCULATE_SNR_DELTA_AGC_GAIN;
         gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_ADC_NOISE;
         gs_RxSubStateCnt = 0;
         gft_CopyRxBuffer = TRUE;
         //ResetCoreReg((uint32)(V_DEC_CFG_ADDR), DEC_ENABLE_MASK);
         //ClearDEC();
         //if(gs_brk_dbg & 0x0001)
         //   Pause(0x0B01);
         }
      break;

      case R_C_MEDLEY_RX_COMPUTE_ADC_NOISE:
             // Note: The check is needed, becuase the state gets be executed multiple times!
             if (guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN)
             {
                   int16 s_PGA;
                   s_PGA = NMS_ADD_AGC_GAIN;          // Measure Medley SNR with 3dB higher AGC gains
                   if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_DELTA)
                   {
                      s_PGA = gt_HercADSL_OPTNMap_MarginControl.s_NMS_AGC;
                   }
                   gt_HercADSL_OPTNMap_MarginControl.s_NMS_AGC = (s_PGA << 8) ;
                   gs_PGA_required = (s_PGA + gs_AGC1_Gain_Set) << 8;   // 8.8 format

              }
              guc_PgaState = TRAINING_IN_PROGRESS;
             AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSetNmsPGA);
             gs_RxSubStateCnt = 0;
             gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT;
       break;

     case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT:
       if (guc_PgaState == TRAINING_DONE)
       {
          gs_RxSubStateCnt++;
          if (gs_RxSubStateCnt >= 4)
          {
             gs_RxSubStateCnt = 0;
             gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK;
          }
       }
       break;

     case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK:
          int16 sa_ResetPllRefToneInput[2];
          if ((guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN) ||
                (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_PllRef))
          {
             sa_ResetPllRefToneInput[0] = gsa_NMS_ResetPllRefToneInput_Save[0];
             sa_ResetPllRefToneInput[1] = gsa_NMS_ResetPllRefToneInput_Save[1];
              gpuca_NMSPilotLog =  (uint8 *)(void *)gpsa_New_NMS_Vector;
          }
          else
          {
             sa_ResetPllRefToneInput[0] = gsa_RxPilotTone[0];
             sa_ResetPllRefToneInput[1] = gsa_RxPilotTone[1];
             gpuca_NMSPilotLog =  (uint8 *)(void *)gpsa_New_NMS_Vector;
         gpuca_NMSPilotLog = gpuca_NMSPilotLog + 512; // offset 512 bytes

          }

          /* Adjust FDQ on pilot Tone */
             FdqAdjustPerTone(&gsa_FDQ_coef_pilot_UnityTdq[0], &guc_FDQ_exp_pilot_UnityTdq,
             &gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)], &guca_pre_FDQ_exp[gs_PilotToneIdx],
             gs_PilotToneIdx, gs_AlignForRotation);

          /* Load pilot FDQ coefs */
          AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQPilot);

          /* Get the reference phase of pilot signal and do the appropriate scaling of */
          /* loop coefficients for the new pilot tone. */
          ResetPllRefTone(sa_ResetPllRefToneInput[0], sa_ResetPllRefToneInput[1]);
          //ToDo : check whether any loop filter parameters to be changed ?? not required in genral.
          //ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
          //ScalePLL(gs_PllScaling);
          /* Enable PLL. */
          gft_EnablePLL = TRUE;
          gs_RxSubStateCnt = 0;
          gs_log2_TrainCnt = 90;
          gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT;
          //if(gs_brk_dbg & 0x0002)
          //  Pause(0x0B02);
       break;

     case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT:
        gs_RxSubStateCnt++;

        memcpy(gpuca_NMSPilotLog,gsa_RxPilotTone,4);
        gpuca_NMSPilotLog = gpuca_NMSPilotLog+4;

        if (gs_RxSubStateCnt > gs_log2_TrainCnt)
        {
           //Initialize the states to perform FDQ training
           //gs_AlgHandlerState = FDQ_TRAIN_INIT;
           MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
           gs_TrainCnt = 0;
           guc_AccumState = TRAINING_DONE;
           gs_num_fdq_training_symbols   = NUM_FDQ_TRAINING_SYMBOLS_MEDLEY;
           gs_log2_num_fdq_training_symbols = LOG2_NUM_FDQ_TRAINING_SYMBOLS_MEDLEY;

           gs_RxSubStateCnt = 0;
           gs_RxSubState = R_C_MEDLEY_RX_NOISE_MARGIN_AVERAGE_FRAME;
           gft_CopyRxBuffer = TRUE;
           //if(gs_brk_dbg & 0x0004)
           //    Pause(0x0B04);
        }
       break;

   case R_C_MEDLEY_RX_NOISE_MARGIN_AVERAGE_FRAME:
                  /* Accumulate the received signal in the background */
                  if ((guc_AccumState == TRAINING_DONE) && (gft_CopyRxBuffer == TRUE))
                  {
                     /* Turn off transfer of the Rx Tone buffer and save the medley offset so
                                 that the accumulation can be moved to the BG */
                     gft_CopyRxBuffer = FALSE;
                     gs_MedleyOffset = gs_RxFirstPNbit;
                     gsa_recv_tones = &gsa_RxToneBuf[0];
                     CopyRxMedleyBuffer();
                     guc_AccumState = TRAINING_IN_PROGRESS;
                     AddFunctionToBkgdFifo((PtrToBkgdFunc) BgMedleyToReverbAccum);
                     gs_TrainCnt++;
                  }
                  /* Compute average of the accumulated frames in background */
                  if(gs_TrainCnt == gs_num_fdq_training_symbols)
                  {
                      guc_FdqTrainingState = TRAINING_IN_PROGRESS;
                      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAvgFDQAccumulation);
                      gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_FDQ_TRAIN;
                      gs_RxSubStateCnt = 0;
                  }

      break;

     case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_FDQ_TRAIN:
        if (guc_FdqTrainingState == TRAINING_DONE)
        {
            if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
            {
                if ((gt_RCMsgFmt_bis.uc_MedleyPRBSds == 1) && (gt_RMsgFmt_bis.uc_MedleyPRBSus == 1))
                {
                    /* If using 14th order PRBS medley sequence, change the reverb reference signal */
                    /* to be the first frame of medley sequence */
                    MemCopyWords(gsa_CReverbRefTones, (int16)(2*gs_RxFirstChannel), gsa_unpk_PN512, (int16)(2*gs_RxFirstChannel), (int16)(2*(gs_RxLastChannel-gs_RxFirstChannel)));
                }
            }
            /* Calculate FDQ coefficients in the background. */
            guc_FdqTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc) FDQTrain);
            gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNRINIT;
            gs_RxSubStateCnt = 0;
        }

        break;

   case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNRINIT:

            if (guc_FdqTrainingState == TRAINING_DONE)
            {
               if (gs_RxSubStateCnt == 0)
               {
                  /* Load current FDQ coefficients */
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
               }
               else if (gs_RxSubStateCnt == TDQ_STABLIZE_LEN)
               {
                  /* Initialize for test SNR calculation */
                  MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
                  guc_AccumState = TRAINING_DONE;
                  gs_TrainCnt = 0;
                  gs_RxSubStateCnt = -1;
                  gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNR;
               }
               gs_RxSubStateCnt++;
            }
         break;

      case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNR:


         //if (gs_RxSubStateCnt == 1)
         //{
         //   if((gs_brk_dbg & 0x0008)&&(guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN))
         //      Pause(0x0B08);
         //   else if((gs_brk_dbg & 0x0010)&&(guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN))
         //      Pause(0x0B10);
         //}

            /* Compute SNR value in the background */
            if((gs_TrainCnt == NUM_SNR_TRAINING_SYMBOLS_ADCNOISE) &&(guc_AccumState == TRAINING_DONE))
            {
               guc_SnrCalcState = TRAINING_IN_PROGRESS;
               /* Init SNR's to 0 prior to SNR calculation */
               MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));
               gs_log2_num_snr_training_symbols = LOG2_NUM_SNR_TRAINING_SYMBOLS_ADCNOISE;
               AddFunctionToBkgdFifo((PtrToBkgdFunc) BGMedleySnrCalc);
               gs_RxSubState = R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_POST_SNR;
               gs_RxSubStateCnt = 0;
             }  /* if(gs_TrainCnt == gs_num_snr_training_symbols) */
                /* Compute noise power in the background */
            else if ((guc_AccumState == TRAINING_DONE) && (gft_CopyRxBuffer == TRUE))
            {
               CopyRxMedleyBuffer();
               gs_MedleyOffset = gs_RxFirstPNbit;
               gft_CopyRxBuffer = FALSE;
               guc_AccumState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc) BgNoiseAcc);
               gs_TrainCnt++;
            }
            gs_RxSubStateCnt++;
            break;

    case R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_POST_SNR:
         if ((guc_NMS_AlgHandler == CALCULATE_SNR_DELTA_AGC_GAIN)
               &&(guc_SnrCalcState == TRAINING_DONE)
             )
         {

            //gs_log2_num_snr_training_symbols = LOG2_NUM_SNR_TRAINING_SYMBOLS_ADCNOISE;
            //guc_SnrCalcState = TRAINING_IN_PROGRESS;
            gt_StateMachCntrl.psa_RXSNRBuf = (int16 *)(void *)gpsa_PGA_Snr;
            //gt_StateMachCntrl.psa_RXSNRBuf       = gsa_MedleySnrBuf;
            //MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));
            //AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
            gft_EnablePLL = FALSE;  //Freeze PLL tracking
            /* Disable FDQ since it will be trained.*/
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ); //disbale FDQ
            // Save values for default SNR measurement after NMS run with AGC1 gain to "actual+3dB"
            //gsa_NMS_ResetPllRefToneInput_Save[0] = (gsa_PllRefTone[0]);// / gs_PilotToneScale);   // gsa_PllRefTone_unscale
            //gsa_NMS_ResetPllRefToneInput_Save[1] = (gsa_PllRefTone[1]);// / gs_PilotToneScale);
            gs_PGA_required = gs_NMS_AGC1_Gain_Save;
            guc_NMS_AlgHandler = CALCULATE_SNR_DEFAULT_AGC_GAIN;
            gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_ADC_NOISE;
            gs_RxSubStateCnt = 0;
            //if(gs_brk_dbg & 0x0020)
            //   Pause(0x0B20);
          }
          else if((guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN)
                     &&(guc_SnrCalcState == TRAINING_DONE)
                  )
          {
             guc_NMS_AlgHandler = NOISE_MARGIN_SEP_DONE;
             gs_PGA_required = gs_PGA_required_Save;
             if (((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0) && (gft_TrainFdqIfMultiTdqDisabled == FALSE))
                gs_RxSubState = R_C_MEDLEY_RX_FINAL_SNR_INIT;
             else
                gs_RxSubState = R_C_MEDLEY_RX_LOAD_TDQ;
             gs_RxSubStateCnt = 0;
             gt_StateMachCntrl.psa_RXSNRBuf        = gsa_MedleySnrBuf;
             gul_TotMedpRev4SymbCount = gl_RxSymbolCount;
             //SetCoreReg((uint32)(V_DEC_CFG_ADDR), DEC_ENABLE_MASK);
             //UnmaskDECOutput();
             //if(gs_brk_dbg & 0x0040)
             //  Pause(0x0B40);
          }

          break;

    }
}

//#ifdef DANUBE
#ifdef TARGET_HW
/****************************************************************************
;   Prototype: void RequestSwap_MedleySnrBuf_ToXmem (void)
;
;   Description: Function makes a request for XDMA by loading the Data Swap
;  Control structure with all necessary parameters required to program the
;  XDMA engine.
;
;  Two global flags will be set:
;     (1) gt_DataSwap.c_State = DATASWAP_REQUESTED
;     (2) gus_DataBuf_InXmem |= MEMLEY_SNR_BUF_IN_XMEM
;
;  The first flag indicates that XDMA transfer is pending and structure
;  gt_DataSwap is occupied.
;
;  The second flag indicates that this particular buffer will be in external
;  memory when DMA is completed.
;
;   Arguments:
;       None
;
;   Return Value:
;       None
;
;****************************************************************************/
C_SCOPE void RequestSwap_MedleySnrBuf_ToXmem (void)
{
    if (gt_DataSwap.c_State == DATASWAP_READY)
    {
        gt_DataSwap.l_SrcAddr = (int32)&gsa_MedleySnrBuf[0];
        gt_DataSwap.l_DstAddr = (int32)&gusa_MedleySnrBuffer_BAR15[0]; // XDSLRTFW-1942 (Start_End)
        gt_DataSwap.s_BufSize = MEDLEY_SNR_BUF_SIZE;
        gt_DataSwap.c_XferDir = XDMA_WRITE_XMEM;
        gt_DataSwap.c_State   = DATASWAP_REQUESTED;
        gus_DataBuf_InXmem |= MEMLEY_SNR_BUF_IN_XMEM;
    }
}
#endif
//#endif // #ifdef DANUBE

#undef SIN_TBL_RSH_CNT
#undef TDQ_MANTISSA_WORDLENGTH
#undef TDQ_MANTISSA_FRAC_BITS

/* undefine substates */
#undef R_C_MEDLEY_RX_LOAD_TDQ
#undef R_C_MEDLEY_ADJUST_FRMALIGN
#undef R_C_MEDLEY_RESET_FRMALIGN
#undef R_C_MEDLEY_RX_FDQ_INIT
#undef R_C_MEDLEY_RX_AVERAGE_FRAME
#undef R_C_MEDLEY_RX_FDQ_TRAIN
#undef R_C_MEDLEY_RX_LOAD_FDQ
#undef R_C_MEDLEY_RX_ADJUST_SYNCH
#undef R_C_MEDLEY_RX_PRE_TEST_SNR_INIT
#undef R_C_MEDLEY_RX_TEST_SNR_INIT
#undef R_C_MEDLEY_RX_CALCULATE_TEST_SNR
#undef R_C_MEDLEY_RX_KEEP_BEST
#undef R_C_MEDLEY_RX_COMPUTE_CHOSEN_FDQ
#undef R_C_MEDLEY_RX_LOAD_BEST
#undef R_C_MEDLEY_FINAL_FRMALIGN
#undef R_C_MEDLEY_RX_FINAL_SNR_INIT
#undef R_C_MEDLEY_RX_CALCULATE_FINAL_SNR


#undef R_C_MEDLEY_RX_BITLOAD
#undef R_C_MEDLEY_RX_BIS_BITLOAD
#undef  R_C_MEDLEY_RX_COMPUTE_NMS_INIT
#undef  R_C_MEDLEY_RX_COMPUTE_ADC_NOISE
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT
#undef  R_C_MEDLEY_RX_NOISE_MARGIN_AVERAGE_FRAME
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_FDQ_TRAIN
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNRINIT
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_SNR
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_POST_SNR
#undef  R_C_MEDLEY_TRAIN_RX_NOISE_MARGIN_POST_SNR

