/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: rinfotbl.c
;
;  This file contains the message tables during the Exchange stage of
;   Initialization.
;
*****************************************************************************/

#include "common.h"
#include "T1413.h"
#include "data_alloc.h"

BSS_DEILV2_DMT
/*  Array containing number of raw data bytes per symbol excluding synch byte for DS  */
/*  AS0, AS1, AS2, AS3, LS0, LS1, LS2 bearer channels for fast and interleaver path  */
/*  for 4 DS rate options */
uint16 gusa_DS_ReqBytes[NUM_DS_BEARER_CHANNELS*NUM_DS_RATE_OPTIONS*NUM_DATA_PATHS];

/*  Array containing number of check bytes for fast and interleaver path for 4 DS rate options */
uint8 guca_DS_CheckBytes[NUM_DS_RATE_OPTIONS*NUM_DATA_PATHS];

/*  Array containing number of raw data bytes per symbol excluding synch byte for US  */
/*  LS0, LS1, LS2 bearer channels for fast and interleaver path for 4 US rate options */
uint16 gusa_US_ReqBytes[NUM_US_BEARER_CHANNELS*NUM_US_RATE_OPTIONS*NUM_DATA_PATHS];

/*  Array containing number of check bytes for fast and interleaver path for 4 US rate options */
uint8 guca_US_CheckBytes[NUM_US_RATE_OPTIONS*NUM_DATA_PATHS];

BSS_MAP_END//BSS_DEILV2_DMT

//dmt only
DATA_MAP_DMT
uint8 guca_PreAmbleField[4];

/* ======================================================================== */
/*  guca_RRates1Tab[] contains the configuration options sent during */
/*  R_RATES1_TX.   */
/* ======================================================================== */
uint8 guca_RRates1Tab[R_RATES1_NUM_BYTES];

/* ======================================================================== */
/*  guca_RMsgs1Tab[] contains the R_MSGS1 data */
/* ======================================================================== */
uint8 guca_RMsgs1Tab[R_MSG1_NUM_BYTES];

/* ======================================================================== */
/*  Four downstream rate options */
/*  Table entries must be arranged such that the lowest entry has */
/*  the maximum number of bits per symbol and the highest entry number */
/*  has the minimum number of bits per symbol. */
/* ======================================================================== */
/* payload bytes, checkbytes, S, D */
Option_t gta_DS_options[NUM_DS_RATE_OPTIONS];

/* ======================================================================== */
/*  Four upstream rate options */
/*  the maximum number of bits per symbol and the highest entry number */
/*  has the minimum number of bits per symbol. */
/* ======================================================================== */
/* payload bytes, checkbytes, S, D */
Option_t gta_US_options[NUM_US_RATE_OPTIONS];


/* ======================================================================== */
/*  Structure for R_MSGS1 */
/* ======================================================================== */
RMsgs1_t gt_RMsgs1;


/* ======================================================================== */
/*  Received R_C_RATES1 config options */
/* ======================================================================== */
uint8  guca_R_C_Rates1[R_C_RATES1_NUM_BYTES];

/* ======================================================================== */
/*  Received R_C_MSGS1 information */
/* ======================================================================== */
uint8  guca_R_C_Msgs1[R_C_MSGS1_NUM_BYTES];

CMsgs1_t gt_RCMsgs1;

DATA_MAP_END
