/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   snr.c
;
;  Routines to perform SNR calculations.
;
;
;****************************************************************************/

#include "common.h"
#include "snr.h"
#include "dsp_op.h"
#include <string.h>


/****************************************************************************
 ;
 ; Function Name: ConvertToDB
 ;
 ; Description:
 ;    Computes the dB value (10log10(l_xin)) of the input argument
 ;
 ;  Algorithm:
 ;      10*log10(l_xin) = (10/log2(10)) * log2(l_xin)
 ;                      = (10/log2(10)) * (x_exp + log2(x))
 ;      where x*2^x_exp = l_xin
 ;
 ;      log2(x) is approximated by
 ;          p(x) = -2.65 + 3.99*x - 1.348*x^2
 ;
 ; Input Arguments:
 ;      int32   l_xin   (Q32.0 format)
 ;
 ;  Return:
 ;      10*log10(l_xin) (in Q8.8 format)
 ;
 *****************************************************************************/

int16 ConvertToDB(int32 l_xin)
{
   int32 l_Acc;
   int16 n;

   if (l_xin <= 0) return (int16)0x8000; /* it shouldn't be <= 0 */

   n = 12;
   // Map input to range [+0.25, +0.5], where the approximation is optimized for
   while (l_xin > 2048) {
      l_xin >>= 1;
      n++;
    }
   while (l_xin <= 1024) {
      l_xin <<= 1;
      n--;
    }

      l_Acc   = (123454)*l_xin - 845972661;
   l_Acc   = (l_Acc >> 12)*l_xin + 615266328;
   l_Acc   = (l_Acc >> 12)*l_xin -  209852925;

   l_Acc >>= 2;
   l_Acc  += 12626113*n;
   l_Acc >>= 14;

   return (int16)l_Acc;
}

