/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   snr_b.c
;
;       Functions for BG Tasks from snr.c
;
;
;****************************************************************************/


// *******************************************************************************
//  snr_b.c
//
// History
//
// 16/01/2009 Vinjam: Added code to use the Virtual Noise in computing the Medley SNR.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 29/01/2009 Vinjam: Added code to store the Show time SNR with out virtual noise in "Port1" data memory.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 12/07/2012 Vinjam: Added code to capture snr with out virtual noise for Loop Diagnostics Mode
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
// *******************************************************************************


#include "common.h"
#include "snr.h"
#include "dsp_op.h"
#include "gdata.h"
#include <string.h>

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
/* The following two parameters represent signal_power in dB 25 * 10log10(2) in the form of */
/* SNR_SIG_MANT*2^SNR_SIG_EXP */
/* The factor of 25 is due to the 0x2000^2 + 0x2000^2, which accounts for 2^27, and then  */
/* an additional divide by 4 to account for the accumulation implementation               */
#define SNR_SIG_MANT (0x4b41)
#define SNR_SIG_EXP     (-8)
/* Following two parameters represent 10/log2(10) in the form of */
/* SNR_NOISE_SCALE_MANT*2^SNR_NOISE_SCALE_EXP */
#define SNR_NOISE_SCALE_MANT  (0x6054)
#define SNR_NOISE_SCALE_EXP      (-13)
/* The following parameters represent the coefficinets of polynomial approximation */
/* of log2(x) = -2.65 + 3.99*x - 1.348*x^2   for 0.5 <= x < 1.0 */
#define  LOG2X_C_EXP    (-13)    /* common exponent for all coefficients */
#define LOG2X_C0_MANT   (-21709) /* -2.65 = LOG2X_C0_MANT*2^LOG2X_C_EXP */
#define LOG2X_C1_MANT   (32686)  /* 3.99 = LOG2X_C1_MANT*2^LOG2X_C_EXP */
#define LOG2X_C2_MANT   (-11043) /* -1.348 = LOG2X_C2_MANT*2^LOG2X_C_EXP */

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
void AddVirtualNoise(int16 *psa_snr, int16 s_idx, int16 s_ch)
{
      DsVnPSDDescriptorTable_t *pt_PSDDesc;
      int16 s_VirtualSNR = 0;
      int16 s_NumBrkpts, s_VirtNoisePsd, s_RefSignalPSD;
      int16 s_LogTssi;

       /* ================================================================================ */
      /* Compute virtual noise SNR = Reference PSD - virtual noise_PSD in Q10.6 format (1 bit for sign bit) */
      /* ================================================================================ */
      //Note: In the first reease, Log_tssi(i) is not considered while computing the Virtual noise SNR, which is
      //mentioned in the G.992.3 Ammendment-5.
         pt_PSDDesc = (DsVnPSDDescriptorTable_t *) (&gt_DS_RefVirtNoiseLevel_ADSL2);
         s_NumBrkpts = pt_PSDDesc->us_NumberOfTones;

         if((s_NumBrkpts > 0) && (gft_Enable_DsVnInMedley == 1))
         {

            //If link is in show time, then store the computed ShowTimeSNR with out Virtual noise
            //in the last 1024 bytes of the DeInterleaver memory.
            //Code to capture showtime snr with out virtual noise for Loop Diagnostics Mode
            //XDSLRTFW-2433
            //if( (gft_ShowTimeFirstPassRx == 1) || (STATArray[STAT_MacroState] == STAT_LoopDiagMode))
               //gpsa_RxSnrBufWoVN[s_ch] = psa_snr[i];
               //gpsa_RxSnrBufWoVN[s_ch] = psa_snr[s_ch];

            // Get the virtual noise PSD in 0.5 dB steps
            s_VirtNoisePsd = GetTonePsd(s_ch, pt_PSDDesc);

            //Get the reference signal PSD
            //REFPSD = NOMPSD - PCB (in 0.1dB granuality)
            //REFPSD is stored with respect to "DEFAULT_NOMPSD_DS".
            s_RefSignalPSD = (gt_TxPMDControl.s_REFPSD_DS + (DEFAULT_NOMPSD_DS*10));

            //consider TSSI in dB format (with 0.1dB granuality) = (20*log10(TSSI))*10
            s_LogTssi = (((ConvertToDB(gusa_DS_Tssi_Value[s_ch]) - 0x1E1A)>>7)*10);
            //Explanation:
            //(i) Data in gusa_DS_Tssi_Value[] is in Qs1.10 format.
            //(ii) ConvertTodB( ) requires input in 32.0 format
            //(iii) So, s_LogTssi = convertTodB(Tssi/1024) = convertTodB(Tssi) - ConvertTodB(1024)
            //          ConvertTodB(1024) = 10*log10(1024) = 30.103 ==> 30.103*256 (in 8.8 format)
            //          ConvertTodB(1024) = 7706 = 0x1E1A (8.8 format)
            //          8.8 format is required, as the function ConvertTodB( ) returns value in 8.8 format
            //(iv) s_LogTssi = convertTodB(tssi) - 0x1E1A; (in 8.8 format)
               //     convertTodB( ) function computes 10*log10(x), where as here 20*log10(x) is required
            //     so, s_logTssi computed needs to be right shifted by 1 (to get x2) and left shifted by
            //     8 times to get the data in integer format.
            //     LeftShift by 7 times = Right Shift by 1 times + Left shift by 8 times.
            //     This is the reason, the computed value is left shifted by "7" times. Later
            //     it is multiplied by "10" to get it in granuality of 0.1dB.

            s_RefSignalPSD = s_RefSignalPSD + s_LogTssi;

            //s_RxMaxNomPsd = gt_TxPMDControl.s_MAXNOMPSD_DS;
            // Get the reference signal PSD in 0.1 dB steps
            //s_RefSignalPSD = 400 - s_RxMaxNomPsd;  //400 ==> -40dBm/Hz in 0.1 dB steps

            // values from 201 to 255, correspond to a virtual noise level of minus infinity
            // dBm/Hz. Here we check against -281 because s_VirtNoisePsd is in dBm/Hz in 0.5dB format
            // and we have already added the offset of 80 (i.e. -40dBm/Hz).
            if (s_VirtNoisePsd <= -281)
            {
               s_VirtualSNR = (int16)0x7FFF; // biggest 16 bit number
            }
            else
            {
               if(s_VirtNoisePsd > -80)
               {
                  // Convert to 0.5 dB steps while computing virtual noise SNR
                  // limit the VN PSD to -40dBm if it is set higher than -40dBm by ME
                  // this cannot happen at CPE side since decoded VN PSD is always lower than -40dBm
                  s_VirtualSNR = (s_RefSignalPSD/5) + 80;
               }
               else
               {
                  // Convert to 0.5 dB steps while computing virtual noise SNR
                  s_VirtualSNR = (s_RefSignalPSD/5) - s_VirtNoisePsd;

               }
               // Convert to Q8.8 format
               s_VirtualSNR = s_VirtualSNR << 7;
            }

            // Take the minimum of the two SNRs
            if (psa_snr[s_idx] > s_VirtualSNR)
               psa_snr[s_idx] = s_VirtualSNR;

         }

}
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

/********************************************************************************************
;  Subroutine Name: SnrCalc
;
;  Description:
;     This routine computes the SNR for each channel in [s_first_chan, s_last_chan] in the
;     following equation:
;
;     SNR = 10*log10(referece_tone_power/average_noise_power)
;
;     reference_power = ((0x4000)^2 + (0x4000)^2))>>2 = 2^27,
;     where extra 2 bits right shifts are used to match the shift used
;     in average power computation.
;
;     average_noise_power = la_NoisePower[i]
;     where >>2 is applied to la_NoisePower[i]
;
;     SNR[i] = 10*log10(2^27) - 10*log10(la_NoisePower[i])
;
;     The implementation is done in the fixed-point algorithmetic and final SNR
;     is expressed in Q8.8 format
;
;  Prototype:
;     void SnrCalc(int32 *pla_NoisePower, int16 *psa_snr, int16 s_first_chan, int16 s_last_chan);
;
;  Input Arguments:
;     s_first_chan -- first channel
;     s_last_chan -- last channel
;     pla_NoisePower -- pointer to accumulators for storing average noise power
;
;  Output Arguments:
;     psa_snr -- pointer to an array of SNR values (in dB)
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/
void SnrCalc(int32 *pla_NoisePower, int16 *psa_snr, int16 s_first_chan, int16 s_last_chan)
{
        int16 i, s_Nchannels;
        int32 l_Acc, l_Acc1, l_NoisePower;

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   int16 s_VirtualSNR=0;
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   s_Nchannels = s_last_chan - s_first_chan + 1;

   /* ============================================================================= */
   /* Compute SNR for each channel i */
   /* ============================================================================= */
   for(i = 0; i < s_Nchannels; i++) {

      l_NoisePower  = pla_NoisePower[i];

      // If noise power is 0, increment to 1 to avoid getting an "infinite" SNR.
      if (l_NoisePower == 0)
         l_NoisePower = 1;

        /* ================================================================================ */
      /* compute 10*log10(pla_NoisePower[i]), in Q24.8 format */
      /* ================================================================================ */
        l_Acc = (int32)ConvertToDB(l_NoisePower);

        /* ================================================================================ */
      /* Load signal_dB = 10*log10(2^27) = SNR_SIG_MANT*2^SNR_SIG_EXP  */
      /* and represent it in Q24.8 format */
      /* ================================================================================ */
      l_Acc1 = (int32)SNR_SIG_MANT;

      /* ================================================================================ */
      /* Compute SNR = signal_dB - noise_dB in Q10.6 format (1 bit for sign bit) */
      /* ================================================================================ */
      l_Acc = l_Acc1 - l_Acc;

      /* Add noise separation margin adjustment to Showtime SNR. */
      if (gs_RxState == R_C_SHOWTIME_RX)
      {

         if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN)
         {
            if(gft_AddNMS == TRUE)
            {
               #if 1
                  int16 s_diff,s_NMS_delta;
                  s_diff = MAX((gpsa_Medley_Vector[s_first_chan+i]- gsa_RxShowtimeSnrBuf[s_first_chan+i]),0);
                  s_NMS_delta = MAX((gpsa_NMS_Vector[s_first_chan+i] - s_diff),0);
                  l_Acc += (int32)MIN(s_NMS_delta,gt_HercADSL_OPTNMap_MarginControl.s_deltaMarginMax);
               #else
                 l_Acc += (int32)gpsa_NMS_Vector[s_first_chan+i];
               #endif
            }
         }
         else
         {
            l_Acc += (int32)gpsa_NoiseSeparationSnrAdj[s_first_chan+i];
         }

      }

      /* Saturate the result and represent SNR in Q8.8 format */
      psa_snr[i] = sature16(l_Acc);

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   if(gl_SelectedMode & (MODE_ADSL2))
   {
         //XDSLRTFW-2433(start)
      // Save SNR without VN from medley phase without VN can be used for init
        if(gft_Enable_DsVnInMedley == 1)
        {
            gsa_RxWithOutVnSnrBuf[s_first_chan+i] = psa_snr[i];
        }

         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
         //Create function "AddVirtualNoise" to deal with the code below
         AddVirtualNoise(psa_snr, i, (s_first_chan+i));
#if 0

      /* ================================================================================ */
   /* Compute virtual noise SNR = Reference PSD - virtual noise_PSD in Q10.6 format (1 bit for sign bit) */
   /* ================================================================================ */
        //Note: In the first reease, Log_tssi(i) is not considered while computing the Virtual noise SNR, which is
      //mentioned in the G.992.3 Ammendment-5.

      s_ch = (s_first_chan + i);
      pt_PSDDesc = (DsVnPSDDescriptorTable_t *) (&gt_DS_RefVirtNoiseLevel_ADSL2);
      s_NumBrkpts = pt_PSDDesc->us_NumberOfTones;

      if((s_NumBrkpts > 0) && (gft_Enable_DsVnInMedley == 1))
      {

         //If link is in show time, then store the computed ShowTimeSNR with out Virtual noise
         //in the last 1024 bytes of the DeInterleaver memory.
         //Code to capture showtime snr with out virtual noise for Loop Diagnostics Mode
         if( (gft_ShowTimeFirstPassRx == 1) || (STATArray[STAT_MacroState] == STAT_LoopDiagMode))
            gpsa_RxSnrBufWoVN[s_ch] = psa_snr[i];

         // Get the virtual noise PSD in 0.5 dB steps
         s_VirtNoisePsd = GetTonePsd(s_ch, pt_PSDDesc);

         //Get the reference signal PSD
         //REFPSD = NOMPSD - PCB (in 0.1dB granuality)
         //REFPSD is stored with respect to "DEFAULT_NOMPSD_DS".
            s_RefSignalPSD = (gt_TxPMDControl.s_REFPSD_DS + (DEFAULT_NOMPSD_DS*10));

                        //consider TSSI in dB format (with 0.1dB granuality) = (20*log10(TSSI))*10
                        s_LogTssi = (((ConvertToDB(gusa_DS_Tssi_Value[s_ch]) - 0x1E1A)>>7)*10);
                        //Explanation:
                        //(i) Data in gusa_DS_Tssi_Value[] is in Qs1.10 format.
                        //(ii) ConvertTodB( ) requires input in 32.0 format
                        //(iii) So, s_LogTssi = convertTodB(Tssi/1024) = convertTodB(Tssi) - ConvertTodB(1024)
                        //          ConvertTodB(1024) = 10*log10(1024) = 30.103 ==> 30.103*256 (in 8.8 format)
                        //          ConvertTodB(1024) = 7706 = 0x1E1A (8.8 format)
                        //          8.8 format is required, as the function ConvertTodB( ) returns value in 8.8 format
                        //(iv) s_LogTssi = convertTodB(tssi) - 0x1E1A; (in 8.8 format)
            //     convertTodB( ) function computes 10*log10(x), where as here 20*log10(x) is required
                        //     so, s_logTssi computed needs to be right shifted by 1 (to get x2) and left shifted by
                        //     8 times to get the data in integer format.
                        //     LeftShift by 7 times = Right Shift by 1 times + Left shift by 8 times.
                        //     This is the reason, the computed value is left shifted by "7" times. Later
                        //     it is multiplied by "10" to get it in granuality of 0.1dB.

            s_RefSignalPSD = s_RefSignalPSD + s_LogTssi;


         //s_RxMaxNomPsd = gt_TxPMDControl.s_MAXNOMPSD_DS;
         // Get the reference signal PSD in 0.1 dB steps
         //s_RefSignalPSD = 400 - s_RxMaxNomPsd;  //400 ==> -40dBm/Hz in 0.1 dB steps

         // values from 201 to 255, correspond to a virtual noise level of minus infinity
         // dBm/Hz. Here we check against -281 because s_VirtNoisePsd is in dBm/Hz in 0.5dB format
         // and we have already added the offset of 80 (i.e. -40dBm/Hz).
         if (s_VirtNoisePsd <= -281)
         {
            s_VirtualSNR = (int16)0x7FFF; // biggest 16 bit number
         }
         else
         {
            if(s_VirtNoisePsd > -80)
            {
               // Convert to 0.5 dB steps while computing virtual noise SNR
               // limit the VN PSD to -40dBm if it is set higher than -40dBm by ME
               // this cannot happen at CPE side since decoded VN PSD is always lower than -40dBm
               s_VirtualSNR = (s_RefSignalPSD/5) + 80;
            }
            else
            {
               // Convert to 0.5 dB steps while computing virtual noise SNR
               s_VirtualSNR = (s_RefSignalPSD/5) - s_VirtNoisePsd;

            }
            // Convert to Q8.8 format
            s_VirtualSNR = s_VirtualSNR << 7;
         }

         // Take the minimum of the two SNRs
         if (psa_snr[i] > s_VirtualSNR)
            psa_snr[i] = s_VirtualSNR;

      }
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)

   }
      //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)
   }
}


//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Compute psd level "wrt MaxNomPsd "of i/p tone index given
 *                                      PSD descriptor table
 *
 *  Prototype: void GetTonePsd(void)
 *
 *  Input Arguments:
 *              s_toneIdxIn             -       I/P Tone Index
 *              pt_PSDDescIn    -       I/P PSD Descriptor Table
 *
 *  Output Arguments: none
 *
 *  Return: PSD level of tone wrt MaxNomPsd
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 GetTonePsd(int16 s_toneIdxIn, DsVnPSDDescriptorTable_t *pt_PSDDescIn)
{
        int16 i, s_NumBrkpts, s_attenLevel;
        int16 s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel;
        PSDRecord_t *pt_PSDRec;

        s_NumBrkpts = pt_PSDDescIn->us_NumberOfTones;
        pt_PSDRec = &(pt_PSDDescIn->ut_PSDRecord[0]);
        for (i=0; i < s_NumBrkpts; i++)
        {
                if (pt_PSDRec[i].us_IndexOfTone >= s_toneIdxIn)
                        break;
        }

        /* Get the adjacent breakpoints given breakpoint index */
        GetAdjacentBreakpts(i, s_NumBrkpts, pt_PSDRec, 0, (int16)(gs_RxNumTones-1),
                                                &s_leftToneIdx, &s_leftToneAttenLevel, &s_rightToneIdx, &s_rightToneAttenLevel);

        /* Compute attenuation level given tone index and adjacent breakpoints */
        s_attenLevel = CalcAttenLevel(s_toneIdxIn, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel);

        return(-s_attenLevel);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Gets adjacent breakpoints given breakpoint index
 *
 *
 *  Prototype:
 *              void GetAdjacentBreakpts(int16 s_brkptIdxIn, int16 s_NumBrkptsIn, PSDRecord_t *pt_PSDRecIn, int16 s_minToneIdxIn, int16 s_maxToneIdxIn,
 *                              int16 *ps_leftToneIdxOut, int16 *ps_leftToneAttenLevelOut, int16 *ps_rightToneIdxOut, int16 *ps_rightToneAttenLevelOut)
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *      Return:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void GetAdjacentBreakpts(int16 s_brkptIdxIn, int16 s_NumBrkptsIn, PSDRecord_t *pt_PSDRecIn, int16 s_minToneIdxIn, int16 s_maxToneIdxIn, int16 *ps_leftToneIdxOut, int16 *ps_leftToneAttenLevelOut, int16 *ps_rightToneIdxOut, int16 *ps_rightToneAttenLevelOut)
{
        //Get the tone index and psd level of a breakpoint
        if (s_brkptIdxIn==0)
        {
                // For flat extension of log_PSD to frequencies lower than first breakpoint
                *ps_leftToneIdxOut = s_minToneIdxIn;
                *ps_leftToneAttenLevelOut = pt_PSDRecIn[0].s_PSDLevelOfTone;

                *ps_rightToneIdxOut = pt_PSDRecIn[s_brkptIdxIn].us_IndexOfTone;
                *ps_rightToneAttenLevelOut = pt_PSDRecIn[s_brkptIdxIn].s_PSDLevelOfTone;
        }
        else
        {
                *ps_leftToneIdxOut = pt_PSDRecIn[s_brkptIdxIn-1].us_IndexOfTone;
                *ps_leftToneAttenLevelOut = pt_PSDRecIn[s_brkptIdxIn-1].s_PSDLevelOfTone;

                if (s_brkptIdxIn == s_NumBrkptsIn)
                {
                        // For flat extension of log_PSD to frequencies higher than last breakpoint
                        *ps_rightToneIdxOut = s_maxToneIdxIn+1;
                        *ps_rightToneAttenLevelOut = pt_PSDRecIn[s_brkptIdxIn-1].s_PSDLevelOfTone;
                }
                else
                {
                        // For interpolation between two breakpoints.
                        // Need to also access the next PSD breakpoint record
                        *ps_rightToneIdxOut = pt_PSDRecIn[s_brkptIdxIn].us_IndexOfTone;
                        *ps_rightToneAttenLevelOut = pt_PSDRecIn[s_brkptIdxIn].s_PSDLevelOfTone;
                }
        }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Computes attenuation level given tone index and adjacent breakpoints
 *
 *
 *  Prototype:
 *              int16 CalcAttenLevel(s_toneIdx, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *      Return:
 *              Attenuation level @ tone index
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 CalcAttenLevel(int16 s_toneIdx, int16 s_leftToneIdx, int16 s_leftToneAttenLevel, int16 s_rightToneIdx, int16 s_rightToneAttenLevel)
{
        int32 l_numer;
        int16 s_denom, s_attenLevel;

        l_numer = (s_toneIdx - s_leftToneIdx) * (s_rightToneAttenLevel - s_leftToneAttenLevel);
        s_denom = (s_rightToneIdx - s_leftToneIdx);

        s_attenLevel = s_leftToneAttenLevel;
        if (s_denom)    // assure we have a non-zero divisor
        {
                if (l_numer > 0)
                {
                        s_attenLevel += (int16)NormAndDivide_32by16bit_with_rnd(l_numer, s_denom);
                }
                else
                {
                        s_attenLevel -= (int16)NormAndDivide_32by16bit_with_rnd(-l_numer, s_denom);
                }
        }

        return(s_attenLevel);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : NormAndDivide_32by16bit_with_rnd
 *
 *  Description:  This function performs the division of a 32-bit numerator by a 16-bit denominator,
 *  and then rounds the result to 16-bit interger.
 *      In equation:
 *              return = (int32)(l_numer/s_denom)
 *
 *  Prototype:
 *          int32 NormAndDivide_32by16bit(int32 l_numer, int16 s_denom)
 *
 *  Input Arguments:
 *      l_numer -- 32-bit numerator
 *              s_denom -- 16-bit denominator
 *
 *
 *  Output Arguments:
 *
 *
 *      Return:
 *              16-bit division result
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int32 NormAndDivide_32by16bit_with_rnd(int32 l_numer, int16 s_denom)
{
        int16 s_quot, s_quot_exp;
        int32 l_quot;

        NormAndDivideMantExp_32by16bit(l_numer, s_denom, &s_quot, &s_quot_exp);

        if(s_quot_exp < 0)
                l_quot = round((int32) s_quot, (int16) (-s_quot_exp));
        else
                l_quot = (int32)s_quot << s_quot_exp;

        return(l_quot);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : NormAndDivideMantExp_32by16bit
 *
 *  Description:  This function performs the division of a 32-bit numerator by a 16-bit denominator,
 *  and the result is represented by a mantissa, s_mant, and exponent, s_exp.
 *      Both numerator and denominator are first normalized before division.
 *      In equation:
 *              s_mant*(2^s_exp) = (l_numer/s_denom)
 *
 *  Prototype:
 *          void NormAndDivideMantExp_32by16bit(int32 l_numer, int16 s_denom, int16 *ps_mant, int16 *ps_exp)
 *
 *  Input Arguments:
 *      l_numer -- 32-bit numerator
 *              s_denom -- 16-bit denominator
 *
 *  Output Arguments:
 *              ps_mant -- pointer to the mantissa of quotient
 *              ps_exp -- pointer to the exponent of quotient
 *
 *      Return:
 *
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void NormAndDivideMantExp_32by16bit(int32 l_numer, int16 s_denom, int16 *ps_mant, int16 *ps_exp)
{
        int16 s_num_exp, s_den_exp, s_quot_exp;
        int16 s_quot;

        s_num_exp = norm_l(l_numer);
        l_numer <<= s_num_exp;
        s_num_exp = -s_num_exp;

        s_den_exp = norm_l((int32)s_denom);
        s_den_exp -= 16;
        s_denom <<= s_den_exp;
        s_den_exp = -s_den_exp;

        Divide_32by16bit(l_numer, s_num_exp, s_denom, s_den_exp, &s_quot, &s_quot_exp);

        *ps_mant = s_quot;
        *ps_exp = s_quot_exp;

}
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)


/* undefine constants used by this file only */
#undef SNR_SIG_MANT
#undef SNR_SIG_EXP
#undef SNR_NOISE_SCALE_MANT
#undef SNR_NOISE_SCALE_EXP
#undef  LOG2X_C_EXP
#undef LOG2X_C0_MANT
#undef LOG2X_C1_MANT
#undef LOG2X_C2_MANT
