/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2010 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   train_reinimmunity.C
*
*   functions protects REIN during training
*
*-------------------------------------------------------------------------
*/
// ************************************************************************
// train_reinimmunity.c
//
// History
// 04/06/2012 Shakil: New feature implemented where we detect REIN noise at training and change framing
//          accordingly taking erasure decoding into account to increase stability in presence of REIN
//          even if the minINP exchanged during GSK was not enough to sustain the REIN. The background
//          of this feature was a test requirement from FT EMC lab at Laneon where the minINP and maxdelay
//          configured was 2 and 16ms respectively whereas REIN in the line was 4-5 DMT symbol duration.
//          In the regular condition considering erasure we may protect maximum 3 DMT symbol REIN therefore
//          resulting huge DS CRCs and link drop. With the new feature we could dynamically detect REIN at
//          CSilent1 state during handshake and increase the INP taking erasure into account while cap the
//          delay maximum to 8 ms and achieved CRC free stable link without sacrifising too much data rate
//          since we also ignore REIN affected symbols before bitloading and medley SNR calculation.There are
//          two parts of the implmentation
//          1. Detect REIN during GSK and adapt framing  prior to bitloading at Medley. It is controlled by
//                INFO 103 28 bitmask 0x200 and disabled by default (bitmask 0x200-> 0 disabled, 1 enabled)
//          2. Ignore REIN affected symbols for bitloading: No CMV controlled. Enabled by default
//          Grep for XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING
//
// ******************************************************************
#include "common.h"
#include "const.h"
#include "rx_ops.h"
#include "tx_ops.h"
#include "noiseacc.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "snr.h"
#include "bitload2.h"
#include <string.h>
#include "cmv.h"
#include "find_sintbl.h"
#include "dsp_op.h"
#include "pll.h"
#include "rcmedley_Data.h"
#include "fifo.h"
#include "med2rev.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "RCMedleyRxF_Bitload_bis.h"
#include "states.h"
#include "RMedleyTxF_bis.h"
#include "RCMedleyRxF_Bitload.h"
#include "memsetbf.h"
#include "memcopy.h"
#include "BGChooseRevSegBin.h"
#include "fdq_adap.h"
#include "dsp_op2.h"
#include "platform.h"
#include "exchdata.h"
#include "decimalgain.h"

//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
#ifdef TARGET_HW
    #include "aux_regs.h"
    #ifdef DANUBE
    #include "dataswap.h"
    #define DO_PILOT_ROT   1
    #endif
#endif
#include "arctan.h"
#include "train_reinimmunity.h"

#ifdef DEBUG_IMP_DETECT
#undef DEBUG_IMP_DETECT
#endif

C_SCOPE void XDump( int16 *psa_indTones, int16 s_NumIndTones)
{
   int32 *p = pl_XDumpAddr;
   int16 n = s_NumIndTones;
   int32 d,i;
   if (n & 1) n++ ; // incr odd
   for( i=0 ; i< n ; i+=2 ){
      d = *psa_indTones++;
      d |= (*psa_indTones++)<<16;
      *p = d;
      if (p < pl_XDumpEnd) p++;
   }
   pl_XDumpAddr = p;
}




/********************************************************************************************
;  Subroutine Name: iMetricSort
;
;  Description:
;     Keeps track of N largest values out of the values passed to it.
;
;  Prototype:
;  int32 iMetricSort( int16 indMetric , int16 s_mode ) ;
;
;  Input Arguments:
;     indMetric  -- value to be sorted, or in mode 2 it is number of highest values to add up.
;     s_mode      -- control to : reset
;                          sort the input.
                           get final values.

;
;  Output Arguments:
;
;
;  Return Value:
;     Meaningful whem mode = 2. It returns the subtotal of N largest values.
;
;  Global Variables:
;     gsa_indMax[MAX_IMP_WIDTH] ; buffer for keeping track of largest values.
      gl_ind_metric_acc  buffer for keeping track of total.
;
;****************************************************************************/
C_SCOPE int32 iMetricSort( int16 indMetric , int16 s_mode )
{
   int i,j=0;
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#ifndef ADSL_62
    int16 s_N;
   switch (s_mode)
    {
      case INITIALIZE_METRIC_SORT:
         for ( i = 0; i < MAX_IMP_WIDTH; i++ )
                gsa_indMax[i]= 0;
         gl_ind_metric_acc =0;

            break;

      case RUN_METRIC_SORT:
         j= -1;
         //Check if new value is in 4 highest values.
         for (  i = 0; (j<0) && (i < MAX_IMP_WIDTH); i++ )
         {
            if (indMetric > gsa_indMax[i])  j=i;
         }
         // if the new value is in highest group then shift down lower 'maximums' and add to list.
         if (j>= 0)
         {
            for ( i = MAX_IMP_WIDTH-1; i >j; i-- )
               gsa_indMax[i]=gsa_indMax[i-1];

            gsa_indMax[j]= indMetric ;
         }
         gl_ind_metric_acc += indMetric;

         break;

      case DONE_METRIC_SORT:
         j =0;
         s_N = indMetric;
         if (s_N < 2) s_N = 2;
         if (s_N > MAX_IMP_WIDTH)  s_N = MAX_IMP_WIDTH;

         // Subtotal largest N samples.
         for (i=0 ; i< s_N ; i++ )
            j += gsa_indMax[i];

         j = gl_ind_metric_acc - j; //return accumulation less the largest N values.
         break;
    }
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#endif //ADSL_62
   return(j);
}
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: chooseImpNoiseTones
 *
 *  Description:
 *    chooseImpNoiseTones() finds a set of tones for impulse noise indication.
 *    .
 *
 *  Prototype: void chooseImpNoiseTones(int16 *sa_RxTone);
 *
 *  Input Arguments: sa_RxTone (RxToneBuf)
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *
 *  int16 gs_chooseStep
 *  int16 gs_NumIndTones
 *  int16 gsa_indTones[8];
 *
 *  Notes: implements state RC-MEDLEY
 *
 *-------------------------------------------------------------------
 *^^^
 */
C_SCOPE void  chooseImpNoiseTones(int16 *sa_RxTone)
{
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#ifndef ADSL_62
      int16 s_maxsnr=0, s_limit;
      int32 i, l_maxtone = 0;
      int32 l_uppertone = 0;

      //check tones across the band
      for (i=0; i< gs_RxNumTones ; i++)
      {
            // Find the tone l_maxtone, with the maximum snr
         if (sa_RxTone[i] > s_maxsnr)
            {
                s_maxsnr  = sa_RxTone[i];
            l_maxtone = i;
            }
            // upper tone is set as the last tone, whose snr is  within 4dB of the maximum snr.
         if (sa_RxTone[i] >= s_maxsnr - 0x400 )
            l_uppertone = i;
      }

      // set default indicator tones to be tones adjacent to maximum tone.
      for (i=0; i<gs_NumIndTones; i++)
        {
         gsa_indTones[i]= l_maxtone + i;
      }

      // if range between max snr and highest 'good' one that is small just go with adjacent tones.
        // YC: probably because if the difference is too small, there is very limited freedom to pick tones
      if (l_uppertone - l_maxtone <  8 ) return;

      // Else look for spread out tones with good snrs.
      i = l_maxtone;
      s_limit = sa_RxTone[l_maxtone] - 0x300 ;
      {
            int   count=1,  step = gs_chooseStep ;
         int offset = step/2;
         do
         {
            i = i + step;
            if (sa_RxTone[i] > s_limit) gsa_indTones[count++]=i;
            else if  (sa_RxTone[i+1] > s_limit) gsa_indTones[count++]=i+1;    // deal with parr

            if (i > l_uppertone)
                {
               s_limit -= 0x0100;
               i = l_maxtone + offset;
               offset = (offset+1) / 2;
               if (s_limit < sa_RxTone[l_maxtone] - 0x800) break; // to eliminate the small chance of an infinite loop.
            }
         } while (count< gs_NumIndTones) ;
      }
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#endif //ADSL_62
 }



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: impulseCheckMedley1
 *
 *  Description:
 *    impulseCheckMedley1() finds
 *      (mode = 1). average recieved indication tone valuee (real and imag ) prior to FDQ im Medley.
 *    (mode = 2). calculated the metric for each received PMD frame (accumulation over indication tones)
 *
 *  Prototype: void impulseCheckMedley1( int16 *sa_RxTone, int16 *sa_tones, int16 s_numTones, int16 s_alphaExp ,int16 mode);
 *
 *  Input Arguments:
 *
 *  mode : 0: initalization,
 *         1: moving average to calculate the average noise amplitude,
 *         2: calculate the metric for each DMT symbol
 *  Output Arguments: metric thre
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *
 *  int16 gs_chooseStep
 *  int16 gs_NumIndTones
 *  int16 gsa_indTones[8];
 *
 *  Notes: implements state RC-MEDLEY
 *   impulseCheckMedley1(gsa_RxToneBuf,gsa_indTones, gs_NumIndTones , 3, gs_mode );
 *-------------------------------------------------------------------
 *^^^
 */
C_SCOPE int32 impulseCheckMedley1( int16 *sa_RxTone , int16 *sa_tones, int16 s_numTones, int16 s_alphaExp ,int16 mode)
{
    int e1,e2,indTone;
    int i,j,l_Metric =0;
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#ifndef ADSL_62
    int16 x,y,xMean ,xLimit;

    for (i=0 ; i < s_numTones ; i++)
    {

      indTone=2*sa_tones[i];

      // 1. Rotate received point to quadrant 1.
      if ((sa_RxTone[indTone] >= 0) && (sa_RxTone[indTone+1]<0))
        {  // Q2
         x = -sa_RxTone[indTone+1];
         y = sa_RxTone[indTone];
        }
      else if ((sa_RxTone[indTone]<0) && (sa_RxTone[indTone+1]<0))
        {  //Q3
         x = -sa_RxTone[indTone];
         y = -sa_RxTone[indTone+1];
      }
      else if ((sa_RxTone[indTone]<0) && (sa_RxTone[indTone+1] >= 0))
        {
         x =  sa_RxTone[indTone+1];
         y = -sa_RxTone[indTone];
      }
      else
      {
         x = sa_RxTone[indTone];
         y = sa_RxTone[indTone+1];
      }
#ifdef DEBUG_IMP_DETECT
        if (i== iWatch)
        {
         gsa_ReverbSnrBuf[4*gs_TrainCnt+0] = sa_RxTone[indTone];
         gsa_ReverbSnrBuf[4*gs_TrainCnt+1] = sa_RxTone[indTone+1];
         gsa_ReverbSnrBuf[4*gs_TrainCnt+2] = x;
         gsa_ReverbSnrBuf[4*gs_TrainCnt+3] = y;
      }
#endif

      //2.0 Initialize Avg with first sample.
      if (mode == 0)
        {
         gsa_RxToneAvg[2*i] = x;
         gsa_RxToneAvg[2*i+1] = y;
      }

      //2.1 Accumulate average with 'limited' input
      else if (mode == 1)
      {
         for (j=0;j<2;j++) // j=0 for real part accumulation and j=1 for imag part
             {
            xMean = gsa_RxToneAvg[2*i+j] ;
            xLimit = xMean >> xLimScale;
            if (xLimit < 128) xLimit = 128;
            if ( x > xMean + xLimit ) x = xMean + xLimit;
            if ( x < xMean - xLimit ) x = xMean - xLimit;

            gsa_RxToneAvg[2*i+j] += ((x - xMean) >> s_alphaExp) ; //leaky bucket average t=8.
            x = y ; //for 2nd time through.
         }
#ifdef DEBUG_IMP_DETECT
         gsa_ReverbEchoSnrBuf[2*gs_TrainCnt+0] = gsa_RxToneAvg[2*i];
         gsa_ReverbEchoSnrBuf[2*gs_TrainCnt+1] = gsa_RxToneAvg[2*i+1];
#endif
      }

      // 2.2 Calculate difference from average for each tone and sum.
      else if (mode == 2)
      {
         e1 = gsa_RxToneAvg[2*i] - x ;
         e2 = gsa_RxToneAvg[2*i+1] - y ;

         //e1= approx abs(e1+je2)
         if (e1<0) e1=-e1;
         if (e2<0) e2=-e2;

         if (e1>e2)
            e1 = (3 * e2)/8 + e1;
         else
            e1 = (e1 * 3)/8 + e2;

         l_Metric += e1;
      }
   }     //for
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#endif //ADSL_62

   return(l_Metric);
}

/* find tones to determine impulse on */



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: impulseCheck
 *
 *  Description:
 *    impulseCheck() finds (during snr accumulation)
 *    (mode = 2). calculated the metric for each received PMD frame (accumulation over indication tones)
 *
 *  Prototype: void impulseCheck( int16 *sa_RxTone, int16 *sa_tones, int16 s_numTones, int16 s_alphaExp ,int16 mode);
 *
 *  Input Arguments:
 *
 *  Output Arguments: metric thre
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *
 *  int16 gs_chooseStep
 *  int16 gs_NumIndTones
 *  int16 gsa_indTones[8];
 *
 *  Notes: implements state RC-MEDLEY
 *   impulseCheckMedley1(gsa_RxToneBuf,gsa_indTones, gs_NumIndTones , 3, gs_mode );
 *-------------------------------------------------------------------
 *^^^
 */
C_SCOPE int32 impulseCheck( int16 *sa_RxTone , int16 *sa_tones, int16 s_numTones)
{
    int e1,e2,indTone;
   int i,l_Metric =0;
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#ifndef ADSL_62
   for (i=0  ; i < s_numTones ; i++)
    {
      indTone=2*sa_tones[i];
        if (sa_RxTone[indTone]<0)
            e1= sa_RxTone[indTone]+8192;
         else
         e1= sa_RxTone[indTone]-8192;

      if (sa_RxTone[indTone+1]<0)
         e2= sa_RxTone[indTone+1]+8192;
      else
         e2= sa_RxTone[indTone+1]-8192;

         //e1= approx abs(e1+je2)
      if (e1<0) e1=-e1;
      if (e2<0) e2=-e2;

        if (e1>e2)
         e1 = (3 * e2)/8 + e1;
      else
         e1 = (e1 * 3)/8 + e2;

      l_Metric += e1;
   }//for
   l_Metric = l_Metric /4;

    if (l_Metric > 0x7fff ) l_Metric = 0x7fff;
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End)
//#endif //ADSL_62
   return(l_Metric);
}

