/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: aoc_rx_ini.c
;
;  This file contains functions for initializing aoc data structures
;
;***************************************************************************/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "const.h"

/*****************************************************************************
;  Subroutine Name: RxAocInit(...)
;
;  This subroutine initializes variables used by the AOC RX functions.
;
;  Prototype:
;     void RxAocInit(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;   Global Variables:
;
;  gt_RxAocHander -- RX AOC handler structure with the following variables initialized:
;     uc_outstanding_msg_count -- (O) RX outputstanding message count
;
;  gt_RxMsgUTC    -- UTC message structure with the following variables initialized:
;     uc_msg_length     -- (O) message length
;     uca_msg_body[]    -- (O) packed message data
;
;  gt_RxAocDecod  -- RX message decoder structure with the following variables initialized:
;     uc_new_msg_flag      -- (O) flag indicating the expected message type (new or continue)
;     uc_msg_byte_cnt      -- (O) curent byte count in message buffer
;     uc_stuffing_byte_cnt -- (O) consecutive number of stuffing byte count
;
*******************************************************************************/
void RxAocInit(void)
{

    gt_RxAocHandler.uc_outstanding_msg_count = 0;

    /* Form a UTC message */
    /* set message length */
    gt_RxMsgUTC.uc_msg_length = (uint8)AOC_MSG_UTC_LEN;

    /* set message body */
    gt_RxMsgUTC.uca_msg_body[0] = (uint8)AOC_HEADER_UTC;

    /* set message identifier */
    gt_RxMsgUTC.uc_msg_id = AOC_MSG_ID_UTC;

#ifdef INCLUDE_FASTRETRAIN_CODE
    if (((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) == 0) && ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C) == 0) )
    { /* Do this portion only if G992_1 */
#endif

        gft_TxBitSwapFlag = FALSE;
        gft_RxBitSwapFlag = FALSE;
        gft_SendAocMsg_Flag = IDLE;

#ifdef INCLUDE_FASTRETRAIN_CODE
    }
#endif

    /* Initialize AOC Rx decoder */
    gpuc_AOCRxPutPtr = gpuc_AOCRxGetPtr = guca_AOCRxBuffer;
    gs_AOCRxDecoderState = AOC_SEARCH_FOR_MESSAGE;

    // clean the AOCMsgBuffer for the next msg
    memset(guca_AOCRxBuffer, 0, (AOC_MAX_MSG_LENGTH*AOC_MSG_REPEAT_CNT+1));

}
