/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: aoc_tx_ini.c
;
;  This file contains functions for initializing aoc data structures
;
;***************************************************************************/
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "const.h"

/*****************************************************************************
;  Subroutine Name: TxAocInit(...)
;
;  This subroutine initializes variables used by the AOC TX functions.
;
;  Prototype:
;     void TxAocInit(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables:
;
;  gt_TxAocHander          -- (O) the structure containing the following variables:
;     uc_msg_repeat_count        -- sending message repeat count
;     uc_stuffing_byte_count     -- sending stuffing byte count
;     uc_tx_outstanding_msg_count   -- TX outputstanding message count
;     uc_tx_nonoutstanding_msg_count   -- TX nonoutstanding message count
;     gs_pre_frame_number        -- (O) previous frame number
;
*******************************************************************************/
#define uc_msg_repeat_count         gt_TxAocHandler.uc_msg_repeat_count
#define uc_next_byte          gt_TxAocHandler.uc_next_byte
#define uc_stuffing_byte_count      gt_TxAocHandler.uc_stuffing_byte_count
#define uc_tx_outstanding_msg_count gt_TxAocHandler.uc_outstanding_msg_count
#define uc_tx_nonoutstanding_msg_count gt_TxAocHandler.uc_nonoutstanding_msg_count
#define uca_AOC_outbuf           gt_TxAocHandler.uca_AOC_outbuf
#define pt_tx_nonoutstanding_msg    gt_TxAocHandler.pt_nonoutstanding_msg
#define pt_tx_outstanding_msg       gt_TxAocHandler.pt_outstanding_msg

void TxAocInit(void)
{
   uc_msg_repeat_count        = 0;
   uc_stuffing_byte_count     = 0;
   uc_tx_outstanding_msg_count = 0;
   uc_tx_nonoutstanding_msg_count   = 0;
   gs_pre_frame_number        = -1;

   /* initialize the Tx AOC fifo */
   gt_TxAocFifo.MessageBuffer = &gus_TxAocBuffer[0];
   gt_TxAocFifo.BufferSize = TXAOCBUFFER_SIZE;
   gt_TxAocFifo.IndexOfOldest = 0;
   gt_TxAocFifo.NextAvailable = 0;
   gt_TxAocFifo.PendingMessageCount = 0;
   gt_TxAocFifo.ErrorCode = 0;
   gt_TxAocFifo.us_OvflowCnt = 0;
}

#undef uc_msg_repeat_count
#undef uc_next_byte
#undef uc_stuffing_byte_count
#undef uc_tx_outstanding_msg_count
#undef uc_tx_nonoutstanding_msg_count
#undef uca_AOC_outbuf
#undef pt_tx_nonoutstanding_msg
#undef pt_tx_outstanding_msg

