/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2002 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       cnfg_task.c
*
*       Configure Task Layer
*
*-------------------------------------------------------------------
*/
// ******************************************************************
// cnfg_task.c
//
// History
//
// 16/04/2010 Nihar: Workaround for false configuration of VINAX 10.6 based SAG5630 DSLAM
//                    In DTAG lab SAG5630 shows very low DS rate because of CO-requested -16dB nomPSD
//                    Grep for IOP_DS_ALL_VINAX_ClearNomPSDRequirement
//
//
// 20/08/2010  Sriram Shastry:  Some BRCM COs prefer AnnexL
//                       in mid loops which causes failing test requirements
//                       due to low US rates. We retrain at this loop range,
//                       around 8kft to 15kft, and disable AnnexL so that
//                       ADSL2+ will be selected. The flag to control this
//                       feature is initialized to 0.
//                      Grep for SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 27/07/2010 Nihar/Bhadra: Send TI (TSTC) vendor-id along with TI's non-standard information
//                   when connecting against TI-AC7 and send Aware (AWRE) vend-id when
//                   connecting against CNXT in ADSL2/2+ mode after a reboot for better US performance.
//                   Grep for IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid
//
// 19/08/2010 AdeelJ/Palaksh/Veena: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               initializing fix enable flag to 0.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 20/08/2010  Sriram Shastry. Initialize the flag and counter for CNXT D57 short loop
//                       Tx power cut
//                       Grep for SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut
//
// 20/08/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is one (enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// 08/07/2010 Nihar: Added code to increase DS performance with TI in DMT mode on short loops with strong noise
//                  Use US-PCB starting from G.Hs to reduce DS-PCB
//             grep for IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 9/09/2011 Anantha Ramu: Added feature to try GHS MAX_ALLOWED_GHS_FAILS times before trying T1413
//                         if T1413 is one of the configured modes in CPE.
//                         Grep for  XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//
// 17/11/11 ChihWen/Bhadra: SRA fail against CNXT Annex-A LC (FW E67.1.64). To fix it,
//                => send GHS non-standard info in CLR as AR7 (FW 7.04.03) when against CNXT Annex-A LC.
//                => do not send spectrum bound/shaping when against CNXT Annex-A LC
//             By default, its disabled. To enable it, cw INFO 103 1 0x4000
//             Grep for SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard
// 02/01/2012 Kannan: 25/08/2008 Sabrina Y: Initialize the flag, gft_T1413_ACK_boost, to 1.
//                       In T1413 mode, R-ACK power level is boosted by 6 dB by default since some IFX
//                       CO has problem in detecting R-ACK at long loops with high noise. However,
//                       some STM COs are sensitive to this signal power and fail to detect R-Reverb1.
//                       So we have to toggle the level till C-Pilot1 off is detected.
//                       grep for SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong
//
// 23/12/2011 Sabrina Y/Balabath : To improve US performance, retrain and switch to Aware VID
//            for IKNS DSLAMs.
//            Grep for XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE
//
// 12/01/2012 Kannan: Added code to emulate 64pt IFFT for CNXT and TI 4000C
//            in T1.413 to get the same performance as G.dmt.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on...).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on...).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 08/02/2012:US rates are very low (~400kbps) upto 2km with Ikanos ISAM NVLT-C in T1413 mode.
//            This appears to be Ikanos TEQ problems. Problems were seen even after merging
//            XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement. Options
//            analogcutback,64 tone FFT etc., didn't help. VendorID change to TI resolves this.
//            And also clear the variable "gft_NVLTC_T1413_fix" in persistent memory.
//       For code changes Grep for XDSLRTFW-414 Enh_US_T1413_TIVID_Switch
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline. Use Annex-B filters in oISDN binary.
//          Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Grep for XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
// 29/08/2013 Prashant: Merged the fix for XDSLRTFW-772.
// Author of code changes: Hanyu
//    Added code to workaround CO tone detection issue on ECI M41 Vinax DSLAM in Annex B by boosting Tx power level:
//    (1) Boosting 4dB Tx tone power in G.hs when it fails at R_C_GALF1_RX state for loops > 3.5km with PAG setting > 0x1A00dB.
//    (2) Restoring it back to the original power level after G.hs for ADSL2/2+ and ADSL1.
//    (3) Fine-tuned the workaround code (ADSLRTFW-1253) to boost training Tx signal power level by 1.5dB on loops > 3.7km and
//        by 2.5dB on loops > 3.9km when previous exception code is E_CODE_GHS_TONE_LOSS_OR_TIME_OUT or E_CODE_RCReverb3Rx_bis_SignalEnd_Failure.
//    (4) Calibrated the loop length estimation based on the PGA setting in R_C_GALF1_RX state.
//        Above changes are not controlled by CMV bit on DTAG FW branch. Suggest adding a new CMV bit in mainline code to narrow down side effect.
//        Grep for  XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower
//
// 08/04/2013 ChihWen:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                2. Combine the framing check in isValidFramingConfiguration and RShowtimeRxF_BIS. The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                3. Optimize the CMV setting related to SRA.
//                4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
//
//22/11/2013 Sooraj Govindan : To reduce the size of PERSISTENT_MEM block by 512 bytes, moved guca_QLN[] from PERSISTENT_MEM to BULK_DATA_RAM block.
//                   This helps in reducing memory requirements needed in VDSL mode, to support PERSISTENT memory of ADSL mode. (XDSLRTFW-441)
//
// 24/03/14 Hanyu: Ported ADSLRTFW-745 (SMS00778928): Retrain for CTLM VID so that we can send the TI VID
//                 Grep for: XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID
//
//
//  30/3/2015 Sriram Shastry:Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//  Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//    Grep for  XDSLRTFW-1843
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
// ******************************************************************

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "cmv.h"
#include "mp.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "load_prf.h"
#include "ec_data.h"
#include "act_T1413.h"
#include "states.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "RQuietTxF_bis.h"
#include "RCQuietRxF_bis.h"
#include "RQuiet2TxF.h"
#include "RCQuiet2RxF.h"
#include "preshow.h"
#include "RRecovTxF.h"
#include "RCRecovRxF.h"
#include "showtime_bis.h"
#include "statein1.h"
#include "hndshk_Data.h"
#include "afe.h"
#include "pll.h"
#include "InitTDQfilter.h"
#include "memsetbf.h"
//#define ADSL_62_DEC_DEBUG
#ifdef ADSL_62_DEC_DEBUG
#include "REctTxF.h"
#include "RCPilot3Tref2RxF.h"
#endif

#ifdef INFINEON
#include "ghs.h"
#endif


#include "showinit.h"
#include "cnfg_task_utils.h"
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
#include "act_T1413.h"
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
#include "VRX_AfeCommonData.h"
#include "dsp_regs_62.h" //XDSLRTFW-3255 (Start_End)
#include "codeswap.h"


#ifndef TARGET_HW

FILE *Taps_infid=NULL;

#endif

#ifndef TARGET_HW
// Static functions.
static void ConfigBisHandshakeParameters(void);
#endif

#ifdef DANUBE
#ifdef RUN_ASIM
void UpdateSimextVars(void);
#endif
#endif   // #ifdef DANUBE

void EraseSRAMVarsAtLinkStart(void);
void CheckBARConfiguration(void); //XDSLRTFW-3255 (Start_End)


void ClearPersistentMemory(void)
{

   // HANDSHAKE PARAMETERS
   // Variables associated with CO identification.
#ifdef WORKAROUND_CTLM_VENDORID
   {
      uint32 ul_fe_ProviderID;
      ul_fe_ProviderID = (guca_fe_G9941_VendorID[2]<<24)|(guca_fe_G9941_VendorID[3]<<16)|(guca_fe_G9941_VendorID[4]<<8)|(guca_fe_G9941_VendorID[5]);      /*  Extract the provider code (Vendor ID, 4 octets), Workaround for CTLM vendor id*/

      // If CO provider ID recorded in last handshake session wasn't CENT, disable the
      if(gft_WorkAround_CTLM_chipset != 1)
      {
         gft_WorkAround_CTLM_chipset = 0;//Sriram : Clear the Persistant Memory variable, if CO is not CTLM //Sriram : Vendor ID addition
      }
      // XDSLRTFW-1843(Start)
      if(guc_IFTN_CRC_MISMATCH_ERR_cnt > CRC_MISMATCH_ERR_FAIL_COUNT)
      {
         guc_IFTN_CRC_MISMATCH_ERR_cnt = 0;
      }
      if(guc_IFTN_DMT_T1413_Train_Cnt > CRC_MISMATCH_ERR_FAIL_COUNT)
      {
         guc_IFTN_DMT_T1413_Train_Cnt  = 0;
      }
      // XDSLRTFW-1843(End)

   }
#endif
#ifdef ISDN
   uint32 ul_fe_ProviderID;
   ul_fe_ProviderID = (guca_fe_G9941_VendorID[2]<<24) |
   (guca_fe_G9941_VendorID[3]<<16) |
   (guca_fe_G9941_VendorID[4]<<8) |
   (guca_fe_G9941_VendorID[5]);

   // IOP_DS_ALL_VINAX_ClearNomPSDRequirement (Start)
   if ((ul_fe_ProviderID != GHS_IFTN_ID) ||
         (gs_Persis_PrevDSNomPSD <-200) ||
         (gs_Persis_PrevDSNomPSD >0) )
   {
      gs_Persis_PrevDSNomPSD = 1;
   }
   // IOP_DS_ALL_VINAX_ClearNomPSDRequirement (End)

   // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start)
   // If CO provider ID recorded in last handshake session wasn't TI or
   // US-PCB-value not in range [0dB..6dB] : clear GHsTxPCB
   if (((ul_fe_ProviderID != GHS_TI_ID) &&
            (ul_fe_ProviderID != GHS_TI4000C)) ||
         (gs_Persis_CurrGHsTxPCB < 0) ||
         (gs_Persis_CurrGHsTxPCB > 6))
   {
      gs_Persis_CurrGHsTxPCB = 0;     // no US-PCB in GHs
   }
   // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (End)
   // IOP_US_ALL_ADI930_AddNoiseToTxMedley (Start)
   if ((ul_fe_ProviderID != GHS_ADI_ID) ||
         (gs_Persis_CurrTxNoiseLevel < 0) ||
         (gs_Persis_CurrTxNoiseLevel > 1024))
   {
      gs_Persis_CurrTxNoiseLevel = 0;
   }
   // IOP_US_ALL_ADI930_AddNoiseToTxMedley (End)

   // IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
   // If CO provider ID recorded in last handshake session wasn't ADI (930/ANCD)
   // or US-PCB-value not in range [0dB..6dB] : clear ReverbTxPCB
   if ((ul_fe_ProviderID != GHS_ADI_ID) ||
         (gs_Persis_CurrReverbTxPCB < 0) ||
         (gs_Persis_CurrReverbTxPCB > 6))
   {
      gs_Persis_CurrReverbTxPCB  = 0;           // no US-PCB in Reverb
   }
   // IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (End)

   // IOP_DS_DMT_ADI_SendNcloadedEqualToZero  (Start)
   if ((ul_fe_ProviderID != GHS_ADI_ID) ||
         (gs_Persis_TargetSNRMrg < 0) ||
         (gs_Persis_TargetSNRMrg > 0x2000))
   {
      gs_Persis_TargetSNRMrg = 0x0600;
   }
   // IOP_DS_DMT_ADI_SendNcloadedEqualToZero  (End)

   // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START)
   // Boost G.hs Tx power by 6dB for ECI/M41/Vinax CO to detect R-TONE1 over 3.8km at DTAG
     if (gft_workaround_ECIM41_VNX > 1)
      gft_workaround_ECIM41_VNX = 0;
   // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (END)

#endif
   // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)

#ifndef ISDN   // Only for Annex-A
   {
      uint32 ul_fe_VendorID_Check;

      // Extract the provider code(Vendor ID,4 octets), workaround for TI?CNXT vendor ID
      ul_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) | (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

      //XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START)
      //SMS01560242 IOP_ALL_ALL_IKNS_LongTrainDuetoCrossTalkAtKPN (START_END)
      if (((ul_fe_VendorID_Check != GHS_IKNS_ID) && (ul_fe_VendorID_Check != 0))||
          (gft_WorkAround_IKNS_US_Perf > 1))
      {
         gft_WorkAround_IKNS_US_Perf = 0;
      }
      //XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (END)

      //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
      if (gft_USCRC_CTLM > 1)
   {
        gft_USCRC_CTLM = 0;
   }
     //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
      // If CO provider ID recorded in last handshake session wasn't TI/CNXT/CTLM, disable the
      // workaround.
      if ((ul_fe_VendorID_Check != GHS_TI_ID) || (gft_USPerf_AC7 > 1))
      gft_USPerf_AC7 = 0x0;

      if ((ul_fe_VendorID_Check != GHS_GSI_ID) || (gft_USPerf_CNXT > 1) ||
            (gft_DSPerf_CNXT > 1))
      {
         gft_USPerf_CNXT = 0x0;
         gft_DSPerf_CNXT = 0x0;
      }

      //ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (START)
      // if (gft_USPerf_Midloop_Gspn > 1)
      // gft_USPerf_Midloop_Gspn = 0;
      //ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (END)
      if (ul_fe_VendorID_Check != GHS_GSI_ID)
      {
         //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
         gft_USPerf_Intracom_Gspn = 0x0; // default off
         //ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_END)
         // gft_USPerf_Midloop_Gspn = 0x0;
         // SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard (Start_End)
         gft_SRAIop_CNXT = 0x0;
         // SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (START)
         gft_StartDMT_CNXT = 0x0;
      }


      //SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL (START)
      //Initialize the disable Annex L flag to 0

      if (gft_disableAnnexL > 1)
         gft_disableAnnexL = 0;

        //SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong (START_END)
        if (gft_T1413_ACK_boost > 1)
           gft_T1413_ACK_boost = 1;
      //PERF_US_T1413_T1&CNXT_64ptIFFT (START)
      //If the variable is corrupt, just clear it for stable state.
      if (gft_Enable_IFFT64_T1413 > 1)
         gft_Enable_IFFT64_T1413 = 0;
      //PERF_US_T1413_T1&CNXT_64ptIFFT (END)
      //XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (start)
      // Initialise gft_NVLTC_T1413_fix
      if (gft_NVLTC_T1413_fix > 1)
            gft_NVLTC_T1413_fix = FALSE;
      //XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (end)
   }
#endif // #ifndef ISDN

   // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (End)

   // Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
   // Clear the persistent memory variables when they take some random
   // values at reboot
   if (gus_ExceptionCode_Persis >=1000 | gus_ExceptionState_Persis >=500)
   {
      gus_ExceptionState_Persis = 0;
      gus_ExceptionCode_Persis = 0;
   }
   // Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)
   // XDSLRTFW-507 IOP_ALL_ALL_ALL_HNSHKT1413_LongTrain_HSStuck (Start)
   // Sriram : Added from Danube for Initialization purpose
#ifndef ISDN
   if (guc_Ghs_fails_count > (MAX_ALLOWED_GHS_FAILS+1))
      guc_Ghs_fails_count = 0;
   // SMS00903001 SMS00925438 IOP_A_ALL_ALL_GhsT1413_Satrtup (END)

   // Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)
   if (guc_T1413_relink_count > (MAX_ALLOWED_GHS_TRIES + 1))
      guc_T1413_relink_count = 0;
   // R3_P1: AR8_TF: IOP_ALL_ALL_ALL_T1413_Ghs_Activation_Fix (End)
   //if(guc_NoCommon_CL_CLR_Message_AnnexBitSet > 10)
      //guc_NoCommon_CL_CLR_Message_AnnexBitSet = 0;

#endif
// XDSLRTFW-507 IOP_ALL_ALL_ALL_HNSHKT1413_LongTrain_HSStuck (End)

   gs_CurrentCoVendorID = 0;
   gc_GhsDS_PCB = 0;
   // Bis Info for post handshake
#ifdef ENABLE_ALL_HDLC_OVHD
   memset(&gt_BisInfoSave, 0, sizeof(Adsl2AllInfo_t));
#endif
   // Flag indicating use of tones 1 to 32 in Annex B
   gft_Tones1To32Support = FALSE;

   // PMS variables
   memset(guca_DS_TransferMode_bis, 0, sizeof(uint8)*NUM_DS_BEARER_CHANNELS_SUPPORTED);
   memset(guca_US_TransferMode_bis, 0, sizeof(uint8)*NUM_US_BEARER_CHANNELS_SUPPORTED);
   memset(&gt_HandshakeBis, 0, sizeof(HandshakeBis_t));

   // PMD variables
   memset(&gt_TxPMDControl, 0, sizeof(PMDControl_t));

   // GHS Tssi breakpoints Info
   memset(&gt_GHS_DSTssiInfo, 0, sizeof(gt_GHS_DSTssiInfo));
   memset(&gt_GHS_USTssiInfo, 0, sizeof(gt_GHS_USTssiInfo));

   gt_GHS_DSTssiInfo.s_MaxNumBrkpt = MAX_NUM_DS_TSSI_VALUES;
   gt_GHS_USTssiInfo.s_MaxNumBrkpt = MAX_NUM_US_TSSI_VALUES;


   // TRAIN PARAMETERS
    //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Increase QLN points to 512
    // XDSLRTFW-441
    //memset(guca_QLN, 0, sizeof(uint8)*(RX_NUM_TONES));
   gl_HsPLLFreqOffset = 0;
   //Sriram BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
#ifndef ISDN
   MemSetBuffer((short *)(void *)&gt_RxCurrentSymbol_B43, 0, 0,
   NUM_CARRIERS_IN_SET * sizeof(Complex_t));
   MemSetBuffer((short *)(void *)&gt_RxLastSymbol_B43, 0, 0,
   NUM_CARRIERS_IN_SET * sizeof(Complex_t));
   MemSetBuffer((short *)(void *)&gta_RxSymbolBuf_B43, 0, 0,
   NUM_CARRIERS_IN_SET * RX_SYMBOL_BUF_SIZE * sizeof(Complex_t));
#endif
   // BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)
}

/*****************************************************************************
;  Prototype: int16 ConfigTaskLayerForInitialState(void)
;
;       This function can be used by any exec to configure the task layer for
;     a particular test type/initial state (G.hs, train, retrain, showtime).
;     Additional engine-specific and/or exec-specific configuration will
;     probably also be necessary.
;
;****************************************************************************/
#define INFINEON_CPE
//#ifdef TARGET_SIM //TODO : Bhadra code optimisation ( This code is not used in normal build)
int16 ConfigTaskLayerForInitialState(void)
{
   int16 i;
#ifdef ISDN
   int16 sa_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED] = {DEFAULT_G992_3B_PSDMASK, DEFAULT_G992_3J_PSDMASK, DEFAULT_G992_3M_PSDMASK};
   int16 sa_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED] = {DEFAULT_G992_5B_PSDMASK, DEFAULT_G992_5J_PSDMASK, DEFAULT_G992_5M_PSDMASK};
#else
   int16 sa_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED] = {DEFAULT_G992_3A_PSDMASK, DEFAULT_G992_3I_PSDMASK, DEFAULT_G992_3M_PSDMASK};
   int16 sa_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED] = {DEFAULT_G992_5A_PSDMASK, DEFAULT_G992_5I_PSDMASK, DEFAULT_G992_5M_PSDMASK};
#endif

   /****************************************************************************/
   /* We cannot truly multimode yet. Hence we set some firmware settings based */
   /* on specific modes that OPTNArray[OPTN_ModeControl] supports          */
   /****************************************************************************/
#ifdef ISDN /* Annex B/J */
   /* Digital and Analog filters to be used */

   /* Reconfig strymon s/w filter coefs for Annex B/J operation   */
   /* Use Annex-B filters in oISDN binary                          */
   /* Reconfigure them post-handshake again based on selected mode */


    //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
   // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
   // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
   // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
   // PSDs because of the reconfiguration of the tx-path after G.Hs
   // As Annex-J activation tones are currently not used in any field deployment the activation
   // tones and G.Hs filter configurations are hard-coded to Annex-B.
   // this part of the code is called only in LinkStartForTest.c
    Reconfig_STR_FW(ANNEX_B);
    //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)

   /* Reconfig AFE filters for Annex B/M/J operation */
   /* Specifically, AFE High pass filters */
   /* No reconfiguration required post-handshake given multi-mode between B/J/M */
          //CHECK_VRX518AFE
      //Initialize DFI with 17a configuration since,
      //both FFT & IFFT will be configured with 4K tones before G.hs
      /// In VRX318, DFE/DFI is configured for 17 a mode, But only AFE RX path configured for ADSL2 mode
      //With that change GHS loop reach increased by 500M. This type of change may not be possible on VRX518 because
      // DFE if configured for 17a means 288MSPS and AFE RX in ADSL means 144 MSPS NOT a valid configuration,

      {
         //Later if someone wants to try other than 17a before GHS
          gus_AFE_RxMode = ADSL2_CPE;
          gus_AFE_TxMode = ADSL2_CPE;
      }
      //Used below hybrid setting for handshake. when we change the hyb for HSK, then we have to update this variable gs_HybridGainRef
      //{ 0x0253,     0x063F,          0x0414,       0xF84F},  //  0   -7.6930   123  210     1600   145   1p   133   off   1p Null Loop
      //gs_HybridGainRef = (int16)  0xF84F;//   -7.6930  CHECK_VRX518AFE
      //AFED_ModeConfig();

      //Reconfig_AFE();
#else
   /* Reconfig of AFE tx HPF filters for Annex A/I/M operation is in after g.hs in rc_quiet1*/

#endif

   if (TESTArray[TEST_InitState] == TEST_GhsInitState)
   {
#ifndef ISDN
      if (OPTNArray[OPTN_ModeControl] == (int16)OPTN_ConfigMode_T1413) // T1413 bit is the only mode
#else
      if (OPTNArray[OPTN_ModeControl1] == (int16)OPTN_ConfigMode_ETSI_AnnexC) // T1413 bit is the only mode
#endif
      {
         /*  ATU-R initiates T1.413 session */
         gs_TxNextState = R_ACT_REQ_TX;
         gpF_TxStateFunc = (PtrToFunc)RActReqTxF;

         gs_RxNextState = R_C_ACT_RX;
         gpF_RxStateFunc = (PtrToFunc)RCActRxF;
      }
      else
      {
         /*  ATU-R initiates DMT G.hs session */
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;

         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

         // We delay the initialization of some G.HS BisInfo Tx members here
         // because those info are controlled via CMV. Therefore we have
         // to wait until all the CMVs have been processed
         /* Initialize Bis (ADSL2) Information in TxInfo */
         for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++)
         {
            gs_Preferred_PSDMask_G9923x[i] = sa_Preferred_PSDMask_G9923x[i];
            InitGlobalVariables2_BisInfoTx(gpt_TxInfo->pta_G9923xInfo[i], i);
            InitGlobalVariables2_BisInfoRx(gpt_RxInfo->pta_G9923xInfo[i], i);
         }
         for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++)
         {
            gs_Preferred_PSDMask_G9925x[i] = sa_Preferred_PSDMask_G9925x[i];
            InitGlobalVariables2_BisPlusInfoTx(gpt_TxInfo->pta_G9925xInfo[i], i);
            InitGlobalVariables2_BisPlusInfoRx(gpt_RxInfo->pta_G9925xInfo[i], i);
         }
      }
   }

   // On target HW we will always transition to the Ready state.
   STATArray[STAT_MacroState] = STAT_ReadyState;
   gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
   gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;

#ifndef TARGET_HW

   // If running a simulation we may need to change the macro state to something
   // other than the Ready state.

   switch (TESTArray[TEST_InitState])
   {

   case TEST_GhsInitState:
   case TEST_T1413InitState:
      STATArray[STAT_MacroState] = STAT_ReadyState;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;
      break;

   case TEST_TrainInitState:
      if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableDiagMode) !=0)
      {
         STATArray[STAT_MacroState] = STAT_LoopDiagMode;
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_LoopDiagMode;
         gusa_HercADSL_MONIMap_Curr[0] = MONI_DIAG_MODE;
      }
      else
      {
         STATArray[STAT_MacroState] = STAT_FullInitState;
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_FullInitState;
         gusa_HercADSL_MONIMap_Curr[0] = MONI_FULL_INIT;
      }
      break;
   case TEST_ShowtimeInitState:
      STATArray[STAT_MacroState] = STAT_ShowTimeState;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeState;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_NOSYNC;
      break;
   case TEST_RetrainInitState:
      STATArray[STAT_MacroState] = STAT_FastRetrainState;
      break;
   default:
      STATArray[STAT_MacroState] = STAT_ReadyState;
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;
      break;
   }

   /* GHS determines the mode if run -- otherwise we must specify here */

   if (TESTArray[TEST_InitState] != TEST_GhsInitState)
   {
      /* Set STAT CMV to indicate Lite mode if necessary */
      if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_2_AB) != 0)
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_2_AB;

      // BIS mode is not specified here because I found that it's already been
      // taken care of in other files. ----ysun

      if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_A) != 0)
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_5_A;

      if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_B) != 0)
      STATArray[STAT_Mode] |= STAT_ConfigMode_G992_5_B;

      SetInitialPgaToMax() ;
      SetTDQtoUnity();

      if (( gl_SelectedMode & (MODE_ADSL2)  ))
      {
         // Initialize DS spectral shaping information.  This normally sent by CO during G.hs.

         // Cocomo CO g.992.3A info:
         // # of breakpoints = 8
         int16 i, s_num_DS_Tssi_brkpt_kept = 8;
         uint16 usa_Rx_DS_Sample_Brk_Pt_Idx_Bis[8] = {4,20,30,33,100,128,140,255};
         uint8 uca_Rx_DS_Sample_Tssi2_Value_Bis[8] = {53,50,35,0,0,0,0,0};
         FlagT fta_Rx_DS_Sample_InSprtSet_Bis[1] = {0xF8}; //{0,0,0,1,1,1,1,1};

#ifdef HERCULES_ADSL_CPE
         int16 s_num_US_Tssi_brkpt_kept = 8;
         uint8 uca_Tx_US_Sample_Brk_Pt_Idx_Bis[8] = {1, 3, 5, 6, 31, 33, 44, 60};
         uint8 uca_Tx_US_Sample_Tssi2_Value_Bis[8] = {35, 34, 32, 0, 0, 34, 54, 62};
         FlagT fta_Tx_US_Sample_InSprtSet_Bis[1] = {0x18}; //{0, 0, 0, 1, 1, 0, 0, 0};
#endif // HERCULES_ADSL_CPE

         // Cocomo CO g.992.3L info:
         // Cocomo CO g.992.5A info:

         // Geminax Max g.992.3A info:
         // Geminax Max g.992.3L info:
         // Geminax Max g.992.5A info:
#ifdef INFINEON_CPE
         if (gl_SelectedMode & (MODE_G992_5))
         {
            s_num_DS_Tssi_brkpt_kept = 7;
            usa_Rx_DS_Sample_Brk_Pt_Idx_Bis[4] = 256;
            usa_Rx_DS_Sample_Brk_Pt_Idx_Bis[5] = 376;
            usa_Rx_DS_Sample_Brk_Pt_Idx_Bis[6] = 511;

            uca_Rx_DS_Sample_Tssi2_Value_Bis[5] = 20;
            uca_Rx_DS_Sample_Tssi2_Value_Bis[6] = 22;
            fta_Rx_DS_Sample_InSprtSet_Bis[0] = 0x78;
         }
#endif



         memset(&gt_GHS_DSTssiInfo, 0, sizeof(gt_GHS_DSTssiInfo));
         memset(&gt_GHS_USTssiInfo, 0, sizeof(gt_GHS_USTssiInfo));

         gt_GHS_DSTssiInfo.s_NumBrkptkept = s_num_DS_Tssi_brkpt_kept;
         for (i=0 ; i< s_num_DS_Tssi_brkpt_kept ; i++)
         {
            gt_GHS_DSTssiInfo.usa_Brkpt[i] = usa_Rx_DS_Sample_Brk_Pt_Idx_Bis[i];
            gt_GHS_DSTssiInfo.uca_Tssi[i] = uca_Rx_DS_Sample_Tssi2_Value_Bis[i];
            gt_GHS_DSTssiInfo.uca_Si[i>>3] = fta_Rx_DS_Sample_InSprtSet_Bis[i>>3];
         }
         //SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (START)
         //SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (START)
         if (gus_shortloop_cutpower > 12)
         gus_shortloop_cutpower = 0;
         if (gft_shortloop_cutpower_counter > 3)
         gft_shortloop_cutpower_counter = 0;
         //SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (END)
         //SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (END)


#ifdef HERCULES_ADSL_CPE
         gt_GHS_USTssiInfo.s_NumBrkptkept = s_num_US_Tssi_brkpt_kept;
         for (i=0 ; i< s_num_US_Tssi_brkpt_kept ; i++)
         {
            gt_GHS_USTssiInfo.uca_Brkpt[i] = uca_Tx_US_Sample_Brk_Pt_Idx_Bis[i];
            gt_GHS_USTssiInfo.uca_Tssi[i] = uca_Tx_US_Sample_Tssi2_Value_Bis[i];
            gt_GHS_USTssiInfo.uca_Si[i>>3] = fta_Tx_US_Sample_InSprtSet_Bis[i>>3];
         }
#endif // HERCULES_ADSL_CPE

      }
      // This is needed now for ADSL1, bc sa_DS_MaxNetDataRateBC[0] contains the programmable DMT rate cap
      ConfigBisHandshakeParameters();

   }


   if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
   {
      int16 i;

      // Pilot tone is unreliable for showtime-only simulations.
      gs_UpdateTimingRecoveryHWEnable = 0;


      if (!(( gl_SelectedMode & (MODE_ADSL2)  )))  /* DMT Mode */
      {
         InitGlobalVariables_DMT();
      }

      if (gl_SelectedMode & (ANNEX_B | ANNEX_J))
      gs_PilotToneIdx = C_PILOT_TONE_96;



      // Read TDQ, FDQ, and DEC parameters from a file.
      if(TESTArray[TEST_Control] & TEST_StryControl)
      {

         // Open parameter file.
         if (strcmp(Taps_Infile_Name,""))
         {

            if ((Taps_infid = fopen(SetInputDir(Taps_Infile_Name), "r")) == NULL)
            {
               fprintf(stdout, "Cannot open taps input file %s\n", SetInputDir(Taps_Infile_Name));
               return((int16) FAIL);
            }
         }

         // Read string from file.
         while(fscanf(Taps_infid,"%s",ca_prm) != EOF)
         {

            // Look for TDQ coefficient.
            if(!strncmp(ca_prm,"gsa_tdq_h",9))
            {

               fscanf(Taps_infid,"%*s");
               ca_prm[strlen(ca_prm)-1] = '\0';
               if(strlen(&ca_prm[10]) > 0)
               {

                  strncpy(ca_idx, &ca_prm[10], 4);
                  i = atoi(ca_idx);
                  if((i >= 0) && (i < gs_TDQLen))
                  fscanf(Taps_infid,"%hd",&(gsa_pre_tdq_h[i]));
               }
               else
               {
                  return((int16) FAIL);
               }
            }
            // Look for TDQ exponent.
            else if(!strncmp(ca_prm,"gs_tdq_h_exp",12))
            {

               fscanf(Taps_infid,"%*s");
               fscanf(Taps_infid,"%hd",&gs_pre_tdq_h_exp);
            }
            // Look for DEC coefficient.
            else if(!strncmp(ca_prm,"gsa_dec_h",9))
            {

               fscanf(Taps_infid,"%*s");
               ca_prm[strlen(ca_prm)-1] = '\0';
               if(strlen(&ca_prm[10]) > 0)
               {

                  strncpy(ca_idx, &ca_prm[10], 4);
                  i = atoi(ca_idx);
                  if((i >= 0) && (i < gs_DEC_ORDER))
                  {
                     fscanf(Taps_infid,"%hd",&(gsa_pre_dec_h[i]));
                  }
               }
               else
               {
                  return((int16) FAIL);
               }
            }
            // Look for DEC exponent.
            else if(!strncmp(ca_prm,"gs_dec_h_exp",12))
            {

               fscanf(Taps_infid,"%*s");
               fscanf(Taps_infid,"%hd",&gs_pre_dec_h_exp);
            }
            // Look for DEC delay.
            else if(!strncmp(ca_prm,"gs_dec_h_delay",14))
            {

               fscanf(Taps_infid,"%*s");
               fscanf(Taps_infid,"%hd",&gs_pre_dec_h_delay);
            }
            // Look for AEC coefficient.
            else if(!strncmp(ca_prm,"gsa_aec_h",9))
            {

               fscanf(Taps_infid,"%*s");
               ca_prm[strlen(ca_prm)-1] = '\0';
               if(strlen(&ca_prm[10]) > 0)
               {

                  strncpy(ca_idx, &ca_prm[10], 4);
                  i = atoi(ca_idx);
                  if((i >= 0) && (i < AEC_ORDER))
                  {
                     fscanf(Taps_infid,"%hd",&(gsa_pre_aec_h[i]));
                  }
               }
               else
               {
                  return((int16) FAIL);
               }
            }
            // Look for AEC exponent.
            else if(!strncmp(ca_prm,"gs_aec_h_exp",12))
            {

               fscanf(Taps_infid,"%*s");
               fscanf(Taps_infid,"%hd",&gs_pre_aec_h_exp);
            }
            // Look for AEC delay.
            else if(!strncmp(ca_prm,"gs_aec_h_delay",14))
            {

               fscanf(Taps_infid,"%*s");
               fscanf(Taps_infid,"%hd",&gs_pre_aec_h_delay);
            }
            // Look for FDQ coefficient.
            else if(!strncmp(ca_prm,"gsa_FDQ_coef",12))
            {

               fscanf(Taps_infid,"%*s");
               ca_prm[strlen(ca_prm)-1] = '\0';
               if(strlen(&ca_prm[13]) > 0)
               {

                  strncpy(ca_idx, &ca_prm[13], 4);
                  i = atoi(ca_idx);
                  if((i >= 0) && (i < gs_RxNumTones))
                  {

                     fscanf(Taps_infid,"%hd",&(gsa_pre_FDQ_coef[2*i]));
                     fscanf(Taps_infid,"%hd",&(gsa_pre_FDQ_coef[2*i+1]));
                  }
               }
               else
               {
                  return((int16) FAIL);
               }
            }
            // Look for FDQ exponent.
            else if(!strncmp(ca_prm,"gsa_FDQ_exp",11))
            {

               fscanf(Taps_infid,"%*s");
               ca_prm[strlen(ca_prm)-1] = '\0';
               if(strlen(&ca_prm[12]) > 0)
               {

                  strncpy(ca_idx, &ca_prm[12], 4);
                  i = atoi(ca_idx);
                  if((i >= 0) && (i < gs_RxNumTones))
                  fscanf(Taps_infid,"%hd",&(guca_pre_FDQ_exp[i]));
               }
               else
               {
                  return((int16) FAIL);
               }
            }
         }

         // Close parameter file.
         if(Taps_infid != NULL)
         fclose(Taps_infid);
      }



      //Initialize Config Structure
      InitConfigStruct();

      ConfigTaskForShowtimeInitState_BeforeTxRxInit();

      switch (gs_TxNextState)
      {
      case R_PRE_SHOWTIME_TX:
         gpF_TxStateFunc  = (PtrToFunc)RPreShowtimeTxF;
         gpF_RxStateFunc  = (PtrToFunc)RPreShowtimeRxF;
         break;

      case R_SHOWTIME_TX:
         if (gft_ModemType == G_DMT_BIS)  //BIS
         {
            gpF_TxStateFunc  = (PtrToFunc)RShowtimeTxF_BIS;
            gpF_RxStateFunc  = (PtrToFunc)RShowtimeRxF_BIS;
         }
         else
         {
            gpF_TxStateFunc  = (PtrToFunc)RShowtimeTxF_DMT;
            gpF_RxStateFunc  = (PtrToFunc)RShowtimeRxF_DMT;
         }
         break;

      default:
         return((int16)FAIL);
      }

      // InitShowTimeRx must be done prior to InitShowtTimeTx because
      // Tx init references Rx config to compute framing constraints on Lp.
      InitShowTimeRx();
      gs_num_preproc_frames = InitShowTimeTx();
      ConfigTaskForShowtimeInitState_AfterRxInit();   /* HAS to be called after InitShowTimeRx() */
   }

#ifdef INCLUDE_FASTRETRAIN_CODE
   else if (TESTArray[TEST_InitState] == TEST_RetrainInitState)
   {
      InitGlobalVariables_DMT();

      RxLoadProfile();
      TxLoadProfile();

      // set gs_TxNextState, gs_RxNextState becaue they are now removed from MP files
      gs_TxNextState = R_RECOV_TX;
      gs_RxNextState = R_C_RECOV_RX;

      gpF_TxStateFunc  = (PtrToFunc)RRecovTxF;
      gpF_RxStateFunc  = (PtrToFunc)RCRecovRxF;

   }
#endif

   else if (TESTArray[TEST_InitState] == TEST_TrainInitState)
   {

      if ( ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_A) != 0) || ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_B) != 0) || ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_A) != 0)) // BIS or plus bit is set
      {
#ifdef ADSL_62_DEC_DEBUG
         /*  ATU-R initiates BIS train session */
         gs_TxNextState = R_ECT_TX;
         gpF_TxStateFunc = (PtrToFunc)REctTxF;

         gs_RxNextState = R_C_TREF2_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCPilot3Tref2RxF;
#else
         /*  ATU-R initiates BIS train session */
         gs_TxNextState = R_QUIET1_TX_BIS;
         gpF_TxStateFunc = (PtrToFunc)RQuiet1TxF_BIS;

         gs_RxNextState = R_C_QUIET1_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCQuiet1RxF_BIS;

#endif
      }
      else   // DMT
      {

         /*  ATU-R initiates DMT train session */
         gs_TxNextState = R_QUIET2_TX;
         gpF_TxStateFunc = (PtrToFunc)RQuiet2TxF;

         gs_RxNextState = R_C_QUIET2_RX;
         gpF_RxStateFunc = (PtrToFunc)RCQuiet2RxF;

      }
   }
   else
   {
      return((int16)FAIL);
   }
#endif /* TARGET_HW */

   return((int16)SUCCEED);

}
//#endif //#ifdef TARGET_SIM
/*^^^
*-------------------------------------------------------------------
*
*  Prototype: int16 ConfigTaskLayerForLinkStart(void)
*
*   Description:
*
*     Initializes Task Layer variables, based on CMV settings,
*  at start of link initiation.  Currently this includes setting
*  the NextState variables based on the link mode (e.g. T1.413 vs.
*  DMT).
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
int16 ConfigTaskLayerForLinkStart(void)
{

   if(!(OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableShortInit)) /* If CPE does not support shortInit mode */
   {
      gl_SelectedMode = 0;
   }

   if (gl_SelectedMode == 0)
   {
      ClearPersistentMemory();
   }

   EraseSRAMVarsAtLinkStart();

   if (TESTArray[TEST_Control3] & TEST_FineGainDisable)
   gft_FineGainOn = FALSE;

   if (TESTArray[TEST_Control2] & TEST_DisableNomATP)
   gft_EnableNomATP = 0;  // disable nomATP

   if (TESTArray[TEST_Control2] & TEST_DisableSRCUpdates)
   gs_UpdateTimingRecoveryHWEnable = 0;

   if ((gft_FineGainOn) && (TESTArray[TEST_SETPLATINUMCOFINEGAIN] == 1))
   {
      gs_max_fine_gain = 384;
      gs_min_fine_gain = -384;
   }
   // XDSLRTFW-1843(Start)
   if(guc_IFTN_CRC_MISMATCH_ERR_cnt == CRC_MISMATCH_ERR_FAIL_COUNT)
   {
      if((OPTNArray[OPTN_ModeControl]& (OPTN_ConfigMode_G992_1_A | OPTN_ConfigMode_G992_1_B ))!=0 )   // Look for  ADSL1 is set in the XTSE  configuration
      {
         gul_ModeControl &= (STAT_ConfigMode_G992_1_ALL) ;  // Set only G.dmt
      }
   }
   // XDSLRTFW-1843(End)

   // This is not updated in showtime based on changes to the CMV.
   gt_DS_MeasurementPeriod.us_snr_measurement_period = (uint16)(1 << OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols]);
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
   if(TESTArray[TEST_GHS_LOG]&TEST_GHS_LOG_NotToGoFailState)
      gft_GotoFailStateOnTimeOut_FromHandshake = FALSE;

#ifndef ISDN
   if ((gus_Cnfg_Misc & CNFG_MISC_NON_STANDARD_HSK_MASK) && (gul_ModeControl & OPTN_ConfigMode_T1413))
   {
      if (gus_Cnfg_Misc & CNFG_MISC_NON_STANDARD_HSK_T1413_MASK)
      Activation_T1413_StateMachine();   //T1413 Activation
      else if (gul_ModeControl & ~(OPTN_ConfigMode_T1413))  //GHS Activation
      {
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc) RSilent0TxF;
         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
      }

   }
   else
#endif
   {
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
   #if 1
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
   #ifndef ISDN
      if (OPTNArray[OPTN_ModeControl] == (int16)OPTN_ConfigMode_T1413) // T1413 bit is the only mode
   #else
      if (OPTNArray[OPTN_ModeControl1] == (int16)OPTN_ConfigMode_ETSI_AnnexC) // T1413 bit is the only mode
   #endif
      {
         /*  ATU-R initiates T1.413 session */
         gs_TxNextState = R_ACT_REQ_TX;
         gpF_TxStateFunc = (PtrToFunc)RActReqTxF;

         gs_RxNextState = R_C_ACT_RX;
         gpF_RxStateFunc = (PtrToFunc)RCActRxF;
      }
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
   #endif
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
      else if (gl_SelectedMode & LINK_SHORTINIT) //original line
   //    if (gl_SelectedMode & LINK_SHORTINIT)
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
      {
         /*  ATU-R initiates short initialization session */
         gs_TxNextState = R_QUIET1_TX_BIS;
         gpF_TxStateFunc = (PtrToFunc)RQuiet1TxF_BIS;

         gs_RxNextState = R_C_QUIET1_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCQuiet1RxF_BIS;
      }
      else
      {
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
   #ifndef ISDN
         // SMS00903001 SMS00925438 IOP_A_ALL_ALL_GhsT1413_Satrtup (START)
         if ((guc_Ghs_fails_count >= (MAX_ALLOWED_GHS_FAILS)) &&
         (OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_T1413))
   #else
         if (OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_ETSI_AnnexC)
   #endif
         {
            /*  ATU-R initiates T1.413 session */
            //SMS00969485_HNSHK2_CS_PM2_OPT (start_End)
            Activation_T1413_StateMachine();
            #ifndef ISDN
            //XDSLRTFW-623 BugFix_T1413_Ghs_Xtalk_Activation_Stuck (START)
            // Reset the counter for the next G.hs/T1.413 activation
            guc_Ghs_fails_count = 0;
            //XDSLRTFW-623 BugFix_T1413_Ghs_Xtalk_Activation_Stuck (END)
            #endif
         }
         else
         {
   //                    Pause(0xBA01);
            // SMS00903001 SMS00925438 IOP_A_ALL_ALL_GhsT1413_Satrtup (END)
            /* ATU-R initiates G.hs session */
            gs_TxNextState = R_SILENT0_TX;
            gpF_TxStateFunc = (PtrToFunc) RSilent0TxF;
            gs_RxNextState = R_C_SILENT1_RX;
            gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
         }

      }
   //XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
   }
   /*****************************************PTM CHANGES**************************************/
//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
#if 0
#ifdef DANUBE_PTM_SUPPORT
   uint16 us_TpsTc;
   if(gt_INFX_CMV.us_PTM_Options_Indicated & SEL_TPS_TC)
   {
      switch (gt_INFX_CMV.us_PTM_Options_Indicated & TPS_TC_MASK)
      {

      case PTM_ONLY:
         us_TpsTc = TPSTC_TYPE_PTM;
         break;
      case PTM_ATM:
         us_TpsTc = TPSTC_TYPE_ATM | TPSTC_TYPE_PTM;
         break;
      default:
         us_TpsTc = TPSTC_TYPE_ATM;
         break;
      }


      CNFGMap[CNFG_TPS_TC_DS0][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_DS1][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_US0][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_US1][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_DS0_PLUS][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_DS1_PLUS][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_US0_PLUS][SCONTROL] = us_TpsTc;
      CNFGMap[CNFG_TPS_TC_US1_PLUS][SCONTROL] = us_TpsTc;

   }
#endif//if defined DANUBE_PTM_SUPPORT
#endif   // #if 0
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
   // XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
   // At Infineon's request, force Nlp =1 , i.e. disable dual latency.
   // See additional changes in DecodeCParams().
   gt_rx_config.s_Nlp = 1;
   gt_tx_config.s_Nlp = 1;

#ifdef WORKAROUND_CTLM_VENDORID
   if(gft_WorkAround_CTLM_chipset != 0 )
   {
      //If flag is set ,then send the AWRE vendor id
      guca_ne_G9941_VendorID[2] = 0x41;
      guca_ne_G9941_VendorID[3] = 0x57;
      guca_ne_G9941_VendorID[4] = 0x52;
      guca_ne_G9941_VendorID[5] = 0x45;
   }
#endif
#ifdef DANUBE
#ifdef RUN_ASIM
   // update modem-simext shared variable pointer table.
   // signal simext to init DLI
   // This function mainly write to some address locations
   // between 0x20000-0x2BFFFF (unused but legally belongs to
   // the ADSL cores space.
   UpdateSimextVars();
#endif
#endif   // #ifdef DANUBE
   // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)
#ifndef ISDN   // Only for Annex-A
   //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
   // Added the gft_USCRC_CTLM flag and condensed all the cases where we send TSTC to one statement
  if (
      (gft_USCRC_CTLM == 1) ||
   //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
         (gft_USPerf_AC7 == 1) || //If flag is set & in ADSL2/2+ ,then reboot and send the TSTC (TI) vendor id for better US Performance
         (gft_DSPerf_CNXT == 1) //If flag is set & in ADSL ,then reboot and send the TSTC (TI) vendor id for better DS Performance
         )
   {
      guca_ne_G9941_VendorID[2] = 'T'; //0x54
      guca_ne_G9941_VendorID[3] = 'S'; //0x53
      guca_ne_G9941_VendorID[4] = 'T'; //0x54
      guca_ne_G9941_VendorID[5] = 'C'; //0x43
   }
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START)
   if (gft_WorkAround_IKNS_US_Perf == 1)
   {
     // If flag is set ,then send the AWRE vendor id
     guca_ne_G9941_VendorID[2] = 0x41;
     guca_ne_G9941_VendorID[3] = 0x57;
     guca_ne_G9941_VendorID[4] = 0x52;
     guca_ne_G9941_VendorID[5] = 0x45;
   }
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (END)

#endif // #ifndef ISDN
   // AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (End)

#ifdef TARGET_HW
   if (OPTNArray[OPTN_AlgControl2] & OPTN_EnableDGasp)
   {
      gs_NE_LPR_indication = 0;
      gs_GPIO_PowerOn = GetGPIOBit(gt_Gpio.s_GPIO_DyingGasp_Pin); //Get the value of GPIO8
   }
#endif
   if (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_ONE_STEP_SRA)
      TESTArray[TEST_OLR_SRA_DeltaLpchange] = 0x7fff;

   return((int16)SUCCEED);
}

//XDSLRTFW-3255 (Start)
void CheckBARConfiguration(void)
{
   uint32 ul_BAR15, ul_BAR18;

   //API command to see the configured BAR values:
   //Port-0 or Single Line: cat /proc/driver/mei_cpe/meminfo/00
   //Port-1: cat /proc/driver/mei_cpe/meminfo/01

   ul_BAR15 = *(uint32 *)(DSP_XMEM_BAR15); //Points to SDRAM page containing DSL FW variables
   ul_BAR18 = *(uint32 *)(DSP_XMEM_BAR18); //Points to CHIPID_EFUSE registers

   if ((ul_BAR15 == 0) || ((ul_BAR18 & BAR_REGISTER_OFFSET) != BAR18_REGISTER_OFFSET))
   {
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_BAR_NOT_CONFIGURED;

      // Run Exception Handler sets FAIL state and triggers ME reboot, including showtime
      ExceptionHandler();
   }
}

void EraseSRAMVarsAtLinkStart(void)
{
   if (gus_DSL_FW_InternalControl & DSL_ERASE_SRAM_VARS)
   {
      memset(&__StartOfSramBAR15,0,(64*1024)); //Erase BAR-15 page, size of page = 64KB
   }
}
//XDSLRTFW-3255 (End)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void ConfigBisHandshakeParameters(void)
*
*   Description:
*
*     (For tests starting at g.992.3 initialization state only).
*  Initializes values used during initialization (by bitloading,etc.)
*  that would normally be determined from the Mode Select info from G.hs.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
#ifndef TARGET_HW
extern int16 gs_OneOverSminADSL2; // Saves 1/S value being used for bitloading
static void ConfigBisHandshakeParameters(void)
{
   gt_HandshakeBis.s_MinMSGDSOverheadRate = MIN_MSGOVERHEAD_DATARATE_DS;   /* DS min overhead data rate = x*1000bits/sec */
   gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[0] = 2*MAX_R_LP0_DS;           /* DS max check bytes for LP0 data path */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[1] = 2*MAX_R_LP1_DS;           /* DS max check bytes for LP1 data path */
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[0] = 1<<MAX_D_LP0_DS;          /* DS max interleave depth for LP0 data path */
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[1] = 1<<MAX_D_LP1_DS;          /* DS max interleave depth for LP1 data path */
   gt_HandshakeBis.sa_DS_BCActive[0] = TRUE;                /* Bearer channel 0 activated */
   gt_HandshakeBis.sa_DS_BCActive[1] = FALSE;                  /* Bearer channel 1 inactive */
   gt_HandshakeBis.sa_DS_MinNetDataRateBC[0] = MIN_NET_DATARATE_ATM_BC0_DS;   /* data rate = x*4000bps */
   gt_HandshakeBis.sa_DS_MinNetDataRateBC[1] = MIN_NET_DATARATE_ATM_BC1_DS;   /* data rate = x*4000bps */
   gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = MAX_NET_DATARATE_ATM_BC0_DS;   /* data rate = x*4000bps */
   gt_HandshakeBis.sa_DS_MaxNetDataRateBC[1] = MAX_NET_DATARATE_ATM_BC1_DS;   /* data rate = x*4000bps */
   gt_HandshakeBis.sa_DS_MaxDataRateLP[0] = MAX_DATARATE_LP0_DATAPATH_DS;/* DS max data rate for LP0 data path = x*4000, x is a 16 bit value */
   gt_HandshakeBis.sa_DS_MaxDataRateLP[1] = MAX_DATARATE_LP1_DATAPATH_DS;/* DS max data rate for LP1 data path = x*4000, x is a 16 bit value */

   gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] = MIN_RES_NET_DATARATE_ATM_BC0_DS; /* data rate = x*4000bps */
   gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[1] = MIN_RES_NET_DATARATE_ATM_BC1_DS; /* data rate = x*4000bps */
   gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = MAX_LATENCY_ATM_BC0_DS;      /* in milli seconds */
   gt_HandshakeBis.sa_DS_MaxLatencyBC[1] = MAX_LATENCY_ATM_BC1_DS;      /* in milli seconds */
   gt_HandshakeBis.sa_DS_BerBC[0] = BER_ATM_BC0_DS;            /* 0x0 corresponds to a BER of 10^(-3) */
   /* 0x1 corresponds to a BER of 10^(-5) */
   /* 0x2 corresponds to a BER of 10^(-7) */
   gt_HandshakeBis.sa_DS_BerBC[1] = BER_ATM_BC1_DS;            /* 0x0 corresponds to a BER of 10^(-3) */
   /* 0x1 corresponds to a BER of 10^(-5) */
   /* 0x2 corresponds to a BER of 10^(-7) */

   //initialize 1/S
   if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_A) != 0)
   gt_HandshakeBis.s_OneOverSminADSL2 = 2;
   else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_A) != 0)
   gt_HandshakeBis.s_OneOverSminADSL2 = 3;
   else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_B) != 0)
   gt_HandshakeBis.s_OneOverSminADSL2 = 2;

   gs_OneOverSminADSL2 = gt_HandshakeBis.s_OneOverSminADSL2;
}
#endif /* TARGET_HW */


#ifdef DANUBE
#ifdef RUN_ASIM
extern int32 gl_LogTxFrame;
extern int16 gs_AFE_PGAGain;

// writing global var addresses to simext modem-variable lookup table
void UpdateSimextVars(void)
{
   // update variable look-up table
   *((int32 *)SIMEXT_PTR_gul_ModeControl) = (int32)&gul_ModeControl;
   *((int32 *)SIMEXT_PTR_gs_bypass_strymon) = (int32)&gs_bypass_strymon;
   *((int32 *)SIMEXT_PTR_TESTArray_TEST_Control) = (int32)&TESTArray[TEST_Control];
   *((int32 *)SIMEXT_PTR_TESTArray_TEST_Control2) = (int32)&TESTArray[TEST_Control2];
   *((int32 *)SIMEXT_PTR_TESTArray_TEST_InitState) = (int32)&TESTArray[TEST_InitState];
   *((int32 *)SIMEXT_PTR_OPTNArray_OPTN_ModeControl) = (int32)&OPTNArray[OPTN_ModeControl];
   *((int32 *)SIMEXT_PTR_gs_RxFftLength) = (int32)&gs_RxFftLength;
   *((int32 *)SIMEXT_PTR_gs_TxFftLength) = (int32)&gs_TxFftLength;
   *((int32 *)SIMEXT_PTR_gft_ResetDmaPtr) = (int32)&gft_ResetDmaPtr;
   *((int32 *)SIMEXT_PTR_gft_TxDataPump_On) = (int32)&gft_TxDataPump_On;
   *((int32 *)SIMEXT_PTR_gft_TcmFlag_bis_US) = (int32)&gft_TcmFlag_bis_US;
   *((int32 *)SIMEXT_PTR_gft_ModemType) = (int32)&gft_ModemType;
   *((int32 *)SIMEXT_PTR_gs_AFE_PGAGain) = (int32)&gs_AFE_PGAGain;

   gl_LogTxFrame = 0;
   *((int32 *)SIMEXT_PTR_gl_LogTxFrame) = (int32)&gl_LogTxFrame;

   // tell simext to execute
   *((int32 *)SIMEXT_EXEC_ConfigForLinkStartAndTest) = 1;
}
#endif
#endif   // #ifdef DANUBE
