/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   cnfg_task_utils.c
 *
 *   Utility functions for configuring task layer.
 *
 *---------------------------------------------------------------------------
 */

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "cmv.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "pll.h"
#include "cnfgshwt.h"
#include "load_prf.h"
#include "bitload_const.h"
#include "snr.h"
#include "dec_gain.h"
#include "CalcRate_BIS.h"


#define R_PILOT_TONE 16

// Local functions
void ConvertGainsToDB(int16 *psa_FineGains);

/*****************************************************************************
;  Prototype: void CalcBATSetFineGains(void)
;
;     Calculates BAT based on showtimevars config structures Lp parameter.
;     Sets Fine Gains
;     Common between HWEngine, SWEngine and TDP
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

void CalcBATSetFineGains(void)
{
   FlagT ft_TcmFlag;
   int16 i, s_numTonesLoaded;
   int16 s_RxTotalDataBits,s_TxTotalDataBits;
   int16 s_tx_constsize, s_tx_bits, s_tx_leftbits;
   int16 s_rx_constsize, s_rx_bits, s_rx_leftbits;
   int16 s_txPilotTone, s_rxPilotTone, s_rxFirstChannel, s_rxLastChannel;

   if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
   else ft_TcmFlag = gft_TcmFlag;


   /* ========================================================================= */
   /* Calculate the total number of Rx bits required per frame */
   /* ========================================================================= */

   for(s_RxTotalDataBits = 0, s_TxTotalDataBits = 0, i = 0; i < NUM_DATA_PATHS; i++) {
      s_RxTotalDataBits += gt_rx_config.s_Lp[i];
      s_TxTotalDataBits += gt_tx_config.s_Lp[i];
   }

   /* ========================================================================= */
   /*  Clear BATs, init Fine Gains, init variables                              */
   /* ========================================================================= */

   for(i=0; i<gs_RxNumTones; i++)
   {
      guca_RxBat[i]=0;
      gsa_RxFineGains[i] = 0x2000;
   }
   for(i=0; i<gs_TxNumTones; i++)
   {
      guca_TxBat[i]=0;
      gsa_TxFineGains[i] = 0x2000;
   }

   s_tx_constsize = gs_tx_ConstSize;
   s_tx_bits = 0;
   s_tx_leftbits= 0;

   s_rx_constsize = gs_rx_ConstSize;
   s_rx_bits = 0;
   s_rx_leftbits= 0;

   /* For TCM */
   if(ft_TcmFlag == TRUE)
   {
      /* we need to add a bit depending on number of loaded tones, so reduce constsize by 1 */
      s_tx_constsize--;
      s_rx_constsize--;
      /* we need to add 4 bits to the BAT table to send predetermined sequence to drive TCM Encode/Decoder to know state */
      s_RxTotalDataBits += 4;
      s_TxTotalDataBits += 4;
   }

   s_rxFirstChannel = gs_RxFirstChannel;
   s_rxLastChannel = gs_RxLastChannel;

   //set cpe pilot tones
   s_txPilotTone = R_PILOT_TONE;
   s_rxPilotTone = gs_CPilotTone;

   /* ========================================================================= */
   /* load BATs */
   /* ========================================================================= */
   s_numTonesLoaded = 0;
   for(i=gs_TxFirstChannel; i<=gs_TxLastChannel; i++)
   {
      if (i == s_txPilotTone) continue;

      if(s_numTonesLoaded < gs_Num1BitTones)
      {
         guca_TxBat[i] = 1;
         s_tx_bits += 1;
         s_numTonesLoaded++;
         if(ft_TcmFlag && !(s_numTonesLoaded%4)) s_TxTotalDataBits++;   //If TCM Enabled, add a bit for every tone pair (four 1 bit tones)
      }
      else if (s_TxTotalDataBits > s_tx_bits + s_tx_constsize)
      {
         guca_TxBat[i] = (uint8) s_tx_constsize;
         s_tx_bits += s_tx_constsize;
         s_numTonesLoaded++;
         if(ft_TcmFlag && s_numTonesLoaded%2) guca_TxBat[i]++; //If TCM Enabled, add a bit for every tone pair
      }
      else
      {
         s_tx_leftbits = s_TxTotalDataBits - s_tx_bits;

         if (s_tx_leftbits > 1)
         {
            guca_TxBat[i] = (uint8) s_tx_leftbits;
         }
         else
         {
            guca_TxBat[i-1]--;
            guca_TxBat[i] = s_tx_leftbits+1;
         }
         s_tx_bits += s_tx_leftbits;
         s_numTonesLoaded++;

         if(ft_TcmFlag && (s_numTonesLoaded%2 || gs_Num1BitTones%4)) guca_TxBat[i]++;  //If TCM Enabled, add a bit for every tone pair
         break;
      }
   } /* End of Tx BAT calculation */

   s_numTonesLoaded = 0;
   for(i=s_rxFirstChannel; i<=s_rxLastChannel; i++)
   {
      if (i == s_rxPilotTone) continue;

      if(s_numTonesLoaded < gs_Num1BitTones)
      {
         guca_RxBat[i] = 1;
         s_rx_bits += 1;
         s_numTonesLoaded++;
         if(ft_TcmFlag && !(s_numTonesLoaded%4)) s_RxTotalDataBits++;   //If TCM Enabled, add a bit for every tone pair (four 1 bit tones)
      }
      else if (s_RxTotalDataBits > s_rx_bits + s_rx_constsize)
      {
         guca_RxBat[i] = (uint8) s_rx_constsize;
         s_rx_bits += s_rx_constsize;
         s_numTonesLoaded++;
         if(ft_TcmFlag && s_numTonesLoaded%2) guca_RxBat[i]++; //If TCM Enabled, add a bit for every tone pair
      }
      else
      {
         s_rx_leftbits = s_RxTotalDataBits - s_rx_bits;

         if (s_rx_leftbits > 1)
         {
            guca_RxBat[i] = (uint8) s_rx_leftbits;
         }
         else
         {
            guca_RxBat[i - 1]--;
            guca_RxBat[i] = s_rx_leftbits+1;
         }

         s_rx_bits += s_rx_leftbits;
         s_numTonesLoaded++;

         if(ft_TcmFlag && (s_numTonesLoaded%2 || gs_Num1BitTones%4)) guca_RxBat[i]++;  //If TCM Enabled, add a bit for every tone pair
         break;
      }
   } /* end of Rx BAT calculation */

   gus_ncloaded = s_numTonesLoaded;

/*
   for(i=0; i<gs_RxNumTones; i++)
   {
      if ((guca_RxBat[i] != 0) || (i == s_rxPilotTone))
         gsa_RxFineGains[i] = 0x2000;     // Pilot tone, loaded tones start with fine gain of 1.0/0dB
   }
*/
} /* End of CalcBATSetFineGains */


/*****************************************************************************
;  Prototype: void InitConfigStruct(void)
;
;     Initialize the gt_tx_config and gt_rx_config structures.
;     Load from CMVs if explicit rate mode enabled else load from
;     config structures
;     Common between HWEngine, SWEngine and TDP
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

void InitConfigStruct(void)
{
   /* If not explicit rate control, load from config structure */
   if ((CNTLArray[0] & CNTL_ExpilictRate)== 0)
   {
      /* else use config set */
      gt_tx_config = gt_config_set[gus_tx_config_num];
      gt_rx_config = gt_config_set[gus_rx_config_num];
   }
}

/*****************************************************************************
;  Prototype: void ConfigTaskForShowtimeInitState_BeforeTxRxInit(void)
;
;     Does Task layer initialization for showtime only tests
;     Common between HWEngine, SWEngine and TDP
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

void ConfigTaskForShowtimeInitState_BeforeTxRxInit(void)
{
   int16 i;
   int16 s_TxLastTone;

   //=================================================================
   // Initialize some variables that would normally get set during
   // the bitloading process.  We assume we are running a software sim so
   // do not worry about whether variables are in Bis or DMT data overlay sections.
   //=================================================================

   gs_RxAvMargin = DESIRED_SNR_MARGIN;
   gt_RMsgPcb_bis.us_R_MIN_PCB_DS = 0;
   gft_BitloadOK = SUCCEED;

   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      // Set PMD parameters so we have non-zero values for HDLC messaging tests.

      gs_RxSNRM_ovhd = gs_RxAvMargin;

      // Set latn=360, so LATNds=36dB.
      guc_LoopAtten_MSB = 1;
      guc_LoopAtten_LSB = 104;

      // Set satn=340, so SATNds=34dB.
      guc_SigAtten_MSB = 1;
      guc_SigAtten_LSB = 84;

      // Set ATTNDR =
      if (( gl_SelectedMode & (MODE_G992_5)  ))
         gt_NearEndParam.ul_AttainableDataRate = 20000000;  // 20 Mbps
      else if (( gl_SelectedMode & (MODE_G992_3)  ))
         gt_NearEndParam.ul_AttainableDataRate = 12000000;  // 12 Mbps

      // Set Far-end ActATP
      guc_ACTATP_MSB = 0;
      guc_ACTATP_LSB = 115;   // 11.5 dBm

      for (i=0 ; i<(RX_NUM_TONES>>1) ; i++)
      {
         // Initialized with arbitrary values
         guca_QLN[i] = (uint8)((i+1)*3);
         gsa_RxHlogDS[i] = (int16)((i+1)*2);
      }
   }

   // Set FDQ coefficients to special value for showtime-only test.
   InitShowtimeTestFDQ(gs_RxNumTones);

   /* Initialize the PLL (this is only needed for test "SHOWTIME",  */
   /* otherwise this initialization is done during "TRAIN" or "FAST_RETRAIN" */
   ResetPLL((int16)LF_KP1, (int16)LF_KI1, (int16)PLL_PI_RADIANS);
   ResetPllRefTone(16384, 16384);

   //==============================================================================
   //  gsa_TxBat, gsa_TxFineGains, gus_ncloaded, gsa_RxBat, gsa_RxFineGains
   //==============================================================================
   if((CNTLArray[0] & CNTL_ExpilictRate) != 0)
   {
      CalcBATSetFineGains();
   }
   else
   {
      for (i=0 ; i< gs_TxNumTones ; i++)
      {
         gsa_TxFineGains[i] = gt_tx_config.psa_FineGains[i] ;
         guca_TxBat[i] = gt_tx_config.psa_BAT[i];
      }
      gus_ncloaded = 0;
      for (i=0 ; i< gs_RxNumTones ; i++)
      {
         gsa_RxFineGains[i] = gt_rx_config.psa_FineGains[i] ;
         guca_RxBat[i] = gt_rx_config.psa_BAT[i];
         if (guca_RxBat[i] !=0)
            gus_ncloaded++;
      }
   }

   ConvertGainsToDB(gsa_RxFineGains);


   gs_RxDesiredMargin = DESIRED_SNR_MARGIN;

   gt_tx_config.psa_BAT        = guca_TxBat;        /* set BAT table pointer */
   gt_tx_config.psa_FineGains = gsa_TxFineGains;   /* set fine gain pointer */
   gt_rx_config.psa_BAT        = guca_RxBat;        /* set BAT table pointer */
   gt_rx_config.psa_FineGains  = gsa_RxFineGains;  /* set fine gain pointer */

   // Assume the CPE does not currently specify any DS blackout bits, so that
   // the DS MEDLEYset is the same as the DS SUPPORTEDset
   for (i=0 ; i<gs_RxNumTones ; i++){
      if (IS_TONEFLAGSET(p_SUPPORTEDset_DS, i))
         SETTONEFLAG(p_MEDLEYset_DS, i);
      else
         CLEARTONEFLAG(p_MEDLEYset_DS, i);
   }

   // Pilot tone is still in the MEDLEYset, strictly speaking, but
   // not for bitloading/OLR purposes.  Since the OLR routines check p_MEDLEYset_DS to see
   // which tones can be bitloaded, clear the bit flag for the pilot tone.
   CLEARTONEFLAG(p_MEDLEYset_DS, gs_PilotToneIdx);

   s_TxLastTone = 32;

   if (( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L)  ))
   {
      if((STATArray[STAT_Misc] & STAT_AnnexL_US_Mask1_PSD) != 0)
         // US Mask1
         s_TxLastTone = 24;
      else // US Mask2
         s_TxLastTone = 14;

   }


   for (i= 0; i<gs_TxNumTones ; i++)
   {
      if ((i >= 6) && (i <= s_TxLastTone))
      {
         SETTONEFLAG(gp_MEDLEYset_US, i);
         SETTONEFLAG(gp_SUPPORTEDset_US, i);
      }
      else
      {
         CLEARTONEFLAG(gp_MEDLEYset_US, i);
         CLEARTONEFLAG(gp_SUPPORTEDset_US, i);
      }
   }

}

/*****************************************************************************
;  Prototype: void ConfigTaskForShowtimeInitState_AfterRxInit(void)
;
;     Does Task layer initialization for showtime only tests
;     Common between HWEngine, SWEngine and TDP
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

void ConfigTaskForShowtimeInitState_AfterRxInit(void)
{
   FlagT ft_TcmFlag;
   int16 i, s_RequiredFastBits, s_AccumFastBits, s_ch, sa_R[2];
   int16 *psa_RxToneOrder;

   if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
   else ft_TcmFlag = gft_TcmFlag;

   //=================
   //  gs_MaxToneForFast
   //=================
   s_RequiredFastBits = 8 * gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_FecFrameSize;

   s_AccumFastBits = 0;

   /* Point to the first non-zero tone */
   psa_RxToneOrder = &gsa_RxToneOrder[gs_FirstNonzeroRxTone];

   // Find value of gs_MaxToneForFast, which is number of tones whose bits are allocated to
   // the fast path. This value currently only used for framing modes 0,1,2.

   if(s_RequiredFastBits == 0)
   {
      gs_MaxToneForFast = -1;

   }
   else if(gt_rx_config.s_FramingMode == REDUCED_MERGED)
   {
      /* For framing mode 3 set this to the max tone index if fast path is active. */
      gs_MaxToneForFast = gs_RxNumTones-1;
   }
   else
   {
      for(i=0; i<gus_ncloaded; i++)
      {
         s_ch = psa_RxToneOrder[i];
         s_AccumFastBits += guca_RxBat[s_ch];

         if(s_AccumFastBits >= s_RequiredFastBits)
         {
            gs_MaxToneForFast = i;
            break;
         }
      }
   }

   //=================
   //  gsa_TotalCodingGain
   //=================
   sa_R[FAST_DATA_PATH] = gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_R;
   sa_R[INTERLEAVE_DATA_PATH] = gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_R;

   for (i=0 ; i<2 ; i++)
   {
      /* Get Reed Solomon Coding gain (in Q15.1 format) */
      gsa_TotalCodingGain[i] = guca_RSCodingGain[(sa_R[i]>>1)];

      /* Add TCM coding gain (in Q15.1) format */
      if(ft_TcmFlag == TRUE)
      {
         gsa_TotalCodingGain[i] += gs_tcm_coding_gain;

         /* Apply limit to coding gain  */
         if(gsa_TotalCodingGain[i] > gs_max_coding_gain)
            gsa_TotalCodingGain[i] = gs_max_coding_gain;
      }
      gsa_TotalCodingGain[i] <<= 7;    // Convert from Q15.1 to Q8.8 format.
   }

   // Calculate data rates in bps for management variables.
   // Updates the net data rate and ovhd msg rate.
   CalcRate_BitsPerSecond(&gt_rx_config, gla_DSDataRate, gsa_DSOvhdRate);
   CalcRate_BitsPerSecond(&gt_tx_config, gla_USDataRate, gsa_USOvhdRate);

}


/*^^^
*-------------------------------------------------------------------
*
*   Prototype:
*     void ConvertGainsToDB(int16 *psa_FineGains)
*
*  Description:
*
*  Input Arguments:
*     psa_FineGains -- pointer to the fine gain table for DS channel. Input format is 3.13 linear.
*
*  Output Arguments:
*     psa_FineGains-- output format is 8.8 dB.
*
*  Return:
*     none
*
*  NOTES:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
C_SCOPE void ConvertGainsToDB(int16 *psa_FineGains)
{
   int16 i;

   for (i=0 ; i<gs_RxNumTones ; i++) {

      if (psa_FineGains[i] == 0)
         psa_FineGains[i] = NEG_INFINITY_DB;
      else
      {
      // ConvertToDB returns 10log_10(x), so multiply by 2.
         psa_FineGains[i] = 2 * (ConvertToDB(psa_FineGains[i]) - ConvertToDB((int16) 0x2000)) ;

      /* ensure that the value we get here does not go out of range +/- 2.5dB, this can
         happen due to precision issues of the function*/

         if (psa_FineGains[i] < gs_min_fine_gain) psa_FineGains[i] = gs_min_fine_gain;
         if (psa_FineGains[i] > gs_max_fine_gain) psa_FineGains[i] = gs_max_fine_gain;

      }
   }
}

