/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   hybrid_settings.c
*
*  Functions for hybrid setting initializations.
*
*-------------------------------------------------------------------------
*/
#include "typedef.h"
#include "common.h"
#include "gdata.h"


void InitHybridSettings(void)
{

#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
   /* Initialize variables and arrays for programmable hybrid training. */
   guc_HybTssiOff = 0;
#ifndef HYB_REG_POINTERS
   //initHybridSettingsTable();
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
#ifdef ISDN /* Annex B */

   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   /*          DANUBE      -     ANNEX B           */
   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   /* 11.04.2006: Stefan change START. Hyb coeffs from Kai */
   /* Hyb_Set_B */
   guc_HybNumHybrids = 35;

   gpusa_HybridReg0[ 0] = 0x0000 ;
   gpusa_HybridReg1[ 0] = 0x0000 ;
   gpusa_HybridReg0[ 1] = 0x0000 ;
   gpusa_HybridReg1[ 1] = 0x0001 ;
   gpusa_HybridReg0[ 2] = 0x0000 ;
   gpusa_HybridReg1[ 2] = 0x0002 ;
   gpusa_HybridReg0[ 3] = 0x0000 ;
   gpusa_HybridReg1[ 3] = 0x070A ;
   gpusa_HybridReg0[ 4] = 0x0000 ;
   gpusa_HybridReg1[ 4] = 0x0A07 ;
   gpusa_HybridReg0[ 5] = 0x0000 ;
   gpusa_HybridReg1[ 5] = 0x0A09 ;
   gpusa_HybridReg0[ 6] = 0x0000 ;
   gpusa_HybridReg1[ 6] = 0x0A0A ;
   gpusa_HybridReg0[ 7] = 0x0000 ;
   gpusa_HybridReg1[ 7] = 0x0C06 ;
   gpusa_HybridReg0[ 8] = 0x0001 ;
   gpusa_HybridReg1[ 8] = 0x0000 ;
   gpusa_HybridReg0[ 9] = 0x0001 ;
   gpusa_HybridReg1[ 9] = 0x0001 ;
   gpusa_HybridReg0[10] = 0x0001 ;
   gpusa_HybridReg1[10] = 0x0002 ;
   gpusa_HybridReg0[11] = 0x0001 ;
   gpusa_HybridReg1[11] = 0x070A ;
   gpusa_HybridReg0[12] = 0x0001 ;
   gpusa_HybridReg1[12] = 0x0A07 ;
   gpusa_HybridReg0[13] = 0x0001 ;
   gpusa_HybridReg1[13] = 0x0A09 ;
   gpusa_HybridReg0[14] = 0x0001 ;
   gpusa_HybridReg1[14] = 0x0A0A ;
   gpusa_HybridReg0[15] = 0x0001 ;
   gpusa_HybridReg1[15] = 0x0C06 ;
   gpusa_HybridReg0[16] = 0x0002 ;
   gpusa_HybridReg1[16] = 0x0B07 ;
   gpusa_HybridReg0[17] = 0x0002 ;
   gpusa_HybridReg1[17] = 0x0A07 ;
   gpusa_HybridReg0[18] = 0x0002 ;
   gpusa_HybridReg1[18] = 0x0C07 ;
   gpusa_HybridReg0[19] = 0x0002 ;
   gpusa_HybridReg1[19] = 0x0B06 ;
   gpusa_HybridReg0[20] = 0x0002 ;
   gpusa_HybridReg1[20] = 0x0A06 ;
   gpusa_HybridReg0[21] = 0x0002 ;
   gpusa_HybridReg1[21] = 0x0C06 ;
   gpusa_HybridReg0[22] = 0x0002 ;
   gpusa_HybridReg1[22] = 0x0B08 ;
   gpusa_HybridReg0[23] = 0x0002 ;
   gpusa_HybridReg1[23] = 0x0A08 ;
   gpusa_HybridReg0[24] = 0x0002 ;
   gpusa_HybridReg1[24] = 0x0C08 ;
   gpusa_HybridReg0[25] = 0x0004 ;
   gpusa_HybridReg1[25] = 0x0D04 ;
   gpusa_HybridReg0[26] = 0x0004 ;
   gpusa_HybridReg1[26] = 0x0C04 ;
   gpusa_HybridReg0[27] = 0x0004 ;
   gpusa_HybridReg1[27] = 0x0E04 ;
   gpusa_HybridReg0[28] = 0x0004 ;
   gpusa_HybridReg1[28] = 0x0D03 ;
   gpusa_HybridReg0[29] = 0x0004 ;
   gpusa_HybridReg1[29] = 0x0D05 ;
   gpusa_HybridReg0[30] = 0x0007 ;
   gpusa_HybridReg1[30] = 0x0D02 ;
   gpusa_HybridReg0[31] = 0x0008 ;
   gpusa_HybridReg1[31] = 0x0C02 ;
   gpusa_HybridReg0[32] = 0x0008 ;
   gpusa_HybridReg1[32] = 0x0D02 ;
   gpusa_HybridReg0[33] = 0x0009 ;
   gpusa_HybridReg1[33] = 0x0D06 ;
   gpusa_HybridReg0[34] = 0x000C ;
   gpusa_HybridReg1[34] = 0x0D08 ;
   /* HPFEq Setting */
   gpusa_HpfEqReg[0]  = 0x0000;
   gpusa_HpfEqReg[1]  = 0x0000;
   gpusa_HpfEqReg[2]  = 0x0000;
   gpusa_HpfEqReg[3]  = 0x0000;
   gpusa_HpfEqReg[4]  = 0x0000;
   gpusa_HpfEqReg[5]  = 0x0000;
   gpusa_HpfEqReg[6]  = 0x0000;
   gpusa_HpfEqReg[7]  = 0x0000;
   gpusa_HpfEqReg[8]  = 0x0000;
   gpusa_HpfEqReg[9]  = 0x0000;
   gpusa_HpfEqReg[10] = 0x0000;
   gpusa_HpfEqReg[11] = 0x0000;
   gpusa_HpfEqReg[12] = 0x0000;
   gpusa_HpfEqReg[13] = 0x0000;
   gpusa_HpfEqReg[14] = 0x0000;
   gpusa_HpfEqReg[15] = 0x0000;
   gpusa_HpfEqReg[16] = 0x0000;
   gpusa_HpfEqReg[17] = 0x0000;
   gpusa_HpfEqReg[18] = 0x0000;
   gpusa_HpfEqReg[19] = 0x0000;
   gpusa_HpfEqReg[20] = 0x0000;
   gpusa_HpfEqReg[21] = 0x0000;
   gpusa_HpfEqReg[22] = 0x0000;
   gpusa_HpfEqReg[23] = 0x0000;
   gpusa_HpfEqReg[24] = 0x0000;
   gpusa_HpfEqReg[25] = 0x0000;
   gpusa_HpfEqReg[26] = 0x0000;
   gpusa_HpfEqReg[27] = 0x0000;
   gpusa_HpfEqReg[28] = 0x0000;
   gpusa_HpfEqReg[29] = 0x0000;
   gpusa_HpfEqReg[30] = 0x0000;
   gpusa_HpfEqReg[31] = 0x0000;
   gpusa_HpfEqReg[32] = 0x0000;
   gpusa_HpfEqReg[33] = 0x0000;
   gpusa_HpfEqReg[34] = 0x0000;

   /* END:  11.04.2006: Stefan change START. Hyb coeffs from Kai */
#else /* Annex A */
   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   /*          DANUBE      -     ANNEX A           */
   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   guc_HybNumHybrids = 35;

   /* Hybrid Settings Danube Annex A */
   gpusa_HybridReg0[ 0] = 0x000c;  // 0
   gpusa_HybridReg1[ 0] = 0x0d00 ;
   gpusa_HybridReg0[ 1] = 0x0208;  // 0
   gpusa_HybridReg1[ 1] = 0x0c00 ;
   gpusa_HybridReg0[ 2] = 0x000f;  // 0
   gpusa_HybridReg1[ 2] = 0x0c02 ;
   gpusa_HybridReg0[ 3] = 0x060c;  // 0
   gpusa_HybridReg1[ 3] = 0x0e00 ;
   gpusa_HybridReg0[ 4] = 0x0009;  // 50
   gpusa_HybridReg1[ 4] = 0x0c00 ;
   gpusa_HybridReg0[ 5] = 0x0206;  // 50 150
   gpusa_HybridReg1[ 5] = 0x0c00 ;
   gpusa_HybridReg0[ 6] = 0x0406;  // 50 150
   gpusa_HybridReg1[ 6] = 0x0c00 ;
   gpusa_HybridReg0[ 7] = 0x0003;  // 150
   gpusa_HybridReg1[ 7] = 0x0c00 ;
   gpusa_HybridReg0[ 8] = 0x0602;  // 150 200
   gpusa_HybridReg1[ 8] = 0x0c00 ;
   gpusa_HybridReg0[ 9] = 0x0000;  // 150 250 300
   gpusa_HybridReg1[ 9] = 0x0a00 ;
   gpusa_HybridReg0[10] = 0x0000;  // 200
   gpusa_HybridReg1[10] = 0x0800 ;
   gpusa_HybridReg0[11] = 0x0000;  // 300 350 400
   gpusa_HybridReg1[11] = 0x0902 ;
   gpusa_HybridReg0[12] = 0x0100;  // 350 400
   gpusa_HybridReg1[12] = 0x0802 ;
   gpusa_HybridReg0[13] = 0x0700;  // 400
   gpusa_HybridReg1[13] = 0x0204 ;
   gpusa_HybridReg0[14] = 0x0300;  // 500
   gpusa_HybridReg1[14] = 0x0004 ;
//    gpusa_HybridReg0[  ] = 0x0600;  // 500
//    gpusa_HybridReg1[  ] = 0x0606 ;
   gpusa_HybridReg0[15] = 0x0000;  // 500 600
   gpusa_HybridReg1[15] = 0x0204 ;
   gpusa_HybridReg0[16] = 0x0600;  // 500 600
   gpusa_HybridReg1[16] = 0x0006 ;
   gpusa_HybridReg0[17] = 0x0500;  // 600 900 1000
   gpusa_HybridReg1[17] = 0x000a;
   gpusa_HybridReg0[18] = 0x0400;  // 700 750 800
   gpusa_HybridReg1[18] = 0x0008 ;
   gpusa_HybridReg0[19] = 0x0600;  // 700 750 800
   gpusa_HybridReg1[19] = 0x0008 ;
   gpusa_HybridReg0[20] = 0x0606;  // 750
   gpusa_HybridReg1[20] = 0x020a ;
   gpusa_HybridReg0[21] = 0x060b;  // 800
   gpusa_HybridReg1[21] = 0x000e ;
   gpusa_HybridReg0[22] = 0x0304;  // 1000
   gpusa_HybridReg1[22] = 0x000c ;
//    gpusa_HybridReg0[  ] = 0x0606;  // 1000
//    gpusa_HybridReg1[  ] = 0x020e ;
   gpusa_HybridReg0[23] = 0x0608;  // 1000
   gpusa_HybridReg1[23] = 0x0010 ;
   gpusa_HybridReg0[24] = 0x0600;  // 1000
   gpusa_HybridReg1[24] = 0x000c ;
   gpusa_HybridReg0[25] = 0x0400;  // 1000
   gpusa_HybridReg1[25] = 0x000b ;
   gpusa_HybridReg0[26] = 0x000e;  // 1250
   gpusa_HybridReg1[26] = 0x0014 ;
   gpusa_HybridReg0[27] = 0x0206;  // 1250
   gpusa_HybridReg1[27] = 0x0010 ;
   gpusa_HybridReg0[28] = 0x000e;  // 1500
   gpusa_HybridReg1[28] = 0x0612 ;
   gpusa_HybridReg0[29] = 0x000b;  // 1500
   gpusa_HybridReg1[29] = 0x0812 ;
   gpusa_HybridReg0[30] = 0x0006;  // 1500
   gpusa_HybridReg1[30] = 0x0a0c ;
   gpusa_HybridReg0[31] = 0x0002;  // 1500
   gpusa_HybridReg1[31] = 0x080c ;
   gpusa_HybridReg0[32] = 0x0000;  // 1500
   gpusa_HybridReg1[32] = 0x080c ;
   gpusa_HybridReg0[33] = 0x000D;  // ANSI#13
   gpusa_HybridReg1[33] = 0x0F02 ;
   gpusa_HybridReg0[34] = 0x000F;  // ANSI#13
   gpusa_HybridReg1[34] = 0x0F01 ;

   /* HpfEq-Register */
   gpusa_HpfEqReg[0]  = 0x0001;
   gpusa_HpfEqReg[1]  = 0x0001;
   gpusa_HpfEqReg[2]  = 0x0001;
   gpusa_HpfEqReg[3]  = 0x0001;
   gpusa_HpfEqReg[4]  = 0x0001;
   gpusa_HpfEqReg[5]  = 0x0001;
   gpusa_HpfEqReg[6]  = 0x0001;
   gpusa_HpfEqReg[7]  = 0x0001;
   gpusa_HpfEqReg[8]  = 0x0001;
   gpusa_HpfEqReg[9]  = 0x0001;
   gpusa_HpfEqReg[10] = 0x0001;
   gpusa_HpfEqReg[11] = 0x0001;
   gpusa_HpfEqReg[12] = 0x0001;
   gpusa_HpfEqReg[13] = 0x0001;
   gpusa_HpfEqReg[14] = 0x0001;
   gpusa_HpfEqReg[15] = 0x0001;
   gpusa_HpfEqReg[16] = 0x0001;
   gpusa_HpfEqReg[17] = 0x0001;
   gpusa_HpfEqReg[18] = 0x0001;
   gpusa_HpfEqReg[19] = 0x0001;
   gpusa_HpfEqReg[20] = 0x0001;
   gpusa_HpfEqReg[21] = 0x0001;
   gpusa_HpfEqReg[22] = 0x0001;
   gpusa_HpfEqReg[23] = 0x0001;
   gpusa_HpfEqReg[24] = 0x0001;
   gpusa_HpfEqReg[25] = 0x0001;
   gpusa_HpfEqReg[26] = 0x0001;
   gpusa_HpfEqReg[27] = 0x0001;
   gpusa_HpfEqReg[28] = 0x0001;
   gpusa_HpfEqReg[29] = 0x0001;
   gpusa_HpfEqReg[30] = 0x0001;
   gpusa_HpfEqReg[31] = 0x0001;
   gpusa_HpfEqReg[32] = 0x0001;
   gpusa_HpfEqReg[33] = 0x0001;
   gpusa_HpfEqReg[34] = 0x0001;
#endif /* end: Danube Annex A */

#else /* end: Danube, start: Amazon */

#ifdef ISDN /* Annex B */
   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   /*          AMAZON      -     ANNEX B           */
   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   guc_HybNumHybrids = 34;
   gpusa_HybridReg0[0]  = 0x0E8D;
   gpusa_HybridReg0[1]  = 0x0E9D;
   gpusa_HybridReg0[2]  = 0x0E7D;
   gpusa_HybridReg0[3]  = 0x0EAD;
   gpusa_HybridReg0[4]  = 0x0E6D;
   gpusa_HybridReg0[5]  = 0x0ECD;
   gpusa_HybridReg0[6]  = 0x0E5D;
   gpusa_HybridReg0[7]  = 0x1D6E;
   gpusa_HybridReg0[8]  = 0x1D7E;
   gpusa_HybridReg0[9]  = 0x0D3D;
   gpusa_HybridReg0[10] = 0x0D4D;
   gpusa_HybridReg0[11] = 0x0D5D;
   gpusa_HybridReg0[12] = 0x0D6D;
   gpusa_HybridReg0[13] = 0x0D7D;
   gpusa_HybridReg0[14] = 0x0D9D;
   gpusa_HybridReg0[15] = 0x0DCD;
   gpusa_HybridReg0[16] = 0x0FCD;
   gpusa_HybridReg0[17] = 0x0FDD;
   gpusa_HybridReg0[18] = 0x0FDD;
   gpusa_HybridReg0[19] = 0x0FED;
   gpusa_HybridReg0[20] = 0x0FFD;
   gpusa_HybridReg0[21] = 0x01DC;
   gpusa_HybridReg0[22] = 0x01DD;
   gpusa_HybridReg0[23] = 0x01EC;
   gpusa_HybridReg0[24] = 0x01ED;
   gpusa_HybridReg0[25] = 0x01FC;
   gpusa_HybridReg0[26] = 0x01FD;
   gpusa_HybridReg0[27] = 0x02FD;
   gpusa_HybridReg0[28] = 0x00DC;
   gpusa_HybridReg0[29] = 0x00DD;
   gpusa_HybridReg0[30] = 0x00EC;
   gpusa_HybridReg0[31] = 0x00ED;
   gpusa_HybridReg0[32] = 0x00FC;
   gpusa_HybridReg0[33] = 0x00FD;
   gpusa_HpfEqReg[0]  = 0x000F;
   gpusa_HpfEqReg[1]  = 0x000F;
   gpusa_HpfEqReg[2]  = 0x000F;
   gpusa_HpfEqReg[3]  = 0x000F;
   gpusa_HpfEqReg[4]  = 0x000F;
   gpusa_HpfEqReg[5]  = 0x000F;
   gpusa_HpfEqReg[6]  = 0x000F;
   gpusa_HpfEqReg[7]  = 0x000F;
   gpusa_HpfEqReg[8]  = 0x000F;
   gpusa_HpfEqReg[9]  = 0x000F;
   gpusa_HpfEqReg[10] = 0x000F;
   gpusa_HpfEqReg[11] = 0x000F;
   gpusa_HpfEqReg[12] = 0x000F;
   gpusa_HpfEqReg[13] = 0x000F;
   gpusa_HpfEqReg[14] = 0x000F;
   gpusa_HpfEqReg[15] = 0x000F;
   gpusa_HpfEqReg[16] = 0x000F;
   gpusa_HpfEqReg[17] = 0x000F;
   gpusa_HpfEqReg[18] = 0x000F;
   gpusa_HpfEqReg[19] = 0x000F;
   gpusa_HpfEqReg[20] = 0x000F;
   gpusa_HpfEqReg[21] = 0x000F;
   gpusa_HpfEqReg[22] = 0x000F;
   gpusa_HpfEqReg[23] = 0x000F;
   gpusa_HpfEqReg[24] = 0x000F;
   gpusa_HpfEqReg[25] = 0x000F;
   gpusa_HpfEqReg[26] = 0x000F;
   gpusa_HpfEqReg[27] = 0x000F;
   gpusa_HpfEqReg[28] = 0x000F;
   gpusa_HpfEqReg[29] = 0x000F;
   gpusa_HpfEqReg[30] = 0x000F;
   gpusa_HpfEqReg[31] = 0x000F;
   gpusa_HpfEqReg[32] = 0x000F;
   gpusa_HpfEqReg[33] = 0x000F;
#else    /* Annex A */

   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   /*          AMAZON      -     ANNEX A           */
   /*-------------------------------------------------------*/
   /*-------------------------------------------------------*/
   guc_HybNumHybrids = 35;
   gpusa_HybridReg0[0]  = 0x0539;
   gpusa_HybridReg0[1]  = 0x0209;
   gpusa_HybridReg0[2]  = 0x0309;
   gpusa_HybridReg0[3]  = 0x0409;
   gpusa_HybridReg0[4]  = 0x061a;
   gpusa_HybridReg0[5]  = 0x0d0e;
   gpusa_HybridReg0[6]  = 0x0e0e;
   gpusa_HybridReg0[7]  = 0x100f;
   gpusa_HybridReg0[8]  = 0x101a;
   gpusa_HybridReg0[9]  = 0x1149;
   gpusa_HybridReg0[10] = 0x123a;
   gpusa_HybridReg0[11] = 0x120b;
   gpusa_HybridReg0[12] = 0x134a;
   gpusa_HybridReg0[13] = 0x132b;
   gpusa_HybridReg0[14] = 0x1389;
   gpusa_HybridReg0[15] = 0x144b;
   gpusa_HybridReg0[16] = 0x146a;
   gpusa_HybridReg0[17] = 0x202c;
   gpusa_HybridReg0[18] = 0x200d;
   gpusa_HybridReg0[19] = 0x204b;
   gpusa_HybridReg0[20] = 0x201e;
   gpusa_HybridReg0[21] = 0x213c;
   gpusa_HybridReg0[22] = 0x214c;
   gpusa_HybridReg0[23] = 0x212d;
   gpusa_HybridReg0[24] = 0x212e;
   gpusa_HybridReg0[25] = 0x224c;
   gpusa_HybridReg0[26] = 0x223d;
   gpusa_HybridReg0[27] = 0x221e;
   gpusa_HybridReg0[28] = 0x227b;
   gpusa_HybridReg0[29] = 0x235c;
   gpusa_HybridReg0[30] = 0x2f0e;
   gpusa_HybridReg0[31] = 0x0d39;
   gpusa_HybridReg0[32] = 0x0d29;
   gpusa_HybridReg0[33] = 0x0389;
   gpusa_HybridReg0[34] = 0x06ea;
   gpusa_HpfEqReg[0]  = 0x0000;
   gpusa_HpfEqReg[1]  = 0x0000;
   gpusa_HpfEqReg[2]  = 0x0000;
   gpusa_HpfEqReg[3]  = 0x0000;
   gpusa_HpfEqReg[4]  = 0x0000;
   gpusa_HpfEqReg[5]  = 0x0000;
   gpusa_HpfEqReg[6]  = 0x0000;
   gpusa_HpfEqReg[7]  = 0x0000;
   gpusa_HpfEqReg[8]  = 0x0000;
   gpusa_HpfEqReg[9]  = 0x0000;
   gpusa_HpfEqReg[10] = 0x0000;
   gpusa_HpfEqReg[11] = 0x0000;
   gpusa_HpfEqReg[12] = 0x0000;
   gpusa_HpfEqReg[13] = 0x0000;
   gpusa_HpfEqReg[14] = 0x0000;
   gpusa_HpfEqReg[15] = 0x0000;
   gpusa_HpfEqReg[16] = 0x0000;
   gpusa_HpfEqReg[17] = 0x0000;
   gpusa_HpfEqReg[18] = 0x0000;
   gpusa_HpfEqReg[19] = 0x0000;
   gpusa_HpfEqReg[20] = 0x0000;
   gpusa_HpfEqReg[21] = 0x0000;
   gpusa_HpfEqReg[22] = 0x0000;
   gpusa_HpfEqReg[23] = 0x0000;
   gpusa_HpfEqReg[24] = 0x0000;
   gpusa_HpfEqReg[25] = 0x0000;
   gpusa_HpfEqReg[26] = 0x0000;
   gpusa_HpfEqReg[27] = 0x0000;
   gpusa_HpfEqReg[28] = 0x0000;
   gpusa_HpfEqReg[29] = 0x0000;
   gpusa_HpfEqReg[30] = 0x0000;
   gpusa_HpfEqReg[31] = 0x0012;
   gpusa_HpfEqReg[32] = 0x000c;
   gpusa_HpfEqReg[33] = 0x1812;
   gpusa_HpfEqReg[34] = 0x180c;
#endif   /* End of #ifdef/#else ISDN*/
#endif   /* End of #ifdef/#else DANUBE_AFE */
#endif   /* End of #ifndef HYB_REG_POINTERS */
#endif   /* End of #ifdef AMAZON_AFE */

#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
#ifdef ISDN
#ifdef DANUBE_AFE /* Infineon Danube-A AFE IC */
   gus_AnnexMHybridReg0 = 0x0000;
   gus_AnnexMHybridReg1 = 0x0000;
#else /* Else for #ifdef DANUBE_AFE */
   gus_AnnexMHybridReg0 = 0x0EBD;
#endif   /* End of #ifdef/#else DANUBE_AFE */
#endif
#endif   /* End of #ifdef AMAZON_AFE */

}

