/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  eoc_ini_b.c
*
*  Functions for BG Tasks from eoc_ini.c
*
****************************************************************************/

#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "eoc.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "fifo.h"
#include "DSLEngin.h"


/*****************************************************************************
*   Subroutine Name: InitEocRegisters()
*
*   Description:
*     This subroutine initializes the EOC registers to some arbitrary values. This is for test
*       purposes only
*
*   Prototype:
*       void InitEocRegisters(void);
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   gt_EocRxReadBuf  -- RX EOC Read structure with the following variables initialized:
*       us_vendor_id[EOC_VENDOR_ID_LEN]                     - ATU-R vendor id
*       us_revision_num[EOC_REVISION_NUM_LEN]               - ATU-R Revision number
*       us_serial_num[EOC_SERIAL_NUM_LEN]                   - ATU-R Serial number
*       uc_line_attenuation[EOC_LINE_ATTENUATION_LEN]       - ATU-R Line Attenuation
*       c_snr_margin[EOC_SNR_MARGIN_LEN]                    - ATU-R snr margin
*       uc_atu_r_configuration[EOC_ATU_R_CONFIGURATION_LEN] - ATU-R Configuration
*       uc_link_state[EOC_LINK_STATE_LEN]                   - ATU-R Link state
*       uc_vendor_discr[EOC_VENDOR_DISCR_LEN]               - vendor discretionary information
*       uc_clear_eoc_payload                                - clear eoc payload byte
*
*
*******************************************************************************/
C_SCOPE void InitEocRegisters(void)
{
   memset(gpt_EocRxReadBuf, 0, sizeof(RxEocReadStruct_t));

   // we need to set vendor info field here as well when the CMV is ready

   gpt_EocRxReadBuf->uc_clear_eoc_payload = 0xA;
}

