/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  eoc_ini.c
*
*  Functions to initialize the eoc functions
*
****************************************************************************/

//******************************************************************
// eoc_rx_ini.c
//
// History
//
// 18/07/2011: Sabrina Y / Vinjam/Kannan: Ported from Danube
//             i.e In T1.413 mode, the System vendor ID, version# and serial #
//             were never initialized nor controlled by host cmv settings.
//             The fix is to initialize these variables the same as in G.dmt.
//             Grep for SMS01450500 ENH_DS_T1413_EOC_VerNumInit
//
//******************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "eoc.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "cmv.h"


/*****************************************************************************
*   Subroutine Name: RxEocInit
*
*   Description:
*     This subroutine initializes variables used by the EOC RX functions.
*
*   Prototype:
*       void RxEocInit(void);
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   gt_RxEocHandler  -- RX EOC handler structure with the following variables initialized:
*       us_rx_eoc_msg_count - Receive eoc message count
*       us_RxEocState       - current state of Rx Eoc state machine
*       us_rx_eoc_msg       - current received eoc message
*       us_pre_eoc_msg      - previous received eoc message
*       *puc_rx_eoc_buf     - pointer to the members of ReadEocBuf
*       us_msg_len          - length of the ATU-R data registers
*
*******************************************************************************/
void RxEocInit(void)
{
   int i;
   uint8 *psa_tempeoc;

   InitEocRegisters();

   gpt_RxEocHandler->us_rx_eoc_msg_count         = 0;
   gpt_RxEocHandler->us_pre_eoc_msg              = 0;

   gpt_RxEocHandler->us_RxEocState               = EOC_IDLE_STATE_RX;
   gft_receive_crc_corrupt_bits_flag = FALSE;
   gft_send_crc_corrupt_bits_flag = FALSE;
   gft_tx_msg_pending          = FALSE;
   gpt_TxEocHandler->s_tx_eoc_msg_put_ptr        = 0;

   /* initialize the Rx EOC fifo */

   gt_RxEocFifo.MessageBuffer = &gus_RxEocBuffer[0];
   gt_RxEocFifo.BufferSize = RXEOCBUFFER_SIZE;
   gt_RxEocFifo.IndexOfOldest = 0;
   gt_RxEocFifo.NextAvailable = 0;
   gt_RxEocFifo.PendingMessageCount = 0;
   gt_RxEocFifo.ErrorCode = 0;
   gt_RxEocFifo.us_OvflowCnt = 0;

   psa_tempeoc = &gpt_EocRxReadBuf->us_vendor_id[0];

   /* Initialize some EOC registers */
   //SMS01450500 ENH_DS_T1413_EOC_VerNumInit (START)
//   if (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)
//   {
//      *psa_tempeoc++ = (gs_ne_T1413_VendorID & 0xFF00) >> 8;
//      *psa_tempeoc++ = gs_ne_T1413_VendorID & 0x00FF;
//   }
//   else
//   {
   //SMS01450500 ENH_DS_T1413_EOC_VerNumInit (END)
      //Initialize System Vendor ID
      for (i = 0; i < EOC_VENDOR_ID_LEN; i++)
         *psa_tempeoc++  = guca_ne_SystemVendorID[i];

      //Initialize System Revision number
      psa_tempeoc = &gpt_EocRxReadBuf->us_revision_num[0];
      for (i = 0; i < EOC_REVISION_NUM_LEN; i++)
         *psa_tempeoc++ = guca_ne_SystemVersionNum[i];

      //Initialize System Serial number
      psa_tempeoc = &gpt_EocRxReadBuf->us_serial_num[0];
      for (i = 0; i < EOC_SERIAL_NUM_LEN; i++)
         *psa_tempeoc++ = guca_ne_SystemSerialNum[i];
//SMS01450500 ENH_DS_T1413_EOC_VerNumInit (START_END)
//   }

}



