/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  eoc_tx_ini.c
*
*  Functions to initialize the eoc functions
*
****************************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "eoc.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "fifo.h"
#include "DSLEngin.h"


/*****************************************************************************
*   Subroutine Name: TxEocInit
*
*   Description:
*     This subroutine initializes variables used by the EOC TX functions.
*
*   Prototype:
*       void TxEocInit(void);
*
*   Arguments:
*     none
*
*   Return:
*     none
*
*   Global Variables:
*     gt_TxEocHandler
*     gt_TxEocHandler             - (O) the structure containing the following variables:
*        uca_TxEocOutBuf[2]      - contains the eoc byte to be x'mited
*        uc_tx_info_buf_index    - index to the buffer containing data to be written into ATU-R data register
*     gt_TxEocDgasp           - TX EOC Dgasp structure with the following variables initialized:
*        ft_send_dgasp_flag      - indicates if there is a loss of power
*        uc_dgasp_msg_count      - counter for transmitted Dgasp msgs.
*
*******************************************************************************/
void TxEocInit(void)
{
   int16 i;

   gpt_TxEocHandler->uc_tx_info_buf_index            = 0xFF;

   for(i=0; i<TX_EOC_MSG_BUF_LEN; i++)
      gpt_TxEocHandler->us_tx_eoc_msg[i] = EOC_NO_SYNC_MSG;

   gft_send_crc_corrupt_bits_flag  = FALSE;
   gft_receive_crc_corrupt_bits_flag   = FALSE;
   gft_no_sync_flag                = TRUE;
   gpt_TxEocDgasp->ft_send_dgasp_flag              = FALSE;
   gpt_TxEocDgasp->uc_dgasp_msg_count              = 0;
   gpt_TxEocHandler->s_tx_eoc_msg_get_ptr           = 0;

    /* initialize the Tx EOC fifo   */

   gt_TxEocFifo.MessageBuffer = &gus_TxEocBuffer[0];
   gt_TxEocFifo.BufferSize = TXEOCBUFFER_SIZE;
   gt_TxEocFifo.IndexOfOldest = 0;
   gt_TxEocFifo.NextAvailable = 0;
   gt_TxEocFifo.PendingMessageCount = 0;
   gt_TxEocFifo.ErrorCode = 0;
   gt_TxEocFifo.us_OvflowCnt = 0;
}

