/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  rx_eoc1.c
*
*
****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "DSLEngin.h"
#include "fifo.h"


/*****************************************************************************
*   Subroutine Name: GetRxEocMessage_AddToFifo
*
*   Description:
*
*     This function checks the Engine EOC data.  If valid,
*  this EOC word is placed into the EOC Fifo and the the EOC data is cleared
*  to prevent this message from being processed again.
*
*     This function is designed as a Time Critical API function.
*
*   Prototype:
*       void GetRxEocMessage_AddToFifo(void)
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   Global Variables:
*
*     gus_RxEocRegister    - 16 bit EOC word
*
*******************************************************************************/

void GetRxEocMessage_AddToFifo()
{

   GetEocMessage(&gus_RxEocRegister);

   /* =======================================================================================   */
   /* if the eoc data is not valid, i.e. if the lsb of both bytes are not set             */
   /* then return                                                          */
   /* =======================================================================================   */
   if ((gus_RxEocRegister & 0x0101) != 0x0101)
   {
      return;
   }

   /* =======================================================================================   */
   /* otherwise, put the new valid message onto the EOC fifo and clear RxEocRegister         */
   /* to prevent this message from being processed a second time.                      */
   /*                                                                   */
   /* =======================================================================================   */

   AddMessageToFifo(&gt_RxEocFifo, gus_RxEocRegister);
   gus_RxEocRegister = 0;

}

