/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   tx_ceoc.c
*
*   DMT Tx Clear EOC processor.
*
****************************************************************************/
// *************************************************************************
// tx_ceoc.c
//
// History
//
//25/03/2014 Sriram Shastry: Changes done for "SMS01261908:Link drop issue during on-hook/off-hook in G.dmt with Catena/Ciena CNX-5 DSLAMs"
//          The fixed includes the following chanages from R3 code
//          1.Disabled Clear EOC indication in CPE G.hs MS for Ciena CO ID CTNW to avoid link drop during phone on-hook/off-hook
//             transitions with a splitter at CPE.
//          2.Reject Clear EOC request from the software(ME) for Catena CO in DMT Mode. This is done to avoid showtime
//             link drop(already there in R4,SMS00825442)
//          3.PLL re-aquisition into ADSL1 Rx C-Reverb3 to train PLL with reference pilot after DEC training state.
//          4.Bug fix in G.dmt only CPE with T1.413 only DSLAM
//             (already there in R4, UTP:SMS00903001)
//        Grep for XDSLRTFW-1658 R4-2 Annex A: SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround
//
// *************************************************************************
#include "common.h"
#include "eoc.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "fifo.h"
#include "gdata.h"
#include "cmv.h"
#include "hs_misc.h"

#define DMT_CEOC_IDLE               0
#define DMT_CEOC_OPENFLAG           1
#define DMT_CEOC_HEADER_BYTE0       2
#define DMT_CEOC_HEADER_BYTE1       3
#define DMT_CEOC_PAYLOAD            4
#define DMT_CEOC_AFTER_ESC_OCTET    5
#define DMT_CEOC_FCS_BYTE0          6
#define DMT_CEOC_FCS_BYTE1          7
#define DMT_CEOC_CLOSE_FLAG            8

int16 gs_DmtCeocState = DMT_CEOC_IDLE;
int16 gs_DmtCeocLength;
int16 gs_DmtCeocIndex;
int16 gs_DmtCeocThrottle=0;

FlagT ME_CEOC_TxProcessor(uint8 *puc_byte)
{
   // for DMT mode, the only message supported is Clear EOC.
   // The whole message buffer is considered CEOC payload.
   FlagT ft_ReturnCode;
   static uint16 us_FCS;

   if ((CNTLArray[CNTL_ME_HDLC] & CNTL_ME_HDLC_ReturnToIdle) != 0)
   {
      STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_IDLE;
      CNTLArray[CNTL_ME_HDLC] &= ~CNTL_ME_HDLC_ReturnToIdle; // CLEAR BIT 2
      gs_DmtCeocState = DMT_CEOC_IDLE;
   }

   if (gs_DmtCeocThrottle > 0)
   {
      // Return a byte every Nth call to this function.
      gs_DmtCeocThrottle--;
      ft_ReturnCode = FALSE;
   }
   else {
      ft_ReturnCode = TRUE;
      switch(gs_DmtCeocState)
      {
      case DMT_CEOC_IDLE:
         if ((CNTLArray[CNTL_ME_HDLC] & CNTL_ME_HDLC_Send) != 0)
         {
            // ME signals a message ready to be sent
              // XDSLRTFW-1658 R4-2 Annex A:SMS01261908 SMS001231692 SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround  - (Start)
            if (gs_CurrentCoChipset == CTNW_CO_CHIPSET)
            {
            // indicate to ME that CLEAR EOC message is being not supported
            // for catena DSLAM. Hence do not send any CLEAR EOC request to the CO.
            // Sending CLEAR EOC to catena results in Showtime Link drop.
            // This problem was observed at KTL lab while conducting TR067 tests
            // in DMT mode.
               STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_MSG_NOT_SUPPORTED;
            }
            else
            {
            // XDSLRTFW-1658 R4-2 Annex A:SMS01261908 SMS001231692 SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround  - (End)
            // indicate that the message is being queued
            STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_MSG_QUEUED;

            // clear the send bit of ME_HDLC Control cmv
            CNTLArray[CNTL_ME_HDLC] &= ~CNTL_ME_HDLC_Send;
            gs_DmtCeocState = DMT_CEOC_OPENFLAG;
            gs_DmtCeocLength = gt_ME_HDLC_Params.s_ME_HdlcTxMsgLength;
            gs_DmtCeocIndex = 0;
            us_FCS = 0xFFFF;
              }   //XDSLRTFW-1658 R4-2 Annex A:SMS01261908 SMS001231692 SMS00825442 IOP_US_DMT_CATENA_ClearEocWorkaround (Start_End)
         }
         ft_ReturnCode = FALSE;
         break;
      case DMT_CEOC_OPENFLAG:
         *puc_byte = 0x7E;
         gs_DmtCeocThrottle = gt_ME_HDLC_Params.s_DmtTxCeocSpacing;
         gs_DmtCeocState = DMT_CEOC_HEADER_BYTE0;
         break;
      case DMT_CEOC_HEADER_BYTE0:
         *puc_byte = 0xFF;
         us_FCS = CalcCRC_Byte(*puc_byte , us_FCS, FCS_GEN_POLY );
         gs_DmtCeocState = DMT_CEOC_HEADER_BYTE1;
         break;
      case DMT_CEOC_HEADER_BYTE1:
         *puc_byte = 0x03;
         us_FCS = CalcCRC_Byte(*puc_byte , us_FCS, FCS_GEN_POLY );
         gs_DmtCeocState = DMT_CEOC_PAYLOAD;
         break;
      case DMT_CEOC_PAYLOAD:
         if (gs_DmtCeocIndex < gs_DmtCeocLength)
         {
            *puc_byte = guca_Tx_ME_HDLCMsgBuffer[gs_DmtCeocIndex++];
            us_FCS = CalcCRC_Byte(*puc_byte , us_FCS, FCS_GEN_POLY );

            // Add octet transparency.
            if ((*puc_byte == 0x7D) || (*puc_byte == 0x7E))
            {
               *puc_byte = 0x7D;
               gs_DmtCeocIndex--;
               gs_DmtCeocState = DMT_CEOC_AFTER_ESC_OCTET;
            }
         }
         else
         {
            ft_ReturnCode = FALSE;
            gs_DmtCeocState = DMT_CEOC_FCS_BYTE0;
         }
         break;
      case DMT_CEOC_AFTER_ESC_OCTET:
         *puc_byte = 0x20 ^ guca_Tx_ME_HDLCMsgBuffer[gs_DmtCeocIndex++];
         gs_DmtCeocState = DMT_CEOC_PAYLOAD;
         break;
      case DMT_CEOC_FCS_BYTE0:
         us_FCS = ~us_FCS;    // 1's complement
         *puc_byte = us_FCS & 0xFF;
         gs_DmtCeocState = DMT_CEOC_FCS_BYTE1;
         break;
      case DMT_CEOC_FCS_BYTE1:
         *puc_byte = us_FCS >> 8;
         gs_DmtCeocState = DMT_CEOC_CLOSE_FLAG;
         break;
      case DMT_CEOC_CLOSE_FLAG:
         *puc_byte = 0x7E;
         STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_MSG_SENT;
         CNTLArray[CNTL_ME_HDLC] &= ~CNTL_ME_HDLC_ReturnToIdle; // CLEAR BIT 2
         gs_DmtCeocState = DMT_CEOC_IDLE;
         //clear gt_RxClearEocBuf_CMV.s_RxClearEocBuf_Disable after a Tx ME-HDLC
         //message is copied from the ME-HDLC buffer in preparation for transmission.
         gt_RxClearEocBuf_CMV.s_RxClearEocBuf_Disable = FALSE;
         break;
      }

      if (ft_ReturnCode)
         gs_DmtCeocThrottle = gt_ME_HDLC_Params.s_DmtTxCeocSpacing;
   }
   return(ft_ReturnCode);
}

