/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   tx_eoc.c
*
*   Source file containing functions and variables for
*   transmitter Embedded Operations Channel (EOC) operations.
*
****************************************************************************/

#include "common.h"
#include "eoc.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "fifo.h"
#include "gdata.h"
#include "xrtstate.h"
#include "cmv.h"

/* =============================================== */
/* constants used by this file and eoc+ini.c */
/* =============================================== */
/* define constants for code clarity */

#define s_tx_eoc_msg_put_ptr           gpt_TxEocHandler->s_tx_eoc_msg_put_ptr
#define s_tx_eoc_msg_get_ptr           gpt_TxEocHandler->s_tx_eoc_msg_get_ptr

#define us_tx_eoc_msg                   gpt_TxEocHandler->us_tx_eoc_msg
#define uca_TxEocOutBuf                 gpt_TxEocHandler->uca_TxEocOutBuf
#define uc_tx_info_buf_index            gpt_TxEocHandler->uc_tx_info_buf_index
#define uc_dgasp_msg_count              gpt_TxEocDgasp->uc_dgasp_msg_count

FlagT ME_CEOC_TxProcessor(uint8 *puc_byte);

/*****************************************************************************
*   Subroutine Name: TxEocHandler
*
*   Description:
*     This subroutine decides which EOC byte is sent in the current sync byte.
*
*   Prototype:
*       uint8 TxEocHandler(int16 s_frame_number);
*
*   Input Arguments:
*       s_frame_number - Data frame number
*
*   Output Arguments:
*     none
*
*  Return:
*     EOC byte for this frame.
*
*   Global Variables:
*     gt_TxEocNetworkHandler
*     gt_TxEocNetworkHandler     - TX EOC Network handler structure with the following variables used:
*        uc_EocAction         -  Read or write or Clear Eoc action
*        c_tx_eoc_info_buf    -  Buffer containing data for clear EOC transmission
*     gt_TxEocHandler
*     gt_TxEocHandler            - TX EOC handler structure with the following variables used:
*        us_tx_eoc_msg           - current echoed tx eoc message
*        uca_TxEocOutBuf[2]      - contains the eoc byte to be x'mited
*        uc_tx_info_buf_index    - index to the buffer containing data to be written into ATU-R data register
*        *puc_tx_eoc_buf          - pointer to the members of ReadEocBuf
*     gt_TxEocDgasp           - TX EOC Dgasp structure with the following variables initialized:
*        uc_dgasp_msg_count      - counter for transmitted Dgasp msgs.
*
*******************************************************************************/
uint8 TxEocHandler(int16 s_frame_number)
{
    uint8 uc_byte;
    int16 s_temp_ptr;

    /*  form eoc message and transmit lower byte in the odd data frame (even numbered data frame) */
    /*  and transmit upper byte in the even data frame (odd numbered data frame) */
    if ((s_frame_number & 0x01) == 0) {
        /*  if Dying Gasp CMV is set, send atleast 12 consecutive DGASP messages. */
      if ((CNTLArray[CNTL_ModemDying] == CNTL_ModemSendDyingGasp) || gs_NE_LPR_indication){
            TxFormEocMsg(EOC_ATU_C, EOC_OPCODE, EOC_ODD_PARITY, 0, OPCODE_DGASP, uca_TxEocOutBuf);
            uc_dgasp_msg_count++;
        }
        else
        { /*  not sending dgasp msg, check if any other autonomous msg. needs to be transmitted */

            if (ME_CEOC_TxProcessor(&uc_byte))
            {
                TxFormEocMsg(EOC_ATU_C, EOC_DATA, EOC_ODD_PARITY, 0, uc_byte, uca_TxEocOutBuf);
            }
            else if(gpt_TxEocNetworkHandler -> uc_EocAction == CLEAR_EOC)
            {
                /*  if autonomous msg. clear eoc, send it once */

            gpt_TxEocNetworkInput->uc_EocAction    = gpt_TxEocNetworkHandler->uc_EocAction;
            gpt_TxEocNetworkInput->c_tx_eoc_info_buf= gpt_TxEocNetworkHandler->c_tx_eoc_info_buf;
            gpt_TxEocNetworkHandler->uc_EocAction     = 0;
            gpt_TxEocNetworkHandler->c_tx_eoc_info_buf   = 0;
                TxFormEocMsg(EOC_ATU_C, EOC_DATA, EOC_ODD_PARITY, 0, gt_TxEocNetworkInput.c_tx_eoc_info_buf, uca_TxEocOutBuf);

            }
            else if(gpt_TxEocNetworkHandler -> uc_EocAction == REQPDN) {
            gpt_TxEocNetworkInput->uc_EocAction    = gpt_TxEocNetworkHandler->uc_EocAction;
            gpt_TxEocNetworkInput->c_tx_eoc_info_buf= gpt_TxEocNetworkHandler->c_tx_eoc_info_buf;
            gpt_TxEocNetworkHandler->uc_EocAction     = 0;
            gpt_TxEocNetworkHandler->c_tx_eoc_info_buf   = 0;
            TxFormEocMsg(EOC_ATU_C, EOC_OPCODE, EOC_ODD_PARITY, 0, OPCODE_REQPDN, uca_TxEocOutBuf);
            }
            else { /*  here process non-autonomous eoc messages */

                if (gft_no_sync_flag == FALSE) {
                    if((s_tx_eoc_msg_get_ptr == s_tx_eoc_msg_put_ptr) && (gft_tx_msg_pending == TRUE))
                    {
                        //if buffer is full, transmit the previous data.
                        s_temp_ptr = s_tx_eoc_msg_get_ptr - 1;
                        if(s_temp_ptr < 0)
                            s_temp_ptr = TX_EOC_MSG_BUF_LEN - 1;

                        uca_TxEocOutBuf[0] = us_tx_eoc_msg[s_temp_ptr] & 0x00FF;
                        uca_TxEocOutBuf[1] = us_tx_eoc_msg[s_temp_ptr] >> 8;
                    }
                    else
                    {
                        if(s_tx_eoc_msg_get_ptr == s_tx_eoc_msg_put_ptr)
                        {
                            uca_TxEocOutBuf[0] = EOC_NO_SYNC_BYTE1;
                            uca_TxEocOutBuf[1] = EOC_NO_SYNC_BYTE2;

                            if((gft_response_to_powerdown == GRANTED) && (gt_EocRxReadBuf.uc_link_state[0] == LINK_STATE_L3))
                            {
                                gs_TxNextState = R_IDLE_LINK_TX;
                                gs_RxNextState = R_IDLE_LINK_RX;
                            }

                        }
                        else
                        {
                            uca_TxEocOutBuf[0] = us_tx_eoc_msg[s_tx_eoc_msg_get_ptr] & 0x00FF;
                            uca_TxEocOutBuf[1] = us_tx_eoc_msg[s_tx_eoc_msg_get_ptr++] >> 8;
                            if(s_tx_eoc_msg_get_ptr >= TX_EOC_MSG_BUF_LEN)
                                s_tx_eoc_msg_get_ptr = 0;
                        }
                    }
                }
                else {
                    uca_TxEocOutBuf[0] = EOC_NO_SYNC_BYTE1;
                    uca_TxEocOutBuf[1] = EOC_NO_SYNC_BYTE2;
                }

            } /*  else { // here process non-autonomous eoc messages */

        } /*  else { // not sending dgasp msg */

        uc_byte = uca_TxEocOutBuf[0]; /*  extract lower byte */

        gus_TxEocRegister = (uca_TxEocOutBuf[0]&0xFF) + ((uca_TxEocOutBuf[1]&0xFF) << 8);

        /* put the EOC message onto the TX EOC fifo */
      AddMessageToFifo(&gt_TxEocFifo, gus_TxEocRegister);

    } /*  if ((s_frame_number....)) */
    else
        uc_byte = uca_TxEocOutBuf[1]; /* extract upper byte */

    /* =============================================================================== */
    /* Return current EOC byte */
    /* =============================================================================== */

    return(uc_byte);
}

/*****************************************************************************
*   Subroutine Name: TxFormEocMsg
*
*   Description:
*     Forms an EOC message.
*
*   Prototype:
*       void TxFormEocMsg(uint8 uc_address, uint8 uc_dataoropcode, uint8 uc_parity, uint8 uc_auto_msg, uint8 uc_information, uint8 *s_txoutbuf);
*
*   Arguments:
*       uc_address      :   (I) Address field, 0 - ATU-R, 3 - ATU-C
*       uc_dataoropcode :   (I) Data or Opcode field, 0 - data, 1 - opcode
*       uc_Parity       :   (I) Parity field, 0 - even parity, 1 - odd parity
*       uc_Auto_msg     :   (I) Autonomous Msg. field
*                           FALSE - Autonomous transfers
*                           TRUE  - ATU-C/ATU-R commands/responses sent to ATU-R/ATU-C
*       uc_information  :   (I) Information field
*       uca_txoutbuf    :   (O) Two bytes of eoc msg is written into this array
*
*******************************************************************************/
void TxFormEocMsg(uint8 uc_address, uint8 uc_dataoropcode, uint8 uc_Parity, uint8 uc_auto_msg, uint8 uc_information, uint8 *uca_txoutbuf)
{

    uca_txoutbuf[0] =  0x3;                              /*  bit 1 is reserved */
    uca_txoutbuf[0] |= ((uc_address &0x03) << 2);        /*  insert address field */
    uca_txoutbuf[0] |= ((uc_dataoropcode & 0x01) << 4);  /*  insert data or opcode field */
    uca_txoutbuf[0] |= ((uc_Parity & 0x01) << 5);        /*  insert parity field */
    uca_txoutbuf[0] |= ((uc_auto_msg & 0x01) << 6);      /*  insert autonomous msg. field */
    uca_txoutbuf[0] |= ((uc_information & 0x01) << 7);   /*  insert bit 6 of information field */

    uca_txoutbuf[1] =  EOC_MESSAGE;                      /*  lsb is set to 1 to indicate eoc msg. */
    uca_txoutbuf[1] |= (uc_information & 0xfe);          /*  insert bit 7-13 of information field */

}

/* undefine constants for code clarity */
#undef s_tx_eoc_msg_put_ptr
#undef s_tx_eoc_msg_get_ptr

#undef us_tx_eoc_msg
#undef uca_TxEocOutBuf
#undef uc_tx_info_buf_index
#undef uc_dgasp_msg_count

