/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodCBGMsg.c
*
*   Source code dealing with message decoding in Exchange Phase.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "rt_state.h"
#include "exchdata.h"
#include "prf_man.h"
#include "cmv.h"     //XDSLRTFW-1721(Start_End)




/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 DecodCBGMsg(void);
*
*   Abstract:
*       Decode C_BG Msg received from ATU-C
*
*   Input Parameters:
*     none
*
*  Return:
*     error code:
*        0 -- no error;
*        1 -- error in rate option
*
*  Global Variables:
*     gsa_US_BitAndGain  -- (I) packed US bits and gains received from ATU-C
*     guca_TxBat[]         -- (O) TX bit allocation table
*     gsa_TxFineGain[]   -- (O) TX fine gain table
*
*-----------------------------------------------------------------------------
^^^*/

int16 DecodCBGMsg(void)
{

   int16 i, i1, s_err_code;

   s_err_code = 0;
   for(i=0; i<(gs_TxNumTones-1); i++) {

      i1 = i+1;

      guca_TxBat[i1] = (uint8) gsa_US_BitAndGain[i] & 0xF;

      if(guca_TxBat[i1] > TX_MAX_BITS_PER_TONE)
         s_err_code++;

      // XDSLRTFW-1721 (start)
      if (TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
      {
         gsa_TxFineGains[i1] = 0x2000;       // Q3.13 Format
      }
      else
      {
         gsa_TxFineGains[i1] = (gsa_US_BitAndGain[i] & 0xFFF0);
      }
      //XDSLRTFW-1721 (End)

   }

   guca_TxBat[0] = 0;
   gsa_TxFineGains[0] = 0;

   return(s_err_code);
}



