/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodCInfo2.c
*
*   Source code dealing with message decoding in Exchange Phase.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "rt_state.h"
#include "exchdata.h"
#include "prf_man.h"
#include "plam.h"
#include "cmv.h"



/* =============================================== */
/* static function prototypes */
/* =============================================== */
int16 DecodUSRateOption(void);

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 DecodCInfo2(void);
*
*   Abstract:
*       Decode C_MSG2 and C_RATES2 received from ATU-C
*
*   Input Parameters:
*     none
*
*  Return:
*     error code:
*        0 -- no error;
*        1 -- error in rate option
*
*  Global Variables:
*     gsa_RCMsg2[]   -- (I) packed 32-bits C_MSG2 received from ATU-C
*     gs_RCRate2     -- (I) packed 8-bit C_RATES2 received from ATU-C
*     gt_RCMsg2      -- (O) structure of decoded C_MSG2
*     gs_DS_RateOption -- (O) selected downstream rate option
*     gs_US_RateOption -- (O) selected upstream rate option
*
*-----------------------------------------------------------------------------
^^^*/
int16 DecodCInfo2(void)
{
   int16 s_err_code, s_DS_RateOption = 0;

   /* ================================================================== */
   /*  Decode C_MSG2 */
   /* ================================================================== */

   /* decode m0 to m8, total number of bits supported */
   gt_RCMsg2.s_TotalBitsSupported = gsa_RCMsg2[0];
   gt_RCMsg2.s_TotalBitsSupported |= ((gsa_RCMsg2[1]&0x1)<<8);
   //Corrected type casting. Code changes added during XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm (Start)
    /* Report US Attainable Data Rate in bits/sec */
    gt_FarEndParam.ul_AttainableDataRate =  ((uint32) (gt_RCMsg2.s_TotalBitsSupported * 4000));
   //Corrected type casting. Code changes added during XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm (End)

   /* decode m16 to m20, performance margin with selected rate option */
   gt_RCMsg2.us_PerformMargin = (uint16)(gsa_RCMsg2[2]&0x1F);

   // save the value into far end test paramter structure
   gt_FarEndParam.s_SnrMargin = (gt_RCMsg2.us_PerformMargin)*10;
#ifdef ISDN   // Workaround for US SNRM reporting for ECI-32 (Anaconda)
   if (gs_CurrentCoChipset == ANCDA_CO_CHIPSET)
   {
      if (gt_FarEndParam.s_SnrMargin < 310 && gt_FarEndParam.s_SnrMargin >= 280)
         gt_FarEndParam.s_SnrMargin -= 65;
      else if (gt_FarEndParam.s_SnrMargin <= 270 && gt_FarEndParam.s_SnrMargin >= 250)
         gt_FarEndParam.s_SnrMargin -= 50;
      else if (gt_FarEndParam.s_SnrMargin <= 240 && gt_FarEndParam.s_SnrMargin >= 180)
         gt_FarEndParam.s_SnrMargin -= 40;
      else if (gt_FarEndParam.s_SnrMargin <= 170 && gt_FarEndParam.s_SnrMargin >= 90)
         gt_FarEndParam.s_SnrMargin -= 20;
      else
         ;
   }
#endif

   /* decode m21,  Erase all stored profiles */
   gt_RCMsg2.us_EraseStoredProfiles = (uint16)((gsa_RCMsg2[2]>>5)&0x1);

#ifdef INCLUDE_FASTRETRAIN_CODE
   /*Erase all stored TX profiles if us_EraseStoredProfiles = 1; */
   if (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) {
      if(gt_RCMsg2.us_EraseStoredProfiles == 1) {
         EraseAllProfiles((FlagT)TX);
      }
   }
#endif

   /* decode m26 to m31, estimated average loop attenuation */
   gt_RCMsg2.us_AvLoopAttenu = ((gsa_RCMsg2[3]>>2)&0x3F);

   // save the value into far end test paramter structure
   gt_FarEndParam.us_LoopAttenuation = (gt_RCMsg2.us_AvLoopAttenu)*5;
   gt_FarEndParam.us_SignalAttenuation = gt_FarEndParam.us_LoopAttenuation;

   /* ================================================================== */
   /*  Decode C_RATES2 */
   /* ================================================================== */
   s_err_code = 0;


      switch((gs_RCRates2 >> 4)) {
   case 0x1:
      s_DS_RateOption = RATE_OPTION1;
        s_err_code = DecodUSRateOption();
        break;

    case 0x2:
      s_DS_RateOption = RATE_OPTION2;
        s_err_code = DecodUSRateOption();
        break;

    case 0x4:
      s_DS_RateOption = RATE_OPTION3;
        s_err_code = DecodUSRateOption();
        break;

    case 0x8:
      s_DS_RateOption = RATE_OPTION4;
        s_err_code = DecodUSRateOption();
        break;

    case 0x0:
        if ((gs_RCRates2 & 0x0F) == 0) {
            gs_US_RateOption = ALL_OPTIONS_FAIL;
            s_DS_RateOption = ALL_OPTIONS_FAIL;
            s_err_code = 1;
        }
        else
            s_err_code = 1;
        break;
    default:
        s_err_code = 1;
        break;
    }

    /*  check if the downstream rate option has changed from that selected in R_RATES2 message */
    /*  return error if it is changed. */
    if (s_DS_RateOption != gs_DS_RateOption) {
        s_err_code = 1;
    }
    gs_DS_RateOption = s_DS_RateOption;

   return(s_err_code);
}

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 DecodUSRateOption(void);
*
*   Abstract:
*       Decode C_RATES2 received from ATU-C for US Rate Option information
*
*   Input Parameters:
*     none
*
*  Return:
*     error code:
*        0 -- no error;
*        1 -- error in rate option
*
*  Global Variables:
*     gs_RCRates2    -- (I) packed 8-bit C_RATES2 received from ATU-C
*     gs_US_RateOption    -- (O) selected upstream rate option
*
*-----------------------------------------------------------------------------
^^^*/
int16 DecodUSRateOption(void)
{
   int16 s_err_code;

    s_err_code = 0;
    switch((gs_RCRates2 & 0x0F)) {
        case 0x1:
            gs_US_RateOption = RATE_OPTION1;
         break;
        case 0x2:
            gs_US_RateOption = RATE_OPTION2;
         break;
        case 0x4:
            gs_US_RateOption = RATE_OPTION3;
         break;
        case 0x8:
            gs_US_RateOption = RATE_OPTION4;
         break;
        default:
            s_err_code = 1;
         break;
    }
    return(s_err_code);
}


