/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRInfo2.c
*
*   Source code dealing with message formatting in Exchange Phase.
*
*-------------------------------------------------------------------------
*/
//******************************************************************************
// FormRInfo2.c
//
// History
//
// 09/08/2010 Nihar : Added the code changes to skip the excess margin reduction using finegains
//                for   pilot tone in ALL modes.
//             Grep for Perf_DS_ALL_ALL_Pll_NoExMarginReduction
//
//******************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "rt_state.h"
#include "exchdata.h"
#include "prf_man.h"
#include "decimalgain.h"
#include "cmv.h"
#include "memsetbf.h"
#include "exchmsgs.h"
#include "T1413.h"

extern int16 gs_AuxPilotToneIdx;       /* aux pilot tone index */
extern int16 gs_CPilotTone;            /* cpilot tone index */

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRInfo2(void);
*
*   Abstract:
*       Formats R_B&G, R_MSG2, R_RATES2 messages to be sent to ATU-C
*
*   Input Parameters:
*     none
*
*  Global Variables:
*     gsa_RxFineGains[] -- (I) fine gain table (in Q3.13)
*     gsa_RxBat[]    -- (I) bit allocation table
*     gt_RMsg2    -- (I) R_MSG2 data structure
*
*     gpsa_DS_BitAndGain[]  -- (O) packed DS B&G table to be sent to ATU-C
*     guca_RMsg2[]      -- (O) packed R_MSG2 data to be sent to ATU-C
*     guc_RRates2       -- (O) packed DS rate option
*-----------------------------------------------------------------------------
^^^*/

void FormRInfo2(void)
{
    int16 i;

    int16 s_RxFineGain;

    uint16 us_SnrMargin, us_AvLoopAttenu;

    /* ============================================================= */
    /* Clear BitAndGain array                                        */
    /* This buffer is length RX_NUM_TONES in Annex A,B.              */
    /* This buffer is 2xRX_NUM_TONES in Annex C due to support       */
    /* dual bit tables                                               */
    /* ============================================================= */

    // mapped to: int16 gsa_CommonTwidMem[1762]
    //
    // gsa_CommonTwidMem
    // Memory section: DATA_MAP_deILV2_BIS
    // State (from ... to)                   | mapped pointer
    // --------------------------------------+----------------------------------------------
    // EstimateChannel                       | gsa_twid_real256, gsa_twid_imag256, gsa_sk_tab256, gsa_bit_reverse_idx256
    // BgAlignmentTraining                   |
    //      - RCReverbFrameSyncFdq           |
    //         - RCReverb2RxF                |
    //         - RCReverb3RxF_BIS            |
    // BgChannelEstimateForHLin              |
    //      - RCReverbFrameSyncFdq           |
    //         - RCReverb2RxF                |
    //         - RCReverb3RxF_BIS            |
    // --------------------------------------+----------------------------------------------
    // FormRInfo2                            | gpsa_DS_BitAndGain
    //      - SelectRateOptionForRMsg2       |
    //         - RCReverbRARxF               |
    //            - RCCrcRARxF               |
    // RBGTxF                                |
    //      - RSegue4TxF                     |
    //         - RReverb5TxF                 |
    // --------------------------------------+----------------------------------------------
    // BgFormRParams                         | guca_R_PARAMS_bis
    //      - RCMsg2RxF_BIS                  |
    //         -  RCExchMarkerRxF_BIS        |
    //  RxInit                               |
    //      - InitShowTimeRx                 |
    //         -  BgInitShowTimeRx           |
    //            - RCMedleyRxF_RxInit_BIS   |
    //            - RCRev5_CSRxF             |
    // --------------------------------------+----------------------------------------------

    memset(gpsa_DS_BitAndGain, 0, (sizeof(int16))*((int16)(RX_NUM_TONES)));


    /* ============================================================= */
    /* Form R_B&G message */
    /* ============================================================= */

    for(i=0; i<gs_RxNumTones; i++)
    {
        if (OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable)
        {
            s_RxFineGain = DecimalGain(gsa_RxFineGains[i]);
        }
        else
        {
            // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (START)
            //Skip Pilot Tone
            if ((i == gs_CPilotTone) || (i == gs_AuxPilotToneIdx))
            {
                s_RxFineGain = DecimalGain(gsa_RxFineGains[i]);
            }

            else
            {
                /* Reduce fine gains if excess margin reduction is on. */
                s_RxFineGain = (int16) (((int32) DecimalGain(gsa_RxFineGains[i]) * gt_FineGainInfo.s_ExcessMarFGReduction) >> 13);
            }
            // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (END)
        }

        // round and mask off 4 LSBs (convert 3.13 to 3.9 format):
        gpsa_DS_BitAndGain[i]  = (s_RxFineGain + (1 << 3)) & 0xFFF0;
        gpsa_DS_BitAndGain[i] |= (guca_RxBat[i] & 0xF); // OR in constellation size

    }


    /* ============================================================= */
    /* Form R_MSG2 */
    /* ============================================================= */
    memset(guca_RMsg2, 0, (sizeof(uint8))*((int16)R_MSG2_TX_LEN));

    /* m0 to m11, total number of bits supported */
    guca_RMsg2[0] = (uint8)(gt_RMsg2.s_TotalBitsSupported & 0xFF);
    guca_RMsg2[1] = (uint8)((gt_RMsg2.s_TotalBitsSupported >> 8) & 0x0F);

    /* m16 to m20, performance margin with selected rate option */
    us_SnrMargin = gt_RMsg2.us_PerformMargin;
#ifndef ISDN
    if ((STATArray[STAT_Mode] & STAT_ConfigMode_T1413) && (gs_fe_T1413_VendorID == T1413_TI_ID))
#else
    if ((STATArray[STAT_Mode1] & STAT_ConfigMode_ETSI_AnnexC) && (gs_fe_T1413_VendorID == T1413_TI_ID))
#endif
    us_SnrMargin = (uint16)(gs_RxDesiredMargin>>8);

    if (us_SnrMargin > 0x1F)
    us_SnrMargin = 0x1F;

    guca_RMsg2[2] = (uint8)us_SnrMargin;

    /* m21, erase all stored profiles */
    guca_RMsg2[2] |= (uint8)(gt_RMsg2.us_EraseStoredProfiles<<5);

    /* m25 to m31, average upstream loop attenuation */
    us_AvLoopAttenu = (gt_RMsg2.us_AvLoopAttenu > 0x7F) ? 0x7F:gt_RMsg2.us_AvLoopAttenu;
    guca_RMsg2[3] = (uint8)(us_AvLoopAttenu<<1);

    /* ============================================================= */
    /* Form R_RATES2  */
    /* ============================================================= */
    guc_RRates2 = FormRRatesRA(gs_DS_RateOption);
}

