/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsgRA.c
*
*   Source code dealing with message formatting in Exchange Phase.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// FormRMsgRA.c
//
// History
//
// 08/07/10  Nihar: Added code to resolve the interop issues with ADI/Anaconda in DMT/RA/Fast mode
//              Disable CO rate generation and CO calculation of DS framing parameters
//             by setting Ncloaded (Number of DS tones loaded) to "0"
//             If Target margin in C-MSG-1 is not correct estimate DS min-margin and do retrain
//             with correct min-margin if estimation was wrong
//             By default it is disabled. To enable it set bit 0 of OPTN 25 0
//             grep for "IOP_DS_DMT_ADI_SendNcloadedEqualToZero"
//
// 25/03/2013 Ram: Merged fix for JIRA-774 from ARX ADSL FW. See JIRA for more details
//                This issue seems to be related to Coding Gain. Coding Gain value computed
//                as 8dB(->16 in 0.5 steps). But we cannot represent coding gain value of
//                16( 0.5dB steps) in RMSG-RA. In RMSG-RA we have only 4 bits (std) for
//                Coding gain so max value is 15 ie., 7.5dB. So, proposed workaround here
//                is Limit the Max Coding Gain reporting to 15 (7.5dB).
//                Grep for XDSLRTFW-774: BugFix_DS_ADSL1T1413_All_CGinRMSGRA
// ******************************************************************

#include "common.h"
#include "gdata.h"
#include "rt_state.h"
#include "exchdata.h"
#include "prf_man.h"
#ifdef ISDN
// IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start_End)
#include "rinfotbl.h"
#endif
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRMsgRA(void)
*
*   Abstract:
*       Pack R_MSG_RA in to 10 bytes for transmission
*
*   Input Parameters:
*
*  Output Parameter:
*
*  Global Variables:
*     gt_RMsgRA      -- (I) structure containing R_MSG_RA information
*     guca_RMsgRATab    -- (O) packed R_MSG_RA data
*
*-----------------------------------------------------------------------------
^^^*/

void FormRMsgRA(void)
{
   int16 i;
   uint16 us_SnrMargin, us_AvLoopAttenu;
   // XDSLRTFW-774: BugFix_DS_ADSL1T1413_All_CGinRMSGRA (Start End)
   uint16 us_CodingGain;

   /* ============================================================= */
   /* Form R_MSG_RA message */
   /* ============================================================= */
   for(i=0; i<R_MSG_RA_NUM_BYTES; i++)
      guca_RMsgRATab[i] = 0;

    /* m0 to m11: total number of bits per DMT symbol, Bmax */
   guca_RMsgRATab[0] = (uint8)(gt_RMsgRA.us_TotalBitsPerSymbol & 0xFF); /*  m0 to m7     */
   guca_RMsgRATab[1] = (uint8)((gt_RMsgRA.us_TotalBitsPerSymbol >> 8) & 0xF); /*  m8 to m11     */

   /* set bit 12 to 0 and bit 13 to 0 */
    guca_RMsgRATab[1] &= 0xCF;
    gt_RMsgRA.us_MaxInterleaveDepth = DMAX_64;

    /* m14 to m15, reserved */

   /* m16 to m20: performance margin with selected rate option */
   us_SnrMargin = (gt_RMsgRA.us_SnrMargin > 0x1F) ? 0x1F:gt_RMsgRA.us_SnrMargin;
   guca_RMsgRATab[2] = (uint8)us_SnrMargin; /*  m16 to m20     */

   /* m21 to m24: coding gain */
   // XDSLRTFW-774: BugFix_DS_ADSL1T1413_All_CGinRMSGRA (Start)
   //guca_RMsgRATab[2] |= (uint8)((gt_RMsgRA.us_CodingGain & 0x7) << 5); /*  m21 to m23     */
   //guca_RMsgRATab[3] = (uint8)((gt_RMsgRA.us_CodingGain >> 3) & 0x1); /*  m24     */

   us_CodingGain = (gt_RMsgRA.us_CodingGain);
   // Limit CodingGain reporting to max value 15 (7.5dB)
   us_CodingGain = (us_CodingGain > MAX_CODING_GAIN) ? MAX_CODING_GAIN : us_CodingGain;
   guca_RMsgRATab[2] |= (uint8) ((us_CodingGain & 0x7) << 5); /* m21 to m23 */
   guca_RMsgRATab[3] = (uint8) ((us_CodingGain >> 3) & 0x1);  /* m24 */
   // XDSLRTFW-774: BugFix_DS_ADSL1T1413_All_CGinRMSGRA (End)

    /* m25 to m31: estimated average loop attenuation */
   us_AvLoopAttenu = (gt_RMsgRA.us_AvLoopAttenu > 0x7F) ? 0x7F:gt_RMsgRA.us_AvLoopAttenu;
   guca_RMsgRATab[3] |= (uint8)( us_AvLoopAttenu << 1); /*  m25 to m31     */

    /* m32 to m39: number of tones carrying data (ncloaded) */
    guca_RMsgRATab[4] = (uint8)gt_RMsgRA.us_ncloaded; /*  m32 to m39     */

#ifdef ISDN
   // IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start)
   if (gft_ADI_ANCDA_minSNR_flag)
      // Send No. of loaded bins = 0
      guca_RMsgRATab[4] = 0; /*  m32 to m39     */
   // IOP_DS_DMT_ADI_SendNcloadedEqualToZero (End)
#endif

   /* m40 to m48: number of RS payload bytes (K) */
    guca_RMsgRATab[5] = (uint8)(gt_RMsgRA.us_K & 0xFF); /*  m40 to m47     */
   guca_RMsgRATab[6] = (uint8)((gt_RMsgRA.us_K >> 8) & 0x1); /*  m48     */

   /* m49 to m55: number of RS check bytes (R) */
    guca_RMsgRATab[6] |= (uint8)((gt_RMsgRA.us_R & 0x7F) << 1); /*  m49 to m55     */



}

