/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRRatesRA.c
*
*   Source code dealing with message formatting in Exchange Phase.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "rt_state.h"
#include "exchdata.h"
#include "prf_man.h"






/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       uint8 FormRRatesRA(int16 uc_option_number)
*
*   Abstract:
*       Form R-RATES-RA and R-RATES2 messages based on the downstream rate
*       option selected based on the measured SNR  of the downstream channel.
*
*   Input Parameters:
*     uc_option_number     -- (I) The rate option selected
*
*  Output Parameters:
*     uc_RRates            -- (O) Rate message to be transmitted
*
*-----------------------------------------------------------------------------
^^^*/
uint8 FormRRatesRA(int16 uc_option_number)
{
   uint8 uc_RRates;

   /* ================================================================= */
   /* Form R-RATES-RA or R-RATES2 information */
   /* ================================================================= */
   uc_RRates = 0x00;    // ALL_OPTIONS_FAIL (default)
   switch(uc_option_number)
   {
   case RATE_OPTION1:
      uc_RRates = 0x11;
      break;

   case RATE_OPTION2:
      uc_RRates = 0x22;
      break;

   case RATE_OPTION3:
      uc_RRates = 0x44;
      break;

   case RATE_OPTION4:
      uc_RRates = 0x88;
      break;

   case NO_RATE_OPTION_SELECTED:
      uc_RRates = 0x01;
      break;
   }
   return(uc_RRates);
}


