/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RBGTxF.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "showinit.h"
#include "fifo.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "states.h"
#include "RCrc5TxF.h"





/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RBGTxF
 *
 *  Description: Transmits the bit allocation and fine gain information
 * that are to be used on the downstream carriers. Because no bits or energy
 * will be transmitted at dc or one-half the sampling rate, b0, g0, b128, g128
 * are all presumed to be zero and shall not be transmitted. Because sub-carrier
 * 64 is reserved as the pilot tone, b64, shall be set to 0 and g64 shall be set to 1.
 * The R-B&G information shall be mapped in a 4080 bit (=255*16 = 510 bytes) message m
 * defined by:
 * m = {m4079, m4078, ..., m1, m0} = {g255, b255, ..., g1, b1}
 *  with the msb of bi and gi in the higher m index and m0 being transmitted first.
 * R_CRC5 is computed over R-B&G message.
 * (Take 510 symbols)
 *
 *  Prototype: void RBGTxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gpsa_DS_BitAndGain[]   - (I) pre-packed downstream B&G sequence
 *      gsa_TxToneBuf[]       - (O) frequency domains samples
 *                                (set in TxReverbSegueSetUp() )
 *      gl_TxSymbolCount      - (I) # symbol periods in current TX state
 *      gs_TxNextState        - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_BG_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RBGTxF(void) {

   int16 s_idx, s_byteNum;
   uint8 uc_byte;
   uint16  us_infobit;
   int16    i;

   if(gl_TxSymbolCount == 0) {
      gft_IFFT_On=TRUE;

      gus_R_CRC = 0x0000;
      gs_TxSubStateCnt = 0;
   }



   /* extract next byte */
   s_idx = gs_TxSubStateCnt >> 1;
   s_byteNum = (int16)(gs_TxSubStateCnt & 0x1);
   uc_byte = (uint8)((gpsa_DS_BitAndGain[s_idx+1]>>(s_byteNum*8))&0xFF);
   gs_TxSubStateCnt++;

   /* compute CRC for current 8 bits */
   for(i=0; i<8; i++) {

      /* extract bit */
      us_infobit = (uint16)((uc_byte >> i) & 0x1);

      /*  computed 16-bit CRC */
      CalcCRC16(&gus_R_CRC, us_infobit);
   }

   /* encode and transmit one byte of message */
   TxExchSig(uc_byte, (int16)NR_MSGS1, (int16)NR_MSGS2, (int16)ENCGAIN2);

   if(gs_TxSubStateCnt == R_BG_TX_LEN) {
      gs_TxNextState = R_CRC5_TX;
      gpF_TxStateFunc = (PtrToFunc)RCrc5TxF;
   }


}

