/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCBGRxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "states.h"
#include "RCCrc3RxF.h"




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCBGRxF
 *
 *  Description: R_C_BG_RX receives bits and gains information from the
 * ATU-C. A total of 62 bytes (= 31 tones x 2 byte/tone) are transmitted
 * using the same signaling method as that used for transmitting C_MSGS2.
 * In this configuration, only the first gs_TxNumTones number of tones are
 * of interest. (Take 62 symbols)
 *
 *  Prototype: void RCBGRxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gus_RC_CRC_computed  - (O) computed CRC over B&G table
 *      gsa_RxToneBuf[]      - (I) output of FDQ (set in GetRxTones())
 *    gsa_US_BitAndGain    - (O) decoded bits and gains information
 *      gl_RxSymbolCount     - (I) number of symbol periods in current state
 *      gs_RxNextState       - (O) RX state beginning next symbol period
 *
 *  Notes: implements state R_C_BG_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCBGRxF(void) {

   uint16  us_infobit;
    int16    i, idx;
   uint8 uc_byte, uc_backup_byte, uc_mean_byte;
   int16 s_R_C_BG_RX_LEN;


   s_R_C_BG_RX_LEN = (2*gs_TxNumTones-2);


    if (gl_RxSymbolCount == 0) {

      /* set B&G buffer to zero */
      memset(gsa_US_BitAndGain, 0, sizeof(int16)*(R_C_BG_RX_LEN>>1));
      memset(gsa_US_BitAndGain2, 0, sizeof(int16)*(R_C_BG_RX_LEN>>1));
      memset(gsa_RxExchMsg1, 0, sizeof(int16)*(R_C_BG_RX_LEN>>1));

        gus_RC_CRC_computed = 0x0000;
      gus_RC_bkpCRC_computed = 0;
      gus_RC_meanCRC_computed = 0;

      gs_RxSubStateCnt = 0;
    }



   /* Get current byte of C_BG */
   RxExchSig(gsa_RxToneBuf, (int16)NC_MSGS1, (int16)NC_MSGS2, &uc_byte, &uc_backup_byte, &uc_mean_byte);

   /* Put into B&G table */
   /* Note:  Must use substate counter because Annex C must skip NEXT symbols */
   idx = (int16)gs_RxSubStateCnt>>1;
   if(gs_RxSubStateCnt & 1) {

      gsa_US_BitAndGain[idx] |= ((int16)uc_byte) << 8;
      gsa_US_BitAndGain2[idx] |= ((int16)uc_backup_byte) << 8;
      gsa_RxExchMsg1[idx] |= ((int16)uc_mean_byte) << 8;
   }
   else {

      gsa_US_BitAndGain[idx] = (int16)uc_byte;
      gsa_US_BitAndGain2[idx] = (int16)uc_backup_byte;
      gsa_RxExchMsg1[idx] = (int16) uc_mean_byte;
   }

    /* Compute CRC for the current byte */
   for(i=0; i<8; i++) {
      us_infobit = (uint16)((uc_byte >> i) & 0x1);
      CalcCRC16(&gus_RC_CRC_computed, us_infobit);

      us_infobit = (uint16)((uc_backup_byte >> i) & 0x1);
      CalcCRC16(&gus_RC_bkpCRC_computed, us_infobit);

      us_infobit = (uint16)((uc_mean_byte >> i) & 0x1);
      CalcCRC16(&gus_RC_meanCRC_computed, us_infobit);
   }

   gs_RxSubStateCnt++;
   if (gs_RxSubStateCnt == s_R_C_BG_RX_LEN) {
      gs_RxNextState = R_C_CRC5_RX;
      gpF_RxStateFunc = (PtrToFunc)RCCrc3RxF;
   }
}

