/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCCrc3RxF.c
 *
 *
 *------------------------------------------------------------------------
 */

// ******************************************************************
// RCCrc3RxF.c
//
// History
//
// 14/10/2011 Raghu : PLL Scaling in RCCrc3Rx.c is moved to Medley_b.c with a CMV control "INFO 103 27 0x1000".
//                    Grep for XDSLRTFW-316
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(C-RATES2 and C-MSG2)-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// ******************************************************************


#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "DecodCInfo1.h"
#include "DecodCInfoRA.h"
#include "states.h"
#include "RCBGRxF.h"
#include "RCReverb5RxF.h"
#include "RCMsg2RxF.h"
#include "RCReverbRARxF.h"
#include "trail.h"

//XDSLRTFW-316 (Start_End)
#include "cmv.h"

#include "codeswap.h"
#include "showinit.h"
#include "DSLEngin.h"
#include "DebugBuffer.h"
#ifdef TARGET_HW
   #include "aux_regs.h"
   #ifdef DANUBE
   #include "cmv.h"
   #include "cmv_Data.h"
   #include "trail.h"
   #include "dataswap.h"
   #endif
#endif
#ifdef ADSL_62
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
#endif


int16 *gpsa_RxExchMsg;
int16 gs_RxExchMsgLength;

/*^^^
 *---------------------------------------------------------------------------------
 *
 *  Name: RCCrc3RxF
 *
 *  Description: Decodes the R_C_CRC3 information and compares to the
 *  CRC computed on the received R_C_MSGS2 information.
 * (Take 2 symbols)
 *
 *  Prototype: void RCCrc3RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   - (I) R_C_CRC3 computed over recevied R_C_MSGS2
 *      gus_RC_CRC_received   - (I/O) R_C_CRC3 recevied
 *      gsa_RxToneBuf[]     - (I) output of FDQ (set in GetRxTones() )
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *
 *  Notes: implements states R_C_CRC3_RX, R_C_CRC4_RX, R_C_CRC5_RX, R_C_CRC_RA1_RX,
 *  and R_C_CRC_RA2_RX
 *
 *---------------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void RCCrc3RxF(void) {

   uint8 uc_byte, uc_backup_byte, uc_mean_byte;
   int16 i, s_err, *psa_CorrectMessage;

    /*  clear received RC_CRC3     */
    if (gl_RxSymbolCount == 0) {
      gus_RC_CRC_received = 0x0000;
      gus_RC_bkpCRC_received = 0x0000;
      gus_RC_meanCRC_received = 0x0000;

      gs_RxSubStateCnt = 0;
    }



   /* Demodulate current byte of C_MSGS2 */
   RxExchSig(gsa_RxToneBuf, (int16)NC_MSGS1, (int16)NC_MSGS2, &uc_byte, &uc_backup_byte, &uc_mean_byte);

   /* Put into gus_RC_CRC_received */
   gus_RC_CRC_received = gus_RC_CRC_received | (uint16)((uint32)uc_byte<<(gs_RxSubStateCnt*8));
   gus_RC_bkpCRC_received = gus_RC_bkpCRC_received | (uint16)((uint32)uc_backup_byte<<(gs_RxSubStateCnt*8));
   gus_RC_meanCRC_received = gus_RC_meanCRC_received | (uint16)((uint32)uc_mean_byte<<(gs_RxSubStateCnt*8));

   gs_RxSubStateCnt++;

    /*  compare CRC's when all bits received */
   if (gs_RxSubStateCnt == R_C_CRC3_RX_LEN) {


      if ((gus_RC_CRC_received == gus_RC_CRC_computed) ||
         (gus_RC_bkpCRC_received == gus_RC_bkpCRC_computed) ||
         (gus_RC_meanCRC_received == gus_RC_meanCRC_computed)) {

         /* ============================================================ */
         /* if the primary CRC is bad */
         /* then move secondary message to primary buffer */
         /* ============================================================ */

         if(gs_RxState == R_C_CRC5_RX) {

            if(gus_RC_CRC_received != gus_RC_CRC_computed) {

               psa_CorrectMessage = gsa_US_BitAndGain2;
               if(gus_RC_bkpCRC_received != gus_RC_bkpCRC_computed)
                  psa_CorrectMessage = gsa_RxExchMsg1;

               memcpy(gsa_US_BitAndGain, psa_CorrectMessage, gs_TxNumTones * sizeof(int16));
            }

         }
         else {

            if(gus_RC_CRC_received != gus_RC_CRC_computed) {

               if(gus_RC_bkpCRC_received != gus_RC_bkpCRC_computed)
               {
                  memcpy(gpsa_RxExchMsg, gsa_RxExchMsg1, gs_RxExchMsgLength * sizeof(int16));
               }
               else
               {
                  for(i=0; i<gs_RxExchMsgLength; i++)
                     gpsa_RxExchMsg[i] >>= 8;
               }
            }
            for(i=0; i<gs_RxExchMsgLength; i++)
               gpsa_RxExchMsg[i] &= 0xff;

         }
         //XDSLRTFW-3674 bug correction for logging(start)
#ifdef DEBUG_TRACES // XDSLRTFW-597
      //to differentiate between C_MSG2 and C_RATES2
      if(gpsa_RxExchMsg == gsa_RCMsg2)
      {
         LogMessages(4,NOT_END_OF_MSG,(uint16)C_MSG2_DMT_MSG,(R_C_MSG2_RX_LEN<<1), (uint8 *)(void *)(gsa_RCMsg2), DEBUG_BUFFER_DELIMITER_ADSL);
         LogMessageSegments(NOT_END_OF_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
         LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_bkpCRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
      }
      else if(gs_RxState == R_C_CRC4_RX)
      {
         LogMessages(4,NOT_END_OF_MSG,(uint16)C_RATES2_DMT_MSG,2, (uint8 *)(void *)(&gs_RCRates2), DEBUG_BUFFER_DELIMITER_ADSL);
         LogMessageSegments(NOT_END_OF_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
         LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_bkpCRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
      }
      //XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES
#ifdef DEBUG_STREAMING
      if(gpsa_RxExchMsg == gsa_RCMsg2)
      {
         DSH_SendStream(DSH_C_MSG2,(R_C_MSG2_RX_LEN<<1),&gsa_RCMsg2[0]);
      }
      else if(gs_RxState == R_C_CRC4_RX)
      {
         DSH_SendStream(DSH_C_RATES2,sizeof(gs_RCRates2),&gs_RCRates2);
      }
#endif
      //XDSLRTFW-3674 bug correction for logging(end)
         /* ============================================================ */
         /*  CRC's match:  continue to next state */
         /* ============================================================ */

         switch(gs_RxState) {

         case R_C_CRC3_RX:

            gs_RxNextState = R_C_RATES2_RX;
            gpF_RxStateFunc = (PtrToFunc)RCMsg2RxF;
            break;

         case R_C_CRC4_RX:

            /* Decode C_MSG2 and C_RATES2 messages */
            s_err = DecodCInfo2();

            if(s_err) {
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_RCCRC4Rx_CMSGS2_DECOD_ERR;
            }
            else {

               /*  Continue with R_C_BG_RX state */
               gs_RxNextState = R_C_BG_RX;
               gpF_RxStateFunc = (PtrToFunc)RCBGRxF;
            }
            break;

         case R_C_CRC5_RX:

            /* Decode C_BG messages */

            s_err = DecodCBGMsg();


            /* If C_BG decoding returns error, go to FAIL state */
            /* otherwise, go to R_C_REVERB5 */
            if(s_err) {
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_RCCRC5Rx_C_BG_DECOD_ERR;
            }
            else {

               /*  Set the flag to indicate C_EXCH2 has been correctly received */
               //gft_RCExch2RcvFlag = RECEIVE_OK1;       //ADR: now when Txinit is in

               /* Switch to Aux Pilot Tone */
                    // XDSLRTFW-316 : Code changes during incorporating fix for "Changing PLL bandwidth"
                    // XDSLRTFW-316:PLL bandwidth is changed based pilot tone reverb SNR.
               if (!(gt_INFX_CMV.us_OperatorSpBits5 & (CMV_TO_BYPASS_PLL_BW_CHANGE_IN_SHOWTIME)))
               {
                  if(gft_AuxPilot == AUX_PILOT_ACTIVE)
                  {
                     gs_PilotToneIdx = gs_AuxPilotToneIdx;
                     ScalePLL(gs_PllScaling);
                  }
                    }

               /*  Continue with R_C_REVERB5_RX state */
               gs_RxNextState = R_C_REVERB5_RX;
               gpF_RxStateFunc = (PtrToFunc)RCRev5_CSRxF ;

            }
            break;

         }  /* ends switch() */
        }
        else {
            /* ============================================================ */
            /*  CRC's don't match:  go to FAIL state */
            /* ============================================================ */
            gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCCRC3Rx_DECOD_ERR;
        }
    }
}


C_SCOPE void RCRev5_CSRxF(void)
{
   if (gl_RxSymbolCount == 0)
      gs_RxSubStateCnt = 0;

   switch(gs_RxSubState) {

      case 0:
         // RxInit should already be in so it can run;
         // Have to get in EXCHDMT relatively quickly and arrange for Txinit too
            gs_RxSubState = 1;
         /* Start initializing Showtime RX */
         guc_ShowTimeRxState = TRAINING_IN_PROGRESS;  /* indicates the BG is active */
#ifdef ADSL_62
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ClearRxZephyrRegs);
#endif
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeRx);
         guc_RxDataPumpState = TRAINING_WAITING;
         break;

        case 1:
#ifdef TARGET_HW
#ifdef ADSL_62
         if (gs_CodeSwapStatus==CODESWAP_IDLE)
         {
            if (gs_CodeSwapSection==CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP0)
            {
               int i, lp0, lp1;

               lp1 = lp0 = 0;
               for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
               {
                  lp1 += (int16) gta_US_options[gs_US_RateOption].pus_ReqBytes[LP1_DATA_PATH*NUM_US_BEARER_CHANNELS + i];
                  //lp0 += (int16) gta_US_options[gs_US_RateOption].pus_ReqBytes[LP0_DATA_PATH*NUM_US_BEARER_CHANNELS + i];
               }
               if(lp1)
                  gs_CodeSwapSection = CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP1;

               gs_CodeSwapStatus = CODESWAP_START;
            }
            else if (gs_CodeSwapSection==CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP0 || gs_CodeSwapSection==CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP1)
               gs_CodeSwapStatus = CODESWAP_START;
            else if (gs_CodeSwapSection==CSPAGE_BIS_TXINIT)
               gs_RxSubState = 2;
         }
         break;
#endif
#ifdef DANUBE
            gs_RxSubState = 2;

         if ((gus_DataBuf_InXmem & STATES_TRAIL_BUF_IN_XMEM) == 0)
         {
               /* Swap training states trail buffer to XMEM */
               RequestSwap_CSStatesTrailBuf_ToXmem();

            if (gt_DataSwap.c_State == DATASWAP_REQUESTED)
            {
                  /* Switch states trail buffer to a smaller one in bulk memory */
                  gsa_StatesTrail = &gsa_ShowTimeStatesTrail[0];
                  INFOMap[INFO_DebugTrail] = (int16*)&gsa_ShowTimeStatesTrail;
                  gt_TrailXmemCollectControl.s_debugTrailLen = (gt_debugTrailCollectControl.s_debugTrailLen + 1)/2*2;   // roundup to even number for XDMA longword aligned
                  gt_TrailXmemCollectControl.s_debugTrailSize = (XMEM_STATES_TRAIL_BUF_END - XMEM_STATES_TRAIL_BUF_ADDR);
                  gt_debugTrailCollectControl.s_debugTrailLen = 0;    // reset index to 0
                  gt_debugTrailCollectControl.s_debugTrailSize = DEBUG_TRAIL_SMALL_SIZE;
                  gt_debugTrailTriggerControl.s_cyclicTrailUpdate = 1; // force buffer wrap around
                  gs_ShowtimeTrailBufferIndex = 0;

                  /* Switch INFO 87 pointer to point to Xmem struct */
                  INFOMap[INFO_DebugTrail_Collect] = (int16*)&gt_TrailXmemCollectControl;
            }
         }
            break;
#endif
#endif

      case 2:
         if ((guc_ShowTimeRxState == TRAINING_DONE) &&
            (guc_RxDataPumpState != TRAINING_DONE)){
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,RxDataPumpSetUp);
         }
         if (guc_RxDataPumpState == TRAINING_DONE){
            if (gft_RxinitSwap == DO_CODESWAP){
               gs_CodeSwapStatus = CODESWAP_START;    // TXINIT gets triggered
               gs_RxSubState = 3;
            }
            else {
               gft_RCExch2RcvFlag = RECEIVE_OK1 ;     // So that Tx state can start txinit()
               gs_RxSubState = 5;
            }
         }
         break;

      case 3:
         if (gs_CodeSwapStatus == CODESWAP_IDLE) {
            gs_CodeSwapStatus = CODESWAP_START;       // EXCHDMT gets triggered
            gft_RCExch2RcvFlag = RECEIVE_OK1 ;        // So that Tx state can start txinit()
            gs_RxSubState = 4;
         }
         break ;

      case 4:
         if (gs_CodeSwapStatus == CODESWAP_IDLE) {    // EXCHDMT is in, so we can switch function
            gs_RxSubState = 5;
         }
         break ;

      case 5:
         gs_RxSubStateCnt = 0 ;
         gpF_RxStateFunc = (PtrToFunc)RCReverb5RxF;
         break ;
   }
}

#ifdef DANUBE
#ifdef TARGET_HW
/****************************************************************************
;   Prototype: void RequestSwap_CSStatesTrailBuf_ToXmem (void)
;
;   Description: Function makes a request for XDMA by loading the Data Swap
;  Control structure with all necessary parameters required to program the
;  XDMA engine.
;
;  Two global flags will be set:
;     (1) gt_DataSwap.c_State = DATASWAP_REQUESTED
;     (2) gus_DataBuf_InXmem |= STATES_TRAIL_BUF_IN_XMEM
;
;  The first flag indicates that XDMA transfer is pending and structure
;  gt_DataSwap is occupied.
;
;  The second flag indicates that this particular buffer will be in external
;  memory when DMA is completed.
;
;   Arguments:
;       None
;
;   Return Value:
;       None
;
;****************************************************************************/
C_SCOPE void RequestSwap_CSStatesTrailBuf_ToXmem (void)
{
    if (gt_DataSwap.c_State == DATASWAP_READY)
    {
        gt_DataSwap.c_State   = DATASWAP_REQUESTED;
        gt_DataSwap.l_SrcAddr = (int32)&gsa_TrainStatesTrail[0];
        gt_DataSwap.l_DstAddr = XMEM_STATES_TRAIL_BUF_ADDR;
        gt_DataSwap.s_BufSize = (gt_debugTrailCollectControl.s_debugTrailLen + 1)/2*4; // byte size, longword aligned
        gt_DataSwap.c_XferDir = XDMA_WRITE_XMEM;
        gus_DataBuf_InXmem   |= STATES_TRAIL_BUF_IN_XMEM;
    }
}
#endif
#endif
