/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCCrcRARxF.c
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCCrcRARxF.c
//
// History
//
// 08/07/10  Nihar: Added code to resolve the interop issues with ADI/Anaconda in DMT/RA/Fast mode
//              Disable CO rate generation and CO calculation of DS framing parameters
//             by setting Ncloaded (Number of DS tones loaded) to "0"
//             If Target margin in C-MSG-1 is not correct estimate DS min-margin and do retrain
//             with correct min-margin if estimation was wrong
//             By default it is disabled. To enable it set bit 0 of OPTN 25 0
//             grep for "IOP_DS_DMT_ADI_SendNcloadedEqualToZero"
//
// 08/07/2010 Nihar: Send noise during Tx Medley so that US BAT is lower than the CO could get
//                   Helps in getting rid of US CRC/FEC during field trials.
//                By default it is disabled. To enable it set bit 0 of OPTN 25 0
//                   Grep for IOP_US_ALL_ADI930_AddNoiseToTxMedley
//
// 08/07/2010  Nihar: Added code to increase DS performance with ADI (930/ANCD) in DMT mode on short loops with strong noise
//                  Use US-PCB starting from Reverb to reduce DS-PCB
//             grep for  IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB
//
// 08/07/2010  Nihar: Added code to increase DS performance with TI in DMT mode on short loops with strong noise
//                  Use US-PCB starting from G.Hs to reduce DS-PCB
//             grep for  IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//             FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255.
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(C-RATES-RA and C-MSG-RA)
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"

// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "DecodCInfo1.h"
#include "DecodCInfoRA.h"
#include "states.h"
#include "RCBGRxF.h"
#include "RCReverb5RxF.h"
#include "RCRatesRARxF.h"
#include "RCReverbRARxF.h"
#include "cmv.h"
#include <string.h>
#include "DebugBuffer.h"

#define     DS_LOOP_ATTN_STEP0   (161) //>=1050m
#define     DS_LOOP_ATTN_STEP1   (139) //>= 900m
#define     DS_LOOP_ATTN_STEP2   (107) //>= 750m
#define     DS_LOOP_ATTN_STEP3   (82) //>= 600m
#define     DS_LOOP_ATTN_STEP4   (50) //>= 450m
#define     DS_LOOP_ATTN_STEP5   (26) //>= 300m
#define     DS_LOOP_ATTN_STEP6   (0) //>= 150m

#define     TXPCB_STEP0    (-1)  //   -1dB   >=1050m (used for comparison only - later set to 0dB)
#define     TXPCB_STEP1     (0)  //    0dB   >= 900m
#define     TXPCB_STEP2     (1)  //    1dB   >= 750m
#define     TXPCB_STEP3     (2)  //    2dB   >= 600m
#define     TXPCB_STEP4     (3)  //    3dB   >= 450m
#define     TXPCB_STEP5     (4)  //    4dB   >= 300m     (currently not used)
#define     TXPCB_STEP6     (5)  //    5dB   >= 150m     (currently not used)
#define     TXPCB_STEP7     (6)  //    6dB    < 150m     (currently not used)

#define ADD_TX_MEDLEY_NOISE_ADI930_DMT_max928kbps        ( 64)    // max. rate 928 kbps
#define ADD_TX_MEDLEY_NOISE_ADI930_DMT_max832kbps        (128)    // max. rate 832 kbps
#define ADD_TX_MEDLEY_NOISE_ADI930_DMT_max672kbps        (256)    // max. rate 672 kbps
#define ADD_TX_MEDLEY_NOISE_ADI930_DMT_max448kbps        (512)    // max. rate 448 kbps
/*^^^
 *---------------------------------------------------------------------------------
 *
 *  Name: RCCrcRARxF
 *
 *  Description: Decodes the R_C_CRC_RA1 information and compares to the
 *  CRC computed on the received R_C_RATES_RA information.
 * (Take 2 symbols)
 *
 *  Prototype: void RCCrcRARxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   - (I) R_C_CRC3 computed over recevied R_C_MSGS2
 *      gus_RC_CRC_received   - (I/O) R_C_CRC3 recevied
 *      gsa_RxToneBuf[]     - (I) output of FDQ (set in GetRxTones() )
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *
 *  Notes: implements states  R_C_CRC_RA1_RX and R_C_CRC_RA2_RX
 *
 *---------------------------------------------------------------------------------
 *^^^
 */
void RCCrcRARxF(void) {

   uint8 uc_byte, uc_backup_byte, uc_mean_byte;
   int16 i;
#ifdef ISDN
   // SMS00842172 IOP_US_ALL_ADI930_AddNoiseToTxMedley (Start_End)
   int16 s_Required_TxNoiseLevel;
#endif
    /*  clear received RC_CRC3     */
    if (gl_RxSymbolCount == 0) {
      gus_RC_CRC_received = 0x0000;
      gus_RC_bkpCRC_received = 0x0000;
      gus_RC_meanCRC_received = 0x0000;

      gs_RxSubStateCnt = 0;
    }

   /* Demodulate current byte of C_MSGS2 */
   RxExchSig(gsa_RxToneBuf, (int16)NC_MSGS1, (int16)NC_MSGS2, &uc_byte, &uc_backup_byte, &uc_mean_byte);

   /* Put into gus_RC_CRC_received */
   gus_RC_CRC_received = gus_RC_CRC_received | (uint16)((uint32)uc_byte<<(gs_RxSubStateCnt*8));
   gus_RC_bkpCRC_received = gus_RC_bkpCRC_received | (uint16)((uint32)uc_backup_byte<<(gs_RxSubStateCnt*8));
   gus_RC_meanCRC_received = gus_RC_meanCRC_received | (uint16)((uint32)uc_mean_byte<<(gs_RxSubStateCnt*8));

   gs_RxSubStateCnt++;

    /*  compare CRC's when all bits received */
   if (gs_RxSubStateCnt == R_C_CRC3_RX_LEN)
   {


      if ((gus_RC_CRC_received == gus_RC_CRC_computed) ||
         (gus_RC_bkpCRC_received == gus_RC_bkpCRC_computed) ||
         (gus_RC_meanCRC_received == gus_RC_meanCRC_computed)) {

         /* ============================================================ */
         /* if the primary CRC is bad */
         /* then move secondary message to primary buffer */
         /* ============================================================ */

         if(gus_RC_CRC_received != gus_RC_CRC_computed)
         {

            if(gus_RC_bkpCRC_received != gus_RC_bkpCRC_computed)
               {
                  memcpy(gpsa_RxExchMsg, gsa_RxExchMsg1, gs_RxExchMsgLength * sizeof(int16));
               }
               else
               {
                  for(i=0; i<gs_RxExchMsgLength; i++)
                     gpsa_RxExchMsg[i] >>= 8;
               }
         }

         for(i=0; i<gs_RxExchMsgLength; i++)
         {
            gpsa_RxExchMsg[i] &= 0xff;
         }
//XDSLRTFW-3674 bug correction for logging(start)
#ifdef DEBUG_TRACES // XDSLRTFW-597
         // to differentiate between 2 messages
         if(gpsa_RxExchMsg == gsa_RCRatesRA)
         {
            LogMessages(4,NOT_END_OF_MSG,(uint16)C_RATES_RA_DMT_MSG,(R_C_RATES_RA_RX_LEN<<1), (uint8 *)(void *)(gsa_RCRatesRA), DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(NOT_END_OF_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_bkpCRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
         }
         else
         {
            LogMessages(4,NOT_END_OF_MSG,(uint16)C_MSG_RA_DMT_MSG,(R_C_MSG_RA_RX_LEN<<1), (uint8 *)(void *)(gsa_RCMsgRA), DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(NOT_END_OF_MSG,2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,2,(uint8 *)(void *)(&gus_RC_bkpCRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
         }
#endif // #ifdef DEBUG_TRACES
#ifdef DEBUG_STREAMING
      if(gpsa_RxExchMsg == gsa_RCRatesRA)
      {
         DSH_SendStream(DSH_C_RATES_RA,(R_C_RATES_RA_RX_LEN<<1),&gsa_RCRatesRA[0]);
      }
      else
      {
         DSH_SendStream(DSH_C_MSG_RA,(R_C_MSG_RA_RX_LEN<<1),&gsa_RCMsgRA[0]);
      }
#endif
//XDSLRTFW-3674 bug correction for logging(end)

         /* ============================================================ */
         /*  CRC's match:  continue to next state */
         /* ============================================================ */

         switch(gs_RxState) {

         case R_C_CRC_RA1_RX:

            gs_RxNextState = R_C_MSG_RA_RX;
            gpF_RxStateFunc = (PtrToFunc)RCRatesRARxF;
            break;

         case R_C_CRC_RA2_RX:
#ifdef  ISDN  // Only for Annex - B
               // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
               // For short Loops Reduce the Tx Power to get Less DS PCB
               // for ADI 930, ADI Anaconda and TI-AC5:     limit US-PCB to 3dB

            if ((gs_CurrentCoChipset ==  ADI_CO_CHIPSET) ||
               (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET) ||
               (gs_CurrentCoChipset == TI_CO_CHIPSET))
            {
               if (gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_STEP0)      //>=1050m -> 0dB US-PCB
               {
                  gs_Required_TxPCB = TXPCB_STEP0;      // Though it is set to -1, but after the fw reboot, its re-initialized to '0' in cnfg_task.c
                  // So, the array pointer is '0'
               }
               else if (gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_STEP1) //>= 900m -> 0dB US-PCB
               {
                  gs_Required_TxPCB = TXPCB_STEP1;
               }
               else if ( gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_STEP2) //>= 750m -> 1dB US-PCB
               {
                  gs_Required_TxPCB = TXPCB_STEP2;
               }
               else if (gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_STEP3)  //>= 600m -> 2dB US-PCB
               {
                  gs_Required_TxPCB = TXPCB_STEP3;
               }
               else                                                                // < 450m -> 3dB US-PCB
               {
                  gs_Required_TxPCB = TXPCB_STEP4;
               }
            }
               // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (End)
#endif // ifdef ISDN
            /* Decode C_MSG_RA and C_RATES_RA msg */
            DecodCInfoRA();
            gft_RCExchRARcvFlag = RECEIVE_OK1;

            gs_RxNextState = R_C_REVERB_RA_RX;
            gpF_RxStateFunc = (PtrToFunc)RCReverbRARxF;
#ifdef ISDN // Only for Annex - B
            // IOP_US_ALL_ADI930_AddNoiseToTxMedley (Start)
            /* Link Drop was observed after 30-60sec against ADI 930 on long White Noise loops
               (3000m - 3800m). In order to avoid aggressive US Bit loading we need to add some
               noise in the Tx Medley.

               It is limited to ADI930 DSLAMs for g.dmt, t1.413 and g.lite mode;
            */

            if (gs_CurrentCoChipset == ADI_CO_CHIPSET)
            {
               if (gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_3750m)
                  s_Required_TxNoiseLevel = ADD_TX_MEDLEY_NOISE_ADI930_DMT_max448kbps + gs_Medley_OffsetXtra;
               else if (gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_3250m)
                  s_Required_TxNoiseLevel = ADD_TX_MEDLEY_NOISE_ADI930_DMT_max672kbps + gs_Medley_OffsetXtra;
               else if (gt_NearEndParam.us_LoopAttenuation >= DS_LOOP_ATTN_2750m)
                  s_Required_TxNoiseLevel = ADD_TX_MEDLEY_NOISE_ADI930_DMT_max832kbps + gs_Medley_OffsetXtra;
               else
                  s_Required_TxNoiseLevel = ADD_TX_MEDLEY_NOISE_ADI930_DMT_max928kbps + gs_Medley_OffsetXtra;

               if (gs_Persis_CurrTxNoiseLevel != s_Required_TxNoiseLevel)
               {
                  gs_Persis_CurrTxNoiseLevel = s_Required_TxNoiseLevel;
                  //gs_RxNextState = FAIL_RX;
                  //gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                  /* Set exception handler variables */
                  //gus_ExceptionState = gs_RxState;
                  gus_ExceptionCode = E_CODE_ADI_CHANGE_MEDLEX_TX_NOISE_LEVEL;
               // intentional retrain - do not increase API retrain counter - Jira XDSLRTFW-255
                  //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
               guc_Forced_Retrain = 0x5;
               }
            }

            if (gs_CurrentCoChipset == ANCDA_CO_CHIPSET)
               gs_Persis_CurrTxNoiseLevel = 0;

            // IOP_US_ALL_ADI930_AddNoiseToTxMedley (End)

            // IOP_DS_DMT_ADI_SendNcloadedEqualToZero IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
            // if (ADI/ACNCDA && (FalseTargetMargin || FalseReverbTxPCB))
            if ( ( (gs_CurrentCoChipset == ADI_CO_CHIPSET) || (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET) ) &&
               (((gs_RxDesiredMargin != gs_Persis_TargetSNRMrg) && (gft_ADI_ANCDA_minSNR_flag)) ||
               (gs_Persis_CurrReverbTxPCB < gs_Required_TxPCB) || (gs_Persis_CurrReverbTxPCB > gs_Required_TxPCB+1)))
            {
               // in Rate-adaptive, Fast-path case we'll use the target margin of C-MSG-RA to calculate datarate and framing parameters for R-MSG-RA
               gs_Persis_TargetSNRMrg = gs_RxDesiredMargin;

               gs_Persis_CurrGHsTxPCB    = 0;      // no US-PCB in G.Hs for ADI
               // set US-PCB in Reverb (ADI uses only Reverb power estimations for DS-PCB selection)
               gs_Persis_CurrReverbTxPCB = gs_Required_TxPCB;

               //gs_RxNextState = FAIL_RX;
               //gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               //gus_ExceptionState = gs_RxState;

               if (gus_ExceptionCode != E_CODE_ADI_CHANGE_MEDLEX_TX_NOISE_LEVEL)
                   gus_ExceptionCode = E_CODE_ADI_REDUCE_REVPWR_LOW_DSPCB_RATE_OPTIONS_RETRAIN;
               else
                   gus_ExceptionCode = E_CODE_ADI_REDUCE_REVPWR_LOW_DSPCB_RATE_OPTIONS_TX_MEDLEY_NOISE_RTN;
            // intentional retrain - do not increase API retrain counter - Jira XDSLRTFW-255
               //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
               guc_Forced_Retrain = 0x6;
            }
            // IOP_DS_DMT_ADI_SendNcloadedEqualToZero IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (End)

            // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start)
            // if (TI_AC5 && FalseGHsTxPCB)
            if ((gs_CurrentCoChipset == TI_CO_CHIPSET) &&
               ((gs_Persis_CurrGHsTxPCB < gs_Required_TxPCB) ||
               (gs_Persis_CurrGHsTxPCB > gs_Required_TxPCB+1)))
            {
               // set US-PCB in G.Hs (TI uses G.Hs and Reverb power estimations for filter and DS-PCB selection)
               gs_Persis_CurrGHsTxPCB = gs_Required_TxPCB;
               // no additional US-PCB for Reverb needed
               gs_Persis_CurrReverbTxPCB = 0;

               //gs_RxNextState = FAIL_RX;
               //gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               //gus_ExceptionState = gs_RxState;

               gus_ExceptionCode = E_CODE_TI_REDUCE_GHSPWR_LOW_DSPCB_RETRAIN;
            // intentional retrain - do not increase API retrain counter - Jira XDSLRTFW-248
               //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
               guc_Forced_Retrain = 0x7;
            }
         //Code optimization (Start)
         if(guc_Forced_Retrain > 0)
         {
                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
                  /* Set exception handler variables */
                  gus_ExceptionState = gs_RxState;
         }
         //Code optimization (Start)

         // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB  (End)
#endif // ifdef ISDN
         break;

         }  /* ends switch() */
        }
        else {
            /* ============================================================ */
            /*  CRC's don't match:  go to FAIL state */
            /* ============================================================ */
            gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCCRC3Rx_DECOD_ERR;
        }
    }
}

