/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMsgs2RxF.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "states.h"
#include "RCCrc3RxF.h"




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMsg2RxF
 *
 *  Description: Demodulate the R_C_MSG2 information and stores into buffer
 *  guca_RCMsg2[].  A CRC16 is computed over the received R_C_MSG2
 * (Take 4 symbols) This function is also reused by state R_C_MSG_RA_RX
 *
 *  Prototype: void RCMsg2RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed  - (I/O) CRC16 computed over received R_C_MSG2
 *      gul_R_C_Msg2         - (O) received R_C_MSG2 information
 *      gsa_RxToneBuf[]      - (I) output of FDQ
 *      gl_RxSymbolCount     - (I) number of symbol periods in current state
 *      gs_RxNextState       - (O) RX state beginning next symbol period
 *
 *  Notes: implements states R_C_MSG2_RX  and R_C_RATES2_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCMsg2RxF(void) {

    uint16  us_infobit;
    int16   i;
   uint8 uc_byte, uc_backup_byte,uc_mean_byte;

    if (gl_RxSymbolCount == 0) {

      /* set state control variables */
      switch(gs_RxState) {

      case R_C_RATES2_RX:

         gt_StateMachCntrl.l_RXCurrentStateLen = R_C_RATES2_RX_LEN;
         gt_StateMachCntrl.s_RXFollowingState = R_C_CRC4_RX;
         gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCCrc3RxF;
         gpsa_RxExchMsg = &gs_RCRates2;
         gs_RxExchMsgLength = R_C_RATES2_RX_LEN;

         break;

        case R_C_MSG2_RX:
         gt_StateMachCntrl.l_RXCurrentStateLen = R_C_MSG2_RX_LEN;
         gt_StateMachCntrl.s_RXFollowingState = R_C_CRC3_RX;
         gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCCrc3RxF;
         gpsa_RxExchMsg = gsa_RCMsg2;
         gs_RxExchMsgLength = R_C_MSG2_RX_LEN;
         break;

      }

      /* init. computed CRC to 0 */
      gus_RC_CRC_computed = 0x0000;
      gus_RC_bkpCRC_computed = 0x0000;
      gus_RC_meanCRC_computed = 0x0000;

      gs_RxSubStateCnt = 0;
    }



   /* Get current byte of C_MSGS2 */
   RxExchSig(gsa_RxToneBuf, (int16)NC_MSGS1, (int16)NC_MSGS2, &uc_byte, &uc_backup_byte, &uc_mean_byte);

   /* Put into message */
   /* Note:  Must use substate counter because Annex C must skip NEXT symbols */
   gsa_RxExchMsg1[gs_RxSubStateCnt] = (int16)uc_mean_byte;
   gpsa_RxExchMsg[gs_RxSubStateCnt] = ((int16) uc_backup_byte) << 8;
   gpsa_RxExchMsg[gs_RxSubStateCnt] |= (int16) uc_byte;

   gs_RxSubStateCnt++;

    /* Compute CRC for the current byte */
   for(i=0; i<8; i++) {
      us_infobit = (uint16)((uc_byte >> i) & 0x1);
      CalcCRC16(&gus_RC_CRC_computed, us_infobit);

      us_infobit = (uint16)((uc_backup_byte >> i) & 0x1);
      CalcCRC16(&gus_RC_bkpCRC_computed, us_infobit);

      us_infobit = (uint16)((uc_mean_byte >> i) & 0x1);
      CalcCRC16(&gus_RC_meanCRC_computed, us_infobit);
   }

   if (gs_RxSubStateCnt == gt_StateMachCntrl.l_RXCurrentStateLen) {
      gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
      gpF_RxStateFunc = gt_StateMachCntrl.pF_RxFollowingState;
   }
}

