/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb5RxF.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */

// ******************************************************************
// RCReverb5RxF.c
//
// History
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//                FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255.
//                Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
// 10/01/2013 Ram: Bug fix for JIRA XDSLRTFW-262
//                 Replaced BIS related error code with DMT error code.
//                 Grep for XDSLRTFW-262: BugFix_DS_DMT_ALL_BIS_ECODE_Reused_In_DMT
//
//
// 10/04/2014 Sriram Shastry: Added the workaround requested by AT&T for their special profile
//                   on Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K)
//                   in T1.413, G.dmt, G.lite and Annex L multimode, i.e.
//                   Multimode CPE needs to disable Annex L on short loops.
//                   This workaround is disabled by default with
//                   CMV bit7 = 0 for INFO 103 26.
//                   To enable it, set bit7 = 1 by cw INFO 103 26 0x0080.
//                   Grep for ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL
//
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "showinit.h"
#include "fifo.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "states.h"
#include "codeswap.h"
#include "cmv.h"
#include "sleep.h"
#include "pll.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif



#include "trail.h"

#ifdef HERCULES_ADSL_CPE
int16 gs_PilotPowerLowCnt=0;
#endif

#ifdef IFX_XTC
        #include "xtc_setup.h"
        #include "ConfigXtcIfRxPath.h"
#endif
#ifdef CUSTOMER_TASKS
        #include "customertasks.h"
#endif


 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb5RxF
 *
 *
 *  Prototype: void RCReverb5RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *              gl_RxSymbolCount                  - (I/O) RX symbol count
 *      gs_RxSubStateCnt                  - (I/O) R_C_SEGUE_RA count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *      R_C_REVERB_RA_RX_INITIALIZE   - Initialize state variables to handle the
 *                                      transition to either R_C_MSG2_RX or R_C_SHOWTIME_RX.
 *                                      If the transition is supposed to be to R_C_MSG2_RX,
 *                                      a downstream rate option is selected from the new
 *                                      set of options received.
 *      R_C_REVERB_RA_RX_DETECT_SEGUE - Attempt to detect SEGUE.
 *
 *  Notes: implements states R_C_REVERB_RA_RX and R_C_REVERB5_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void RCReverb5RxF(void)
{


        int16 s_ToneType, s_numRevMatches, s_numSegueMatches;


        gft_EnablePLL = TRUE;



#ifdef BIS_CODESWAP
        if (gs_CodeSwapStatus==CODESWAP_IDLE && gs_CodeSwapSection==CSPAGE_BIS_SHT1DMT && gs_TxState==R_SEGUE4_TX) {
                if (OPTNArray[OPTN_DMTLinkControl] & OPTN_DiagMode_Enable) {
                        gs_CodeSwapSection = CSPAGE_BIS_SLEEP;
                        gs_CodeSwapStatus = CODESWAP_START;
                }
                else {
                        gs_CodeSwapStatus = CODESWAP_START;
                }
        }
#endif



        /*  Detect C_SEGUE3 */
        DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, &s_numRevMatches, &s_numSegueMatches);
        if(s_numSegueMatches >= ((3*gs_RSDetect_NumBins+1)>>2)) /* Segue matches over 3/4 of all tones tested */
                s_ToneType = C_SEGUE;
        else
                s_ToneType = C_REVERB;
        /*  If incoming symbol is C_Segue, then incr. counter, else reset counter.
                Since at 8 Segues we start the non-reversible procedure of transitioning into Showtime,
                we commit to the state transition at this point */
        if ((s_ToneType == C_SEGUE) || (gs_RxSubStateCnt >= R_C_SEGUE2_LEN-2)) {
                gs_RxSubStateCnt++;
        }
        else {
                gs_RxSubStateCnt = 0;
        }


#ifdef HERCULES_ADSL_CPE
        // All following code takes place if Segues keep coming.
        if (s_ToneType==C_SEGUE)
        {
#endif

#ifdef ADSL_62
                if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 3)
                {
                        memcpy(gsa_RxBuffer8X_1, gsa_pre_FDQ_coef, sizeof(int16)*gs_RxSamplesPerFrame);

                        //move FDQ coefficients array to YMEM (L2 functionality requires FDQ reside in XYmem).
                        gsa_FDQ_coef_out = gsa_pre_FDQ_coef = (int16 *) gsa_RxBuffer8X_1;
                        //move RxToneBuf to YExtended
                        gsa_RxToneBuf = (int16 *) gsa_YBlock_Extended;
                }
#endif
                if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 2)
                {
                        if(!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
                        {
                                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
                        }

                }

                if (OPTNArray[OPTN_DMTLinkControl] & OPTN_DiagMode_Enable) {
                        if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 9) {
                                gs_TxNextState = SLEEP_TX;
                                gs_RxNextState = SLEEP_RX;
                                gpF_TxStateFunc = (PtrToFunc)RSleepTxF;
                                gpF_RxStateFunc = (PtrToFunc)RSleepRxF;
                        }
                }

#ifdef BIS_CODESWAP
                if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 2) {
                        if (gs_CodeSwapSection != CSPAGE_BIS_SHT2DMT ){
                                /* the swap is not done */
                                gs_RxNextState = FAIL_RX;
                                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                                /* Set exception handler variables */
                                gus_ExceptionState      = gs_RxState;
                                gus_ExceptionCode       = E_CODE_CODESWAP_ERR;
                        }
                }
#endif

                /* Train to showtime transition */
                DoRxFFTBufferScenarioTransition(gs_RxSubStateCnt, R_C_SEGUE2_LEN);              // Starts at (R_C_SEGUE2_LEN-2)

                if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 1)
                {
                        /* Change or rather initialize the captured tone index (in an Iridia register) */
                        AddFunctionToFifo(gp_RxLoadingFunctionFifo,ChangeCapturedToneIdx);
#ifndef ISDN
                        // Clear the variable before showtime
         gus_shortloop_cutpower = 0;
#endif


#ifdef IFX_XTC
                if (gft_AlphaeusSel == FALSE)
                {
                        // Enable Rx xTC I/F
                        AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableRxXtcIF);
                }
#endif

                }
                else if (gs_RxSubStateCnt >= R_C_SEGUE2_LEN)
                {
                        /*  C_SEGUE3 detected, go to next state */
                        gft_RCSegue3RcvFlag = RECEIVE_OK1;
#ifndef ISDN
                        gft_disableAnnexL = 0;//ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL (START_END)
#endif
                }

#ifdef HERCULES_ADSL_CPE
        }// if (s_ToneType==C_SEGUE)
#endif


#ifdef HERCULES_ADSL_CPE

        // Force failure after detection of 50 frames that
        // have pilot tone power at least 6dB below nominal
        if (!gft_PilotPowerOK)
                gs_PilotPowerLowCnt++;

        if ( (gs_PilotPowerLowCnt>50) || ((gs_RxSubStateCnt>=R_C_SEGUE2_LEN-2) && (s_ToneType!=C_SEGUE)) )
        {
                gs_RxNextState = FAIL_RX;
                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                /* Set exception handler variables */
                gus_ExceptionState = gs_RxState;

        //XDSLRTFW-262: BugFix_DS_DMT_ALL_BIS_ECODE_Reused_In_DMT (Start_End)
                gus_ExceptionCode = E_CODE_RCReverb5Rx_C_SEGUE_Quiet_Failure;
        }

        /*  if C_SEGUE not detected yet, then the ATU-C has timed out */
        if (gl_RxSymbolCount == ( R_C_REVERB5_TIMEOUT-1) ) {
                gs_RxNextState = FAIL_RX;
                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                /* Set exception handler variables */
                gus_ExceptionState      = gs_RxState;
                gus_ExceptionCode       = E_CODE_RCReverb5Rx_C_SEGUE_Failure;
        }
#endif

        /*  if C_SEGUE not detected yet, then the ATU-C has timed out */
        if (gl_RxSymbolCount == ( R_C_REVERB5_TIMEOUT-1) ) {
                gs_RxNextState = FAIL_RX;
                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                /* Set exception handler variables */
                gus_ExceptionState      = gs_RxState;
                gus_ExceptionCode       = E_CODE_RCReverb5Rx_C_SEGUE_Failure;
        }


}


