/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbRARxF.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload_dmt.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "states.h"
#include "RCMsg2RxF.h"
#include "rcmedley_Data.h"
#include "cmv.h"
#if defined DANUBE_SE_CODESWAP || defined ADSL_62// For 24KB image footprint
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
#endif // For 24KB image footprint



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverbRARxF
 *
 *  Description: Transition to R_C_MSG2_RX after the detection of C_SEGUE_RA signal
 *
 *  Prototype: void RCReverbRARxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE_RA count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *      R_C_REVERB_RA_RX_INITIALIZE   - Initialize state variables to handle the
 *                                      transition to either R_C_MSG2_RX or R_C_SHOWTIME_RX.
 *                                      If the transition is supposed to be to R_C_MSG2_RX,
 *                                      a downstream rate option is selected from the new
 *                                      set of options received.
 *      R_C_REVERB_RA_RX_DETECT_SEGUE - Attempt to detect SEGUE.
 *
 *  Notes: implements states R_C_REVERB_RA_RX and R_C_REVERB5_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB_RA_RX_INITIALIZE     (0)
#define R_C_REVERB_RA_RX_BITLOAD_DONE  (1)
#define R_C_REVERB_RA_RX_DETECT_SEGUE   (2)

void RCReverbRARxF(void) {
   int16 s_ToneType;

   // XDSLRTFW-4226 ADSL1 Long training times due to FW crash caused by wrong timing of code swap
   // Moved the commented out section inside the state machine to avoid code execution of SelectRateOptionForRMsg2
   // !!!! NOTE !!! with this step we delay the state machine and the start of the next code swap!!!
   // This could lead to new timing issues, which were so far not observed. But, if there are new training fails
   // after C-Rates2, this might be the right place to look at.

   //#if defined DANUBE_SE_CODESWAP || defined ADSL_62 // For 24KB image footprint
   //#ifdef BIS_CODESWAP
   //   if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_RXINIT))
   //   {
   //      gs_CodeSwapStatus = CODESWAP_START;
   //   }
   //#endif
   //#endif

   if (gl_RxSymbolCount == 0)
   {
      gs_RxSubStateCnt = 0;
      gft_EnablePLL = TRUE;
   }

   switch(gs_RxSubState)
   {
      case R_C_REVERB_RA_RX_INITIALIZE:
         // XDSLRTFW-4226 ADSL1 Long training times due to FW crash caused by wrong timing of code swap
         // Wait until code swap of CSPAGE_BIS_BTLDDMT1 is finalized before calling
         // the function SelectRateOptionForMsg2(), which needs code from this swap page i.e. FormRInfo2().
         if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_RXINIT))
         {
            gs_RxSubState = R_C_REVERB_RA_RX_BITLOAD_DONE;
            /* Select a downstream rate option from the new set of options received */
            /* and perform bit allocation */
            gft_BitloadState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo(SelectRateOptionForRMsg2);
            gl_BitloadStart = gl_RxSymbolCount;
            gs_CodeSwapStatus = CODESWAP_START;
         }
         // Debug code to check code swap timing. 18 to 60 symbols have been observed until
         // gs_CodeSwapStatus has reached the state CODESWAP_IDLE
         //else
         //{
         //   debugC++; // Check how long it takes until the code
         //}
         break;

      case R_C_REVERB_RA_RX_BITLOAD_DONE:
         /* Wait until bit loading is completed. */
         if (gft_BitloadState == TRAINING_DONE) {
            gs_RxSubState = R_C_REVERB_RA_RX_DETECT_SEGUE;
            gl_BitloadEnd = gl_RxSymbolCount;
         }
         break;

      case R_C_REVERB_RA_RX_DETECT_SEGUE:
         /*  wait to detect C_SEGUE2 */
         s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);
         /*  if incoming symbol is C_Segue, then incr. counter */
         /*  else reset counter */
         if (s_ToneType == C_SEGUE)
            gs_RxSubStateCnt++;
         else {
            gs_RxSubStateCnt = 0;
         }

         /*  if C_SEGUE2 not detected yet, then the ATU-C has timed out */
         /*  goto FAIL_RX state */
         if (gl_RxSymbolCount == (R_C_REVERB_RA_TIMEOUT - 1) ) {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverbRARx_C_SEGUE2_Failure;
         }

         if (gs_RxSubStateCnt==R_C_SEGUE2_LEN) {
            /*  C_SEGUE2 detected, go to next state */
            gft_EnablePLL = FALSE;

            gs_RxNextState = R_C_MSG2_RX;
            gpF_RxStateFunc = (PtrToFunc)RCMsg2RxF;
         }
         break;
   } /*  switch(gs_RxSubState) */
}

#undef R_C_REVERB_RA_RX_INITIALIZE
#undef R_C_REVERB_RA_RX_DETECT_SEGUE

