/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCrcRATxF.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "RRatesRATxF.h"
#include "RReverb5TxF.h"
#include "states.h"
#include "RReverbRATxF.h"





/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCrcRATxF
 *
 *  Description: The CRC computed during R_MSG_RA is sent during
 *  R_CRC_RA2_TX.  This routine transmits the 16-bit CRC using the same
 * signaling scheme as that used for transmit the R-MSG_RA information.
 * (Take 2 symbols)
 *
 *  Prototype: void RCrcRATxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_R_CRC           - (I) CRC16 computed over guca_RMsg2[]
 *      s_TxToneBuf[]       - (O) frequency domains samples
 *                                (set in TxReverbSegueSetUp() )
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) current TX state
 *
 *  Notes: implements states R_CRC_RA1_TX,  R_CRC_RA2_TX,
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCrcRATxF(void) {

    uint8 uc_byte;

   if (gl_TxSymbolCount == 0) {
      gft_IFFT_On=TRUE;
      gs_TxSubStateCnt = 0;
      /*  State Machine Control */
        switch (gs_TxState) {

      case R_CRC_RA1_TX:
         gt_StateMachCntrl.s_TXFollowingState  = R_RATES_RA_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RRatesRATxF;
         break;

      case R_CRC_RA2_TX:
         gt_StateMachCntrl.s_TXFollowingState  = R_REVERB_RA_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverbRATxF;
         break;
      }
   }



      /* extract current byte */
      uc_byte = (uint8)((gus_R_CRC >> (gs_TxSubStateCnt*8)) & 0xFF);
      gs_TxSubStateCnt++;

      /* encode and transmit one byte of message */
      TxExchSig(uc_byte, (int16)NR_MSGS1, (int16)NR_MSGS2, (int16)ENCGAIN2);

      /* move to the next state */
      if (gs_TxSubStateCnt == R_CRC3_TX_LEN) {
         gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
         gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
      }



}



