/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMsgs2TxF.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "fifo.h"
#include "pll.h"
#include "detect.h"
#include "memsetbf.h"
#include "RCrc3TxF.h"
#include "states.h"




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMsgs2TxF
 *
 *  Description: This R_MSGS2_TX is in reply to C_RATES_RA based on the results
 *  of the downstream channel analysis.
 *
 *  Prototype: void RMsgs2TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gs_DS_RateOption     - (I) selected downstream rate option
 *                      (set in SelectRateOptionForRMsgRA())
 *    gta_DS_options[]     - (I) the set of downstream rate options
 *      guc_RRatesRA          - (O) Packed rate configuration options to be sent
 *      gus_R_CRC       - (I/O) CRC16 computed over guc_RRatesRA
 *      gsa_TxToneBuf[]       - (O) frequency domain samples
 *                         (set in TxReverbSegueSetUp() )
 *      gs_TxSubState      - (I/O) substate within current state
 *      gl_TxSymbolCount      - (I) # symbol periods in current TX state
 *      gs_TxNextState        - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) current TX state
 *    gt_StateMachCntrl    - state machine control structure
 *
 *  Notes: implements states R_MSGS2_TX,
 *  and R_RATES2_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RMsgs2TxF(void) {

    uint16  us_infobit;
   uint8 uc_byte;
   int16 i;

   if(gl_TxSymbolCount == 0) {

      gft_IFFT_On=TRUE;
      /* Set CRC to 0 */
      gus_R_CRC = 0x0000;
      gs_TxSubStateCnt = 0;
      switch(gs_TxState) {


         case R_MSGS2_TX:

            gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG2_TX_LEN;
            gt_StateMachCntrl.s_TXFollowingState = R_CRC3_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrc3TxF;
            gt_StateMachCntrl.puca_TX_message = guca_RMsg2;

            break;

         case R_RATES2_TX:

            gt_StateMachCntrl.l_TXCurrentStateLen = R_RATES2_TX_LEN;
            gt_StateMachCntrl.s_TXFollowingState = R_CRC4_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrc3TxF;
            gt_StateMachCntrl.puca_TX_message = &guc_RRates2;
            break;
      }  /* switch(gs_TxState) */

   }



      /* Extract current byte */
      uc_byte = gt_StateMachCntrl.puca_TX_message[gs_TxSubStateCnt];
      gs_TxSubStateCnt++;

      /* Compute CRC for current 8 bits */
      for(i=0; i<8; i++) {

         /* Extract bit */
         us_infobit = (uint16)((uc_byte >> i) & 0x1);

         /* Computed 16-bit CRC */
         CalcCRC16(&gus_R_CRC, us_infobit);
      }

      /* Encode and transmit one byte of message */
      TxExchSig(uc_byte, (int16)NR_MSGS1, (int16)NR_MSGS2, (int16)ENCGAIN2);

      if(gs_TxSubStateCnt == gt_StateMachCntrl.l_TXCurrentStateLen) {
         gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
         gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
      }



}

