/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RRatesRATxF.c
 *
 *
 *------------------------------------------------------------------------
 */


// ****************************************************************************************************
// RRatesRATxF.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-RATES-RA in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "crc16.h"
#include "memsetbf.h"
#include "states.h"
#include "RCrcRATxF.h"
#include "rinfotbl.h"
#include "cmv.h"
#include "DebugBuffer.h"




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RRatesRATxF
 *
 *  Description: This R_RATES_RA_TX is in reply to C_RATES1 based on the results
 *  of the downstream channel analysis. The format of R_RATES_RA is the same as
 *  that of R_RATES2, except for the additional bit pattern used to indicate
 *  "no option selected". The duration of R_RATES_RA is 1 symbol.
 *
 *  Prototype: void RRatesRATxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gs_DS_RateOption     - (I) selected downstream rate option
 *                      (set in SelectRateOptionForRMsgRA())
 *    gta_DS_options[]     - (I) the set of downstream rate options
 *      guc_RRatesRA          - (O) Packed rate configuration options to be sent
 *      gus_R_CRC       - (I/O) CRC16 computed over guc_RRatesRA
 *      gsa_TxToneBuf[]       - (O) frequency domain samples
 *                         (set in TxReverbSegueSetUp() )
 *      gs_TxSubState      - (I/O) substate within current state
 *      gl_TxSymbolCount      - (I) # symbol periods in current TX state
 *      gs_TxNextState        - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) current TX state
 *    gt_StateMachCntrl    - state machine control structure
 *
 *  Notes: implements states R_RATES_RA_TX, R_MSG_RA_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RRatesRATxF(void) {

    uint16  us_infobit;
   uint8 uc_byte;
   int16 i;

   if(gl_TxSymbolCount == 0) {

      gft_IFFT_On=TRUE;
      /* Set CRC to 0 */
      gus_R_CRC = 0x0000;
      gs_TxSubStateCnt = 0;
      switch(gs_TxState) {

         case R_MSG_RA_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG_RA_TX_LEN;
            gt_StateMachCntrl.s_TXFollowingState = R_CRC_RA1_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrcRATxF;
            gt_StateMachCntrl.puca_TX_message = guca_RMsgRATab;

            /* Form R_MSG_RA */
            FormRMsgRA();
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)R_MSG_RA_DMT_MSG,R_MSG_RA_NUM_BYTES, (uint8 *)guca_RMsgRATab, DEBUG_BUFFER_DELIMITER_ADSL);
#endif // #ifdef DEBUG_TRACES
#ifdef DEBUG_STREAMING
       DSH_SendStream(DSH_R_MSG_RA,R_MSG_RA_NUM_BYTES,&guca_RMsgRATab[0]);
#endif
            break;

         case R_RATES_RA_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_RATES_RA_TX_LEN;
            gt_StateMachCntrl.s_TXFollowingState = R_CRC_RA2_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrcRATxF;
            gt_StateMachCntrl.puca_TX_message = &guc_RRatesRA;

            /* Form R_RATES_RA message */
            guc_RRatesRA = FormRRatesRA(gs_DS_RateOption);
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)R_RATES_RA_DMT_MSG,1, (uint8 *)(&guc_RRatesRA), DEBUG_BUFFER_DELIMITER_ADSL);
#endif // #ifdef DEBUG_TRACES
#ifdef DEBUG_STREAMING
       DSH_SendStream(DSH_R_RATES_RA,sizeof(guc_RRatesRA),&guc_RRatesRA);
#endif
            break;


      }  /* switch(gs_TxState) */

   }




      /* Extract current byte */
      uc_byte = gt_StateMachCntrl.puca_TX_message[gs_TxSubStateCnt];
      gs_TxSubStateCnt++;

      /* Compute CRC for current 8 bits */
      for(i=0; i<8; i++) {

         /* Extract bit */
         us_infobit = (uint16)((uc_byte >> i) & 0x1);

         /* Computed 16-bit CRC */
         CalcCRC16(&gus_R_CRC, us_infobit);
      }

      /* Encode and transmit one byte of message */
      TxExchSig(uc_byte, (int16)NR_MSGS1, (int16)NR_MSGS2, (int16)ENCGAIN2);

      if(gs_TxSubStateCnt == gt_StateMachCntrl.l_TXCurrentStateLen) {
         gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
         gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
#ifdef DEBUG_TRACES // XDSLRTFW-597
         LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_R_CRC), DEBUG_BUFFER_DELIMITER_ADSL);
#endif // #ifdef DEBUG_TRACES
      }



}

