/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb5TxF.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "showinit.h"
#include "fifo.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "states.h"
#include "RSegue4TxF.h"



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb5TxF
 *
 *  Description: R_REVERB5_TX transmits the R_Reverb signal.
 *
 *  Prototype: void RReverb5TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB5_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define   REVERB5_TX_INITIALIZE                    (0)
#define   REVERB5_TX_WAIT1                         (1)
#define   REVERB5_TX_WAIT2                         (2)
#define   REVERB5_TX_WAIT3                         (3)

#ifdef WIN32
#define REVERB5_SUBSTATE_LENGTH_AFTER_CRC5         (1000)      // Not very elegant, just in order not to have new binary testvectors
#else
#define REVERB5_SUBSTATE_LENGTH_AFTER_CRC5         (1000)
#endif

void RReverb5TxF(void) {

   switch (gs_TxSubState) {

      case REVERB5_TX_INITIALIZE:
         TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

         gft_IFFT_On = TRUE;
         gpft2_RCExchRcvFlag = &gft_RCExch2RcvFlag;
         *gpft2_RCExchRcvFlag = NOT_RECEIVE;
         gs_TxSubState = REVERB5_TX_WAIT1;
         break;

      case REVERB5_TX_WAIT1:
         if(*gpft2_RCExchRcvFlag == RECEIVE_OK1) {   /* TXINIT has been swapped in at this point */
            /* we can go ahead and set up the Tx Parameters */
            *gpft2_RCExchRcvFlag = RECEIVE_OK2;
            guc_ShowTimeTxState = TRAINING_IN_PROGRESS;  /* indicates the BG is active */
            guc_TxDataPumpState = TRAINING_WAITING;
#ifdef ADSL_62
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ClearTxZephyrRegs);
#endif
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeTx);
            gs_TxSubStateCnt = 1;
            gs_TxSubState = REVERB5_TX_WAIT2;
         }
         break;

      case REVERB5_TX_WAIT2:
         gs_TxSubStateCnt++;
         if((guc_ShowTimeTxState == TRAINING_DONE) &&
            (guc_TxDataPumpState != TRAINING_DONE)){
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxDataPumpSetUp);
         }
         if (guc_TxDataPumpState == TRAINING_DONE){
            gs_TxSubState = REVERB5_TX_WAIT3;
         }
         break;

      case REVERB5_TX_WAIT3:
         gs_TxSubStateCnt++;
         /*extend the duration of the state to the maximum allowed by the spec */
         if (gs_TxSubStateCnt >= REVERB5_SUBSTATE_LENGTH_AFTER_CRC5)
         {

            {
            gs_TxNextState = R_SEGUE4_TX;
            gpF_TxStateFunc = (PtrToFunc)RSegue4TxF;
            }
         }
         break;
   }
   /* Check if time out happens */
   if (gl_TxSymbolCount == (R_REVERB5_TX_TIMEOUT-1)) {
      gs_TxNextState = FAIL_TX;

      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RReverb5Tx_C_SEGUE2_Failure;
   }
}

#undef   REVERB5_TX_INITIALIZE
#undef   REVERB5_TX_WAIT1
#undef   REVERB5_TX_WAIT2
#undef   REVERB5_TX_WAIT3

