/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb6TxF.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "showinit.h"
#include "fifo.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "RSegue5TxF.h"
#include "states.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb6TxF
 *
 *  Description: R_REVERB6_TX transmits the R_Reverb signal.
 *
 *  Prototype: void RReverb6TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB6_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RReverb6TxF(void) {

   if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

      gft_IFFT_On = TRUE;
      gpft2_RCExchRcvFlag = &gft_RCSegue3RcvFlag;
         /* Start initializing Showtime TX */
      *gpft2_RCExchRcvFlag = NOT_RECEIVE;
   }

   /* If RX has completed detection of R_C_CRC_RA2 or R_C_CRC2 or R_C_CRC5 or R_C_SEGUE3  */
   /* (indicated by setting gft_RCExchRARcvFlag or gft_RCExch1RcvFlag or gft_RCExch2RcvFlag or  */
    /*  gft_RCSegue3RcvFlag = RECEIVE_OK1) */
   /* continue to transmit R_Reverb for another 64 or 20 or 64 or 0 symbols respectively */
   /* and then enter next state */
   if(*gpft2_RCExchRcvFlag == RECEIVE_OK1) {
      gs_TxSubStateCnt = 0;
      *gpft2_RCExchRcvFlag = RECEIVE_OK2;
   }
   else if(*gpft2_RCExchRcvFlag == RECEIVE_OK2) {
      gs_TxSubStateCnt++;

      /* if gft_RxinitSwap == NO_CODESWAP, then the showtime code          */
      /* is always present.  If gs_CodeSwapSection == CSPAGE_BIS_SHOWBG2, then */
      /* all Tx showtime code has been swapped in.  Either case indicates     */
      /* that we may now transition to showtime (via R-SEGUE5). */
#ifdef BIS_CODESWAP
   #if !defined DANUBE_SE_CODESWAP && !defined ADSL_62
      if ( (gft_RxinitSwap == NO_CODESWAP)|| (gs_CodeSwapSection == CSPAGE_BIS_SHOWBG2) ){
   #else
      if ( (gft_RxinitSwap == NO_CODESWAP)|| (gs_CodeSwapSection == CSPAGE_BIS_SHOWBG1DMT) ){
   #endif
#else
      if (gft_RxinitSwap == NO_CODESWAP) {
#endif


         {
            gs_TxNextState = R_SEGUE5_TX;
            gpF_TxStateFunc = (PtrToFunc)RSegue5TxF;
         }
      }

   }

   /* Check if time out happens */
   if (gl_TxSymbolCount == (R_REVERB6_TX_TIMEOUT-1)) {
      gs_TxNextState = FAIL_TX;

      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RReverb6Tx_C_SEGUE3_Failure;
   }
}

