/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegue4TxF.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "showinit.h"
#include "fifo.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "RBGTxF.h"
#include "states.h"



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegue4
 *
 *  Description: Transmits the R_Segue signal to the ATU-C.
 *
 *  Prototype: void RSegue4TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_SEGUE4_TX,
 *------------------------------------------------------------------------
 *^^^
 */
void RSegue4TxF(void) {

   if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);

      gft_IFFT_On = TRUE;

   /*  state machine control */
      gt_StateMachCntrl.s_TXFollowingState  = R_BG_TX;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RBGTxF;

   }

#ifdef DANUBE
#ifdef TARGET_HW
     // This is part of PPE workaround: TX_FCI_DONE interrupt is disabled
     // in RReverb5 state. It is re-enabled in Segue4 before modem
     // enters Showtime.
    if (gl_TxSymbolCount == 2)
           AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_TX_FCI_DONE_Int);
#endif
#endif

   if (gl_TxSymbolCount == (R_SEGUE1_TX_LEN-1)) {
      /* set the next TX state */
      gs_TxNextState = R_BG_TX;
      gpF_TxStateFunc = (PtrToFunc)RBGTxF;
   }


}


