/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegue5TxF.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */
//*-------------------------------------------------------------------------------//
// RSegue5TxF.c
//
// History
//
// 21/11/2012 Kannan:
//          1. Added functions to notify PPE that both TX and RX directions leave
//             the showtime state and added an another function to notify PPE that
//             Zephyr Rx is disabled when link is drop from the showtime,
//             i.e bytes stop going to PPE.
//             Grep for "XDSLRTFW-541: Platform_VRX318"
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx-
//                   training messages (G.Hs + training) and to initiate the DMA of Debug Buffer
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//*-------------------------------------------------------------------------------//
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "exchsig.h"
#include "exchmsgs.h"
#include "exchdata.h"
#include "bitload.h"
#include "crc16.h"
#include "showinit.h"
#include "fifo.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "RBGTxF.h"
#include "states.h"
#include "DebugBuffer.h"
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
#include "showtime.h"



#ifdef IFX_XTC
   #include "xtc_setup.h"
   #include "ConfigXtcIfTxPath.h"
#endif
#ifdef CUSTOMER_TASKS
   #include "customertasks.h"
#endif


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegue5
 *
 *  Description: Transmits the R_Segue signal to the ATU-C.
 *
 *  Prototype: void RSegue5TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_SEGUE5_TX
 *------------------------------------------------------------------------
 *^^^
 */
void RSegue5TxF(void) {

   if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);

      gft_IFFT_On = TRUE;

   /*  state machine control */

   }

   if((guc_ShowTimeTxState != TRAINING_DONE) || (guc_TxDataPumpState != TRAINING_DONE)) {

      gs_TxNextState = FAIL_TX;
      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RSegue5Tx_C_SEGUE3_Failure;
      return;
   }

   if(gl_TxSymbolCount == (R_SEGUE2_TX_LEN-FRAME_LATENCY_TX_SHOWTIME - gs_num_preproc_frames))
   {
       /* enable TX data input on interleaved path */
      gft_TxInlvInputEnabled = TRUE;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxIntlvFraming);

   }

   if(gl_TxSymbolCount > (R_SEGUE2_TX_LEN-FRAME_LATENCY_TX_SHOWTIME - gs_num_preproc_frames))
      gft_TxDataPump_On = TRUE;

   if (gl_TxSymbolCount == (R_SEGUE2_TX_LEN-FRAME_LATENCY_TX_SHOWTIME)) {
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_MTE_Tx);
      gft_TxFastInputEnabled = TRUE;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxFastFraming);
   }


#ifdef IFX_XTC
   if ((gft_AlphaeusSel == FALSE) && (gl_TxSymbolCount == (R_SEGUE2_TX_LEN-2)))
   {
      // Enable Tx xTC I/F two frames before showtime
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxXtcIF);
   }
#endif


   if (gl_TxSymbolCount == (R_SEGUE1_TX_LEN-1)) {
      /* Use this variable to indicate progress of any last BgTasks using */
      /* R_NOSHOW page before we bring in SHOWBG1 and SHOWBG2 pages     */
      guc_BkgdTaskState = BKGDTASK_WAITING;
      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
      //XDSLRTFW-541: Platform_VRX318 (START_END)
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, DFE_PPE_LinkStatus_TxRxShow);
      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
      /* set the next TX state */
      gs_TxNextState = R_SHOWTIME_TX;
      gpF_TxStateFunc = (PtrToFunc)RShowtimeTxF_DMT;
#ifdef DEBUG_TRACES // XDSLRTFW-597
      //for debug purpose, log GHS messages recieved
      LogMessages(1,END_OF_THE_MSG,DEBUG_BUFFER_DELIMETER_TRAINING_END);
      RequestSwap_DebugBuff_GHS_OR_TRAINING_Tomem();
      gt_debugBufStatus.s_debugTrailLen=0;
      gt_DebugBufferStatus.s_debugBuffer_Size_of_Super_Frame_structure_Bytes=sizeof(gt_DebugBuffSuperframe);
#endif //#ifdef DEBUG_TRACES
   }

}


