/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   EXCHSIG.C
*
*   Functions of doing transmitting and receiving signal in exchange phase.
*
*-------------------------------------------------------------------------
*/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "memsetbf.h"
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void TxExchSig(uint8 uc_byte,
*                 int16 s_nR_MSGS1,
*                 int16 s_nR_MSGS2,
*                 int16 s_constellation_gain);
*
*   Abstract:
*       Modulate a byte of 8 bits into a DMT symbol. Two bits are modulated to
*  each subcarriers s_nR_MSGS1 to s_nR_MSGS1+3. The same byte is also modulated
*  onto the backup subcarriers s_bR_MSGS2 to s_bR_MSGS2+3
*
*   Input Parameters:
*     uc_byte -- input byte to be modulated
*     s_nR_MSGS1 -- the first channel of the first group of subcarriers
*     s_nR_MSGS2 -- the first channel of the backup group of subcarriers
*     s_constellation_gain -- constellation gain for QPSK case
*
*  Return
*     none
*
*
*  Global Variables:
*     gs_TxNumTones
*     gsa_TxToneBuf[]   -- (O) TX tones buffer
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE void TxExchSig(uint8 uc_byte, int16 s_nR_MSGS1, int16 s_nR_MSGS2, int16 s_constellation_gain)
{
   uint8 idx;
   int16 i, k, s_group1;

   /* ======================================================================================== */
   /* Clear buffer */
   /* ======================================================================================== */
   memset(gsa_TxToneBuf, 0, (sizeof(int16))*2*gs_TxNumTones);
   s_group1 = s_nR_MSGS1;

   /* ======================================================================================== */
   /* Modulate input byte onto the first group of subcarriers */
   /* ========================================================================================== */
   for(i=0; i<4; i++) {

      /* extract next two bits */
      idx = (uc_byte >> (i*2))& 0x3;
      k = s_group1*2;

      /* perform QPSK encoding */
      if(idx == 0) {
         gsa_TxToneBuf[k] = s_constellation_gain;
         gsa_TxToneBuf[k+1] = s_constellation_gain;
      }
      else if(idx == 1) {
         gsa_TxToneBuf[k] = -s_constellation_gain;
         gsa_TxToneBuf[k+1] = s_constellation_gain;
      }
      else if(idx == 2) {
         gsa_TxToneBuf[k] = s_constellation_gain;
         gsa_TxToneBuf[k+1] = -s_constellation_gain;
      }
      else {
         gsa_TxToneBuf[k] = -s_constellation_gain;
         gsa_TxToneBuf[k+1] = -s_constellation_gain;
      }
      s_group1++;
   }

   /* ======================================================================================== */
   /* Copy the above carriers to the backup carriers */
   /* ========================================================================================  */
   for(i=s_nR_MSGS1*2, k=s_nR_MSGS2*2; i<(s_nR_MSGS1+4)*2; i++, k++) {
      gsa_TxToneBuf[k] = gsa_TxToneBuf[i];
   }
}


C_SCOPE void RxExchSig_decodebits(int16 s_val, int16 s_val1, uint8 *puc_byte, int16 i)
{

         /* Decode the first group of carriers */
      if((s_val > 0) && (s_val1 < 0)) {
         *puc_byte = (*puc_byte | (2<<(i*2)));
      }
      else if((s_val < 0) && (s_val1 > 0)) {
         *puc_byte = (*puc_byte | (1<<(i*2)));
      }
      else if ((s_val < 0) && (s_val1 < 0)) {
         *puc_byte = (*puc_byte | (3<<(i*2)));
      }
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     int16 RxExchSig(int16 *psa_RxToneBuf,
*                 int16 s_nR_MSGS1,
*                 int16 s_nR_MSGS2,
*                 uint8 *puc_byte,
*                 uint8 *puc_bkpbyte);
*
*   Abstract:
*       Demodulate a DMT symbol to byte of 8 bits, assuming that two bits are
*  modulated to each subcarriers s_nR_MSGS1 to s_nR_MSGS1+3. The same byte is
*  also modulated onto the backup subcarriers s_bR_MSGS2 to s_bR_MSGS2+3
*
*   Input Parameters:
*     s_nR_MSGS1 -- the first channel of the first group of subcarriers
*     s_nR_MSGS2 -- the first channel of the backup group of subcarriers
*     psa_RxToneBuf[] -- pointer to a received DMT tone buffer
*
*  Output Parameters:
*     puc_byte -- pointer to output byte demodulated
*
*  Return
*     0 -- backup tones match to original tones
*     2 -- backup tones not match to original tones
*
*  Global Variables:
*
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE int16 RxExchSig(int16 *psa_RxToneBuf, int16 s_nR_MSGS1, int16 s_nR_MSGS2, uint8 *puc_byte, uint8 *puc_bkpbyte, uint8 *puc_meanbyte)
{
   uint8 uc_byte, uc_backup_byte;
   int16 i, k1, k2, k1p1, k2p1, s_group1, s_group2;
   uint8  uc_mean_byte;
   int16 mean_k1k2, mean_k1p1k2p1;


   s_group1 = s_nR_MSGS1;
   s_group2 = s_nR_MSGS2;

   uc_byte = 0;
   uc_backup_byte = 0;
   uc_mean_byte = 0;

   for(i=0; i<4; i++) {

      k1 = 2*s_group1++;
      k2 = 2*s_group2++;
      k1p1 = k1+1;
      k2p1 = k2+1;

      /* Decode the first group of carriers */
      RxExchSig_decodebits(psa_RxToneBuf[k1], psa_RxToneBuf[k1p1], &uc_byte, i);

      /* Decode the backup carriers */
      RxExchSig_decodebits(psa_RxToneBuf[k2], psa_RxToneBuf[k2p1], &uc_backup_byte, i);

      /* Decode the average of the first group of carriers and backup carriers */
      mean_k1k2 = (psa_RxToneBuf[k1] >> 1) + (psa_RxToneBuf[k2] >> 1);
      mean_k1p1k2p1 = (psa_RxToneBuf[k1p1] >> 1) + (psa_RxToneBuf[k2p1] >> 1);

      RxExchSig_decodebits(mean_k1k2, mean_k1p1k2p1, &uc_mean_byte, i);

   }

   *puc_byte = uc_byte;
   *puc_bkpbyte = uc_backup_byte;
   *puc_meanbyte = uc_mean_byte;

   if(uc_byte == uc_backup_byte)
      return (0);
   else
      return (1);
}
