/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  hdlc_deframer.c
*
*
****************************************************************************/
#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "DSLEngin.h"
#include "fifo.h"
#include "rx_ovrhd_bis.h"
#include "ghs.h"
#include "hs_misc.h"
#include <string.h>
#include "rt_state.h"
#include "rx_eoc.h"
#include "cmv.h"
#include "trail.h"

#ifdef HDLC_LEAVE_TRAIL
extern   FILE *fp_HDLCdata;
#endif

extern int16 gs_Bis_OvhdMsgIndex;        // Initialize the log index to be a maximum value, so that by default we
                                                 // are not going to save Rx ovhd msg into gsa_StatesTrail[] array
extern uint16 gus_Rx_HDLCIndex;                     // Total Rx ovhd msg counter

// Counts of bad HDLC message types.
extern int16 gs_Invalid_Ovhd_Msg_FCS;
extern int16 gs_Invalid_Ovhd_Msg_BadEscape;
extern int16 gs_Invalid_Ovhd_Msg_Large;
extern int16 gs_Invalid_Ovhd_Msg_Small;

extern FlagT gft_HdlcMsgInProgress ;         // If true, Rx HDLC msg being received.
extern FlagT gft_escape_octet_received ;           // Last HDLC octet received was 0x7D escape character.


#define     HDLC_DEFRAMER_NORMAL    0
#define     HDLC_DEFRAMER_VALID_MSG    1
#define     HDLC_DEFRAMER_MSG_TOO_LARGE   2
#define     HDLC_DEFRAMER_BAD_ESC_SEQ  3
#define     HDLC_DEFRAMER_BAD_FCS      4
#define     HDLC_DEFRAMER_MSG_TOO_SMALL   5

/*****************************************************************************
*   Subroutine Name: HDLC_Deframer
*
*   Description:
*
*   Prototype:
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   Global Variables:
*
*
*******************************************************************************/

C_SCOPE int32 HDLC_Deframer(uint8 uc_byte)
{
   int i;
   int16 s_log_length;
   int32 l_return_code;

   if (uc_byte != OPENING_FLAG)
   {
      if (!gft_HdlcMsgInProgress) {
         // Opening flag.  Start of new message.
         gft_HdlcMsgInProgress = TRUE;
         gt_RxHDLCMsg.gus_FCS = 0xFFFF;
      }

      /* Copy the message in the corresponding buffer */
      /* NOTE: The buffer will have the Control field at the beginning */
      /* and FCS high and FCS low field at the end */

      /* ---- octet transparency ---- */
      if (gft_escape_octet_received == TRUE)
      {
         if((uc_byte == 0x5E) || (uc_byte == 0x5D))
         {
            uc_byte = uc_byte ^ 0x20;
            gft_escape_octet_received = FALSE;
         }
         else
         {
            // Invalid message (according to G997.1 $6.3.5)
            // 3: Message that contains control escape sequences other than 0x7D, 0x5E and 0x7D, 0x5D

            gs_Invalid_Ovhd_Msg_BadEscape++;
            l_return_code = HDLC_DEFRAMER_BAD_ESC_SEQ;
            goto EndOfMessage;
         }
      }
      else if ( (uc_byte == 0x7D) || (uc_byte == 0x7E))
      {
         gft_escape_octet_received = TRUE;
         /* This is an escape octet, don't add to message buffer */
         return(HDLC_DEFRAMER_NORMAL);
      }

      if (gus_rx_msg_index == MAX_RX_HDLC_MSG_SIZE)
      {
         // Message is larger than we have room for.
         gs_Invalid_Ovhd_Msg_Large++;
         l_return_code = HDLC_DEFRAMER_MSG_TOO_LARGE;
         goto EndOfMessage;
      }
      else
      {
         // Add byte to buffer
         guca_rx_hdlc_msg_buffer[gus_rx_msg_index] = uc_byte;
         gus_rx_msg_index++;
      }

      /* Compute FCS only after the escape octets have been removed */
      gt_RxHDLCMsg.gus_FCS = CalcCRC_Byte( uc_byte, gt_RxHDLCMsg.gus_FCS, FCS_GEN_POLY );
      return(HDLC_DEFRAMER_NORMAL);
   }
   else
   { // Opening/Closing FLAG

      if (gft_HdlcMsgInProgress)
      {
         uint8* gpuca_ovhd_log = (uint8*)(void *)gsa_StatesTrail;

         // Closing Flag

         gus_Rx_HDLCIndex++;
         l_return_code = HDLC_DEFRAMER_VALID_MSG;

         // log the ovhd msg index if necessary
         if ((gs_Bis_OvhdMsgIndex +3) < 2*MAX_STATES)
         {

            gpuca_ovhd_log[gs_Bis_OvhdMsgIndex++] = 0xFF;
            gpuca_ovhd_log[gs_Bis_OvhdMsgIndex++] = (gus_Rx_HDLCIndex >> 8) & 0xFF;
            gpuca_ovhd_log[gs_Bis_OvhdMsgIndex++] = gus_Rx_HDLCIndex & 0xFF;
            // protect the array from overflow
            s_log_length = 2*MAX_STATES - gs_Bis_OvhdMsgIndex;
            s_log_length = (s_log_length > gus_rx_msg_index)? gus_rx_msg_index:s_log_length;

            for (i = 0; i < s_log_length; i++)
            {
               gpuca_ovhd_log[gs_Bis_OvhdMsgIndex++] = guca_rx_hdlc_msg_buffer[i];
            }
         }

         // Check the invalid message (according to G997.1 $6.3.5)
         if  (gt_RxHDLCMsg.gus_FCS != MAGIC_FCS_CHECK)
         {
            l_return_code = HDLC_DEFRAMER_BAD_FCS;
            gs_Invalid_Ovhd_Msg_FCS++;
         }
         if ( gft_escape_octet_received )
         {// Illegal sequence: Control Escape octet followed immediately by a Flag, i.e., 0x7D, 0x7E
            l_return_code = HDLC_DEFRAMER_BAD_ESC_SEQ;
            gs_Invalid_Ovhd_Msg_BadEscape++;
         }
         if (gus_rx_msg_index < MIN_OVHD_MESSAGE_LEN)
         {
            // Message is too short: less than 4 octets in between flags not including transparency octets
            l_return_code = HDLC_DEFRAMER_MSG_TOO_SMALL;
            gs_Invalid_Ovhd_Msg_Small++;
         }

         // Received the closing flag, so message is complete.
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "\nHDLC_Received_Msg #%d\n", gus_Rx_HDLCIndex);
         for (j = 0; j < gus_rx_msg_index; j++)
         {
            fprintf(fp_HDLCdata, "%2x  ", guca_rx_hdlc_msg_buffer[j]);
         }
         fprintf(fp_HDLCdata, "\n");
#endif
#ifdef DEBUG_STREAMING
         // In case the new message will not fit in the rest of the EOC debug buffer, we will write it to the beginning
         if((gus_DSH_RX_EOC_idx+gus_rx_msg_index)>DSH_EOC_BUFFER_LENGTH)
         {
            gus_DSH_RX_EOC_idx=0;
         }
         memcpy(guca_DSH_RX_EOC_msg_buffer, &guca_rx_hdlc_msg_buffer[0], gus_rx_msg_index);
         DSH_SendStream(DSH_OCH_RX_MESSAGES,gus_rx_msg_index-2,&guca_DSH_RX_EOC_msg_buffer[0]);
         // Avoid overwriting previous message by shifting the gus_DSH_RX_EOC_idx behind this message
         gus_DSH_RX_EOC_idx+=gus_rx_msg_index;


#endif
         // For ADSL2, process any valid message.
         if (l_return_code == HDLC_DEFRAMER_VALID_MSG)
            if (gul_ModeControl & STAT_ConfigMode_ADSL2_ALL)
               Rx_ovhd_msg_handler();
            else
               Rx_DMT_ClearEOC_msg_handler();

         goto EndOfMessage;
      }
      else
         return(HDLC_DEFRAMER_NORMAL);// No message in progress, ignore flag.
   }

EndOfMessage:
   /* Clear the flag to check for escape octet as message ended */
   gft_escape_octet_received = FALSE;
   gus_rx_msg_index = 0;
   gft_HdlcMsgInProgress = FALSE;
   // reset global msg buffer
   memset(guca_rx_hdlc_msg_buffer, 0, MAX_RX_HDLC_MSG_SIZE);
   return (l_return_code);
}
