/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   DetectTones_Ghs.c
 *
 *------------------------------------------------------------------------
 */
// *****************************************************************************
// DetectTones_Ghs.c
//
// History
// 26/07/2010 ChihWen/Palaksha/Bhadra: In Huawei lab against a CNXT CO (H33EADB, B02D111/D57.1.10),
//       Xtalk-like noise will make CPE falsely detect C-Tone, and fail later in handshaking.
//       Here we increase tone detect scale from 3 to 8 in handshaking.And force to DMT mode
//       or T1413 mode when measured power in RCGlaf1 is lower than 21dB when against
//       CNXT CO (version number = 0x07 or 0x0b).
//       This fix is controlled by Bit#8 (0x0100) of CMV OPTN 25 0 (0 = feature disabled 1 = feature enabled)
//       Grep for SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop
// 23/08/2011 Kannan: Use "gsa_RxRepFrameAlignBuf" buffer to detect Ghs tone instead
//      of gsa_RxToneBuf, since gsa_RxRepFrameAlignBuf contains accumulated and averaged
//      data whereas gsa_RxToneBuf contain just one frame of ghs data.
//      Grep for
//      XDSLRTFW-327 Bugfix_DS_ALL_ALL_UseAveragedRxtoneBufferForGhsToneDetection
//
// 04/12/2013 Sriram Shastry: It  has seen in DTAG lab that due to  Xtalk from neighbouring  line , there is false Ctone detection
//             Fine tuned GHs detection scale factor. cmv OPTN 33 0 bit 13 (0x2000) enabled by default.
//              Grep for :  XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413
//
// 10/25/2016 Abu Rahman: XDSLRTFW-2882 : Wrong HS tone selection in case of DPBO (ADSL)
//          A new CTone Detection algorithm is developed which uses Average power of the CTones and their neighboring tones
//            instead of Average constellations of those tones (used in previous implementation).
//            New Tone Detection algorithm is described in GhsCToneDetectionAlgorithm() section.
//            Grep for XDSLRTFW-2882
//
// 23/05/2017 Abu Rahman
//            XDSLRTFW-3258: CPE starts G.HS every 8sec in ADSL mode &
//            XDSLRTFW-3318: R7AMR6: CPE not linking up reliable in T1.413
//            Bug fix in GhsCToneDetectionAlgorithm() function. Due to this bug C-Tones were
//            falsely detected while there were no CTones on the line.
//            Grep for XDSLRTFW-3318
//
// 04/10/2017 Abu Rahman
//            XDSLRTFW-3477: VRX518 HS started without CO connected ADSL2+
//            The false C-Tone detection issue is seen while C-Tone constellation is [(+/-)1 + (+/-)j] and average noise power constellation
//            is (0, +/-1 or +/-j) which leads to 3dB SNR on C-Tone. In real life scenario, C-Tones with very low constellation
//            (Amplitude power < 6dB) can not contain any decodable information. False C-Tones detection issue is solved by
//            filtering out this kind of tones from the C-Tone detection algorithm. This removal will not have any impact on
//            the Ghs message decoding.
//            Grep for XDSLRTFW-3477
// *****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "ghs.h"
#include "states.h"
#include "fifo.h"
#include "cmv.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "detect.h"
#include "hndshk_Data.h"
#include "pga_set.h"
#include "act_T1413.h"
#include "RCGalf1RxF.h"
#include "SetPgaForToneDetection.h"
#include "accum32.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "pll.h"
#include "afe.h"
#include "vecpwr.h"

extern int16 ConvertToDB(int32 l_xin);    //XDSLRTFW-2882 : Wrong HS tone selection (Start-End)



#define GHSCARRIERSET_ACCUM_PREPARE 0
#define GHSCARRIERSET_ACCUM         1
#define GHSCARRIERSET_AVERAGE    2
#define GHSCARRIERSET_DETECT     3

//SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (begin)
#define GHS_DETECT_SCALE   8
//SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (end)

//XDSLRTFW-2882 : Wrong HS tone selection (Start)
#define NO_TONESET -1
#define A43_TONESET 0
#define B43_TONESET 1
#define A43C_B43C_TONESET 2



/*^^^
*-----------------------------------------------------------------------------
*   Prototype: int16 GhsCToneDetectionAlgorithm(int16 s_THRESHOLD)
*
*   Description:
*     This Function determines the best ToneSet (eg A43, B43 or A43/B43C) to decode the GHs messages.
*
*  Algorithm:
*     1. If the CTone SNR >=  s_THRESHOLD, this function declare this tone as usable tone for Ghs decoding
*     2.
*        Legend #A43 : No OF Usable Tone in A43 ToneSet
*        Legend SNR_A43 : Total SNR of Usable Tones in A43 ToneSet
*
*
*     If  ( #A43 ==3 ) Selected ToneSet = A43
*     Else if   ( #B43 ==3 ) Selected ToneSet = B43
*     Else if   ( #B43C ==3 ) Selected ToneSet = B43C
*     Else{       // Comment : No ToneSet has 3 Usable tones
*              // if only one has highest number of Usable Tone
*              If ((#B43C  > #A43) &  (#B43C > #B43) Selected ToneSet = B43C
*              else if (#A43 > B43C) Selected ToneSet = A43
*              else if (#B43 > B43C) Selected ToneSet = B43
*              else {// Comment : if two ToneSets have similar number of Usable Tone, SNR based detection is used
*                    If ((SNR_B43C  > SNR_A43) &  (SNR_B43C > SNR_B43)) Selected ToneSet = B43C
*                          else if (SNR_A43 >= SNR_B43C) Selected ToneSet = A43
*                          else if (SNR_B43 >= SNR_B43C) Selected ToneSet = B43
*           }
*     }
*
*
*
*   Input Parameters:
*     gula_GhsTonePower[] : Contains average tone power values in linear format
*     gula_GhsToneNoisePower[]: Contains average neighboring tones noise power value in linear format

  *   Output Parameters:
  *      Structure: gt_GhsCToneInfo
  *
  *      gt_GhsCToneInfo[].s_TonePwr : Average Tone Signal PWR in 8.8 dB Format
  *      gt_GhsCToneInfo[].s_NeighboingToneNoisePwr :Average Neighboring Tones Noise PWR in 8.8 dB Format
  *      gt_GhsCToneInfo[].us_ToneUsability : 1 : Usable for detection, 0 : non usable for detection
  *
  *
  *   Return value:
  *      Detected CTone Set
  *      -1 :  NO_TONESET
  *      0 :  A43_TONESET
  *      1 :  B43_TONESET
  *      2 :  A43C_B43C_TONESET
  *
  *   Global variables:
  *      gula_GhsTonePower
  *      gula_GhsToneNoisePower
  *      gt_GhsCToneInfo
  *-----------------------------------------------------------------------------
^^^*/



int16 GhsCToneDetectionAlgorithm(int16 s_THRESHOLD)
{
   //CTone order in gt_GhsCToneInfo struct is {40,56,64,72,88,96,257,293,337}
   int16 s_CToneSetIdx = 0 ;  // A43 = 0, B43 = 1, A43c/B43c = 2;
   int16 s_CToneIdx = 0; // 0 -> first tone in Toneset, 1-> second Tone in Toneset, 2-> third tone in Toneset
   int16 sa_NoOfUsableToneInToneSet[3] = {0};

   int16 s_ToneSetDetected = -1;

   uint32 ula_TotalToneSetSNR[3] = {0};

   int16 s_TotalNoOfDecodableTone = 0; // XDSLRTFW-3318 R7AMR6: CPE not linking up reliable in T1.413
                                    // without logic related to this variable (s_TotalNoOfDecodableTone) could miss detect
                                    // G.Hs tone while there are no C-Tone tones present on the line!
                                       // This variable ensures that Ghs C tones are detected only if C tones are present on the line.



   // This section calculates Tone power and Noise power in dB, also finds the usable tones
   for( int i = 0; i < 9; i++)
   {
      gt_GhsCToneInfo[i].s_TonePwr =   (ConvertToDB(gula_GhsTonePower[i])); // Signal Power in 8.8 dB format
      // XDSLRTFW-3477(Start): VRX518 HS started without CO connected ADSL2+
      // The false C-Tone detection issue is seen while C-Tone constellation is [(+/-)1 + (+/-)j] and average noise power constellation
      // is (0, +/-1 or +/-j) which leads to 3dB SNR on C-Tone. In real life scenario, C-Tones with very low constellation
      // (Amplitude power < 6dB) can not contain any decodable information. False C-Tones detection issue is solved by
      // filtering out this kind of tones from the C-Tone detection algorithm. This removal will not have any impact on
      // the Ghs message decoding.
      if (gt_GhsCToneInfo[i].s_TonePwr < (6<<8) ) // 6dB in 8.8 format
      {
         gt_GhsCToneInfo[i].s_TonePwr = 0;
         gt_GhsCToneInfo[i].s_NeighboingToneNoisePwr = 0;
         gt_GhsCToneInfo[i].us_ToneUsability = 0;
         continue;
      }
      // XDSLRTFW-3477(End)

      gt_GhsCToneInfo[i].s_NeighboingToneNoisePwr = (ConvertToDB(gula_GhsToneNoisePower[i])); // Noise Power in 8.8 dB format
      if (gt_GhsCToneInfo[i].s_NeighboingToneNoisePwr < 0)
         gt_GhsCToneInfo[i].s_NeighboingToneNoisePwr = 0; //avoid negative power


      // if the Tone power is 3 dB higher than the tone noise power.
      if (gt_GhsCToneInfo[i].s_TonePwr - gt_GhsCToneInfo[i].s_NeighboingToneNoisePwr >= s_THRESHOLD )
      {
         gt_GhsCToneInfo[i].us_ToneUsability = 1;
         s_TotalNoOfDecodableTone++;            // XDSLRTFW-3318 R7AMR6: CPE not linking up reliable in T1.413
      }
   }

   // This section calculate the number of usable tones in ToneSet and Total SNR among usable tones in ToneSet
   for (s_CToneSetIdx = 0; s_CToneSetIdx < 3; s_CToneSetIdx++)
   {
      for (s_CToneIdx = 0; s_CToneIdx < 3; s_CToneIdx++)
      {
         if(gt_GhsCToneInfo[s_CToneSetIdx*3+s_CToneIdx].us_ToneUsability)
         {
            // calculate no of usable tones per tone set
            sa_NoOfUsableToneInToneSet[s_CToneSetIdx]++;
            // calculate sum of usable SNR per ToneSet
            ula_TotalToneSetSNR[s_CToneSetIdx] += gt_GhsCToneInfo[s_CToneSetIdx*3+s_CToneIdx].s_TonePwr - gt_GhsCToneInfo[s_CToneSetIdx*3+s_CToneIdx].s_NeighboingToneNoisePwr;
         }
      }
   }

   // ToneSet Detection algorithm begin here....

   // Assumption : A43 and B43 Tone sets never come together
   // sa_NoOfUsableToneInToneSet[0] = No of A43 Tone
   // sa_NoOfUsableToneInToneSet[1] = No of B43 Tone
   // sa_NoOfUsableToneInToneSet[2] = No of B43c Tone

   // ula_TotalToneSetSNR[0] = Total SNR of A43 usable tones
   // ula_TotalToneSetSNR[1] = Total SNR of A43 usable tones
   // ula_TotalToneSetSNR[2] = Total SNR of A43 usable tones

   if (sa_NoOfUsableToneInToneSet[0] == 3)
   {
      s_ToneSetDetected = A43_TONESET; // A43 has selected
   }
   else if (sa_NoOfUsableToneInToneSet[1] == 3)
   {
      s_ToneSetDetected = B43_TONESET; // B43 has selected
   }
   else if (sa_NoOfUsableToneInToneSet[2] == 3)
   {
      s_ToneSetDetected = A43C_B43C_TONESET; // B43C/A43C has selected
   }
   else  // There are no tone set with 3 usable tones
   {
      if((sa_NoOfUsableToneInToneSet[2] > sa_NoOfUsableToneInToneSet[0]) & (sa_NoOfUsableToneInToneSet[2] > sa_NoOfUsableToneInToneSet[1]))
      {
         s_ToneSetDetected = A43C_B43C_TONESET;  // A43C has more usable tones
      }
      else if (sa_NoOfUsableToneInToneSet[0] > sa_NoOfUsableToneInToneSet[2])
      {
         s_ToneSetDetected = A43_TONESET; // A43 has more usable tones
      }
      else if (sa_NoOfUsableToneInToneSet[1] > sa_NoOfUsableToneInToneSet[2])
      {
            s_ToneSetDetected = B43_TONESET; // B43 has more usable tones
      }
      else if (s_TotalNoOfDecodableTone )// Multiple toneset have same number of tones : Decision is taken by using Average SNR information
      {
         if((ula_TotalToneSetSNR[2] > ula_TotalToneSetSNR[0]) & (ula_TotalToneSetSNR[2] > ula_TotalToneSetSNR[1]))
         {
            s_ToneSetDetected =  A43C_B43C_TONESET;  // A43C/B43C has more total SNR
         }
         else if (ula_TotalToneSetSNR[0] >= ula_TotalToneSetSNR[2])
         {
            s_ToneSetDetected =  A43_TONESET; // A43 has more or similar total SNR than A43C
         }
         else if (ula_TotalToneSetSNR[1] >= ula_TotalToneSetSNR[2])
         {
               s_ToneSetDetected =  B43_TONESET; // B43 has more or similar total SNR than B43C
         }
      }
   }

   return(s_ToneSetDetected);

}

//XDSLRTFW-2882 : Wrong HS tone selection (End)






void BgDetectMultiTones(void)
{
   //SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (begin)
   int16 s_ghs_detect_scale;
   int16 s_ToneSet;

    if (OPTNArray[OPTN_AlgControl3] & CMV_TO_BoostGhsToneDetScale)
   {
        s_ghs_detect_scale = (GHS_DETECT_SCALE << 8);
   }
   else
   {
   // XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(Start)
      s_ghs_detect_scale = (DETECT_SCALE << 8);          /* scale = 10*log10(3) =   4.7712dB */
      /* XDSLRTFW-2191 (Start)*/
#ifdef ISDN
      if ((OPTNArray[OPTN_AlgControl3] & CMV_TO_IncreaseGhsToneDetectScale) == CMV_TO_IncreaseGhsToneDetectScale)
         s_ghs_detect_scale = (DETECT_SCALE_ISDN_HSK << 8);       /* scale = 10*log10(4) =   6.0206dB */
#else
      if ((OPTNArray[OPTN_AlgControl3] & CMV_TO_IncreaseGhsToneDetectScale) == CMV_TO_IncreaseGhsToneDetectScale)
         s_ghs_detect_scale = (DETECT_SCALE_AVDSL << 8);          /* scale = 10*log10(5) =   6.9897dB */
#endif
      /* XDSLRTFW-2191 (End)*/
   // XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(End)

   }
    gft_DetectGhsCarrierSet_TonesDetected = FALSE;

   //XDSLRTFW-2882 : Wrong HS tone selection (Start)
    /* ---- detect tones ---- */

    s_ghs_detect_scale = 0x300; // 3 dB in 8.8 dB Format

   s_ToneSet = GhsCToneDetectionAlgorithm(s_ghs_detect_scale);

   switch(s_ToneSet)
   {
      case A43_TONESET:
            gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_A43]++;
            gft_DetectGhsCarrierSet_TonesDetected = TRUE;
            break;
      case B43_TONESET:
            gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_B43_J43]++;
            gft_DetectGhsCarrierSet_TonesDetected = TRUE;
            break;

      case A43C_B43C_TONESET:
            gsa_DetectGhsCarrierSet_DetectCount[DS_GHS_CARRIER_SET_A43c]++;
            gft_DetectGhsCarrierSet_TonesDetected = TRUE;
            break;
      case NO_TONESET:
         break;
   }
   //XDSLRTFW-2882 : Wrong HS tone selection (End)
    //SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (end)
   guc_BkgdTaskState = TRAINING_DONE;
}

//XDSLRTFW-2882 : Wrong HS tone selection (Start)
int16 DetectGhsCarrierSet(void)
{
   int16 s_shift = 3;
   int16 sa_CToneIdx[9] = {40,56,64,72,88,96,257,293,337};
   int16 i;


   switch (gs_DetectGhsCarrierSet_State)
   {
   case GHSCARRIERSET_ACCUM_PREPARE:
      /* clear accum buffer before first accumulation */
      gs_DetectGhsCarrierSet_AccumCount = 0;
      for (i = 0; i < 9; i++)
      {

         gt_GhsCToneInfo[i].s_TonePwr = 0;
         gt_GhsCToneInfo[i].s_NeighboingToneNoisePwr = 0;
         gt_GhsCToneInfo[i].us_ToneUsability =0;

         // Accumulation buffer
         gula_GhsTonePower[i] = 0;
         gula_GhsToneNoisePower[i] = 0;
      }
      gs_DetectGhsCarrierSet_State = GHSCARRIERSET_ACCUM;


      break;

   case GHSCARRIERSET_ACCUM:
      /* RxToneBuf captured when 2<=TxSymbolCount<=4 are affected by echo due to Tx phase reversal every 69 frames */
      /* Hence, discard those averaged recieved signals that have been affected by echo due to Tx phase reversal */
      if ((gl_TxSymbolCount % TIME_16MS) < 2 || (gl_TxSymbolCount % TIME_16MS) > 4)
      {
         /* Accumulate received signal */
         gs_DetectGhsCarrierSet_AccumCount++;
            /************************************************************************/
         // Calculate CTone power and its neighboring tone power (noise)
         //int16 sa_CToneIdx[9] = {40,56,64,72,88,96,257,293,337};

         uint32 l_tone_power;
         uint32 l_rx_power;
         int16 s_first_tone, s_last_tone;

         for(i = 0; i < 9; i++)
         {
            s_first_tone = sa_CToneIdx[i] - HALF_DETECT_BAND; // CTone -4
            s_last_tone  = sa_CToneIdx[i] + HALF_DETECT_BAND; // CTone +4

            l_tone_power = VectorPower(gsa_RxToneBuf, (2*sa_CToneIdx[i]), 2, s_shift); // calculate CTone  Power
            l_rx_power = VectorPower(gsa_RxToneBuf, (2*s_first_tone), (2*(s_last_tone - s_first_tone+1)), s_shift); // caclulate total 9 tone power (noise) from (CTone-4) to (Ctone+4)

            gula_GhsTonePower[i] += l_tone_power; // Accumulate Ctone power over symbol
            gula_GhsToneNoisePower[i] += (l_rx_power - l_tone_power) >>3; // Accumulate average noise power form (CTone -4) to (CTone+4) except (CTone)

         }
      }
      /* Accumulation done, goto next state */
      if (gs_DetectGhsCarrierSet_AccumCount == (1<<GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS))
      {
            /* Average accumulated signal */
            gs_DetectGhsCarrierSet_State = GHSCARRIERSET_AVERAGE;
      }
      break;

   case GHSCARRIERSET_AVERAGE:

         for( i = 0; i < 9; i++)
         {
            gula_GhsTonePower[i] = gula_GhsTonePower[i] >> GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS; // Average CTone Power over 256 symbol
            gula_GhsToneNoisePower[i] = (gula_GhsToneNoisePower[i] >> GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS); // Average CTone noise power over 256 symbol
         }

         /* Average accumulated signal */
         guc_BkgdTaskState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDetectMultiTones);
         gs_DetectGhsCarrierSet_State = GHSCARRIERSET_DETECT;
         break;

   case GHSCARRIERSET_DETECT:
      if (guc_BkgdTaskState == TRAINING_DONE &&
         gs_SetPgaForTones_State == SETPGATONES_LEVEL_OK)
      {
         guc_BkgdTaskState = TRAINING_WAITING;
         gs_DetectGhsCarrierSet_State = GHSCARRIERSET_ACCUM_PREPARE;
         return((int16)(gft_DetectGhsCarrierSet_TonesDetected));
      }
   }
   return(-1);
}
//XDSLRTFW-2882 : Wrong HS tone selection (End)
#undef GHSCARRIERSET_ACCUM
#undef GHSCARRIERSET_AVERAGE
#undef GHSCARRIERSET_DETECT

#undef R_C_TONES_RX_DETECT_TONES
#undef R_C_TONES_RX_COUNT_SYMBOLS
