/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   HSMsgTx_Util.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RFlag2TxF.h"
#include "RGalf2TxF.h"
#include "gdata_bis.h"
#include "trail.h"



#ifdef BIS_CODESWAP
#include "soc_codeswap.h"
#endif

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RHSMsgTxF
 *
 *  Description:
 *    Handshake messages are transmitted until message exchange is
 *    over and cleardown is requested.  Idle FLAGs are transmitted when there
 *    is no message to transmit.
 *
 *  Prototype: void RHSMsgTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]              - frequency domain samples, used in TxBit()
 *      guc_TxOctet                 - (I/O) current octet being transmitted
 *      gs_RxState                  - (I) current RX state
 *      gs_TxSubState               - (I/O) current TX substate
 *      gl_TxSymbolCount            - (I) # symbol periods in current TX state
 *      gs_TxNextState              - (O) TX state that will begin next symbol period
 *      gpuca_TxMsgBuf              - (I) message octets to be transmitted in
 *                                    this state
 *      gs_TxMsgBufCnt              - (O) # octets in the message buffer to be
 *                                    transmitted in this state
 *      gt_hsc                      - (I/O) handshake control structure
 *      gft_RxSymbolReAlignRequired - (I/O) symbol realign flag
 *
 *  Substates:
 *      R_HS_MSG_TX_PREFIX_FLAG     - Transmits NUM_PREFIX_FLAG mandatory FLAGs
 *                                    at the head of a message.
 *      R_HS_MSG_TX_MESSAGE         - Transmits a message body.
 *      R_HS_MSG_TX_POSTFIX_FLAG    - Transmits NUM_POSTFIX_FLAG mandatory FLAGs
 *                                    at the tail of a message.
 *      R_HS_MSG_TX_IDLE_FLAG       - Transmits FLAGs while waiting for a
 *                                    message in Rx side.
 *
 *  Notes: implements state R_HS_MSG_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_HS_MSG_TX_PREFIX_FLAG     (0)
#define R_HS_MSG_TX_MESSAGE         (1)
#define R_HS_MSG_TX_POSTFIX_FLAG    (2)
#define R_HS_MSG_TX_IDLE_FLAG       (3)


// newly created global variables for msg segmentation
//uint8 guca_MsgSegment[2*(gs_MaxMsgLen+FCS_LEN)]; // the reason we put 2*(MAX_MESSAGE_LEN+FCS_LEN) here is that
                                  // in G.HS standard sec 10.3, saying that "Not including the two octets
                                  // of FCS and any octets that have been inserted to achieve octet
                                  // transparency, the maximum number of octets in any frame shall be 64"
                                  // Therefore, the transmitted msg could reach 2*(MAX_MESSAGE_LEN+FCS_LEN)
#ifdef DANUBE_TEMP
DATA_MAP_ILV1_GHS
#else
DATA_BULKO2_BEGIN
#endif
DATA_MAP_END//DATA_BULKO2_BEGIN
// msg segment length
extern int16 gs_MsgSegLen;
extern uint8 guca_MsgSegment[256];

/* =============================================== */
/* local functions to create each msg segment  */
/* =============================================== */
void TxSegmentMsg()
{
   uint16       us_FCS;                       /*  Frame Check Sequence */
   int       idx, i;
// uint8        uca_M[gs_MaxMsgLen+FCS_LEN];
   uint8        uca_M[256];          //temporary workaround
   int16        s_MsgLen;
    uint8*       uca_Msg;

   // Log the Tx msg segment count
   guc_TxHSMsg_SegmentCnt++;

   uca_Msg = gpuca_TxMsgBuf+gs_MsgOffset;

   // calculate message length
    if ((gs_MsgOctetCnt+gs_MaxMsgLen)>gs_TxMsgBufCnt)
      s_MsgLen = gs_TxMsgBufCnt-gs_MsgOctetCnt;
   else
      s_MsgLen = gs_MaxMsgLen;

   gs_MsgOffset += s_MsgLen;

   /* ==== Frame Check Sequence ==== */
   us_FCS   = 0xFFFF;    /*  initialize to all binary 1's */
   for ( idx = 0; idx < s_MsgLen; idx++ ) {
      uca_M[idx] = uca_Msg[idx];
      us_FCS = CalcCRC_Byte( uca_M[idx], us_FCS, FCS_GEN_POLY );
   }

   // for special case, we will append a dummy one at the end of the msg segment
   if (s_MsgLen == 1) {
      uca_M[idx++] = 0x80;
      us_FCS = CalcCRC_Byte( uca_M[s_MsgLen], us_FCS, FCS_GEN_POLY );
   }

   us_FCS = ~us_FCS;   /*  take 1's compliment */

   uca_M[idx++] = (uint8) us_FCS;
   uca_M[idx++] = (uint8) ( us_FCS >> 8 );

   s_MsgLen = idx;
   idx = 0;

   /* ==== Octet transparency ==== */
   for ( i = 0; i < s_MsgLen; i++ ) {

      switch (uca_M[i]) {

         case FLAG:
         case 0x7D:
            guca_MsgSegment[idx++] = 0x7D;
            guca_MsgSegment[idx++] = uca_M[i] ^ 0x20;
            break;

         default:
            guca_MsgSegment[idx++] = uca_M[i];
            break;

      }   /*  switch */

   }   /*  for */

   gs_MsgSegLen = idx;  // this is the length of the msg segment
   gs_TxMsgBufCnt += (idx-s_MsgLen+FCS_LEN); // 2FCS octet and possible octet transparency

}

void TxFlag( int16 s_Num_Flag, int16 s_NextSubState )    {
    gs_TxOctetCnt++;
    if ( gs_TxOctetCnt >= (s_Num_Flag) ) {
        gs_TxOctetCnt = 0;
        gs_TxSubState = (s_NextSubState);

    }
    guc_TxOctet = FLAG;
}   /*  TxFlag */

/* =============================================== */
/* macro to prepare for next handshake message exchange */
/* =============================================== */
void InitNextMsgExchange()   {
    if ( gs_TxMsgBufCnt > 0 ) {  /* start from R_HS_MSG_TX_PREFIX_FLAG if there is a message to transmit*/
        gs_TxOctetCnt = 1;
//    gs_MsgOctetCnt = 0;
        gs_TxSubState = R_HS_MSG_TX_PREFIX_FLAG;
    }
    else {                      /* start from R_HS_MSG_TX_IDLE_FLAG if there is nothing to transmit */
        gt_hsc.s_TxMsgComplete = TRUE;
        gs_TxSubState          = R_HS_MSG_TX_IDLE_FLAG;
    }
}



#undef R_HS_MSG_TX_PREFIX_FLAG
#undef R_HS_MSG_TX_MESSAGE
#undef R_HS_MSG_TX_POSTFIX_FLAG
#undef R_HS_MSG_TX_IDLE_FLAG

#undef TxFlag
#undef InitNextMsgExchange

