/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   MapInputtoINP_CLR.c
 *
 *   Map input value for INP in CLR to 2*(actualINP) value it represents
 *
 *------------------------------------------------------------------------
 */
#include <string.h>
#include "common.h"

int16 MapInputtoINP_CLR(int16 s_inputMinINP);

/*^^^
 *------------------------------------------------------------------------
 *

  Name : MapInputtoINP_CLR(int16 s_inputMinINP)

  Description: Function to map the INP value sent in CLR to required INP in frames.

  Inputs : ta_TpsTcType[s_index].s_IMAxINP :Handshake INP value

 *------------------------------------------------------------------------
 *^^^
 */


int16 MapInputtoINP_CLR(int16 s_inputMinINP)
{
   int16 s_shift;
   int16 s_ActualMinINP;

   // For MinINP value: 0,1/2,1 frame, input exchanged value is 2 * ActualINP

   if (s_inputMinINP <=2)
      return(s_inputMinINP);

   if ((s_inputMinINP & 0xF0) == 0) //only 4 bits used
   {
         s_shift = s_inputMinINP>>2;
         s_ActualMinINP = (2 << s_shift);

   }

   else if ((s_inputMinINP & 0x0F) == 0XF) //INP =16
   {
         s_ActualMinINP = 16 ;
   }
   else
   {
      // INP 2-15 frames
      s_shift = ( s_inputMinINP >> 4);

      if (s_shift ==0)
         s_ActualMinINP = 2 ;
      else
         s_ActualMinINP = s_shift;

   }

   return (s_ActualMinINP * 2);

}

