/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCFlag1RxF.c
 *
 *
 *------------------------------------------------------------------------
 */

// ******************************************************************
// RCFlag1RxF.c
//
// History
//
// 20/04/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is ONE(enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "RCHSMsgRxF.h"



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCFlag1RxF
 *
 *  Description: R_C_FLAG1_RX detects a FLAG octet.
 *  Upon receiving C_Flag1, Rx gets ready to receive messages.
 *
 *  Prototype: void RCFlag1RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]   - input of IFFT, used in RxBit()
 *      gs_RxToneBuf[]    - frequency domain samples, used in RxBit()
 *      gs_RxAn_Prev      - previous DPSK symbol, used in RxBit()
 *      gsa_RxSubBitBuf[] - 8 DPSK symbols for a bit, used in RxBit()
 *      guc_RxOctet       - (I/O) current octet being transmitted
 *      gs_RxState        - (I) current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *
 *  Notes: implements state R_C_FLAG1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCFlag1RxF(void) {

    RxBit( (int16) (gl_RxSymbolCount & MODULO_BY_8_MASK) );

    /* ==== if one full octet received, check for FLAG character ==== */
    if ( ( gl_RxSymbolCount & MODULO_BY_64_MASK ) == (SYMBOLS_PER_OCTET - 1) ) {

#ifdef DEBUG_GHS
      printf( "Rx\t%x\n", guc_RxOctet );
#endif

      /* ---- check for FLAG --- */
      if (guc_RxOctet == FLAG) {
        //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
//Clear the B43 detection flag guc_AnnexMCarSet_Detect once C-FLAG1 is not correctly decoded.
#ifndef ISDN
         if ((guc_AnnexMCarSet_Detect & 0x1) && (guc_RxOctet != guc_RxOctet_B43))
            guc_AnnexMCarSet_Detect &= 0xfe;
#endif
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
         gs_RxNextState = R_C_HS_MSG_RX;
         gpF_RxStateFunc = (PtrToFunc)RCHSMsgRxF;
      }
      /* ---- o.w. check for timeout or unexpected (non-GALF) octet --- */
      else if ( (gl_RxSymbolCount >= HS_TONE_TIMEOUT) || (guc_RxOctet != GALF) ) {

         if (gft_GotoFailStateOnTimeOut_FromHandshake == FALSE)
         {
            gs_RxNextState = R_C_SILENT1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

            /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
            gs_TxNextState = R_SILENT0_TX;
            gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
         }
         else
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_GHS_TONE_LOSS_OR_TIME_OUT;
         }

      }

    }   /*  if (complete an octet) */

}   /*  RCFlag1RxF */

