/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCFlag2RxF.c
 *
 *
 *------------------------------------------------------------------------
 */
// *------------------------------------------------------------------------//
// RCFlag2RxF.c
//
// History
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// *------------------------------------------------------------------------//

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "gdata_bis.h"




void TerminateHandshakeRx(void);

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RCFlag2RxF
 *
 *  Description: Wait until Tx finishes GALF transmission and move to next
 *  state.
 *
 *  Prototype: void RCFlag2RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *
 *  Notes: implements state R_C_FLAG2_RX_F
 *
 *-------------------------------------------------------------------
 *^^^
 */

#define R_C_FLAG2_RX_RECEIVE_FLAG   (0)
#define R_C_FLAG2_RX_END_OF_FLAGS   (1)

void RCFlag2RxF(void) {

#ifdef DEBUG_GHS
    RxBit( (int16) (gl_RxSymbolCount & MODULO_BY_8_MASK) );
#endif /*  DEBUG_GHS */

   switch(gs_RxSubState) {

      case R_C_FLAG2_RX_RECEIVE_FLAG:

         //==== check for end of R_C_Flag2, equivalently look for silence ====
         if ( !DetectMultiTones( gsa_RxToneBuf, (CONSTANT int16*)gsa_DnCarSet, NUM_CARRIERS_IN_SET, NUM_CARRIERS_REQUIRED, DETECT_SCALE << 8) )
            gs_RxSubStateCnt++;
         else
            gs_RxSubStateCnt = 0;

         if ( gs_RxSubStateCnt >= SILENCE_BURST_CNT ) {

            SetSelectedModeAnnex(gt_hsc.l_SelectedMode);

            if ( (gt_hsc.l_SelectedMode != NOT_SELECTED) &&
               ((gt_hsc.l_SelectedMode & (NO_COMMON_MODE|SILENCE|RESTART_HS|RESTART_VIA_CLEARDOWN)) == 0 ) )
            {
               // Define or redefine some variables based on whether we've
               // negotiated G.992_1 or G.992_2 during handshake
               // NOTE: Do this in the foreground. Don't want this to be interrupted
               // by the Rx time critical.
               SetLinkModeDependentVariables();

               guc_HandshakeDone = FALSE;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BGInitModem_PostHandshake);
            }
            else {
               guc_HandshakeDone = TRUE;
            }

            gs_RxSubState = R_C_FLAG2_RX_END_OF_FLAGS;
         }
         break;

      case R_C_FLAG2_RX_END_OF_FLAGS:

         /* ---- move to next state when Tx completes GALF transmission ---- */
         if((gt_hsc.s_TxMsgComplete == TRUE) && (guc_HandshakeDone == TRUE)) {

            gt_hsc.s_TxMsgComplete  = FALSE; /*  reset flag */
            TerminateHandshakeRx();
         }
         break;
   }
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (Start)

   /* If no silence is detected within 1s */
   if ( gl_RxSymbolCount >= (HS_TONE_TIMEOUT + SYMBOLS_PER_OCTET) ) {
      /* No option to go back to initial state (like earlier G.hs timeouts) -
         this TO is far enough into link to warrant fail state */
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_GHS_TONE_LOSS_OR_TIME_OUT;
   }
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)
#ifdef DEBUG_GHS
    if ( ( gl_RxSymbolCount & MODULO_BY_64_MASK ) == (SYMBOLS_PER_OCTET - 1) )
        printf( "Rx\t%x\n", guc_RxOctet );
#endif /*  DEBUG_GHS */

}   /*  RCFlag2RxF */

#undef R_C_FLAG2_RX_RECEIVE_FLAG
#undef R_C_FLAG2_RX_END_OF_FLAGS

