/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCGalf1RxF.c
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************************
// RCGalf1RxF.c
//
// History
//
// 11/08/2010 Hanyu/Bhadra: Added code to measure G.hs Pilot tone power
//            for C-Pilot1 detection to overcome a xtalk issue against
//            UT900/CNXT/D57/Rev7 DSLAM at Netcom.
//            By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//            Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
// 29/08/2013 Prashant: Merged the fix for XDSLRTFW-772.
// Author of code changes: Hanyu
//    Added code to workaround CO tone detection issue on ECI M41 Vinax DSLAM in Annex B by boosting Tx power level:
//    (1) Boosting 4dB Tx tone power in G.hs when it fails at R_C_GALF1_RX state for loops > 3.5km with PAG setting > 0x1A00dB.
//    (2) Restoring it back to the original power level after G.hs for ADSL2/2+ and ADSL1.
//    (3) Fine-tuned the workaround code (ADSLRTFW-1253) to boost training Tx signal power level by 1.5dB on loops > 3.7km and
//        by 2.5dB on loops > 3.9km when previous exception code is E_CODE_GHS_TONE_LOSS_OR_TIME_OUT or E_CODE_RCReverb3Rx_bis_SignalEnd_Failure.
//    (4) Calibrated the loop length estimation based on the PGA setting in R_C_GALF1_RX state.
//        Above changes are not controlled by CMV bit on DTAG FW branch. Suggest adding a new CMV bit in mainline code to narrow down side effect.
//        Grep for  XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower
//
// ******************************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "pll.h"

extern void RxSymbolReAlign(void);
extern int32 VectorPower(int16 *s_databuf, int16 s_offset, int16 s_ndata, int16 s_GuardBits);
extern int16 ConvertToDB(int32 l_xin);

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCGalf1RxF
 *
 *  Description: R_C_GALF1_RX detects a GALF octet.
 *  Upon receiving C_Galf the Rx bit boundaries are aligned.
 *
 *  Prototype: void RCGalf1RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]   - input of IFFT, used in RxSymbolRealign()
 *      gs_RxToneBuf[]    - frequency domain samples, used in RxSymbolRealign()
 *      gs_RxAn_Prev      - previous DPSK symbol, used in RxSymbolRealign()
 *      gsa_RxSubBitBuf[] - 8 DPSK symbols for a bit, used in RxSymbolRealign()
 *      guc_RxOctet       - (I/O) current octet being transmitted,
 *                          used in RxSymbolRealign()
 *      gs_RxState        - (I) current RX state, used in RxSymbolRealign()
 *      gs_RxSubState     - (I/O) current RX substate, used in RxSymbolRealign()
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *      gs_RxSubStateCnt  - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *
 *  Notes: implements state R_C_GALF1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define R_C_GALF1_RX_INITIALIZE        (0)
#define R_C_GALF1_RX_LOCK_PHASE        (10)
#define R_C_GALF1_RX_SYMBOL_REALIGN    (20)

#define  GHS_ROUGH_LOOP_ESTIMATE_LEN    (8)
#define  LOG2_GHS_ROUGH_LOOP_ESTIMATE_LEN (3)
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef  ISDN  // Only for Annex - A
void CalcPilotThrd(void);
#endif
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
void RCGalf1RxF(void) {

   int16 s_pllScaling;
    FlagT ft_run_RxSymbolReAlign = TRUE; //XDSLRTFW-2465

   switch (gs_RxSubState)
   {
   case R_C_GALF1_RX_INITIALIZE:
      /* Set the Macro State CMV. */
      //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start_End)

      /* Get the reference phase of pilot signal. */
      ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);

      /* Set PLL loop filter parameters to fast converge. */
      ResetPLL((int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);

      /* Compute scaling for gs_PilotToneIdx */
      PllScalingCalc(gs_PilotToneIdx, &s_pllScaling);
      ScalePLL(s_pllScaling);

      /* Turn on PLL. */
      gft_EnablePLL = TRUE;

      /* Go to next substate. */
      gs_RxSubStateCnt = 0;
      gs_RxSubState = R_C_GALF1_RX_LOCK_PHASE;
      break;

   case R_C_GALF1_RX_LOCK_PHASE:
      /* Update substate count. */
      gs_RxSubStateCnt++;

      /* Reset PLL loop filter parameters to slow converge parameters. */
      if(gs_RxSubStateCnt == PLL_FAST_ACQUISITION_LEN) {
         ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
         /* Compute scaling for gs_PilotToneIdx */
         PllScalingCalc(gs_PilotToneIdx, &s_pllScaling);
         ScalePLL(s_pllScaling);
      }

      //for rough loop attenuation estimate during HSK
      //Reset the power accumulation variable
      if (gs_RxSubStateCnt ==  5*PLL_FAST_ACQUISITION_LEN - GHS_ROUGH_LOOP_ESTIMATE_LEN)
      {
         gl_hsk_tone_power = 0;
      }

      //Accumulate the power for consecutive GHS_ROUGH_LOOP_ESTIMATE_LEN symbols
      //Add the power of each HSK tone, shifted by LOG2_GHS_ROUGH_LOOP_ESTIMATE_LEN
      if(gs_RxSubStateCnt >  5*PLL_FAST_ACQUISITION_LEN - GHS_ROUGH_LOOP_ESTIMATE_LEN)
      {
         int16 i;
         for (i=0; i<NUM_CARRIERS_IN_SET; i++)
            gl_hsk_tone_power += VectorPower(gsa_RxToneBuf, 2*gsa_DnCarSet[i], 2, LOG2_GHS_ROUGH_LOOP_ESTIMATE_LEN);
      }

      // SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef  ISDN  // Only for Annex - A
      if ((gs_RxSubStateCnt >= 5*PLL_FAST_ACQUISITION_LEN - PILOT_AV_COUNT+1) &&
            (gs_RxSubStateCnt <= 5*PLL_FAST_ACQUISITION_LEN))
      {
         CalcPilotThrd();
      }
#endif
      // SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
      /* Achieve phase lock with slow PLL parameters. */
      if(gs_RxSubStateCnt == 5*PLL_FAST_ACQUISITION_LEN)
      {
         //Calculate average HSK tone power at the analog front end
         //Taking into account of (1).avergae power calculated from rxtonebuffer, (2).hsk PGA
         //(3).TDQ scaleback with reference to initial gs_pre_tdq_h_exp, which is set to 14, i.e., with 6dB gain
         gs_hsk_tone_power_dB = ConvertToDB((int32) (gl_hsk_tone_power/NUM_CARRIERS_IN_SET)) - gs_PGA_set + (gs_pre_tdq_h_exp -14) *6*256 ;
         gs_hsk_tone_power_dB += gs_hsk_power_dB_Comp;

#ifndef ISDN
         //XDSLRTFW-2191(Start)
         if(gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_12000F)   // Higher than 12Kft loop Length
         {
            gft_hsk_tone_power_dB_12KftADSL_Above = TRUE;
         }
         else
         {
            gft_hsk_tone_power_dB_12KftADSL_Above  = FALSE;
         }
         //XDSLRTFW-2191(End)
#endif

         /* Turn off PLL. */
         gft_EnablePLL = FALSE;

         /* Log the acquired frequency offset for debug. */
         gl_HsPLLFreqOffset = gl_pll_freq_offset;

         /* Set the flag to inform TX State Machine that handshake PLL is done? */

         /* Initialize RxSymbolReAlign variables. */
         gs_RxSubStateCnt = 0;
         gs_ReAlignSubState = 0;

         /* Go to next substate. */
         gs_RxSubState = R_C_GALF1_RX_SYMBOL_REALIGN;
      }
      break;

   case R_C_GALF1_RX_SYMBOL_REALIGN:
      /* ---- if timeout, move to the beginning. ---- */
      if ( gl_RxSymbolCount >= (HS_TONE_TIMEOUT + SYMBOLS_PER_OCTET) ) {
#ifdef ISDN
         // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START)
         // Boost G.hs Tx power by 6dB for ECI/M41/Vinax CO to detect R-TONE1 over 3.8km at DTAG
         if (gs_PGA_set > 0x1A00) // for loops > 3.5km. To add && CMV bit13 = 1 in info 103 28 in mainline code
            gft_workaround_ECIM41_VNX = 1;
         // XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (END)
#endif
         if ((gft_GotoFailStateOnTimeOut_FromHandshake == FALSE)
               ||(gt_INFX_CMV.us_OperatorSpBits2 & CMV_CGALF1_TIMEOUT_SILENT1))
         {
            //XDSLRTFW-2465 (Start)
            gl_pll_freq_offset = 0;
            ft_run_RxSymbolReAlign =  FALSE;
            //XDSLRTFW-2465 (End)
            gs_RxNextState = R_C_SILENT1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

            /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
            gs_TxNextState = R_SILENT0_TX;
            gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
         }
         else
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_GHS_TONE_LOSS_OR_TIME_OUT;
         }
      }

      if (ft_run_RxSymbolReAlign)  //XDSLRTFW-2465 (Start_End)
      {
         RxSymbolReAlign();
      }
      break;
   }

}   /*  RCGalf1RxF */

// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef  ISDN  // Only for Annex - A
void CalcPilotThrd(void)
{
  int16 i;
  int32 l_Temp;

  for (i = 2*(gs_CPilotTone - 1); i < 2*(gs_CPilotTone + 2); i++)
  {
    l_Temp = (int32)gsa_RxToneBuf[i];
    if (i == 2*gs_CPilotTone)
    {
      gl_Ghs_PilotAccR += l_Temp;
    }
    else if (i == (2*gs_CPilotTone + 1))
    {
      gl_Ghs_PilotAccI += l_Temp;
    }
    else
    {
      l_Temp *= l_Temp;
      gl_Ghs_NoiseAccH += (l_Temp >> 16);
      gl_Ghs_NoiseAccL += (l_Temp & 0xFFFF);
    }
  }

}
#endif
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
