/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCGalf2RxF.c
 *
 *
 *------------------------------------------------------------------------
 */
// *------------------------------------------------------------------------//
// RCGalf2RxF.c
//
// History
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// *------------------------------------------------------------------------//

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "ghs.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "DSLEngin.h"
#ifdef DEBUG_GHS
#include <stdio.h>
#endif /*  DEBUG_GHS */
#include "flcswap.h"
#include "codeswap.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "post_hsk.h"
#include "detect.h"
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "hndshk_Data.h"
#include "gdata_bis.h"



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RCGalf2RxF
 *
 *  Description: Wait for a GALF characters.  Exits to selected G.hs mode when
 *  a GALF character is received.
 *
 *  Prototype: void RCGalf2RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]             - input of IFFT, used in RxBit()
 *      gs_RxToneBuf[]              - frequency domain samples, used in RxBit()
 *      gpt_RxInfo                  - (I) RX message information structure,
 *                                    used in HSMsgHandler()
 *      guc_RxOctet                 - (I/O) current octet being transmitted
 *      gs_RxState                  - (I) current RX state
 *      gs_RxSubState               - (I/O) current RX substate
 *      gl_RxSymbolCount            - (I) # symbol periods in current RX state
 *      gs_RxNextState              - (O) RX state that will begin next symbol period
 *
 *  Substates:
 *      R_C_GALF2_RX_RECEIVE_GALF   - Wait for reception of a GALF character.
 *      R_C_GALF2_RX_TRANSMIT_FLAGS - Wait for the transmitter to finish transmitting additional FLAGs.

 *
 *  Notes: implements state R_C_GALF2_RX
 *
 *-------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_GALF2_RX_RECEIVE_GALF   (0)
#define R_C_GALF2_RX_TRANSMIT_FLAGS (1)

void RCGalf2RxF(void) {

    static int16 s_SilencePresent ;

    if(gl_RxSymbolCount == 0)
    {
      guc_RxGalfCnt = 0;
      s_SilencePresent = 0;
      // In long loops, IFX tends to false detect silence from our part
      // (after it has sent its GALFs and while we are still sending FLAGs).
      // Shorten our cleardown FLAG number (i.e. the ones sent after we
      // detect GALF): spec says up to 500ms; normally we send 20 FLAGs=
      // 1280 symbols, which is ~300ms; now we will send 5 FLAGs =~60ms,
      // which we already do against BDCM (for legacy DMT reasons).
      // This way even when IFX false detects silence and sends its CComb1
      // signal earlier, we will have finished our QLN etc processing and
      // we will be ready to catch it.
      if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
         gs_num_cleardown_flags = gs_num_cleardown_flags_short ;
   }

    /* ==== check for silence, in case GALFs are not detected by any chance ==== */
    if ( (gs_RxSubState==R_C_GALF2_RX_RECEIVE_GALF) && !s_SilencePresent )
    {

        if ( !DetectMultiTones( gsa_RxToneBuf, (CONSTANT int16*)gsa_DnCarSet, NUM_CARRIERS_IN_SET, NUM_CARRIERS_REQUIRED, DETECT_SCALE << 8) )
            gs_RxSubStateCnt++;
        else
            gs_RxSubStateCnt = 0;

         if ( gs_RxSubStateCnt >= SILENCE_BURST_CNT )
         {
            s_SilencePresent = 1 ;
         }

    }


    /* ---- Bit Detection : common for all substates ---- */
    RxBit( (int16) (gl_RxSymbolCount & MODULO_BY_8_MASK) );

    /* ==== if one full octet received, check for GALF character ==== */
    if ( ( gl_RxSymbolCount & MODULO_BY_64_MASK ) == (SYMBOLS_PER_OCTET - 1) )
    {

#ifdef DEBUG_GHS
     printf( "Rx\t%x\n", guc_RxOctet );
#endif /*  DEBUG_GHS */

        switch (gs_RxSubState)
        {
        /* =============================================== */
        /* wait for a GALF */
        /* =============================================== */
        case R_C_GALF2_RX_RECEIVE_GALF:

            if (guc_RxOctet == GALF)
                guc_RxGalfCnt++;
            else
                guc_RxGalfCnt = 0;

            if ( (guc_RxGalfCnt == NUM_CLEARDOWN_GALF) || s_SilencePresent )
            {
               SetSelectedModeAnnex(gt_hsc.l_SelectedMode);

               if ( (gt_hsc.l_SelectedMode != NOT_SELECTED) &&
                  ((gt_hsc.l_SelectedMode & (NO_COMMON_MODE|SILENCE|RESTART_HS|RESTART_VIA_CLEARDOWN)) == 0 ) )
               {
                  // Define or redefine some variables based on whether we've
                  // negotiated G.992_1 or G.992_2 during handshake
                  // NOTE: Do this in the foreground. Don't want this to be interrupted
                  // by the Rx time critical.
                  SetLinkModeDependentVariables();
                  guc_HandshakeDone = FALSE;
                  AddFunctionToBkgdFifo((PtrToBkgdFunc)BGInitModem_PostHandshake);
               }
               else
               {
                  guc_HandshakeDone = TRUE;
               }

               gt_hsc.s_RxMsgComplete = TRUE;
               gs_RxSubState = R_C_GALF2_RX_TRANSMIT_FLAGS;
            }

            break;

        /* =============================================== */
        /* wait for Tx side to finish transmitting additional FLAGs */
        /* =============================================== */
        case R_C_GALF2_RX_TRANSMIT_FLAGS:

            if((gt_hsc.s_TxMsgComplete == TRUE) && (guc_HandshakeDone == TRUE))
            {
                gt_hsc.s_TxMsgComplete = FALSE;  /*  reset flag */
                TerminateHandshakeRx();
            }
            break;
        }   /*  switch */

    }   /*  if (complete an octet) */
    /* If no Galf or silence is detected within 1s */
    if ( gl_RxSymbolCount >= (HS_TONE_TIMEOUT + SYMBOLS_PER_OCTET) )
    {
      /* No option to go back to initial state (like earlier G.hs timeouts) -
         this TO is far enough into link to warrant fail state */
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_GHS_TONE_LOSS_OR_TIME_OUT;
    }
    /* ---- non-GALF octets are ignored ---- */
}   /*  RCGalf2RxF */

#undef R_C_GALF2_RX_RECEIVE_GALF
#undef R_C_GALF2_RX_TRANSMIT_FLAGS

